/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmid;

import gnu.classpath.tools.common.Persistent;
import gnu.classpath.tools.rmid.ActivationSystemImpl;
import gnu.java.rmi.activation.BidiTable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimerTask;

public class PersistentBidiHashTable
extends BidiTable
implements Persistent {
    File database;
    WriteToDiskTask sheduled = null;
    long lastUpdated;

    public PersistentBidiHashTable() {
        super(0);
    }

    public void init(File file, boolean coldStart) {
        try {
            this.database = file;
            if (this.database.exists()) {
                if (coldStart) {
                    this.k2v = new Hashtable();
                    this.v2k = new Hashtable();
                    this.database.delete();
                } else {
                    FileInputStream fi = new FileInputStream(file);
                    BufferedInputStream b = new BufferedInputStream(fi);
                    AdaptedReader oin = new AdaptedReader(b);
                    this.k2v = (Map)oin.readObject();
                    oin.close();
                    this.v2k = new Hashtable(this.k2v.size());
                    for (Object key : this.k2v.keySet()) {
                        this.v2k.put(this.k2v.get(key), key);
                    }
                }
            } else {
                this.k2v = new Hashtable();
                this.v2k = new Hashtable();
            }
        }
        catch (Exception ioex) {
            InternalError ierr = new InternalError("Unable to intialize with file " + file);
            ierr.initCause(ioex);
            throw ierr;
        }
    }

    public synchronized void writeContent() {
        try {
            FileOutputStream fou = new FileOutputStream(this.database);
            BufferedOutputStream b = new BufferedOutputStream(fou);
            ObjectOutputStream oout = new ObjectOutputStream(b);
            oout.writeObject(this.k2v);
            oout.close();
        }
        catch (Exception ioex) {
            InternalError ierr = new InternalError("Failed to write database to disk: " + this.database);
            ierr.initCause(ioex);
            throw ierr;
        }
    }

    public void markDirty() {
        if (System.currentTimeMillis() - this.lastUpdated > 300000L) {
            this.writeContent();
            this.lastUpdated = System.currentTimeMillis();
            if (this.sheduled != null) {
                this.sheduled.cancel();
                this.sheduled = null;
            }
        } else {
            if (this.sheduled != null) {
                this.sheduled.cancel();
            }
            this.sheduled = new WriteToDiskTask();
            timer.schedule((TimerTask)this.sheduled, 5000L);
        }
    }

    public void shutdown() {
        if (this.sheduled != null) {
            this.writeContent();
            this.sheduled = null;
        }
    }

    public void put(Object key, Object value) {
        super.put(key, value);
        this.markDirty();
    }

    public void removeKey(Object key) {
        super.removeKey(key);
        this.markDirty();
    }

    class AdaptedReader
    extends ObjectInputStream {
        AdaptedReader(InputStream in) throws IOException {
            super(in);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof ActivationSystemImpl) {
                return ActivationSystemImpl.singleton2;
            }
            return obj;
        }
    }

    class WriteToDiskTask
    extends TimerTask {
        WriteToDiskTask() {
        }

        public void run() {
            PersistentBidiHashTable.this.writeContent();
            PersistentBidiHashTable.this.sheduled = null;
        }
    }
}

