/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.tools.gc_analyze;

import java.nio.ByteBuffer;

public class BytePtr {
    ByteBuffer content;
    int wordSize;

    BytePtr(ByteBuffer b, int ws) {
        this.content = b;
        this.wordSize = ws;
    }

    public int getsize() {
        return this.content.limit();
    }

    public int getByte(int offset) {
        return this.content.get(offset);
    }

    public int getInt(int n) {
        return this.content.getInt(n * 4);
    }

    public int getShort(int n) {
        return this.content.getShort(n * 2);
    }

    public long getWord(int n) {
        if (4 == this.wordSize) {
            return 0xFFFFFFFFL & (long)this.content.getInt(n * 4);
        }
        return this.content.getLong(n * 8);
    }

    public int intsPerWord() {
        return 4 == this.wordSize ? 1 : 2;
    }

    public BytePtr getRegion(int offset, int size) {
        int oldLimit = this.content.limit();
        this.content.position(offset);
        this.content.limit(offset + size);
        ByteBuffer n = this.content.slice();
        this.content.position(0);
        this.content.limit(oldLimit);
        return new BytePtr(n, this.wordSize);
    }

    public void setInt(int a, int n) {
        this.content.putInt(a * 4, n);
    }

    public void dump() {
        StringBuilder b = new StringBuilder(67);
        int i = 0;
        while (i < 66) {
            b.append(' ');
            ++i;
        }
        b.append('\n');
        i = 0;
        do {
            int j = 0;
            while (j < 16) {
                int k = i + j;
                if (k < this.content.limit()) {
                    int v = 0xFF & this.getByte(k);
                    int v1 = v / 16;
                    b.setCharAt(j * 3 + 0, (char)(v1 >= 10 ? 87 + v1 : v1 + 48));
                    v1 = v % 16;
                    b.setCharAt(j * 3 + 1, (char)(v1 >= 10 ? 87 + v1 : v1 + 48));
                    b.setCharAt(j + 50, (char)(v >= 32 && v <= 127 ? v : 46));
                } else {
                    b.setCharAt(j * 3 + 0, ' ');
                    b.setCharAt(j * 3 + 1, ' ');
                    b.setCharAt(j + 50, ' ');
                }
                ++j;
            }
            System.out.print(b);
        } while ((i += 16) < this.content.limit());
    }
}

