# CMake macro to test if we (can) use Gphoto2
#  GPHOTO2_FOUND        - system has the Gphoto2 library
#  GPHOTO2_INCLUDE_DIRS - include directories for libgphoto2
#  GPHOTO2_CFLAGS       - additional compiler flags needed
#  GPHOTO2_LIBRARIES    - the libraries needed to use libgphoto2
#  GPHOTO2_LDFLAGS      - additional compiler flags needed
#  GPHOTO2_PORT_INCLUDE_DIRS - include directories for libgphoto2_port
#  GPHOTO2_PORT_CFLAGS       - additional compiler flags needed for libgphoto2_port
#  GPHOTO2_PORT_LIBRARIES    - the libraries needed to use libgphoto2_port
#  GPHOTO2_PORT_LDFLAGS      - additional compiler flags needed for libgphoto2_port

# Copyright (c) 2006, 2007 Laurent Montel, <montel@kde.org>
# Copyright (c) 2013 Vadim Zhukov, <persgray@gmail.com>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


include(FindPkgConfig)

macro(gphoto2_config_parse _prefix _cfgprogname _cfgpkgname _testheader)
	set(_libdir_hints)
	set(_lib_names)

	find_program(_program NAMES ${_cfgprogname})

	pkg_check_modules("${_prefix}_PKG" QUIET "${_cfgpkgname}")
	if ("${_prefix}_PKG_FOUND")
		set(_libdir_hints ${${_prefix}_PKG_LIBRARY_DIRS})
		set(_lib_names ${${_prefix}_PKG_LIBRARIES})
	endif ("${_prefix}_PKG_FOUND")

	# search for libraries

	if (_program)
		exec_program(${_program} ARGS --libs RETURN_VALUE _rv OUTPUT_VARIABLE _output)
	endif (_program)

	if (_program AND _rv)
		separate_arguments(_output)
		foreach(_s ${_output})
			if (_s MATCHES "^-L(.*)")
				set(_libdir_hints ${_libdir_hints} "${CMAKE_MATCHES_1}")
			elseif (_s MATCHES "^-l(.*)")
				set(_lib_names ${_lib_names} "${CMAKE_MATCHES_1}")
			elseif (_s MATCHES "^-.*")
				set("${_prefix}_LDFLAGS" ${${_prefix}_LDFLAGS} "${_s}")
			else (_s MATCHES "^-L(.*)")
				# assume a full path to library
				set("${_prefix}_LIBRARIES" ${${_prefix}_LIBRARIES} "${_s}")
			endif (_s MATCHES "^-L(.*)")
		endforeach(_s ${_output})
	elseif (NOT "${_prefix}_PKG_FOUND")
		set(_lib_names ${ARGN})
		set("${_prefix}_LDFLAGS" ${${_prefix}_PKG_LDFLAGS_OTHER})
	endif (_program AND _rv)
		
	foreach(_lib ${_lib_names})
		find_library("${_prefix}_LIB_${_lib}" "${_lib}" HINTS ${_libdir_hints})
		set("${_prefix}_LIBRARIES" ${${_prefix}_LIBRARIES} "${${_prefix}_LIB_${_lib}}")
	endforeach(_lib ${_lib_names})

	# search for include directories

	if (_program)
		exec_program(${_program} ARGS --cflags RETURN_VALUE _rv OUTPUT_VARIABLE _output)
	endif (_program)

	if (_program AND _rv)
		separate_arguments(_output)
		foreach(_s ${_output})
			if (_s MATCHES "^-I(.*)")
				set("${_prefix}_INCLUDE_DIRS" ${${_prefix}_INCLUDE_DIRS} "${CMAKE_MATCHES_1}")
			else (_s MATCHES "^-I(.*)")
				set("${_prefix}_CFLAGS" ${${_prefix}_CFLAGS} "${CMAKE_MATCHES_1}")
			endif (_s MATCHES "^-I(.*)")
		endforeach(_s ${_output})
	else (_program AND _rv)
		find_path("${_prefix}_INCLUDE_DIRS" "${_testheader}" HINTS ${${_prefix}_PKG_INCLUDE_DIRS} PATH_SUFFIXES gphoto2)
		set("${_prefix}_CFLAGS" ${${_prefix}_PKG_CFLAGS_OTHER})
	endif (_program AND _rv)
endmacro(gphoto2_config_parse _prefix _cfgprogname _cfgpkgname _testheader)

option(KDE4_GPHOTO2 "do not build kamera (gphoto2 required)" ON)
if (KDE4_GPHOTO2 )
	if (NOT GPHOTO2_FOUND)
		gphoto2_config_parse(GPHOTO2_PORT gphoto2-port-config libgphoto2_port gphoto2-port.h gphoto2_port)
		gphoto2_config_parse(GPHOTO2 gphoto2-config libgphoto2 gphoto2.h gphoto2 gphoto2_port)

		# backward compatibility
		set(GPHOTO2_INCLUDE_DIR ${GPHOTO2_INCLUDE_DIRS})
	endif (NOT GPHOTO2_FOUND)

	find_package_handle_standard_args(Gphoto2 GPHOTO2_LIBRARIES GPHOTO2_INCLUDE_DIRS GPHOTO2_PORT_LIBRARIES GPHOTO2_PORT_INCLUDE_DIRS)
	mark_as_advanced(GPHOTO2_LIBRARIES GPHOTO2_PORT_LIBRARIES GPHOTO2_INCLUDE_DIRS GPHOTO2_PORT_INCLUDE_DIR)
endif(KDE4_GPHOTO2)

