"""Generated message classes for compute version beta.

Creates and runs virtual machines on Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'compute'


class AcceleratorConfig(_messages.Message):
  r"""A specification of the type and number of accelerator cards attached to
  the instance.

  Fields:
    acceleratorCount: The number of the guest accelerator cards exposed to
      this instance.
    acceleratorType: Full or partial URL of the accelerator type resource to
      attach to this instance. If you are creating an instance template,
      specify only the accelerator name.
  """

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorType = _messages.StringField(2)


class AcceleratorType(_messages.Message):
  r"""An Accelerator Type resource. (== resource_for beta.acceleratorTypes ==)
  (== resource_for v1.acceleratorTypes ==)

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    deprecated: [Output Only] The deprecation status associated with this
      accelerator type.
    description: [Output Only] An optional textual description of the
      resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] The type of the resource. Always
      compute#acceleratorType for accelerator types.
    maximumCardsPerInstance: [Output Only] Maximum accelerator cards allowed
      per instance.
    name: [Output Only] Name of the resource.
    selfLink: [Output Only] Server-defined fully-qualified URL for this
      resource.
    zone: [Output Only] The name of the zone where the accelerator type
      resides, such as us-central1-a. You must specify this field as part of
      the HTTP request URL. It is not settable as a field in the request body.
  """

  creationTimestamp = _messages.StringField(1)
  deprecated = _messages.MessageField('DeprecationStatus', 2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#acceleratorType')
  maximumCardsPerInstance = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  name = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  zone = _messages.StringField(9)


class AcceleratorTypeAggregatedList(_messages.Message):
  r"""A AcceleratorTypeAggregatedList object.

  Messages:
    ItemsValue: A list of AcceleratorTypesScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of AcceleratorTypesScopedList resources.
    kind: [Output Only] Type of resource. Always
      compute#acceleratorTypeAggregatedList for aggregated lists of
      accelerator types.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of AcceleratorTypesScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of accelerator types.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A AcceleratorTypesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AcceleratorTypesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#acceleratorTypeAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class AcceleratorTypeList(_messages.Message):
  r"""Contains a list of accelerator types.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of AcceleratorType resources.
    kind: [Output Only] Type of resource. Always compute#acceleratorTypeList
      for lists of accelerator types.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('AcceleratorType', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#acceleratorTypeList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class AcceleratorTypesScopedList(_messages.Message):
  r"""A AcceleratorTypesScopedList object.

  Messages:
    WarningValue: [Output Only] An informational warning that appears when the
      accelerator types list is empty.

  Fields:
    acceleratorTypes: [Output Only] A list of accelerator types contained in
      this scope.
    warning: [Output Only] An informational warning that appears when the
      accelerator types list is empty.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] An informational warning that appears when the
    accelerator types list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  acceleratorTypes = _messages.MessageField('AcceleratorType', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class AccessConfig(_messages.Message):
  r"""An access configuration attached to an instance's network interface.
  Only one access config per instance is supported.

  Enums:
    NetworkTierValueValuesEnum: This signifies the networking tier used for
      configuring this access configuration and can only take the following
      values: PREMIUM, STANDARD.  If an AccessConfig is specified without a
      valid external IP address, an ephemeral IP will be created with this
      networkTier.  If an AccessConfig with a valid external IP address is
      specified, it must match that of the networkTier associated with the
      Address resource owning that IP.
    TypeValueValuesEnum: The type of configuration. The default and only
      option is ONE_TO_ONE_NAT.

  Fields:
    kind: [Output Only] Type of the resource. Always compute#accessConfig for
      access configs.
    name: The name of this access configuration. The default and recommended
      name is External NAT but you can use any arbitrary string you would
      like. For example, My external IP or Network Access.
    natIP: An external IP address associated with this instance. Specify an
      unused static external IP address available to the project or leave this
      field undefined to use an IP from a shared ephemeral IP address pool. If
      you specify a static external IP address, it must live in the same
      region as the zone of the instance.
    networkTier: This signifies the networking tier used for configuring this
      access configuration and can only take the following values: PREMIUM,
      STANDARD.  If an AccessConfig is specified without a valid external IP
      address, an ephemeral IP will be created with this networkTier.  If an
      AccessConfig with a valid external IP address is specified, it must
      match that of the networkTier associated with the Address resource
      owning that IP.
    publicPtrDomainName: The DNS domain name for the public PTR record. This
      field can only be set when the set_public_ptr field is enabled.
    setPublicPtr: Specifies whether a public DNS ?PTR? record should be
      created to map the external IP address of the instance to a DNS domain
      name.
    type: The type of configuration. The default and only option is
      ONE_TO_ONE_NAT.
  """

  class NetworkTierValueValuesEnum(_messages.Enum):
    r"""This signifies the networking tier used for configuring this access
    configuration and can only take the following values: PREMIUM, STANDARD.
    If an AccessConfig is specified without a valid external IP address, an
    ephemeral IP will be created with this networkTier.  If an AccessConfig
    with a valid external IP address is specified, it must match that of the
    networkTier associated with the Address resource owning that IP.

    Values:
      PREMIUM: <no description>
      STANDARD: <no description>
    """
    PREMIUM = 0
    STANDARD = 1

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of configuration. The default and only option is
    ONE_TO_ONE_NAT.

    Values:
      ONE_TO_ONE_NAT: <no description>
    """
    ONE_TO_ONE_NAT = 0

  kind = _messages.StringField(1, default=u'compute#accessConfig')
  name = _messages.StringField(2)
  natIP = _messages.StringField(3)
  networkTier = _messages.EnumField('NetworkTierValueValuesEnum', 4)
  publicPtrDomainName = _messages.StringField(5)
  setPublicPtr = _messages.BooleanField(6)
  type = _messages.EnumField('TypeValueValuesEnum', 7, default=u'ONE_TO_ONE_NAT')


class Address(_messages.Message):
  r"""A reserved address resource. (== resource_for beta.addresses ==) (==
  resource_for v1.addresses ==) (== resource_for beta.globalAddresses ==) (==
  resource_for v1.globalAddresses ==)

  Enums:
    AddressTypeValueValuesEnum: The type of address to reserve, either
      INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
    IpVersionValueValuesEnum: The IP Version that will be used by this
      address. Valid options are IPV4 or IPV6. This can only be specified for
      a global address.
    NetworkTierValueValuesEnum: This signifies the networking tier used for
      configuring this Address and can only take the following values: PREMIUM
      , STANDARD.  If this field is not specified, it is assumed to be
      PREMIUM.
    PurposeValueValuesEnum: The purpose of resource, only used with INTERNAL
      type.
    StatusValueValuesEnum: [Output Only] The status of the address, which can
      be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING
      is currently in the process of being reserved. A RESERVED address is
      currently reserved and available to use. An IN_USE address is currently
      being used by another resource and is not available.

  Messages:
    LabelsValue: Labels to apply to this Address resource. These can be later
      modified by the setLabels method. Each label key/value must comply with
      RFC1035. Label values may be empty.

  Fields:
    address: The static IP address represented by this resource.
    addressType: The type of address to reserve, either INTERNAL or EXTERNAL.
      If unspecified, defaults to EXTERNAL.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    ipVersion: The IP Version that will be used by this address. Valid options
      are IPV4 or IPV6. This can only be specified for a global address.
    kind: [Output Only] Type of the resource. Always compute#address for
      addresses.
    labelFingerprint: A fingerprint for the labels being applied to this
      Address, which is essentially a hash of the labels set used for
      optimistic locking. The fingerprint is initially generated by Compute
      Engine and changes after every request to modify or update labels. You
      must always provide an up-to-date fingerprint hash in order to update or
      change labels.  To see the latest fingerprint, make a get() request to
      retrieve an Address.
    labels: Labels to apply to this Address resource. These can be later
      modified by the setLabels method. Each label key/value must comply with
      RFC1035. Label values may be empty.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    network: The URL of the network in which to reserve the address. This
      field can only be used with INTERNAL type with VPC_PEERING purpose.
    networkTier: This signifies the networking tier used for configuring this
      Address and can only take the following values: PREMIUM , STANDARD.  If
      this field is not specified, it is assumed to be PREMIUM.
    prefixLength: The prefix length if the resource reprensents an IP range.
    purpose: The purpose of resource, only used with INTERNAL type.
    region: [Output Only] URL of the region where the regional address
      resides. This field is not applicable to global addresses. You must
      specify this field as part of the HTTP request URL. You cannot set this
      field in the request body.
    selfLink: [Output Only] Server-defined URL for the resource.
    status: [Output Only] The status of the address, which can be one of
      RESERVING, RESERVED, or IN_USE. An address that is RESERVING is
      currently in the process of being reserved. A RESERVED address is
      currently reserved and available to use. An IN_USE address is currently
      being used by another resource and is not available.
    subnetwork: The URL of the subnetwork in which to reserve the address. If
      an IP address is specified, it must be within the subnetwork's IP range.
      This field can only be used with INTERNAL type with
      GCE_ENDPOINT/DNS_RESOLVER purposes.
    users: [Output Only] The URLs of the resources that are using this
      address.
  """

  class AddressTypeValueValuesEnum(_messages.Enum):
    r"""The type of address to reserve, either INTERNAL or EXTERNAL. If
    unspecified, defaults to EXTERNAL.

    Values:
      EXTERNAL: <no description>
      INTERNAL: <no description>
      UNSPECIFIED_TYPE: <no description>
    """
    EXTERNAL = 0
    INTERNAL = 1
    UNSPECIFIED_TYPE = 2

  class IpVersionValueValuesEnum(_messages.Enum):
    r"""The IP Version that will be used by this address. Valid options are
    IPV4 or IPV6. This can only be specified for a global address.

    Values:
      IPV4: <no description>
      IPV6: <no description>
      UNSPECIFIED_VERSION: <no description>
    """
    IPV4 = 0
    IPV6 = 1
    UNSPECIFIED_VERSION = 2

  class NetworkTierValueValuesEnum(_messages.Enum):
    r"""This signifies the networking tier used for configuring this Address
    and can only take the following values: PREMIUM , STANDARD.  If this field
    is not specified, it is assumed to be PREMIUM.

    Values:
      PREMIUM: <no description>
      STANDARD: <no description>
    """
    PREMIUM = 0
    STANDARD = 1

  class PurposeValueValuesEnum(_messages.Enum):
    r"""The purpose of resource, only used with INTERNAL type.

    Values:
      DNS_RESOLVER: <no description>
      GCE_ENDPOINT: <no description>
      UNSPECIFIED_PURPOSE: <no description>
      VPC_PEERING: <no description>
    """
    DNS_RESOLVER = 0
    GCE_ENDPOINT = 1
    UNSPECIFIED_PURPOSE = 2
    VPC_PEERING = 3

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output Only] The status of the address, which can be one of
    RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently
    in the process of being reserved. A RESERVED address is currently reserved
    and available to use. An IN_USE address is currently being used by another
    resource and is not available.

    Values:
      IN_USE: <no description>
      RESERVED: <no description>
      RESERVING: <no description>
    """
    IN_USE = 0
    RESERVED = 1
    RESERVING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels to apply to this Address resource. These can be later modified
    by the setLabels method. Each label key/value must comply with RFC1035.
    Label values may be empty.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  address = _messages.StringField(1)
  addressType = _messages.EnumField('AddressTypeValueValuesEnum', 2)
  creationTimestamp = _messages.StringField(3)
  description = _messages.StringField(4)
  id = _messages.IntegerField(5, variant=_messages.Variant.UINT64)
  ipVersion = _messages.EnumField('IpVersionValueValuesEnum', 6)
  kind = _messages.StringField(7, default=u'compute#address')
  labelFingerprint = _messages.BytesField(8)
  labels = _messages.MessageField('LabelsValue', 9)
  name = _messages.StringField(10)
  network = _messages.StringField(11)
  networkTier = _messages.EnumField('NetworkTierValueValuesEnum', 12)
  prefixLength = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  purpose = _messages.EnumField('PurposeValueValuesEnum', 14)
  region = _messages.StringField(15)
  selfLink = _messages.StringField(16)
  status = _messages.EnumField('StatusValueValuesEnum', 17)
  subnetwork = _messages.StringField(18)
  users = _messages.StringField(19, repeated=True)


class AddressAggregatedList(_messages.Message):
  r"""A AddressAggregatedList object.

  Messages:
    ItemsValue: A list of AddressesScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of AddressesScopedList resources.
    kind: [Output Only] Type of resource. Always compute#addressAggregatedList
      for aggregated lists of addresses.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of AddressesScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of addresses.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A AddressesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AddressesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#addressAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class AddressList(_messages.Message):
  r"""Contains a list of addresses.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of Address resources.
    kind: [Output Only] Type of resource. Always compute#addressList for lists
      of addresses.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('Address', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#addressList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class AddressesScopedList(_messages.Message):
  r"""A AddressesScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of addresses when the list is empty.

  Fields:
    addresses: [Output Only] A list of addresses contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      addresses when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning which replaces the list of
    addresses when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  addresses = _messages.MessageField('Address', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class AliasIpRange(_messages.Message):
  r"""An alias IP range attached to an instance's network interface.

  Fields:
    ipCidrRange: The IP CIDR range represented by this alias IP range. This IP
      CIDR range must belong to the specified subnetwork and cannot contain IP
      addresses reserved by system or used by other network interfaces. This
      range may be a single IP address (e.g. 10.2.3.4), a netmask (e.g. /24)
      or a CIDR format string (e.g. 10.1.2.0/24).
    subnetworkRangeName: Optional subnetwork secondary range name specifying
      the secondary range from which to allocate the IP CIDR range for this
      alias IP range. If left unspecified, the primary range of the subnetwork
      will be used.
  """

  ipCidrRange = _messages.StringField(1)
  subnetworkRangeName = _messages.StringField(2)


class AttachedDisk(_messages.Message):
  r"""An instance-attached disk resource.

  Enums:
    InterfaceValueValuesEnum: Specifies the disk interface to use for
      attaching this disk, which is either SCSI or NVME. The default is SCSI.
      Persistent disks must always use SCSI and the request will fail if you
      attempt to attach a persistent disk in any other format than SCSI. Local
      SSDs can use either NVME or SCSI. For performance characteristics of
      SCSI over NVMe, see Local SSD performance.
    ModeValueValuesEnum: The mode in which to attach this disk, either
      READ_WRITE or READ_ONLY. If not specified, the default is to attach the
      disk in READ_WRITE mode.
    TypeValueValuesEnum: Specifies the type of the disk, either SCRATCH or
      PERSISTENT. If not specified, the default is PERSISTENT.

  Fields:
    autoDelete: Specifies whether the disk will be auto-deleted when the
      instance is deleted (but not when the disk is detached from the
      instance).
    boot: Indicates that this is a boot disk. The virtual machine will use the
      first partition of the disk for its root filesystem.
    deviceName: Specifies a unique device name of your choice that is
      reflected into the /dev/disk/by-id/google-* tree of a Linux operating
      system running within the instance. This name can be used to reference
      the device for mounting, resizing, and so on, from within the instance.
      If not specified, the server chooses a default device name to apply to
      this disk, in the form persistent-disks-x, where x is a number assigned
      by Google Compute Engine. This field is only applicable for persistent
      disks.
    diskEncryptionKey: Encrypts or decrypts a disk using a customer-supplied
      encryption key.  If you are creating a new disk, this field encrypts the
      new disk using an encryption key that you provide. If you are attaching
      an existing disk that is already encrypted, this field decrypts the disk
      using the customer-supplied encryption key.  If you encrypt a disk using
      a customer-supplied key, you must provide the same key again when you
      attempt to use this resource at a later time. For example, you must
      provide the key when you create a snapshot or an image from the disk or
      when you attach the disk to a virtual machine instance.  If you do not
      provide an encryption key, then the disk will be encrypted using an
      automatically generated key and you do not need to provide a key to use
      the disk later.  Instance templates do not store customer-supplied
      encryption keys, so you cannot use your own keys to encrypt disks in a
      managed instance group.
    guestOsFeatures: A list of features to enable on the guest operating
      system. Applicable only for bootable images. Read  Enabling guest
      operating system features to see a list of available options.
    index: [Output Only] A zero-based index to this disk, where 0 is reserved
      for the boot disk. If you have many disks attached to an instance, each
      disk would have a unique index number.
    initializeParams: [Input Only] Specifies the parameters for a new disk
      that will be created alongside the new instance. Use initialization
      parameters to create boot disks or local SSDs attached to the new
      instance.  This property is mutually exclusive with the source property;
      you can only define one or the other, but not both.
    interface: Specifies the disk interface to use for attaching this disk,
      which is either SCSI or NVME. The default is SCSI. Persistent disks must
      always use SCSI and the request will fail if you attempt to attach a
      persistent disk in any other format than SCSI. Local SSDs can use either
      NVME or SCSI. For performance characteristics of SCSI over NVMe, see
      Local SSD performance.
    kind: [Output Only] Type of the resource. Always compute#attachedDisk for
      attached disks.
    licenses: [Output Only] Any valid publicly visible licenses.
    mode: The mode in which to attach this disk, either READ_WRITE or
      READ_ONLY. If not specified, the default is to attach the disk in
      READ_WRITE mode.
    source: Specifies a valid partial or full URL to an existing Persistent
      Disk resource. When creating a new instance, one of
      initializeParams.sourceImage or disks.source is required except for
      local SSD.  If desired, you can also attach existing non-root persistent
      disks using this property. This field is only applicable for persistent
      disks.  Note that for InstanceTemplate, specify the disk name, not the
      URL for the disk.
    type: Specifies the type of the disk, either SCRATCH or PERSISTENT. If not
      specified, the default is PERSISTENT.
  """

  class InterfaceValueValuesEnum(_messages.Enum):
    r"""Specifies the disk interface to use for attaching this disk, which is
    either SCSI or NVME. The default is SCSI. Persistent disks must always use
    SCSI and the request will fail if you attempt to attach a persistent disk
    in any other format than SCSI. Local SSDs can use either NVME or SCSI. For
    performance characteristics of SCSI over NVMe, see Local SSD performance.

    Values:
      NVME: <no description>
      SCSI: <no description>
    """
    NVME = 0
    SCSI = 1

  class ModeValueValuesEnum(_messages.Enum):
    r"""The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
    If not specified, the default is to attach the disk in READ_WRITE mode.

    Values:
      READ_ONLY: <no description>
      READ_WRITE: <no description>
    """
    READ_ONLY = 0
    READ_WRITE = 1

  class TypeValueValuesEnum(_messages.Enum):
    r"""Specifies the type of the disk, either SCRATCH or PERSISTENT. If not
    specified, the default is PERSISTENT.

    Values:
      PERSISTENT: <no description>
      SCRATCH: <no description>
    """
    PERSISTENT = 0
    SCRATCH = 1

  autoDelete = _messages.BooleanField(1)
  boot = _messages.BooleanField(2)
  deviceName = _messages.StringField(3)
  diskEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 4)
  guestOsFeatures = _messages.MessageField('GuestOsFeature', 5, repeated=True)
  index = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  initializeParams = _messages.MessageField('AttachedDiskInitializeParams', 7)
  interface = _messages.EnumField('InterfaceValueValuesEnum', 8)
  kind = _messages.StringField(9, default=u'compute#attachedDisk')
  licenses = _messages.StringField(10, repeated=True)
  mode = _messages.EnumField('ModeValueValuesEnum', 11)
  source = _messages.StringField(12)
  type = _messages.EnumField('TypeValueValuesEnum', 13)


class AttachedDiskInitializeParams(_messages.Message):
  r"""[Input Only] Specifies the parameters for a new disk that will be
  created alongside the new instance. Use initialization parameters to create
  boot disks or local SSDs attached to the new instance.  This property is
  mutually exclusive with the source property; you can only define one or the
  other, but not both.

  Messages:
    LabelsValue: Labels to apply to this disk. These can be later modified by
      the disks.setLabels method. This field is only applicable for persistent
      disks.

  Fields:
    description: An optional description. Provide this property when creating
      the disk.
    diskName: Specifies the disk name. If not specified, the default is to use
      the name of the instance. If the disk with the instance name exists
      already in the given zone/region, a new name will be automatically
      generated.
    diskSizeGb: Specifies the size of the disk in base-2 GB.
    diskType: Specifies the disk type to use to create the instance. If not
      specified, the default is pd-standard, specified using the full URL. For
      example: https://www.googleapis.com/compute/v1/projects/project/zones/zo
      ne/diskTypes/pd-standard   Other values include pd-ssd and local-ssd. If
      you define this field, you can provide either the full or partial URL.
      For example, the following are valid values:   - https://www.googleapis.
      com/compute/v1/projects/project/zones/zone/diskTypes/diskType  -
      projects/project/zones/zone/diskTypes/diskType  -
      zones/zone/diskTypes/diskType  Note that for InstanceTemplate, this is
      the name of the disk type, not URL.
    labels: Labels to apply to this disk. These can be later modified by the
      disks.setLabels method. This field is only applicable for persistent
      disks.
    sourceImage: The source image to create this disk. When creating a new
      instance, one of initializeParams.sourceImage or disks.source is
      required except for local SSD.  To create a disk with one of the public
      operating system images, specify the image by its family name. For
      example, specify family/debian-9 to use the latest Debian 9 image:
      projects/debian-cloud/global/images/family/debian-9   Alternatively, use
      a specific version of a public operating system image: projects/debian-
      cloud/global/images/debian-9-stretch-vYYYYMMDD   To create a disk with a
      custom image that you created, specify the image name in the following
      format: global/images/my-custom-image   You can also specify a custom
      image by its image family, which returns the latest version of the image
      in that family. Replace the image name with family/family-name:
      global/images/family/my-image-family   If the source image is deleted
      later, this field will not be set.
    sourceImageEncryptionKey: The customer-supplied encryption key of the
      source image. Required if the source image is protected by a customer-
      supplied encryption key.  Instance templates do not store customer-
      supplied encryption keys, so you cannot create disks for instances in a
      managed instance group if the source images are encrypted with your own
      keys.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels to apply to this disk. These can be later modified by the
    disks.setLabels method. This field is only applicable for persistent
    disks.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  diskName = _messages.StringField(2)
  diskSizeGb = _messages.IntegerField(3)
  diskType = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  sourceImage = _messages.StringField(6)
  sourceImageEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 7)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:  { "audit_configs": [ { "service": "allServices"
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:foo@gmail.com" ] }, { "log_type": "DATA_WRITE", }, { "log_type":
  "ADMIN_READ", } ] }, { "service": "fooservice.googleapis.com"
  "audit_log_configs": [ { "log_type": "DATA_READ", }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:bar@gmail.com" ] } ] } ] }  For
  fooservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts foo@gmail.com from DATA_READ logging, and
  bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    exemptedMembers:
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:foo@gmail.com" ] }, { "log_type": "DATA_WRITE", } ] }  This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting foo@gmail.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of [Binding.members][].
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      ADMIN_READ: <no description>
      DATA_READ: <no description>
      DATA_WRITE: <no description>
      LOG_TYPE_UNSPECIFIED: <no description>
    """
    ADMIN_READ = 0
    DATA_READ = 1
    DATA_WRITE = 2
    LOG_TYPE_UNSPECIFIED = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class AuthorizationLoggingOptions(_messages.Message):
  r"""Authorization-related information used by Cloud Audit Logging.

  Enums:
    PermissionTypeValueValuesEnum: The type of the permission that was
      checked.

  Fields:
    permissionType: The type of the permission that was checked.
  """

  class PermissionTypeValueValuesEnum(_messages.Enum):
    r"""The type of the permission that was checked.

    Values:
      ADMIN_READ: <no description>
      ADMIN_WRITE: <no description>
      DATA_READ: <no description>
      DATA_WRITE: <no description>
      PERMISSION_TYPE_UNSPECIFIED: <no description>
    """
    ADMIN_READ = 0
    ADMIN_WRITE = 1
    DATA_READ = 2
    DATA_WRITE = 3
    PERMISSION_TYPE_UNSPECIFIED = 4

  permissionType = _messages.EnumField('PermissionTypeValueValuesEnum', 1)


class Autoscaler(_messages.Message):
  r"""Represents an Autoscaler resource. Autoscalers allow you to
  automatically scale virtual machine instances in managed instance groups
  according to an autoscaling policy that you define. For more information,
  read Autoscaling Groups of Instances. (== resource_for beta.autoscalers ==)
  (== resource_for v1.autoscalers ==) (== resource_for beta.regionAutoscalers
  ==) (== resource_for v1.regionAutoscalers ==)

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the autoscaler
      configuration.

  Fields:
    autoscalingPolicy: The configuration parameters for the autoscaling
      algorithm. You can define one or more of the policies for an autoscaler:
      cpuUtilization, customMetricUtilizations, and loadBalancingUtilization.
      If none of these are specified, the default will be to autoscale based
      on cpuUtilization to 0.6 or 60%.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#autoscaler for
      autoscalers.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    region: [Output Only] URL of the region where the instance group resides
      (for autoscalers living in regional scope).
    selfLink: [Output Only] Server-defined URL for the resource.
    status: [Output Only] The status of the autoscaler configuration.
    statusDetails: [Output Only] Human-readable details about the current
      state of the autoscaler. Read the documentation for Commonly returned
      status messages for examples of status messages you might encounter.
    target: URL of the managed instance group that this autoscaler will scale.
    zone: [Output Only] URL of the zone where the instance group resides (for
      autoscalers living in zonal scope).
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output Only] The status of the autoscaler configuration.

    Values:
      ACTIVE: <no description>
      DELETING: <no description>
      ERROR: <no description>
      PENDING: <no description>
    """
    ACTIVE = 0
    DELETING = 1
    ERROR = 2
    PENDING = 3

  autoscalingPolicy = _messages.MessageField('AutoscalingPolicy', 1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#autoscaler')
  name = _messages.StringField(6)
  region = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  status = _messages.EnumField('StatusValueValuesEnum', 9)
  statusDetails = _messages.MessageField('AutoscalerStatusDetails', 10, repeated=True)
  target = _messages.StringField(11)
  zone = _messages.StringField(12)


class AutoscalerAggregatedList(_messages.Message):
  r"""A AutoscalerAggregatedList object.

  Messages:
    ItemsValue: A list of AutoscalersScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of AutoscalersScopedList resources.
    kind: [Output Only] Type of resource. Always
      compute#autoscalerAggregatedList for aggregated lists of autoscalers.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of AutoscalersScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of autoscalers.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A AutoscalersScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('AutoscalersScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#autoscalerAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class AutoscalerList(_messages.Message):
  r"""Contains a list of Autoscaler resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of Autoscaler resources.
    kind: [Output Only] Type of resource. Always compute#autoscalerList for
      lists of autoscalers.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('Autoscaler', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#autoscalerList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class AutoscalerStatusDetails(_messages.Message):
  r"""A AutoscalerStatusDetails object.

  Enums:
    TypeValueValuesEnum: The type of error returned.

  Fields:
    message: The status message.
    type: The type of error returned.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of error returned.

    Values:
      ALL_INSTANCES_UNHEALTHY: <no description>
      BACKEND_SERVICE_DOES_NOT_EXIST: <no description>
      CAPPED_AT_MAX_NUM_REPLICAS: <no description>
      CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE: <no description>
      CUSTOM_METRIC_INVALID: <no description>
      MIN_EQUALS_MAX: <no description>
      MISSING_CUSTOM_METRIC_DATA_POINTS: <no description>
      MISSING_LOAD_BALANCING_DATA_POINTS: <no description>
      MORE_THAN_ONE_BACKEND_SERVICE: <no description>
      NOT_ENOUGH_QUOTA_AVAILABLE: <no description>
      REGION_RESOURCE_STOCKOUT: <no description>
      SCALING_TARGET_DOES_NOT_EXIST: <no description>
      UNKNOWN: <no description>
      UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION: <no description>
      ZONE_RESOURCE_STOCKOUT: <no description>
    """
    ALL_INSTANCES_UNHEALTHY = 0
    BACKEND_SERVICE_DOES_NOT_EXIST = 1
    CAPPED_AT_MAX_NUM_REPLICAS = 2
    CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE = 3
    CUSTOM_METRIC_INVALID = 4
    MIN_EQUALS_MAX = 5
    MISSING_CUSTOM_METRIC_DATA_POINTS = 6
    MISSING_LOAD_BALANCING_DATA_POINTS = 7
    MORE_THAN_ONE_BACKEND_SERVICE = 8
    NOT_ENOUGH_QUOTA_AVAILABLE = 9
    REGION_RESOURCE_STOCKOUT = 10
    SCALING_TARGET_DOES_NOT_EXIST = 11
    UNKNOWN = 12
    UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION = 13
    ZONE_RESOURCE_STOCKOUT = 14

  message = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class AutoscalersScopedList(_messages.Message):
  r"""A AutoscalersScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of autoscalers when the list is empty.

  Fields:
    autoscalers: [Output Only] A list of autoscalers contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      autoscalers when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning which replaces the list of
    autoscalers when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  autoscalers = _messages.MessageField('Autoscaler', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class AutoscalingPolicy(_messages.Message):
  r"""Cloud Autoscaler policy.

  Fields:
    coolDownPeriodSec: The number of seconds that the autoscaler should wait
      before it starts collecting information from a new instance. This
      prevents the autoscaler from collecting information when the instance is
      initializing, during which the collected usage would not be reliable.
      The default time autoscaler waits is 60 seconds.  Virtual machine
      initialization times might vary because of numerous factors. We
      recommend that you test how long an instance may take to initialize. To
      do this, create an instance and time the startup process.
    cpuUtilization: Defines the CPU utilization policy that allows the
      autoscaler to scale based on the average CPU utilization of a managed
      instance group.
    customMetricUtilizations: Configuration parameters of autoscaling based on
      a custom metric.
    loadBalancingUtilization: Configuration parameters of autoscaling based on
      load balancer.
    maxNumReplicas: The maximum number of instances that the autoscaler can
      scale up to. This is required when creating or updating an autoscaler.
      The maximum number of replicas should not be lower than minimal number
      of replicas.
    minNumReplicas: The minimum number of replicas that the autoscaler can
      scale down to. This cannot be less than 0. If not provided, autoscaler
      will choose a default value depending on maximum number of instances
      allowed.
  """

  coolDownPeriodSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  cpuUtilization = _messages.MessageField('AutoscalingPolicyCpuUtilization', 2)
  customMetricUtilizations = _messages.MessageField('AutoscalingPolicyCustomMetricUtilization', 3, repeated=True)
  loadBalancingUtilization = _messages.MessageField('AutoscalingPolicyLoadBalancingUtilization', 4)
  maxNumReplicas = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  minNumReplicas = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class AutoscalingPolicyCpuUtilization(_messages.Message):
  r"""CPU utilization policy.

  Fields:
    utilizationTarget: The target CPU utilization that the autoscaler should
      maintain. Must be a float value in the range (0, 1]. If not specified,
      the default is 0.6.  If the CPU level is below the target utilization,
      the autoscaler scales down the number of instances until it reaches the
      minimum number of instances you specified or until the average CPU of
      your instances reaches the target utilization.  If the average CPU is
      above the target utilization, the autoscaler scales up until it reaches
      the maximum number of instances you specified or until the average
      utilization reaches the target utilization.
  """

  utilizationTarget = _messages.FloatField(1)


class AutoscalingPolicyCustomMetricUtilization(_messages.Message):
  r"""Custom utilization metric policy.

  Enums:
    UtilizationTargetTypeValueValuesEnum: Defines how target utilization value
      is expressed for a Stackdriver Monitoring metric. Either GAUGE,
      DELTA_PER_SECOND, or DELTA_PER_MINUTE. If not specified, the default is
      GAUGE.

  Fields:
    filter: A filter string, compatible with a Stackdriver Monitoring filter
      string for TimeSeries.list API call. This filter is used to select a
      specific TimeSeries for the purpose of autoscaling and to determine
      whether the metric is exporting per-instance or per-group data.  For the
      filter to be valid for autoscaling purposes, the following rules apply:
      - You can only use the AND operator for joining selectors.  - You can
      only use direct equality comparison operator (=) without any functions
      for each selector.  - You can specify the metric in both the filter
      string and in the metric field. However, if specified in both places,
      the metric must be identical.  - The monitored resource type determines
      what kind of values are expected for the metric. If it is a
      gce_instance, the autoscaler expects the metric to include a separate
      TimeSeries for each instance in a group. In such a case, you cannot
      filter on resource labels. If the resource type is any other value, the
      autoscaler expects this metric to contain values that apply to the
      entire autoscaled instance group and resource label filtering can be
      performed to point autoscaler at the correct TimeSeries to scale upon.
      This is called a per-group metric for the purpose of autoscaling.  If
      not specified, the type defaults to gce_instance.    You should provide
      a filter that is selective enough to pick just one TimeSeries for the
      autoscaled group or for each of the instances (if you are using
      gce_instance resource type). If multiple TimeSeries are returned upon
      the query execution, the autoscaler will sum their respective values to
      obtain its scaling value.
    metric: The identifier (type) of the Stackdriver Monitoring metric. The
      metric cannot have negative values.  The metric must have a value type
      of INT64 or DOUBLE.
    singleInstanceAssignment: If scaling is based on a per-group metric value
      that represents the total amount of work to be done or resource usage,
      set this value to an amount assigned for a single instance of the scaled
      group. Autoscaler will keep the number of instances proportional to the
      value of this metric, the metric itself should not change value due to
      group resizing.  A good metric to use with the target is for example
      pubsub.googleapis.com/subscription/num_undelivered_messages or a custom
      metric exporting the total number of requests coming to your instances.
      A bad example would be a metric exporting an average or median latency,
      since this value can't include a chunk assignable to a single instance,
      it could be better used with utilization_target instead.
    utilizationTarget: The target value of the metric that autoscaler should
      maintain. This must be a positive value. A utilization metric scales
      number of virtual machines handling requests to increase or decrease
      proportionally to the metric.  For example, a good metric to use as a
      utilization_target is
      compute.googleapis.com/instance/network/received_bytes_count. The
      autoscaler will work to keep this value constant for each of the
      instances.
    utilizationTargetType: Defines how target utilization value is expressed
      for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or
      DELTA_PER_MINUTE. If not specified, the default is GAUGE.
  """

  class UtilizationTargetTypeValueValuesEnum(_messages.Enum):
    r"""Defines how target utilization value is expressed for a Stackdriver
    Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE. If
    not specified, the default is GAUGE.

    Values:
      DELTA_PER_MINUTE: <no description>
      DELTA_PER_SECOND: <no description>
      GAUGE: <no description>
    """
    DELTA_PER_MINUTE = 0
    DELTA_PER_SECOND = 1
    GAUGE = 2

  filter = _messages.StringField(1)
  metric = _messages.StringField(2)
  singleInstanceAssignment = _messages.FloatField(3)
  utilizationTarget = _messages.FloatField(4)
  utilizationTargetType = _messages.EnumField('UtilizationTargetTypeValueValuesEnum', 5)


class AutoscalingPolicyLoadBalancingUtilization(_messages.Message):
  r"""Configuration parameters of autoscaling based on load balancing.

  Fields:
    utilizationTarget: Fraction of backend capacity utilization (set in
      HTTP(s) load balancing configuration) that autoscaler should maintain.
      Must be a positive float value. If not defined, the default is 0.8.
  """

  utilizationTarget = _messages.FloatField(1)


class Backend(_messages.Message):
  r"""Message containing information of one individual backend.

  Enums:
    BalancingModeValueValuesEnum: Specifies the balancing mode for this
      backend. For global HTTP(S) or TCP/SSL load balancing, the default is
      UTILIZATION. Valid values are UTILIZATION, RATE (for HTTP(S)) and
      CONNECTION (for TCP/SSL).  For Internal Load Balancing, the default and
      only supported mode is CONNECTION.

  Fields:
    balancingMode: Specifies the balancing mode for this backend. For global
      HTTP(S) or TCP/SSL load balancing, the default is UTILIZATION. Valid
      values are UTILIZATION, RATE (for HTTP(S)) and CONNECTION (for TCP/SSL).
      For Internal Load Balancing, the default and only supported mode is
      CONNECTION.
    capacityScaler: A multiplier applied to the group's maximum servicing
      capacity (based on UTILIZATION, RATE or CONNECTION). Default value is 1,
      which means the group will serve up to 100% of its configured capacity
      (depending on balancingMode). A setting of 0 means the group is
      completely drained, offering 0% of its available Capacity. Valid range
      is [0.0,1.0].  This cannot be used for internal load balancing.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    group: The fully-qualified URL of a Instance Group resource. This instance
      group defines the list of instances that serve traffic. Member virtual
      machine instances from each instance group must live in the same zone as
      the instance group itself. No two backends in a backend service are
      allowed to use same Instance Group resource.  Note that you must specify
      an Instance Group resource using the fully-qualified URL, rather than a
      partial URL.  When the BackendService has load balancing scheme
      INTERNAL, the instance group must be within the same region as the
      BackendService.
    maxConnections: The max number of simultaneous connections for the group.
      Can be used with either CONNECTION or UTILIZATION balancing modes. For
      CONNECTION mode, either maxConnections or maxConnectionsPerInstance must
      be set.  This cannot be used for internal load balancing.
    maxConnectionsPerEndpoint: The max number of simultaneous connections that
      a single backend network endpoint can handle. This is used to calculate
      the capacity of the group. Can be used in either CONNECTION or
      UTILIZATION balancing modes. For CONNECTION mode, either maxConnections
      or maxConnectionsPerEndpoint must be set.  This cannot be used for
      internal load balancing.
    maxConnectionsPerInstance: The max number of simultaneous connections that
      a single backend instance can handle. This is used to calculate the
      capacity of the group. Can be used in either CONNECTION or UTILIZATION
      balancing modes. For CONNECTION mode, either maxConnections or
      maxConnectionsPerInstance must be set.  This cannot be used for internal
      load balancing.
    maxRate: The max requests per second (RPS) of the group. Can be used with
      either RATE or UTILIZATION balancing modes, but required if RATE mode.
      For RATE mode, either maxRate or maxRatePerInstance must be set.  This
      cannot be used for internal load balancing.
    maxRatePerEndpoint: The max requests per second (RPS) that a single
      backend network endpoint can handle. This is used to calculate the
      capacity of the group. Can be used in either balancing mode. For RATE
      mode, either maxRate or maxRatePerEndpoint must be set.  This cannot be
      used for internal load balancing.
    maxRatePerInstance: The max requests per second (RPS) that a single
      backend instance can handle. This is used to calculate the capacity of
      the group. Can be used in either balancing mode. For RATE mode, either
      maxRate or maxRatePerInstance must be set.  This cannot be used for
      internal load balancing.
    maxUtilization: Used when balancingMode is UTILIZATION. This ratio defines
      the CPU utilization target for the group. The default is 0.8. Valid
      range is [0.0, 1.0].  This cannot be used for internal load balancing.
  """

  class BalancingModeValueValuesEnum(_messages.Enum):
    r"""Specifies the balancing mode for this backend. For global HTTP(S) or
    TCP/SSL load balancing, the default is UTILIZATION. Valid values are
    UTILIZATION, RATE (for HTTP(S)) and CONNECTION (for TCP/SSL).  For
    Internal Load Balancing, the default and only supported mode is
    CONNECTION.

    Values:
      CONNECTION: <no description>
      RATE: <no description>
      UTILIZATION: <no description>
    """
    CONNECTION = 0
    RATE = 1
    UTILIZATION = 2

  balancingMode = _messages.EnumField('BalancingModeValueValuesEnum', 1)
  capacityScaler = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  description = _messages.StringField(3)
  group = _messages.StringField(4)
  maxConnections = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxConnectionsPerEndpoint = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  maxConnectionsPerInstance = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  maxRate = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  maxRatePerEndpoint = _messages.FloatField(9, variant=_messages.Variant.FLOAT)
  maxRatePerInstance = _messages.FloatField(10, variant=_messages.Variant.FLOAT)
  maxUtilization = _messages.FloatField(11, variant=_messages.Variant.FLOAT)


class BackendBucket(_messages.Message):
  r"""A BackendBucket resource. This resource defines a Cloud Storage bucket.

  Fields:
    bucketName: Cloud Storage bucket name.
    cdnPolicy: Cloud CDN configuration for this BackendBucket.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional textual description of the resource; provided by
      the client when the resource is created.
    enableCdn: If true, enable Cloud CDN for this BackendBucket.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    kind: Type of the resource.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    selfLink: [Output Only] Server-defined URL for the resource.
  """

  bucketName = _messages.StringField(1)
  cdnPolicy = _messages.MessageField('BackendBucketCdnPolicy', 2)
  creationTimestamp = _messages.StringField(3)
  description = _messages.StringField(4)
  enableCdn = _messages.BooleanField(5)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(7, default=u'compute#backendBucket')
  name = _messages.StringField(8)
  selfLink = _messages.StringField(9)


class BackendBucketCdnPolicy(_messages.Message):
  r"""Message containing Cloud CDN configuration for a backend bucket.

  Fields:
    signedUrlCacheMaxAgeSec: Maximum number of seconds the response to a
      signed URL request will be considered fresh. After this time period, the
      response will be revalidated before being served. Defaults to 1hr
      (3600s). When serving responses to signed URL requests, Cloud CDN will
      internally behave as though all responses from this backend had a
      ?Cache-Control: public, max-age=[TTL]? header, regardless of any
      existing Cache-Control header. The actual headers served in responses
      will not be altered.
    signedUrlKeyNames: [Output Only] Names of the keys for signing request
      URLs.
  """

  signedUrlCacheMaxAgeSec = _messages.IntegerField(1)
  signedUrlKeyNames = _messages.StringField(2, repeated=True)


class BackendBucketList(_messages.Message):
  r"""Contains a list of BackendBucket resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of BackendBucket resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('BackendBucket', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#backendBucketList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class BackendService(_messages.Message):
  r"""A BackendService resource. This resource defines a group of backend
  virtual machines and their serving capacity. (== resource_for
  v1.backendService ==) (== resource_for beta.backendService ==)

  Enums:
    LoadBalancingSchemeValueValuesEnum: Indicates whether the backend service
      will be used with internal or external load balancing. A backend service
      created for one type of load balancing cannot be used with the other.
      Possible values are INTERNAL and EXTERNAL.
    ProtocolValueValuesEnum: The protocol this BackendService uses to
      communicate with backends.  Possible values are HTTP, HTTPS, TCP, and
      SSL. The default is HTTP.  For internal load balancing, the possible
      values are TCP and UDP, and the default is TCP.
    SessionAffinityValueValuesEnum: Type of session affinity to use. The
      default is NONE.  When the load balancing scheme is EXTERNAL, can be
      NONE, CLIENT_IP, or GENERATED_COOKIE.  When the load balancing scheme is
      INTERNAL, can be NONE, CLIENT_IP, CLIENT_IP_PROTO, or
      CLIENT_IP_PORT_PROTO.  When the protocol is UDP, this field is not used.

  Fields:
    affinityCookieTtlSec: Lifetime of cookies in seconds if session_affinity
      is GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
      only until the end of the browser session (or equivalent). The maximum
      allowed value for TTL is one day.  When the load balancing scheme is
      INTERNAL, this field is not used.
    backends: The list of backends that serve this BackendService.
    cdnPolicy: Cloud CDN configuration for this BackendService.
    connectionDraining: A ConnectionDraining attribute.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    customRequestHeaders: Headers that the HTTP/S load balancer should add to
      proxied requests.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    enableCDN: If true, enable Cloud CDN for this BackendService.  When the
      load balancing scheme is INTERNAL, this field is not used.
    fingerprint: Fingerprint of this resource. A hash of the contents stored
      in this object. This field is used in optimistic locking. This field
      will be ignored when inserting a BackendService. An up-to-date
      fingerprint must be provided in order to update the BackendService.  To
      see the latest fingerprint, make a get() request to retrieve a
      BackendService.
    healthChecks: The list of URLs to the HttpHealthCheck or HttpsHealthCheck
      resource for health checking this BackendService. Currently at most one
      health check can be specified, and a health check is required for
      Compute Engine backend services. A health check must not be specified
      for App Engine backend and Cloud Function backend.  For internal load
      balancing, a URL to a HealthCheck resource must be specified instead.
    iap: A BackendServiceIAP attribute.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of resource. Always compute#backendService for
      backend services.
    loadBalancingScheme: Indicates whether the backend service will be used
      with internal or external load balancing. A backend service created for
      one type of load balancing cannot be used with the other. Possible
      values are INTERNAL and EXTERNAL.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    port: Deprecated in favor of portName. The TCP port to connect on the
      backend. The default value is 80.  This cannot be used for internal load
      balancing.
    portName: Name of backend port. The same name should appear in the
      instance groups referenced by this service. Required when the load
      balancing scheme is EXTERNAL.  When the load balancing scheme is
      INTERNAL, this field is not used.
    protocol: The protocol this BackendService uses to communicate with
      backends.  Possible values are HTTP, HTTPS, TCP, and SSL. The default is
      HTTP.  For internal load balancing, the possible values are TCP and UDP,
      and the default is TCP.
    region: [Output Only] URL of the region where the regional backend service
      resides. This field is not applicable to global backend services. You
      must specify this field as part of the HTTP request URL. It is not
      settable as a field in the request body.
    securityPolicy: [Output Only] The resource URL for the security policy
      associated with this backend service.
    selfLink: [Output Only] Server-defined URL for the resource.
    sessionAffinity: Type of session affinity to use. The default is NONE.
      When the load balancing scheme is EXTERNAL, can be NONE, CLIENT_IP, or
      GENERATED_COOKIE.  When the load balancing scheme is INTERNAL, can be
      NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.  When the
      protocol is UDP, this field is not used.
    timeoutSec: How many seconds to wait for the backend before considering it
      a failed request. Default is 30 seconds.
  """

  class LoadBalancingSchemeValueValuesEnum(_messages.Enum):
    r"""Indicates whether the backend service will be used with internal or
    external load balancing. A backend service created for one type of load
    balancing cannot be used with the other. Possible values are INTERNAL and
    EXTERNAL.

    Values:
      EXTERNAL: <no description>
      INTERNAL: <no description>
      INVALID_LOAD_BALANCING_SCHEME: <no description>
    """
    EXTERNAL = 0
    INTERNAL = 1
    INVALID_LOAD_BALANCING_SCHEME = 2

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""The protocol this BackendService uses to communicate with backends.
    Possible values are HTTP, HTTPS, TCP, and SSL. The default is HTTP.  For
    internal load balancing, the possible values are TCP and UDP, and the
    default is TCP.

    Values:
      HTTP: <no description>
      HTTP2: <no description>
      HTTPS: <no description>
      SSL: <no description>
      TCP: <no description>
      UDP: <no description>
    """
    HTTP = 0
    HTTP2 = 1
    HTTPS = 2
    SSL = 3
    TCP = 4
    UDP = 5

  class SessionAffinityValueValuesEnum(_messages.Enum):
    r"""Type of session affinity to use. The default is NONE.  When the load
    balancing scheme is EXTERNAL, can be NONE, CLIENT_IP, or GENERATED_COOKIE.
    When the load balancing scheme is INTERNAL, can be NONE, CLIENT_IP,
    CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.  When the protocol is UDP, this
    field is not used.

    Values:
      CLIENT_IP: <no description>
      CLIENT_IP_PORT_PROTO: <no description>
      CLIENT_IP_PROTO: <no description>
      GENERATED_COOKIE: <no description>
      NONE: <no description>
    """
    CLIENT_IP = 0
    CLIENT_IP_PORT_PROTO = 1
    CLIENT_IP_PROTO = 2
    GENERATED_COOKIE = 3
    NONE = 4

  affinityCookieTtlSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  backends = _messages.MessageField('Backend', 2, repeated=True)
  cdnPolicy = _messages.MessageField('BackendServiceCdnPolicy', 3)
  connectionDraining = _messages.MessageField('ConnectionDraining', 4)
  creationTimestamp = _messages.StringField(5)
  customRequestHeaders = _messages.StringField(6, repeated=True)
  description = _messages.StringField(7)
  enableCDN = _messages.BooleanField(8)
  fingerprint = _messages.BytesField(9)
  healthChecks = _messages.StringField(10, repeated=True)
  iap = _messages.MessageField('BackendServiceIAP', 11)
  id = _messages.IntegerField(12, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(13, default=u'compute#backendService')
  loadBalancingScheme = _messages.EnumField('LoadBalancingSchemeValueValuesEnum', 14)
  name = _messages.StringField(15)
  port = _messages.IntegerField(16, variant=_messages.Variant.INT32)
  portName = _messages.StringField(17)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 18)
  region = _messages.StringField(19)
  securityPolicy = _messages.StringField(20)
  selfLink = _messages.StringField(21)
  sessionAffinity = _messages.EnumField('SessionAffinityValueValuesEnum', 22)
  timeoutSec = _messages.IntegerField(23, variant=_messages.Variant.INT32)


class BackendServiceAggregatedList(_messages.Message):
  r"""Contains a list of BackendServicesScopedList.

  Messages:
    ItemsValue: A list of BackendServicesScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of BackendServicesScopedList resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of BackendServicesScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: Name of the scope containing this set of
        BackendServices.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A BackendServicesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('BackendServicesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#backendServiceAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class BackendServiceCdnPolicy(_messages.Message):
  r"""Message containing Cloud CDN configuration for a backend service.

  Fields:
    cacheKeyPolicy: The CacheKeyPolicy for this CdnPolicy.
    signedUrlCacheMaxAgeSec: Maximum number of seconds the response to a
      signed URL request will be considered fresh. After this time period, the
      response will be revalidated before being served. Defaults to 1hr
      (3600s). When serving responses to signed URL requests, Cloud CDN will
      internally behave as though all responses from this backend had a
      ?Cache-Control: public, max-age=[TTL]? header, regardless of any
      existing Cache-Control header. The actual headers served in responses
      will not be altered.
    signedUrlKeyNames: [Output Only] Names of the keys for signing request
      URLs.
  """

  cacheKeyPolicy = _messages.MessageField('CacheKeyPolicy', 1)
  signedUrlCacheMaxAgeSec = _messages.IntegerField(2)
  signedUrlKeyNames = _messages.StringField(3, repeated=True)


class BackendServiceGroupHealth(_messages.Message):
  r"""A BackendServiceGroupHealth object.

  Fields:
    healthStatus: A HealthStatus attribute.
    kind: [Output Only] Type of resource. Always
      compute#backendServiceGroupHealth for the health of backend services.
  """

  healthStatus = _messages.MessageField('HealthStatus', 1, repeated=True)
  kind = _messages.StringField(2, default=u'compute#backendServiceGroupHealth')


class BackendServiceIAP(_messages.Message):
  r"""Identity-Aware Proxy

  Fields:
    enabled: A boolean attribute.
    oauth2ClientId: A string attribute.
    oauth2ClientSecret: A string attribute.
    oauth2ClientSecretSha256: [Output Only] SHA256 hash value for the field
      oauth2_client_secret above.
  """

  enabled = _messages.BooleanField(1)
  oauth2ClientId = _messages.StringField(2)
  oauth2ClientSecret = _messages.StringField(3)
  oauth2ClientSecretSha256 = _messages.StringField(4)


class BackendServiceList(_messages.Message):
  r"""Contains a list of BackendService resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of BackendService resources.
    kind: [Output Only] Type of resource. Always compute#backendServiceList
      for lists of backend services.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('BackendService', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#backendServiceList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class BackendServiceReference(_messages.Message):
  r"""A BackendServiceReference object.

  Fields:
    backendService: A string attribute.
  """

  backendService = _messages.StringField(1)


class BackendServicesScopedList(_messages.Message):
  r"""A BackendServicesScopedList object.

  Messages:
    WarningValue: Informational warning which replaces the list of backend
      services when the list is empty.

  Fields:
    backendServices: A list of BackendServices contained in this scope.
    warning: Informational warning which replaces the list of backend services
      when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""Informational warning which replaces the list of backend services when
    the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  backendServices = _messages.MessageField('BackendService', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: Unimplemented. The condition that is associated with this
      binding. NOTE: an unsatisfied condition will not allow user access via
      current binding. Different bindings, including their conditions, are
      examined independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@gmail.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`.  *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`.    * `domain:{domain}`: A Google Apps
      domain name that represents all the users of that domain. For example,
      `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CacheInvalidationRule(_messages.Message):
  r"""A CacheInvalidationRule object.

  Fields:
    host: If set, this invalidation rule will only apply to requests with a
      Host header matching host.
    path: A string attribute.
  """

  host = _messages.StringField(1)
  path = _messages.StringField(2)


class CacheKeyPolicy(_messages.Message):
  r"""Message containing what to include in the cache key for a request for
  Cloud CDN.

  Fields:
    includeHost: If true, requests to different hosts will be cached
      separately.
    includeProtocol: If true, http and https requests will be cached
      separately.
    includeQueryString: If true, include query string parameters in the cache
      key according to query_string_whitelist and query_string_blacklist. If
      neither is set, the entire query string will be included. If false, the
      query string will be excluded from the cache key entirely.
    queryStringBlacklist: Names of query string parameters to exclude in cache
      keys. All other parameters will be included. Either specify
      query_string_whitelist or query_string_blacklist, not both. '&' and '='
      will be percent encoded and not treated as delimiters.
    queryStringWhitelist: Names of query string parameters to include in cache
      keys. All other parameters will be excluded. Either specify
      query_string_whitelist or query_string_blacklist, not both. '&' and '='
      will be percent encoded and not treated as delimiters.
  """

  includeHost = _messages.BooleanField(1)
  includeProtocol = _messages.BooleanField(2)
  includeQueryString = _messages.BooleanField(3)
  queryStringBlacklist = _messages.StringField(4, repeated=True)
  queryStringWhitelist = _messages.StringField(5, repeated=True)


class Commitment(_messages.Message):
  r"""Represents a Commitment resource. Creating a Commitment resource means
  that you are purchasing a committed use contract with an explicit start and
  end time. You can create commitments based on vCPUs and memory usage and
  receive discounted rates. For full details, read Signing Up for Committed
  Use Discounts.  Committed use discounts are subject to Google Cloud
  Platform's Service Specific Terms. By purchasing a committed use discount,
  you agree to these terms. Committed use discounts will not renew, so you
  must purchase a new commitment to continue receiving discounts. (==
  resource_for beta.commitments ==) (== resource_for v1.commitments ==)

  Enums:
    PlanValueValuesEnum: The plan for this commitment, which determines
      duration and discount rate. The currently supported plans are
      TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
    StatusValueValuesEnum: [Output Only] Status of the commitment with regards
      to eventual expiration (each commitment has an end date defined). One of
      the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    endTimestamp: [Output Only] Commitment end time in RFC3339 text format.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#commitment for
      commitments.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    plan: The plan for this commitment, which determines duration and discount
      rate. The currently supported plans are TWELVE_MONTH (1 year), and
      THIRTY_SIX_MONTH (3 years).
    region: [Output Only] URL of the region where this commitment may be used.
    resources: A list of commitment amounts for particular resources. Note
      that VCPU and MEMORY resource commitments must occur together.
    selfLink: [Output Only] Server-defined URL for the resource.
    startTimestamp: [Output Only] Commitment start time in RFC3339 text
      format.
    status: [Output Only] Status of the commitment with regards to eventual
      expiration (each commitment has an end date defined). One of the
      following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
    statusMessage: [Output Only] An optional, human-readable explanation of
      the status.
  """

  class PlanValueValuesEnum(_messages.Enum):
    r"""The plan for this commitment, which determines duration and discount
    rate. The currently supported plans are TWELVE_MONTH (1 year), and
    THIRTY_SIX_MONTH (3 years).

    Values:
      INVALID: <no description>
      THIRTY_SIX_MONTH: <no description>
      TWELVE_MONTH: <no description>
    """
    INVALID = 0
    THIRTY_SIX_MONTH = 1
    TWELVE_MONTH = 2

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output Only] Status of the commitment with regards to eventual
    expiration (each commitment has an end date defined). One of the following
    values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.

    Values:
      ACTIVE: <no description>
      CREATING: <no description>
      EXPIRED: <no description>
      NOT_YET_ACTIVE: <no description>
    """
    ACTIVE = 0
    CREATING = 1
    EXPIRED = 2
    NOT_YET_ACTIVE = 3

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  endTimestamp = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#commitment')
  name = _messages.StringField(6)
  plan = _messages.EnumField('PlanValueValuesEnum', 7)
  region = _messages.StringField(8)
  resources = _messages.MessageField('ResourceCommitment', 9, repeated=True)
  selfLink = _messages.StringField(10)
  startTimestamp = _messages.StringField(11)
  status = _messages.EnumField('StatusValueValuesEnum', 12)
  statusMessage = _messages.StringField(13)


class CommitmentAggregatedList(_messages.Message):
  r"""A CommitmentAggregatedList object.

  Messages:
    ItemsValue: A list of CommitmentsScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of CommitmentsScopedList resources.
    kind: [Output Only] Type of resource. Always
      compute#commitmentAggregatedList for aggregated lists of commitments.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of CommitmentsScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of commitments.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A CommitmentsScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('CommitmentsScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#commitmentAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class CommitmentList(_messages.Message):
  r"""Contains a list of Commitment resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of Commitment resources.
    kind: [Output Only] Type of resource. Always compute#commitmentList for
      lists of commitments.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('Commitment', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#commitmentList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class CommitmentsScopedList(_messages.Message):
  r"""A CommitmentsScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of commitments when the list is empty.

  Fields:
    commitments: [Output Only] A list of commitments contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      commitments when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning which replaces the list of
    commitments when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  commitments = _messages.MessageField('Commitment', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class ComputeAcceleratorTypesAggregatedListRequest(_messages.Message):
  r"""A ComputeAcceleratorTypesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeAcceleratorTypesGetRequest(_messages.Message):
  r"""A ComputeAcceleratorTypesGetRequest object.

  Fields:
    acceleratorType: Name of the accelerator type to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  acceleratorType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeAcceleratorTypesListRequest(_messages.Message):
  r"""A ComputeAcceleratorTypesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeAddressesAggregatedListRequest(_messages.Message):
  r"""A ComputeAddressesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeAddressesDeleteRequest(_messages.Message):
  r"""A ComputeAddressesDeleteRequest object.

  Fields:
    address: Name of the address resource to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeAddressesGetRequest(_messages.Message):
  r"""A ComputeAddressesGetRequest object.

  Fields:
    address: Name of the address resource to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeAddressesInsertRequest(_messages.Message):
  r"""A ComputeAddressesInsertRequest object.

  Fields:
    address: A Address resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  address = _messages.MessageField('Address', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeAddressesListRequest(_messages.Message):
  r"""A ComputeAddressesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeAddressesSetLabelsRequest(_messages.Message):
  r"""A ComputeAddressesSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  requestId = _messages.StringField(4)
  resource = _messages.StringField(5, required=True)


class ComputeAddressesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeAddressesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeAutoscalersAggregatedListRequest(_messages.Message):
  r"""A ComputeAutoscalersAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeAutoscalersDeleteRequest(_messages.Message):
  r"""A ComputeAutoscalersDeleteRequest object.

  Fields:
    autoscaler: Name of the autoscaler to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeAutoscalersGetRequest(_messages.Message):
  r"""A ComputeAutoscalersGetRequest object.

  Fields:
    autoscaler: Name of the autoscaler to return.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeAutoscalersInsertRequest(_messages.Message):
  r"""A ComputeAutoscalersInsertRequest object.

  Fields:
    autoscaler: A Autoscaler resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.MessageField('Autoscaler', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeAutoscalersListRequest(_messages.Message):
  r"""A ComputeAutoscalersListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeAutoscalersPatchRequest(_messages.Message):
  r"""A ComputeAutoscalersPatchRequest object.

  Fields:
    autoscaler: Name of the autoscaler to patch.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeAutoscalersTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeAutoscalersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeAutoscalersUpdateRequest(_messages.Message):
  r"""A ComputeAutoscalersUpdateRequest object.

  Fields:
    autoscaler: Name of the autoscaler to update.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: Name of the zone for this request.
  """

  autoscaler = _messages.StringField(1)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeBackendBucketsAddSignedUrlKeyRequest(_messages.Message):
  r"""A ComputeBackendBucketsAddSignedUrlKeyRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to which the Signed URL
      Key should be added. The name should conform to RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    signedUrlKey: A SignedUrlKey resource to be passed as the request body.
  """

  backendBucket = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  signedUrlKey = _messages.MessageField('SignedUrlKey', 4)


class ComputeBackendBucketsDeleteRequest(_messages.Message):
  r"""A ComputeBackendBucketsDeleteRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendBucket = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeBackendBucketsDeleteSignedUrlKeyRequest(_messages.Message):
  r"""A ComputeBackendBucketsDeleteSignedUrlKeyRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to which the Signed URL
      Key should be added. The name should conform to RFC1035.
    keyName: The name of the Signed URL Key to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendBucket = _messages.StringField(1, required=True)
  keyName = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeBackendBucketsGetRequest(_messages.Message):
  r"""A ComputeBackendBucketsGetRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to return.
    project: Project ID for this request.
  """

  backendBucket = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeBackendBucketsInsertRequest(_messages.Message):
  r"""A ComputeBackendBucketsInsertRequest object.

  Fields:
    backendBucket: A BackendBucket resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendBucket = _messages.MessageField('BackendBucket', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeBackendBucketsListRequest(_messages.Message):
  r"""A ComputeBackendBucketsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeBackendBucketsPatchRequest(_messages.Message):
  r"""A ComputeBackendBucketsPatchRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to patch.
    backendBucketResource: A BackendBucket resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendBucket = _messages.StringField(1, required=True)
  backendBucketResource = _messages.MessageField('BackendBucket', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeBackendBucketsUpdateRequest(_messages.Message):
  r"""A ComputeBackendBucketsUpdateRequest object.

  Fields:
    backendBucket: Name of the BackendBucket resource to update.
    backendBucketResource: A BackendBucket resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendBucket = _messages.StringField(1, required=True)
  backendBucketResource = _messages.MessageField('BackendBucket', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeBackendServicesAddSignedUrlKeyRequest(_messages.Message):
  r"""A ComputeBackendServicesAddSignedUrlKeyRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the Signed
      URL Key should be added. The name should conform to RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    signedUrlKey: A SignedUrlKey resource to be passed as the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  signedUrlKey = _messages.MessageField('SignedUrlKey', 4)


class ComputeBackendServicesAggregatedListRequest(_messages.Message):
  r"""A ComputeBackendServicesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Name of the project scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeBackendServicesDeleteRequest(_messages.Message):
  r"""A ComputeBackendServicesDeleteRequest object.

  Fields:
    backendService: Name of the BackendService resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeBackendServicesDeleteSignedUrlKeyRequest(_messages.Message):
  r"""A ComputeBackendServicesDeleteSignedUrlKeyRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the Signed
      URL Key should be added. The name should conform to RFC1035.
    keyName: The name of the Signed URL Key to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  keyName = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeBackendServicesGetHealthRequest(_messages.Message):
  r"""A ComputeBackendServicesGetHealthRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the queried
      instance belongs.
    project: A string attribute.
    resourceGroupReference: A ResourceGroupReference resource to be passed as
      the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  resourceGroupReference = _messages.MessageField('ResourceGroupReference', 3)


class ComputeBackendServicesGetRequest(_messages.Message):
  r"""A ComputeBackendServicesGetRequest object.

  Fields:
    backendService: Name of the BackendService resource to return.
    project: Project ID for this request.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeBackendServicesInsertRequest(_messages.Message):
  r"""A ComputeBackendServicesInsertRequest object.

  Fields:
    backendService: A BackendService resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.MessageField('BackendService', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeBackendServicesListRequest(_messages.Message):
  r"""A ComputeBackendServicesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeBackendServicesPatchRequest(_messages.Message):
  r"""A ComputeBackendServicesPatchRequest object.

  Fields:
    backendService: Name of the BackendService resource to patch.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeBackendServicesSetSecurityPolicyRequest(_messages.Message):
  r"""A ComputeBackendServicesSetSecurityPolicyRequest object.

  Fields:
    backendService: Name of the BackendService resource to which the security
      policy should be set. The name should conform to RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    securityPolicyReference: A SecurityPolicyReference resource to be passed
      as the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  securityPolicyReference = _messages.MessageField('SecurityPolicyReference', 4)


class ComputeBackendServicesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeBackendServicesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeBackendServicesUpdateRequest(_messages.Message):
  r"""A ComputeBackendServicesUpdateRequest object.

  Fields:
    backendService: Name of the BackendService resource to update.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeDiskTypesAggregatedListRequest(_messages.Message):
  r"""A ComputeDiskTypesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeDiskTypesGetRequest(_messages.Message):
  r"""A ComputeDiskTypesGetRequest object.

  Fields:
    diskType: Name of the disk type to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  diskType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeDiskTypesListRequest(_messages.Message):
  r"""A ComputeDiskTypesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeDisksAddResourcePoliciesRequest(_messages.Message):
  r"""A ComputeDisksAddResourcePoliciesRequest object.

  Fields:
    disk: The disk name for this request.
    disksAddResourcePoliciesRequest: A DisksAddResourcePoliciesRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  disksAddResourcePoliciesRequest = _messages.MessageField('DisksAddResourcePoliciesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeDisksAggregatedListRequest(_messages.Message):
  r"""A ComputeDisksAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeDisksCreateSnapshotRequest(_messages.Message):
  r"""A ComputeDisksCreateSnapshotRequest object.

  Fields:
    disk: Name of the persistent disk to snapshot.
    guestFlush: A boolean attribute.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    snapshot: A Snapshot resource to be passed as the request body.
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  guestFlush = _messages.BooleanField(2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  snapshot = _messages.MessageField('Snapshot', 5)
  zone = _messages.StringField(6, required=True)


class ComputeDisksDeleteRequest(_messages.Message):
  r"""A ComputeDisksDeleteRequest object.

  Fields:
    disk: Name of the persistent disk to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeDisksGetIamPolicyRequest(_messages.Message):
  r"""A ComputeDisksGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeDisksGetRequest(_messages.Message):
  r"""A ComputeDisksGetRequest object.

  Fields:
    disk: Name of the persistent disk to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeDisksInsertRequest(_messages.Message):
  r"""A ComputeDisksInsertRequest object.

  Fields:
    disk: A Disk resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    sourceImage: Optional. Source image to restore onto a disk.
    zone: The name of the zone for this request.
  """

  disk = _messages.MessageField('Disk', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  sourceImage = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeDisksListRequest(_messages.Message):
  r"""A ComputeDisksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeDisksRemoveResourcePoliciesRequest(_messages.Message):
  r"""A ComputeDisksRemoveResourcePoliciesRequest object.

  Fields:
    disk: The disk name for this request.
    disksRemoveResourcePoliciesRequest: A DisksRemoveResourcePoliciesRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  disksRemoveResourcePoliciesRequest = _messages.MessageField('DisksRemoveResourcePoliciesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeDisksResizeRequest(_messages.Message):
  r"""A ComputeDisksResizeRequest object.

  Fields:
    disk: The name of the persistent disk.
    disksResizeRequest: A DisksResizeRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  disk = _messages.StringField(1, required=True)
  disksResizeRequest = _messages.MessageField('DisksResizeRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeDisksSetIamPolicyRequest(_messages.Message):
  r"""A ComputeDisksSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
    zoneSetPolicyRequest: A ZoneSetPolicyRequest resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)
  zoneSetPolicyRequest = _messages.MessageField('ZoneSetPolicyRequest', 4)


class ComputeDisksSetLabelsRequest(_messages.Message):
  r"""A ComputeDisksSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
    zoneSetLabelsRequest: A ZoneSetLabelsRequest resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  resource = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)
  zoneSetLabelsRequest = _messages.MessageField('ZoneSetLabelsRequest', 5)


class ComputeDisksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeDisksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeFirewallsDeleteRequest(_messages.Message):
  r"""A ComputeFirewallsDeleteRequest object.

  Fields:
    firewall: Name of the firewall rule to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  firewall = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeFirewallsGetRequest(_messages.Message):
  r"""A ComputeFirewallsGetRequest object.

  Fields:
    firewall: Name of the firewall rule to return.
    project: Project ID for this request.
  """

  firewall = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeFirewallsInsertRequest(_messages.Message):
  r"""A ComputeFirewallsInsertRequest object.

  Fields:
    firewall: A Firewall resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  firewall = _messages.MessageField('Firewall', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeFirewallsListRequest(_messages.Message):
  r"""A ComputeFirewallsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeFirewallsPatchRequest(_messages.Message):
  r"""A ComputeFirewallsPatchRequest object.

  Fields:
    firewall: Name of the firewall rule to patch.
    firewallResource: A Firewall resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  firewall = _messages.StringField(1, required=True)
  firewallResource = _messages.MessageField('Firewall', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeFirewallsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeFirewallsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeFirewallsUpdateRequest(_messages.Message):
  r"""A ComputeFirewallsUpdateRequest object.

  Fields:
    firewall: Name of the firewall rule to update.
    firewallResource: A Firewall resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  firewall = _messages.StringField(1, required=True)
  firewallResource = _messages.MessageField('Firewall', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeForwardingRulesAggregatedListRequest(_messages.Message):
  r"""A ComputeForwardingRulesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeForwardingRulesDeleteRequest(_messages.Message):
  r"""A ComputeForwardingRulesDeleteRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeForwardingRulesGetRequest(_messages.Message):
  r"""A ComputeForwardingRulesGetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeForwardingRulesInsertRequest(_messages.Message):
  r"""A ComputeForwardingRulesInsertRequest object.

  Fields:
    forwardingRule: A ForwardingRule resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  forwardingRule = _messages.MessageField('ForwardingRule', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeForwardingRulesListRequest(_messages.Message):
  r"""A ComputeForwardingRulesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeForwardingRulesSetLabelsRequest(_messages.Message):
  r"""A ComputeForwardingRulesSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  requestId = _messages.StringField(4)
  resource = _messages.StringField(5, required=True)


class ComputeForwardingRulesSetTargetRequest(_messages.Message):
  r"""A ComputeForwardingRulesSetTargetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource in which target is to
      be set.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetReference: A TargetReference resource to be passed as the request
      body.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  targetReference = _messages.MessageField('TargetReference', 5)


class ComputeForwardingRulesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeForwardingRulesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeGlobalAddressesDeleteRequest(_messages.Message):
  r"""A ComputeGlobalAddressesDeleteRequest object.

  Fields:
    address: Name of the address resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalAddressesGetRequest(_messages.Message):
  r"""A ComputeGlobalAddressesGetRequest object.

  Fields:
    address: Name of the address resource to return.
    project: Project ID for this request.
  """

  address = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalAddressesInsertRequest(_messages.Message):
  r"""A ComputeGlobalAddressesInsertRequest object.

  Fields:
    address: A Address resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  address = _messages.MessageField('Address', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalAddressesListRequest(_messages.Message):
  r"""A ComputeGlobalAddressesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeGlobalAddressesSetLabelsRequest(_messages.Message):
  r"""A ComputeGlobalAddressesSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeGlobalAddressesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeGlobalAddressesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeGlobalForwardingRulesDeleteRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesDeleteRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalForwardingRulesGetRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesGetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource to return.
    project: Project ID for this request.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalForwardingRulesInsertRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesInsertRequest object.

  Fields:
    forwardingRule: A ForwardingRule resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  forwardingRule = _messages.MessageField('ForwardingRule', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeGlobalForwardingRulesListRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeGlobalForwardingRulesSetLabelsRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeGlobalForwardingRulesSetTargetRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesSetTargetRequest object.

  Fields:
    forwardingRule: Name of the ForwardingRule resource in which target is to
      be set.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetReference: A TargetReference resource to be passed as the request
      body.
  """

  forwardingRule = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  targetReference = _messages.MessageField('TargetReference', 4)


class ComputeGlobalForwardingRulesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeGlobalForwardingRulesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeGlobalOperationsAggregatedListRequest(_messages.Message):
  r"""A ComputeGlobalOperationsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeGlobalOperationsDeleteRequest(_messages.Message):
  r"""A ComputeGlobalOperationsDeleteRequest object.

  Fields:
    operation: Name of the Operations resource to delete.
    project: Project ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalOperationsDeleteResponse(_messages.Message):
  r"""An empty ComputeGlobalOperationsDelete response."""


class ComputeGlobalOperationsGetRequest(_messages.Message):
  r"""A ComputeGlobalOperationsGetRequest object.

  Fields:
    operation: Name of the Operations resource to return.
    project: Project ID for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeGlobalOperationsListRequest(_messages.Message):
  r"""A ComputeGlobalOperationsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeHealthChecksDeleteRequest(_messages.Message):
  r"""A ComputeHealthChecksDeleteRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHealthChecksGetRequest(_messages.Message):
  r"""A ComputeHealthChecksGetRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to return.
    project: Project ID for this request.
  """

  healthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHealthChecksInsertRequest(_messages.Message):
  r"""A ComputeHealthChecksInsertRequest object.

  Fields:
    healthCheck: A HealthCheck resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.MessageField('HealthCheck', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHealthChecksListRequest(_messages.Message):
  r"""A ComputeHealthChecksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeHealthChecksPatchRequest(_messages.Message):
  r"""A ComputeHealthChecksPatchRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to patch.
    healthCheckResource: A HealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.StringField(1, required=True)
  healthCheckResource = _messages.MessageField('HealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeHealthChecksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeHealthChecksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeHealthChecksUpdateRequest(_messages.Message):
  r"""A ComputeHealthChecksUpdateRequest object.

  Fields:
    healthCheck: Name of the HealthCheck resource to update.
    healthCheckResource: A HealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  healthCheck = _messages.StringField(1, required=True)
  healthCheckResource = _messages.MessageField('HealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeHttpHealthChecksDeleteRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksDeleteRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHttpHealthChecksGetRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksGetRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to return.
    project: Project ID for this request.
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHttpHealthChecksInsertRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksInsertRequest object.

  Fields:
    httpHealthCheck: A HttpHealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  httpHealthCheck = _messages.MessageField('HttpHealthCheck', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHttpHealthChecksListRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeHttpHealthChecksPatchRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksPatchRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to patch.
    httpHealthCheckResource: A HttpHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  httpHealthCheckResource = _messages.MessageField('HttpHealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeHttpHealthChecksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeHttpHealthChecksUpdateRequest(_messages.Message):
  r"""A ComputeHttpHealthChecksUpdateRequest object.

  Fields:
    httpHealthCheck: Name of the HttpHealthCheck resource to update.
    httpHealthCheckResource: A HttpHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  httpHealthCheck = _messages.StringField(1, required=True)
  httpHealthCheckResource = _messages.MessageField('HttpHealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeHttpsHealthChecksDeleteRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksDeleteRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHttpsHealthChecksGetRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksGetRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to return.
    project: Project ID for this request.
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeHttpsHealthChecksInsertRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksInsertRequest object.

  Fields:
    httpsHealthCheck: A HttpsHealthCheck resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  httpsHealthCheck = _messages.MessageField('HttpsHealthCheck', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeHttpsHealthChecksListRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeHttpsHealthChecksPatchRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksPatchRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to patch.
    httpsHealthCheckResource: A HttpsHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  httpsHealthCheckResource = _messages.MessageField('HttpsHealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeHttpsHealthChecksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeHttpsHealthChecksUpdateRequest(_messages.Message):
  r"""A ComputeHttpsHealthChecksUpdateRequest object.

  Fields:
    httpsHealthCheck: Name of the HttpsHealthCheck resource to update.
    httpsHealthCheckResource: A HttpsHealthCheck resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  httpsHealthCheck = _messages.StringField(1, required=True)
  httpsHealthCheckResource = _messages.MessageField('HttpsHealthCheck', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeImagesDeleteRequest(_messages.Message):
  r"""A ComputeImagesDeleteRequest object.

  Fields:
    image: Name of the image resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  image = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeImagesDeprecateRequest(_messages.Message):
  r"""A ComputeImagesDeprecateRequest object.

  Fields:
    deprecationStatus: A DeprecationStatus resource to be passed as the
      request body.
    image: Image name.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  deprecationStatus = _messages.MessageField('DeprecationStatus', 1)
  image = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeImagesGetFromFamilyRequest(_messages.Message):
  r"""A ComputeImagesGetFromFamilyRequest object.

  Fields:
    family: Name of the image family to search for.
    project: Project ID for this request.
  """

  family = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeImagesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeImagesGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)


class ComputeImagesGetRequest(_messages.Message):
  r"""A ComputeImagesGetRequest object.

  Fields:
    image: Name of the image resource to return.
    project: Project ID for this request.
  """

  image = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeImagesInsertRequest(_messages.Message):
  r"""A ComputeImagesInsertRequest object.

  Fields:
    forceCreate: Force image creation if true.
    image: A Image resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  forceCreate = _messages.BooleanField(1)
  image = _messages.MessageField('Image', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeImagesListRequest(_messages.Message):
  r"""A ComputeImagesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeImagesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeImagesSetIamPolicyRequest object.

  Fields:
    globalSetPolicyRequest: A GlobalSetPolicyRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetPolicyRequest = _messages.MessageField('GlobalSetPolicyRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeImagesSetLabelsRequest(_messages.Message):
  r"""A ComputeImagesSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeImagesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeImagesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeInstanceGroupManagersAbandonInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersAbandonInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersAbandonInstancesRequest: A
      InstanceGroupManagersAbandonInstancesRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersAbandonInstancesRequest = _messages.MessageField('InstanceGroupManagersAbandonInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersAggregatedListRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersDeleteInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersDeleteInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersDeleteInstancesRequest: A
      InstanceGroupManagersDeleteInstancesRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersDeleteInstancesRequest = _messages.MessageField('InstanceGroupManagersDeleteInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersDeleteRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersDeleteRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersGetRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersGetRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupManagersInsertRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersInsertRequest object.

  Fields:
    instanceGroupManager: A InstanceGroupManager resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where you want to create the managed instance
      group.
  """

  instanceGroupManager = _messages.MessageField('InstanceGroupManager', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersListManagedInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersListManagedInstancesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    instanceGroupManager: The name of the managed instance group.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    order_by: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  filter = _messages.StringField(1)
  instanceGroupManager = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  order_by = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  zone = _messages.StringField(7, required=True)


class ComputeInstanceGroupManagersListRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone where the managed instance group is located.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeInstanceGroupManagersPatchRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersPatchRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagerResource: A InstanceGroupManager resource to be passed
      as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where you want to create the managed instance
      group.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagerResource = _messages.MessageField('InstanceGroupManager', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersRecreateInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersRecreateInstancesRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersRecreateInstancesRequest: A
      InstanceGroupManagersRecreateInstancesRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersRecreateInstancesRequest = _messages.MessageField('InstanceGroupManagersRecreateInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersResizeAdvancedRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersResizeAdvancedRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersResizeAdvancedRequest: A
      InstanceGroupManagersResizeAdvancedRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersResizeAdvancedRequest = _messages.MessageField('InstanceGroupManagersResizeAdvancedRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersResizeRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersResizeRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    size: The number of running instances that the managed instance group
      should maintain at any given time. The group automatically adds or
      removes instances to maintain the number of instances specified by this
      parameter.
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  size = _messages.IntegerField(4, required=True, variant=_messages.Variant.INT32)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagersSetAutoHealingRequest: A
      InstanceGroupManagersSetAutoHealingRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersSetAutoHealingRequest = _messages.MessageField('InstanceGroupManagersSetAutoHealingRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersSetInstanceTemplateRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersSetInstanceTemplateRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersSetInstanceTemplateRequest: A
      InstanceGroupManagersSetInstanceTemplateRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersSetInstanceTemplateRequest = _messages.MessageField('InstanceGroupManagersSetInstanceTemplateRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersSetTargetPoolsRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersSetTargetPoolsRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    instanceGroupManagersSetTargetPoolsRequest: A
      InstanceGroupManagersSetTargetPoolsRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the managed instance group is located.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagersSetTargetPoolsRequest = _messages.MessageField('InstanceGroupManagersSetTargetPoolsRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupManagersTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupManagersUpdateRequest(_messages.Message):
  r"""A ComputeInstanceGroupManagersUpdateRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagerResource: A InstanceGroupManager resource to be passed
      as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where you want to create the managed instance
      group.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagerResource = _messages.MessageField('InstanceGroupManager', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupsAddInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupsAddInstancesRequest object.

  Fields:
    instanceGroup: The name of the instance group where you are adding
      instances.
    instanceGroupsAddInstancesRequest: A InstanceGroupsAddInstancesRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  instanceGroupsAddInstancesRequest = _messages.MessageField('InstanceGroupsAddInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupsAggregatedListRequest(_messages.Message):
  r"""A ComputeInstanceGroupsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInstanceGroupsDeleteRequest(_messages.Message):
  r"""A ComputeInstanceGroupsDeleteRequest object.

  Fields:
    instanceGroup: The name of the instance group to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupsGetRequest(_messages.Message):
  r"""A ComputeInstanceGroupsGetRequest object.

  Fields:
    instanceGroup: The name of the instance group.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstanceGroupsInsertRequest(_messages.Message):
  r"""A ComputeInstanceGroupsInsertRequest object.

  Fields:
    instanceGroup: A InstanceGroup resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where you want to create the instance group.
  """

  instanceGroup = _messages.MessageField('InstanceGroup', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceGroupsListInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupsListInstancesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    instanceGroup: The name of the instance group from which you want to
      generate a list of included instances.
    instanceGroupsListInstancesRequest: A InstanceGroupsListInstancesRequest
      resource to be passed as the request body.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  filter = _messages.StringField(1)
  instanceGroup = _messages.StringField(2, required=True)
  instanceGroupsListInstancesRequest = _messages.MessageField('InstanceGroupsListInstancesRequest', 3)
  maxResults = _messages.IntegerField(4, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(5)
  pageToken = _messages.StringField(6)
  project = _messages.StringField(7, required=True)
  zone = _messages.StringField(8, required=True)


class ComputeInstanceGroupsListRequest(_messages.Message):
  r"""A ComputeInstanceGroupsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone where the instance group is located.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeInstanceGroupsRemoveInstancesRequest(_messages.Message):
  r"""A ComputeInstanceGroupsRemoveInstancesRequest object.

  Fields:
    instanceGroup: The name of the instance group where the specified
      instances will be removed.
    instanceGroupsRemoveInstancesRequest: A
      InstanceGroupsRemoveInstancesRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  instanceGroupsRemoveInstancesRequest = _messages.MessageField('InstanceGroupsRemoveInstancesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupsSetNamedPortsRequest(_messages.Message):
  r"""A ComputeInstanceGroupsSetNamedPortsRequest object.

  Fields:
    instanceGroup: The name of the instance group where the named ports are
      updated.
    instanceGroupsSetNamedPortsRequest: A InstanceGroupsSetNamedPortsRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the instance group is located.
  """

  instanceGroup = _messages.StringField(1, required=True)
  instanceGroupsSetNamedPortsRequest = _messages.MessageField('InstanceGroupsSetNamedPortsRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstanceGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInstanceGroupsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeInstanceTemplatesDeleteRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesDeleteRequest object.

  Fields:
    instanceTemplate: The name of the instance template to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceTemplate = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeInstanceTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)


class ComputeInstanceTemplatesGetRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesGetRequest object.

  Fields:
    instanceTemplate: The name of the instance template.
    project: Project ID for this request.
  """

  instanceTemplate = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeInstanceTemplatesInsertRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesInsertRequest object.

  Fields:
    instanceTemplate: A InstanceTemplate resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceTemplate = _messages.MessageField('InstanceTemplate', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeInstanceTemplatesListRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInstanceTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesSetIamPolicyRequest object.

  Fields:
    globalSetPolicyRequest: A GlobalSetPolicyRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetPolicyRequest = _messages.MessageField('GlobalSetPolicyRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeInstanceTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInstanceTemplatesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeInstancesAddAccessConfigRequest(_messages.Message):
  r"""A ComputeInstancesAddAccessConfigRequest object.

  Fields:
    accessConfig: A AccessConfig resource to be passed as the request body.
    instance: The instance name for this request.
    networkInterface: The name of the network interface to add to this
      instance.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  accessConfig = _messages.MessageField('AccessConfig', 1)
  instance = _messages.StringField(2, required=True)
  networkInterface = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesAggregatedListRequest(_messages.Message):
  r"""A ComputeInstancesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInstancesAttachDiskRequest(_messages.Message):
  r"""A ComputeInstancesAttachDiskRequest object.

  Fields:
    attachedDisk: A AttachedDisk resource to be passed as the request body.
    forceAttach: Whether to force attach the disk even if it's currently
      attached to another instance. This is only available for regional disks.
    instance: The instance name for this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  attachedDisk = _messages.MessageField('AttachedDisk', 1)
  forceAttach = _messages.BooleanField(2)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesDeleteAccessConfigRequest(_messages.Message):
  r"""A ComputeInstancesDeleteAccessConfigRequest object.

  Fields:
    accessConfig: The name of the access config to delete.
    instance: The instance name for this request.
    networkInterface: The name of the network interface.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  accessConfig = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  networkInterface = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesDeleteRequest(_messages.Message):
  r"""A ComputeInstancesDeleteRequest object.

  Fields:
    instance: Name of the instance resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesDetachDiskRequest(_messages.Message):
  r"""A ComputeInstancesDetachDiskRequest object.

  Fields:
    deviceName: Disk device name to detach.
    instance: Instance name.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  deviceName = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesGetGuestAttributesRequest(_messages.Message):
  r"""A ComputeInstancesGetGuestAttributesRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    queryPath: Specifies the guest attributes path to be queried.
    variableKey: Specifies the key for the guest attributes entry.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  queryPath = _messages.StringField(3)
  variableKey = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeInstancesGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesGetRequest(_messages.Message):
  r"""A ComputeInstancesGetRequest object.

  Fields:
    instance: Name of the instance resource to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesGetSerialPortOutputRequest(_messages.Message):
  r"""A ComputeInstancesGetSerialPortOutputRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    port: Specifies which COM or serial port to retrieve data from.
    project: Project ID for this request.
    start: Returns output starting from a specific byte position. Use this to
      page through output when the output is too large to return in a single
      request. For the initial request, leave this field unspecified. For
      subsequent calls, this field should be set to the next value returned in
      the previous call.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32, default=1)
  project = _messages.StringField(3, required=True)
  start = _messages.IntegerField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesGetShieldedVmIdentityRequest(_messages.Message):
  r"""A ComputeInstancesGetShieldedVmIdentityRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesInsertRequest(_messages.Message):
  r"""A ComputeInstancesInsertRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    sourceInstanceTemplate: Specifies instance template to create the
      instance.  This field is optional. It can be a full or partial URL. For
      example, the following are all valid URLs to an instance template:   - h
      ttps://www.googleapis.com/compute/v1/projects/project/global/instanceTem
      plates/instanceTemplate  -
      projects/project/global/instanceTemplates/instanceTemplate  -
      global/instanceTemplates/instanceTemplate
    zone: The name of the zone for this request.
  """

  instance = _messages.MessageField('Instance', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  sourceInstanceTemplate = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesListReferrersRequest(_messages.Message):
  r"""A ComputeInstancesListReferrersRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    instance: Name of the target instance scoping this request, or '-' if the
      request should span over all instances in the container.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  instance = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  zone = _messages.StringField(7, required=True)


class ComputeInstancesListRequest(_messages.Message):
  r"""A ComputeInstancesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesResetRequest(_messages.Message):
  r"""A ComputeInstancesResetRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesSetDeletionProtectionRequest(_messages.Message):
  r"""A ComputeInstancesSetDeletionProtectionRequest object.

  Fields:
    deletionProtection: Whether the resource should be protected against
      deletion.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
  """

  deletionProtection = _messages.BooleanField(1, default=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  resource = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetDiskAutoDeleteRequest(_messages.Message):
  r"""A ComputeInstancesSetDiskAutoDeleteRequest object.

  Fields:
    autoDelete: Whether to auto-delete the disk when the instance is deleted.
    deviceName: The device name of the disk to modify.
    instance: The instance name.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  autoDelete = _messages.BooleanField(1, required=True)
  deviceName = _messages.StringField(2, required=True)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeInstancesSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
    zoneSetPolicyRequest: A ZoneSetPolicyRequest resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)
  zoneSetPolicyRequest = _messages.MessageField('ZoneSetPolicyRequest', 4)


class ComputeInstancesSetLabelsRequest(_messages.Message):
  r"""A ComputeInstancesSetLabelsRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    instancesSetLabelsRequest: A InstancesSetLabelsRequest resource to be
      passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetLabelsRequest = _messages.MessageField('InstancesSetLabelsRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetMachineResourcesRequest(_messages.Message):
  r"""A ComputeInstancesSetMachineResourcesRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    instancesSetMachineResourcesRequest: A InstancesSetMachineResourcesRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetMachineResourcesRequest = _messages.MessageField('InstancesSetMachineResourcesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetMachineTypeRequest(_messages.Message):
  r"""A ComputeInstancesSetMachineTypeRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    instancesSetMachineTypeRequest: A InstancesSetMachineTypeRequest resource
      to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetMachineTypeRequest = _messages.MessageField('InstancesSetMachineTypeRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetMetadataRequest(_messages.Message):
  r"""A ComputeInstancesSetMetadataRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    metadata: A Metadata resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  metadata = _messages.MessageField('Metadata', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetMinCpuPlatformRequest(_messages.Message):
  r"""A ComputeInstancesSetMinCpuPlatformRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    instancesSetMinCpuPlatformRequest: A InstancesSetMinCpuPlatformRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetMinCpuPlatformRequest = _messages.MessageField('InstancesSetMinCpuPlatformRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetSchedulingRequest(_messages.Message):
  r"""A ComputeInstancesSetSchedulingRequest object.

  Fields:
    instance: Instance name.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    scheduling: A Scheduling resource to be passed as the request body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  scheduling = _messages.MessageField('Scheduling', 4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetServiceAccountRequest(_messages.Message):
  r"""A ComputeInstancesSetServiceAccountRequest object.

  Fields:
    instance: Name of the instance resource to start.
    instancesSetServiceAccountRequest: A InstancesSetServiceAccountRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesSetServiceAccountRequest = _messages.MessageField('InstancesSetServiceAccountRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetShieldedVmIntegrityPolicyRequest(_messages.Message):
  r"""A ComputeInstancesSetShieldedVmIntegrityPolicyRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    shieldedVmIntegrityPolicy: A ShieldedVmIntegrityPolicy resource to be
      passed as the request body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  shieldedVmIntegrityPolicy = _messages.MessageField('ShieldedVmIntegrityPolicy', 4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSetTagsRequest(_messages.Message):
  r"""A ComputeInstancesSetTagsRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    tags: A Tags resource to be passed as the request body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  tags = _messages.MessageField('Tags', 4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesSimulateMaintenanceEventRequest(_messages.Message):
  r"""A ComputeInstancesSimulateMaintenanceEventRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeInstancesStartRequest(_messages.Message):
  r"""A ComputeInstancesStartRequest object.

  Fields:
    instance: Name of the instance resource to start.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesStartWithEncryptionKeyRequest(_messages.Message):
  r"""A ComputeInstancesStartWithEncryptionKeyRequest object.

  Fields:
    instance: Name of the instance resource to start.
    instancesStartWithEncryptionKeyRequest: A
      InstancesStartWithEncryptionKeyRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  instancesStartWithEncryptionKeyRequest = _messages.MessageField('InstancesStartWithEncryptionKeyRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeInstancesStopRequest(_messages.Message):
  r"""A ComputeInstancesStopRequest object.

  Fields:
    instance: Name of the instance resource to stop.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInstancesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeInstancesUpdateAccessConfigRequest(_messages.Message):
  r"""A ComputeInstancesUpdateAccessConfigRequest object.

  Fields:
    accessConfig: A AccessConfig resource to be passed as the request body.
    instance: The instance name for this request.
    networkInterface: The name of the network interface where the access
      config is attached.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  accessConfig = _messages.MessageField('AccessConfig', 1)
  instance = _messages.StringField(2, required=True)
  networkInterface = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesUpdateNetworkInterfaceRequest(_messages.Message):
  r"""A ComputeInstancesUpdateNetworkInterfaceRequest object.

  Fields:
    instance: The instance name for this request.
    networkInterface: The name of the network interface to update.
    networkInterfaceResource: A NetworkInterface resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  networkInterface = _messages.StringField(2, required=True)
  networkInterfaceResource = _messages.MessageField('NetworkInterface', 3)
  project = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)
  zone = _messages.StringField(6, required=True)


class ComputeInstancesUpdateShieldedVmConfigRequest(_messages.Message):
  r"""A ComputeInstancesUpdateShieldedVmConfigRequest object.

  Fields:
    instance: Name of the instance scoping this request.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    shieldedVmConfig: A ShieldedVmConfig resource to be passed as the request
      body.
    zone: The name of the zone for this request.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  shieldedVmConfig = _messages.MessageField('ShieldedVmConfig', 4)
  zone = _messages.StringField(5, required=True)


class ComputeInterconnectAttachmentsAggregatedListRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInterconnectAttachmentsDeleteRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsDeleteRequest object.

  Fields:
    interconnectAttachment: Name of the interconnect attachment to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  interconnectAttachment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeInterconnectAttachmentsGetRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsGetRequest object.

  Fields:
    interconnectAttachment: Name of the interconnect attachment to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  interconnectAttachment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeInterconnectAttachmentsInsertRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsInsertRequest object.

  Fields:
    interconnectAttachment: A InterconnectAttachment resource to be passed as
      the request body.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  interconnectAttachment = _messages.MessageField('InterconnectAttachment', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeInterconnectAttachmentsListRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeInterconnectAttachmentsPatchRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsPatchRequest object.

  Fields:
    interconnectAttachment: Name of the interconnect attachment to patch.
    interconnectAttachmentResource: A InterconnectAttachment resource to be
      passed as the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  interconnectAttachment = _messages.StringField(1, required=True)
  interconnectAttachmentResource = _messages.MessageField('InterconnectAttachment', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeInterconnectAttachmentsSetLabelsRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  requestId = _messages.StringField(4)
  resource = _messages.StringField(5, required=True)


class ComputeInterconnectAttachmentsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInterconnectAttachmentsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeInterconnectLocationsGetRequest(_messages.Message):
  r"""A ComputeInterconnectLocationsGetRequest object.

  Fields:
    interconnectLocation: Name of the interconnect location to return.
    project: Project ID for this request.
  """

  interconnectLocation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeInterconnectLocationsListRequest(_messages.Message):
  r"""A ComputeInterconnectLocationsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInterconnectsDeleteRequest(_messages.Message):
  r"""A ComputeInterconnectsDeleteRequest object.

  Fields:
    interconnect: Name of the interconnect to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  interconnect = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeInterconnectsGetDiagnosticsRequest(_messages.Message):
  r"""A ComputeInterconnectsGetDiagnosticsRequest object.

  Fields:
    interconnect: Name of the interconnect resource to query.
    project: Project ID for this request.
  """

  interconnect = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeInterconnectsGetRequest(_messages.Message):
  r"""A ComputeInterconnectsGetRequest object.

  Fields:
    interconnect: Name of the interconnect to return.
    project: Project ID for this request.
  """

  interconnect = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeInterconnectsInsertRequest(_messages.Message):
  r"""A ComputeInterconnectsInsertRequest object.

  Fields:
    interconnect: A Interconnect resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  interconnect = _messages.MessageField('Interconnect', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeInterconnectsListRequest(_messages.Message):
  r"""A ComputeInterconnectsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeInterconnectsPatchRequest(_messages.Message):
  r"""A ComputeInterconnectsPatchRequest object.

  Fields:
    interconnect: Name of the interconnect to update.
    interconnectResource: A Interconnect resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  interconnect = _messages.StringField(1, required=True)
  interconnectResource = _messages.MessageField('Interconnect', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeInterconnectsSetLabelsRequest(_messages.Message):
  r"""A ComputeInterconnectsSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeInterconnectsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeInterconnectsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeLicenseCodesGetRequest(_messages.Message):
  r"""A ComputeLicenseCodesGetRequest object.

  Fields:
    licenseCode: Number corresponding to the License code resource to return.
    project: Project ID for this request.
  """

  licenseCode = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeLicensesDeleteRequest(_messages.Message):
  r"""A ComputeLicensesDeleteRequest object.

  Fields:
    license: Name of the license resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  license = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeLicensesGetRequest(_messages.Message):
  r"""A ComputeLicensesGetRequest object.

  Fields:
    license: Name of the License resource to return.
    project: Project ID for this request.
  """

  license = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeLicensesInsertRequest(_messages.Message):
  r"""A ComputeLicensesInsertRequest object.

  Fields:
    license: A License resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  license = _messages.MessageField('License', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeLicensesListRequest(_messages.Message):
  r"""A ComputeLicensesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeMachineTypesAggregatedListRequest(_messages.Message):
  r"""A ComputeMachineTypesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeMachineTypesGetRequest(_messages.Message):
  r"""A ComputeMachineTypesGetRequest object.

  Fields:
    machineType: Name of the machine type to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  machineType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeMachineTypesListRequest(_messages.Message):
  r"""A ComputeMachineTypesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeNetworkEndpointGroupsAggregatedListRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeNetworkEndpointGroupsAttachNetworkEndpointsRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsAttachNetworkEndpointsRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group where you are
      attaching network endpoints to. It should comply with RFC1035.
    networkEndpointGroupsAttachEndpointsRequest: A
      NetworkEndpointGroupsAttachEndpointsRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  networkEndpointGroupsAttachEndpointsRequest = _messages.MessageField('NetworkEndpointGroupsAttachEndpointsRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNetworkEndpointGroupsDeleteRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsDeleteRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group to delete. It
      should comply with RFC1035.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeNetworkEndpointGroupsDetachNetworkEndpointsRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsDetachNetworkEndpointsRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group where you are
      removing network endpoints. It should comply with RFC1035.
    networkEndpointGroupsDetachEndpointsRequest: A
      NetworkEndpointGroupsDetachEndpointsRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  networkEndpointGroupsDetachEndpointsRequest = _messages.MessageField('NetworkEndpointGroupsDetachEndpointsRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNetworkEndpointGroupsGetRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsGetRequest object.

  Fields:
    networkEndpointGroup: The name of the network endpoint group. It should
      comply with RFC1035.
    project: Project ID for this request.
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  networkEndpointGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeNetworkEndpointGroupsInsertRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsInsertRequest object.

  Fields:
    networkEndpointGroup: A NetworkEndpointGroup resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone where you want to create the network endpoint
      group. It should comply with RFC1035.
  """

  networkEndpointGroup = _messages.MessageField('NetworkEndpointGroup', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeNetworkEndpointGroupsListNetworkEndpointsRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsListNetworkEndpointsRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    networkEndpointGroup: The name of the network endpoint group from which
      you want to generate a list of included network endpoints. It should
      comply with RFC1035.
    networkEndpointGroupsListEndpointsRequest: A
      NetworkEndpointGroupsListEndpointsRequest resource to be passed as the
      request body.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  networkEndpointGroup = _messages.StringField(3, required=True)
  networkEndpointGroupsListEndpointsRequest = _messages.MessageField('NetworkEndpointGroupsListEndpointsRequest', 4)
  orderBy = _messages.StringField(5)
  pageToken = _messages.StringField(6)
  project = _messages.StringField(7, required=True)
  zone = _messages.StringField(8, required=True)


class ComputeNetworkEndpointGroupsListRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone where the network endpoint group is located. It
      should comply with RFC1035.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeNetworkEndpointGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeNetworkEndpointGroupsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeNetworksAddPeeringRequest(_messages.Message):
  r"""A ComputeNetworksAddPeeringRequest object.

  Fields:
    network: Name of the network resource to add peering to.
    networksAddPeeringRequest: A NetworksAddPeeringRequest resource to be
      passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  networksAddPeeringRequest = _messages.MessageField('NetworksAddPeeringRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNetworksDeleteRequest(_messages.Message):
  r"""A ComputeNetworksDeleteRequest object.

  Fields:
    network: Name of the network to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeNetworksGetRequest(_messages.Message):
  r"""A ComputeNetworksGetRequest object.

  Fields:
    network: Name of the network to return.
    project: Project ID for this request.
  """

  network = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class ComputeNetworksInsertRequest(_messages.Message):
  r"""A ComputeNetworksInsertRequest object.

  Fields:
    network: A Network resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  network = _messages.MessageField('Network', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeNetworksListRequest(_messages.Message):
  r"""A ComputeNetworksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeNetworksPatchRequest(_messages.Message):
  r"""A ComputeNetworksPatchRequest object.

  Fields:
    network: Name of the network to update.
    networkResource: A Network resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  networkResource = _messages.MessageField('Network', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNetworksRemovePeeringRequest(_messages.Message):
  r"""A ComputeNetworksRemovePeeringRequest object.

  Fields:
    network: Name of the network resource to remove peering from.
    networksRemovePeeringRequest: A NetworksRemovePeeringRequest resource to
      be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  networksRemovePeeringRequest = _messages.MessageField('NetworksRemovePeeringRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNetworksSwitchToCustomModeRequest(_messages.Message):
  r"""A ComputeNetworksSwitchToCustomModeRequest object.

  Fields:
    network: Name of the network to be updated.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  network = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeNetworksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeNetworksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeNodeGroupsAddNodesRequest(_messages.Message):
  r"""A ComputeNodeGroupsAddNodesRequest object.

  Fields:
    nodeGroup: Name of the NodeGroup resource to delete.
    nodeGroupsAddNodesRequest: A NodeGroupsAddNodesRequest resource to be
      passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  nodeGroupsAddNodesRequest = _messages.MessageField('NodeGroupsAddNodesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNodeGroupsAggregatedListRequest(_messages.Message):
  r"""A ComputeNodeGroupsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeNodeGroupsDeleteNodesRequest(_messages.Message):
  r"""A ComputeNodeGroupsDeleteNodesRequest object.

  Fields:
    nodeGroup: Name of the NodeGroup resource to delete.
    nodeGroupsDeleteNodesRequest: A NodeGroupsDeleteNodesRequest resource to
      be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  nodeGroupsDeleteNodesRequest = _messages.MessageField('NodeGroupsDeleteNodesRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNodeGroupsDeleteRequest(_messages.Message):
  r"""A ComputeNodeGroupsDeleteRequest object.

  Fields:
    nodeGroup: Name of the NodeGroup resource to delete.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  zone = _messages.StringField(4, required=True)


class ComputeNodeGroupsGetIamPolicyRequest(_messages.Message):
  r"""A ComputeNodeGroupsGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeNodeGroupsGetRequest(_messages.Message):
  r"""A ComputeNodeGroupsGetRequest object.

  Fields:
    nodeGroup: Name of the node group to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeNodeGroupsInsertRequest(_messages.Message):
  r"""A ComputeNodeGroupsInsertRequest object.

  Fields:
    initialNodeCount: Initial count of nodes in the node group.
    nodeGroup: A NodeGroup resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  initialNodeCount = _messages.IntegerField(1, required=True, variant=_messages.Variant.INT32)
  nodeGroup = _messages.MessageField('NodeGroup', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNodeGroupsListNodesRequest(_messages.Message):
  r"""A ComputeNodeGroupsListNodesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    nodeGroup: Name of the NodeGroup resource whose nodes you want to list.
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  nodeGroup = _messages.StringField(3, required=True)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  zone = _messages.StringField(7, required=True)


class ComputeNodeGroupsListRequest(_messages.Message):
  r"""A ComputeNodeGroupsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeNodeGroupsSetIamPolicyRequest(_messages.Message):
  r"""A ComputeNodeGroupsSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    zone: The name of the zone for this request.
    zoneSetPolicyRequest: A ZoneSetPolicyRequest resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)
  zoneSetPolicyRequest = _messages.MessageField('ZoneSetPolicyRequest', 4)


class ComputeNodeGroupsSetNodeTemplateRequest(_messages.Message):
  r"""A ComputeNodeGroupsSetNodeTemplateRequest object.

  Fields:
    nodeGroup: Name of the NodeGroup resource to delete.
    nodeGroupsSetNodeTemplateRequest: A NodeGroupsSetNodeTemplateRequest
      resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    zone: The name of the zone for this request.
  """

  nodeGroup = _messages.StringField(1, required=True)
  nodeGroupsSetNodeTemplateRequest = _messages.MessageField('NodeGroupsSetNodeTemplateRequest', 2)
  project = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  zone = _messages.StringField(5, required=True)


class ComputeNodeGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeNodeGroupsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeNodeTemplatesAggregatedListRequest(_messages.Message):
  r"""A ComputeNodeTemplatesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeNodeTemplatesDeleteRequest(_messages.Message):
  r"""A ComputeNodeTemplatesDeleteRequest object.

  Fields:
    nodeTemplate: Name of the NodeTemplate resource to delete.
    project: Project ID for this request.
    region: The name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  nodeTemplate = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNodeTemplatesGetIamPolicyRequest(_messages.Message):
  r"""A ComputeNodeTemplatesGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeNodeTemplatesGetRequest(_messages.Message):
  r"""A ComputeNodeTemplatesGetRequest object.

  Fields:
    nodeTemplate: Name of the node template to return.
    project: Project ID for this request.
    region: The name of the region for this request.
  """

  nodeTemplate = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeNodeTemplatesInsertRequest(_messages.Message):
  r"""A ComputeNodeTemplatesInsertRequest object.

  Fields:
    nodeTemplate: A NodeTemplate resource to be passed as the request body.
    project: Project ID for this request.
    region: The name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  nodeTemplate = _messages.MessageField('NodeTemplate', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeNodeTemplatesListRequest(_messages.Message):
  r"""A ComputeNodeTemplatesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: The name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeNodeTemplatesSetIamPolicyRequest(_messages.Message):
  r"""A ComputeNodeTemplatesSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    regionSetPolicyRequest: A RegionSetPolicyRequest resource to be passed as
      the request body.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetPolicyRequest = _messages.MessageField('RegionSetPolicyRequest', 3)
  resource = _messages.StringField(4, required=True)


class ComputeNodeTemplatesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeNodeTemplatesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeNodeTypesAggregatedListRequest(_messages.Message):
  r"""A ComputeNodeTypesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeNodeTypesGetRequest(_messages.Message):
  r"""A ComputeNodeTypesGetRequest object.

  Fields:
    nodeType: Name of the node type to return.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  nodeType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeNodeTypesListRequest(_messages.Message):
  r"""A ComputeNodeTypesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: The name of the zone for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeProjectsDisableXpnHostRequest(_messages.Message):
  r"""A ComputeProjectsDisableXpnHostRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ComputeProjectsDisableXpnResourceRequest(_messages.Message):
  r"""A ComputeProjectsDisableXpnResourceRequest object.

  Fields:
    project: Project ID for this request.
    projectsDisableXpnResourceRequest: A ProjectsDisableXpnResourceRequest
      resource to be passed as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  projectsDisableXpnResourceRequest = _messages.MessageField('ProjectsDisableXpnResourceRequest', 2)
  requestId = _messages.StringField(3)


class ComputeProjectsEnableXpnHostRequest(_messages.Message):
  r"""A ComputeProjectsEnableXpnHostRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ComputeProjectsEnableXpnResourceRequest(_messages.Message):
  r"""A ComputeProjectsEnableXpnResourceRequest object.

  Fields:
    project: Project ID for this request.
    projectsEnableXpnResourceRequest: A ProjectsEnableXpnResourceRequest
      resource to be passed as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  projectsEnableXpnResourceRequest = _messages.MessageField('ProjectsEnableXpnResourceRequest', 2)
  requestId = _messages.StringField(3)


class ComputeProjectsGetRequest(_messages.Message):
  r"""A ComputeProjectsGetRequest object.

  Fields:
    project: Project ID for this request.
  """

  project = _messages.StringField(1, required=True)


class ComputeProjectsGetXpnHostRequest(_messages.Message):
  r"""A ComputeProjectsGetXpnHostRequest object.

  Fields:
    project: Project ID for this request.
  """

  project = _messages.StringField(1, required=True)


class ComputeProjectsGetXpnResourcesRequest(_messages.Message):
  r"""A ComputeProjectsGetXpnResourcesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    order_by: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  order_by = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeProjectsListXpnHostsRequest(_messages.Message):
  r"""A ComputeProjectsListXpnHostsRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    order_by: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    projectsListXpnHostsRequest: A ProjectsListXpnHostsRequest resource to be
      passed as the request body.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  order_by = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  projectsListXpnHostsRequest = _messages.MessageField('ProjectsListXpnHostsRequest', 6)


class ComputeProjectsMoveDiskRequest(_messages.Message):
  r"""A ComputeProjectsMoveDiskRequest object.

  Fields:
    diskMoveRequest: A DiskMoveRequest resource to be passed as the request
      body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  diskMoveRequest = _messages.MessageField('DiskMoveRequest', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeProjectsMoveInstanceRequest(_messages.Message):
  r"""A ComputeProjectsMoveInstanceRequest object.

  Fields:
    instanceMoveRequest: A InstanceMoveRequest resource to be passed as the
      request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceMoveRequest = _messages.MessageField('InstanceMoveRequest', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeProjectsSetCommonInstanceMetadataRequest(_messages.Message):
  r"""A ComputeProjectsSetCommonInstanceMetadataRequest object.

  Fields:
    metadata: A Metadata resource to be passed as the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  metadata = _messages.MessageField('Metadata', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ComputeProjectsSetDefaultNetworkTierRequest(_messages.Message):
  r"""A ComputeProjectsSetDefaultNetworkTierRequest object.

  Fields:
    project: Project ID for this request.
    projectsSetDefaultNetworkTierRequest: A
      ProjectsSetDefaultNetworkTierRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  project = _messages.StringField(1, required=True)
  projectsSetDefaultNetworkTierRequest = _messages.MessageField('ProjectsSetDefaultNetworkTierRequest', 2)
  requestId = _messages.StringField(3)


class ComputeProjectsSetUsageExportBucketRequest(_messages.Message):
  r"""A ComputeProjectsSetUsageExportBucketRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    usageExportLocation: A UsageExportLocation resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  usageExportLocation = _messages.MessageField('UsageExportLocation', 3)


class ComputeRegionAutoscalersDeleteRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersDeleteRequest object.

  Fields:
    autoscaler: Name of the autoscaler to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionAutoscalersGetRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersGetRequest object.

  Fields:
    autoscaler: Name of the autoscaler to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionAutoscalersInsertRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersInsertRequest object.

  Fields:
    autoscaler: A Autoscaler resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  autoscaler = _messages.MessageField('Autoscaler', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionAutoscalersListRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionAutoscalersPatchRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersPatchRequest object.

  Fields:
    autoscaler: Name of the autoscaler to patch.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  autoscaler = _messages.StringField(1)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionAutoscalersTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionAutoscalersUpdateRequest(_messages.Message):
  r"""A ComputeRegionAutoscalersUpdateRequest object.

  Fields:
    autoscaler: Name of the autoscaler to update.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  autoscaler = _messages.StringField(1)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionBackendServicesDeleteRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesDeleteRequest object.

  Fields:
    backendService: Name of the BackendService resource to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionBackendServicesGetHealthRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesGetHealthRequest object.

  Fields:
    backendService: Name of the BackendService resource for which to get
      health.
    project: A string attribute.
    region: Name of the region scoping this request.
    resourceGroupReference: A ResourceGroupReference resource to be passed as
      the request body.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  resourceGroupReference = _messages.MessageField('ResourceGroupReference', 4)


class ComputeRegionBackendServicesGetRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesGetRequest object.

  Fields:
    backendService: Name of the BackendService resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  backendService = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionBackendServicesInsertRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesInsertRequest object.

  Fields:
    backendService: A BackendService resource to be passed as the request
      body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.MessageField('BackendService', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionBackendServicesListRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionBackendServicesPatchRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesPatchRequest object.

  Fields:
    backendService: Name of the BackendService resource to patch.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionBackendServicesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionBackendServicesUpdateRequest(_messages.Message):
  r"""A ComputeRegionBackendServicesUpdateRequest object.

  Fields:
    backendService: Name of the BackendService resource to update.
    backendServiceResource: A BackendService resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  backendService = _messages.StringField(1, required=True)
  backendServiceResource = _messages.MessageField('BackendService', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionCommitmentsAggregatedListRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeRegionCommitmentsGetRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsGetRequest object.

  Fields:
    commitment: Name of the commitment to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  commitment = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionCommitmentsInsertRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsInsertRequest object.

  Fields:
    commitment: A Commitment resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  commitment = _messages.MessageField('Commitment', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionCommitmentsListRequest(_messages.Message):
  r"""A ComputeRegionCommitmentsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionDiskTypesGetRequest(_messages.Message):
  r"""A ComputeRegionDiskTypesGetRequest object.

  Fields:
    diskType: Name of the disk type to return.
    project: Project ID for this request.
    region: The name of the region for this request.
  """

  diskType = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionDiskTypesListRequest(_messages.Message):
  r"""A ComputeRegionDiskTypesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: The name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionDisksAddResourcePoliciesRequest(_messages.Message):
  r"""A ComputeRegionDisksAddResourcePoliciesRequest object.

  Fields:
    disk: The disk name for this request.
    project: Project ID for this request.
    region: The name of the region for this request.
    regionDisksAddResourcePoliciesRequest: A
      RegionDisksAddResourcePoliciesRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionDisksAddResourcePoliciesRequest = _messages.MessageField('RegionDisksAddResourcePoliciesRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionDisksCreateSnapshotRequest(_messages.Message):
  r"""A ComputeRegionDisksCreateSnapshotRequest object.

  Fields:
    disk: Name of the regional persistent disk to snapshot.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    snapshot: A Snapshot resource to be passed as the request body.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  snapshot = _messages.MessageField('Snapshot', 5)


class ComputeRegionDisksDeleteRequest(_messages.Message):
  r"""A ComputeRegionDisksDeleteRequest object.

  Fields:
    disk: Name of the regional persistent disk to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionDisksGetRequest(_messages.Message):
  r"""A ComputeRegionDisksGetRequest object.

  Fields:
    disk: Name of the regional persistent disk to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionDisksInsertRequest(_messages.Message):
  r"""A ComputeRegionDisksInsertRequest object.

  Fields:
    disk: A Disk resource to be passed as the request body.
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    sourceImage: Optional. Source image to restore onto a disk.
  """

  disk = _messages.MessageField('Disk', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  sourceImage = _messages.StringField(5)


class ComputeRegionDisksListRequest(_messages.Message):
  r"""A ComputeRegionDisksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionDisksRemoveResourcePoliciesRequest(_messages.Message):
  r"""A ComputeRegionDisksRemoveResourcePoliciesRequest object.

  Fields:
    disk: The disk name for this request.
    project: Project ID for this request.
    region: The name of the region for this request.
    regionDisksRemoveResourcePoliciesRequest: A
      RegionDisksRemoveResourcePoliciesRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionDisksRemoveResourcePoliciesRequest = _messages.MessageField('RegionDisksRemoveResourcePoliciesRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionDisksResizeRequest(_messages.Message):
  r"""A ComputeRegionDisksResizeRequest object.

  Fields:
    disk: Name of the regional persistent disk.
    project: The project ID for this request.
    region: Name of the region for this request.
    regionDisksResizeRequest: A RegionDisksResizeRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  disk = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionDisksResizeRequest = _messages.MessageField('RegionDisksResizeRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionDisksSetLabelsRequest(_messages.Message):
  r"""A ComputeRegionDisksSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  requestId = _messages.StringField(4)
  resource = _messages.StringField(5, required=True)


class ComputeRegionDisksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionDisksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionInstanceGroupManagersAbandonInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersAbandonInstancesRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersAbandonInstancesRequest: A
      RegionInstanceGroupManagersAbandonInstancesRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersAbandonInstancesRequest = _messages.MessageField('RegionInstanceGroupManagersAbandonInstancesRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersDeleteInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersDeleteInstancesRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersDeleteInstancesRequest: A
      RegionInstanceGroupManagersDeleteInstancesRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersDeleteInstancesRequest = _messages.MessageField('RegionInstanceGroupManagersDeleteInstancesRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersDeleteRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersDeleteRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group to delete.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionInstanceGroupManagersGetRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersGetRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionInstanceGroupManagersInsertRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersInsertRequest object.

  Fields:
    instanceGroupManager: A InstanceGroupManager resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.MessageField('InstanceGroupManager', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ComputeRegionInstanceGroupManagersListManagedInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersListManagedInstancesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    instanceGroupManager: The name of the managed instance group.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    order_by: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  instanceGroupManager = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  order_by = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  region = _messages.StringField(7, required=True)


class ComputeRegionInstanceGroupManagersListRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionInstanceGroupManagersPatchRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersPatchRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagerResource: A InstanceGroupManager resource to be passed
      as the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagerResource = _messages.MessageField('InstanceGroupManager', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersRecreateInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersRecreateInstancesRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersRecreateRequest: A
      RegionInstanceGroupManagersRecreateRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersRecreateRequest = _messages.MessageField('RegionInstanceGroupManagersRecreateRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersResizeRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersResizeRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    size: Number of instances that should exist in this instance group
      manager.
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  size = _messages.IntegerField(5, required=True, variant=_messages.Variant.INT32)


class ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest
  object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersSetAutoHealingRequest: A
      RegionInstanceGroupManagersSetAutoHealingRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersSetAutoHealingRequest = _messages.MessageField('RegionInstanceGroupManagersSetAutoHealingRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest object.

  Fields:
    instanceGroupManager: The name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersSetTemplateRequest: A
      RegionInstanceGroupManagersSetTemplateRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersSetTemplateRequest = _messages.MessageField('RegionInstanceGroupManagersSetTemplateRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersSetTargetPoolsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersSetTargetPoolsRequest object.

  Fields:
    instanceGroupManager: Name of the managed instance group.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupManagersSetTargetPoolsRequest: A
      RegionInstanceGroupManagersSetTargetPoolsRequest resource to be passed
      as the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupManagersSetTargetPoolsRequest = _messages.MessageField('RegionInstanceGroupManagersSetTargetPoolsRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupManagersTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionInstanceGroupManagersUpdateRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupManagersUpdateRequest object.

  Fields:
    instanceGroupManager: The name of the instance group manager.
    instanceGroupManagerResource: A InstanceGroupManager resource to be passed
      as the request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroupManager = _messages.StringField(1, required=True)
  instanceGroupManagerResource = _messages.MessageField('InstanceGroupManager', 2)
  project = _messages.StringField(3, required=True)
  region = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupsGetRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupsGetRequest object.

  Fields:
    instanceGroup: Name of the instance group resource to return.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionInstanceGroupsListInstancesRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupsListInstancesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    instanceGroup: Name of the regional instance group for which we want to
      list the instances.
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupsListInstancesRequest: A
      RegionInstanceGroupsListInstancesRequest resource to be passed as the
      request body.
  """

  filter = _messages.StringField(1)
  instanceGroup = _messages.StringField(2, required=True)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(4)
  pageToken = _messages.StringField(5)
  project = _messages.StringField(6, required=True)
  region = _messages.StringField(7, required=True)
  regionInstanceGroupsListInstancesRequest = _messages.MessageField('RegionInstanceGroupsListInstancesRequest', 8)


class ComputeRegionInstanceGroupsListRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionInstanceGroupsSetNamedPortsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupsSetNamedPortsRequest object.

  Fields:
    instanceGroup: The name of the regional instance group where the named
      ports are updated.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    regionInstanceGroupsSetNamedPortsRequest: A
      RegionInstanceGroupsSetNamedPortsRequest resource to be passed as the
      request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
  """

  instanceGroup = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  regionInstanceGroupsSetNamedPortsRequest = _messages.MessageField('RegionInstanceGroupsSetNamedPortsRequest', 4)
  requestId = _messages.StringField(5)


class ComputeRegionInstanceGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRegionInstanceGroupsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRegionOperationsDeleteRequest(_messages.Message):
  r"""A ComputeRegionOperationsDeleteRequest object.

  Fields:
    operation: Name of the Operations resource to delete.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionOperationsDeleteResponse(_messages.Message):
  r"""An empty ComputeRegionOperationsDelete response."""


class ComputeRegionOperationsGetRequest(_messages.Message):
  r"""A ComputeRegionOperationsGetRequest object.

  Fields:
    operation: Name of the Operations resource to return.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)


class ComputeRegionOperationsListRequest(_messages.Message):
  r"""A ComputeRegionOperationsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRegionsGetRequest(_messages.Message):
  r"""A ComputeRegionsGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region resource to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)


class ComputeRegionsListRequest(_messages.Message):
  r"""A ComputeRegionsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeResourcePoliciesAggregatedListRequest(_messages.Message):
  r"""A ComputeResourcePoliciesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeResourcePoliciesDeleteRequest(_messages.Message):
  r"""A ComputeResourcePoliciesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    resourcePolicy: Name of the resource policy to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  resourcePolicy = _messages.StringField(4, required=True)


class ComputeResourcePoliciesGetRequest(_messages.Message):
  r"""A ComputeResourcePoliciesGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    resourcePolicy: Name of the resource policy to retrieve.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resourcePolicy = _messages.StringField(3, required=True)


class ComputeResourcePoliciesInsertRequest(_messages.Message):
  r"""A ComputeResourcePoliciesInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    resourcePolicy: A ResourcePolicy resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  resourcePolicy = _messages.MessageField('ResourcePolicy', 4)


class ComputeResourcePoliciesListRequest(_messages.Message):
  r"""A ComputeResourcePoliciesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeResourcePoliciesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeResourcePoliciesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRoutersAggregatedListRequest(_messages.Message):
  r"""A ComputeRoutersAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeRoutersDeleteRequest(_messages.Message):
  r"""A ComputeRoutersDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    router: Name of the Router resource to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  router = _messages.StringField(4, required=True)


class ComputeRoutersGetNatMappingInfoRequest(_messages.Message):
  r"""A ComputeRoutersGetNatMappingInfoRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
    router: Name of the Router resource to query for Nat Mapping information
      of VM endpoints.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)
  router = _messages.StringField(7, required=True)


class ComputeRoutersGetRequest(_messages.Message):
  r"""A ComputeRoutersGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    router: Name of the Router resource to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  router = _messages.StringField(3, required=True)


class ComputeRoutersGetRouterStatusRequest(_messages.Message):
  r"""A ComputeRoutersGetRouterStatusRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    router: Name of the Router resource to query.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  router = _messages.StringField(3, required=True)


class ComputeRoutersInsertRequest(_messages.Message):
  r"""A ComputeRoutersInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    router: A Router resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  router = _messages.MessageField('Router', 4)


class ComputeRoutersListRequest(_messages.Message):
  r"""A ComputeRoutersListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeRoutersPatchRequest(_messages.Message):
  r"""A ComputeRoutersPatchRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    router: Name of the Router resource to patch.
    routerResource: A Router resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  router = _messages.StringField(4, required=True)
  routerResource = _messages.MessageField('Router', 5)


class ComputeRoutersPreviewRequest(_messages.Message):
  r"""A ComputeRoutersPreviewRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    router: Name of the Router resource to query.
    routerResource: A Router resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  router = _messages.StringField(3, required=True)
  routerResource = _messages.MessageField('Router', 4)


class ComputeRoutersTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRoutersTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeRoutersUpdateRequest(_messages.Message):
  r"""A ComputeRoutersUpdateRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    router: Name of the Router resource to update.
    routerResource: A Router resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  router = _messages.StringField(4, required=True)
  routerResource = _messages.MessageField('Router', 5)


class ComputeRoutesDeleteRequest(_messages.Message):
  r"""A ComputeRoutesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    route: Name of the Route resource to delete.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  route = _messages.StringField(3, required=True)


class ComputeRoutesGetRequest(_messages.Message):
  r"""A ComputeRoutesGetRequest object.

  Fields:
    project: Project ID for this request.
    route: Name of the Route resource to return.
  """

  project = _messages.StringField(1, required=True)
  route = _messages.StringField(2, required=True)


class ComputeRoutesInsertRequest(_messages.Message):
  r"""A ComputeRoutesInsertRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    route: A Route resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  route = _messages.MessageField('Route', 3)


class ComputeRoutesListRequest(_messages.Message):
  r"""A ComputeRoutesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeRoutesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeRoutesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeSecurityPoliciesAddRuleRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesAddRuleRequest object.

  Fields:
    project: Project ID for this request.
    securityPolicy: Name of the security policy to update.
    securityPolicyRule: A SecurityPolicyRule resource to be passed as the
      request body.
    validateOnly: If true, the request will not be committed.
  """

  project = _messages.StringField(1, required=True)
  securityPolicy = _messages.StringField(2, required=True)
  securityPolicyRule = _messages.MessageField('SecurityPolicyRule', 3)
  validateOnly = _messages.BooleanField(4)


class ComputeSecurityPoliciesDeleteRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to delete.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  securityPolicy = _messages.StringField(3, required=True)


class ComputeSecurityPoliciesGetRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesGetRequest object.

  Fields:
    project: Project ID for this request.
    securityPolicy: Name of the security policy to get.
  """

  project = _messages.StringField(1, required=True)
  securityPolicy = _messages.StringField(2, required=True)


class ComputeSecurityPoliciesGetRuleRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesGetRuleRequest object.

  Fields:
    priority: The priority of the rule to get from the security policy.
    project: Project ID for this request.
    securityPolicy: Name of the security policy to which the queried rule
      belongs.
  """

  priority = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  securityPolicy = _messages.StringField(3, required=True)


class ComputeSecurityPoliciesInsertRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesInsertRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    securityPolicy: A SecurityPolicy resource to be passed as the request
      body.
    validateOnly: If true, the request will not be committed.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  securityPolicy = _messages.MessageField('SecurityPolicy', 3)
  validateOnly = _messages.BooleanField(4)


class ComputeSecurityPoliciesListPreconfiguredExpressionSetsRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesListPreconfiguredExpressionSetsRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSecurityPoliciesListRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSecurityPoliciesPatchRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesPatchRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    securityPolicy: Name of the security policy to update.
    securityPolicyResource: A SecurityPolicy resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  securityPolicy = _messages.StringField(3, required=True)
  securityPolicyResource = _messages.MessageField('SecurityPolicy', 4)


class ComputeSecurityPoliciesPatchRuleRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesPatchRuleRequest object.

  Fields:
    priority: The priority of the rule to patch.
    project: Project ID for this request.
    securityPolicy: Name of the security policy to update.
    securityPolicyRule: A SecurityPolicyRule resource to be passed as the
      request body.
    validateOnly: If true, the request will not be committed.
  """

  priority = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  securityPolicy = _messages.StringField(3, required=True)
  securityPolicyRule = _messages.MessageField('SecurityPolicyRule', 4)
  validateOnly = _messages.BooleanField(5)


class ComputeSecurityPoliciesRemoveRuleRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesRemoveRuleRequest object.

  Fields:
    priority: The priority of the rule to remove from the security policy.
    project: Project ID for this request.
    securityPolicy: Name of the security policy to update.
  """

  priority = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  project = _messages.StringField(2, required=True)
  securityPolicy = _messages.StringField(3, required=True)


class ComputeSecurityPoliciesSetLabelsRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeSecurityPoliciesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeSecurityPoliciesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeSnapshotsDeleteRequest(_messages.Message):
  r"""A ComputeSnapshotsDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    snapshot: Name of the Snapshot resource to delete.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  snapshot = _messages.StringField(3, required=True)


class ComputeSnapshotsGetIamPolicyRequest(_messages.Message):
  r"""A ComputeSnapshotsGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)


class ComputeSnapshotsGetRequest(_messages.Message):
  r"""A ComputeSnapshotsGetRequest object.

  Fields:
    project: Project ID for this request.
    snapshot: Name of the Snapshot resource to return.
  """

  project = _messages.StringField(1, required=True)
  snapshot = _messages.StringField(2, required=True)


class ComputeSnapshotsListRequest(_messages.Message):
  r"""A ComputeSnapshotsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSnapshotsSetIamPolicyRequest(_messages.Message):
  r"""A ComputeSnapshotsSetIamPolicyRequest object.

  Fields:
    globalSetPolicyRequest: A GlobalSetPolicyRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetPolicyRequest = _messages.MessageField('GlobalSetPolicyRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeSnapshotsSetLabelsRequest(_messages.Message):
  r"""A ComputeSnapshotsSetLabelsRequest object.

  Fields:
    globalSetLabelsRequest: A GlobalSetLabelsRequest resource to be passed as
      the request body.
    project: Project ID for this request.
    resource: Name of the resource for this request.
  """

  globalSetLabelsRequest = _messages.MessageField('GlobalSetLabelsRequest', 1)
  project = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeSnapshotsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeSnapshotsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeSslCertificatesDeleteRequest(_messages.Message):
  r"""A ComputeSslCertificatesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    sslCertificate: Name of the SslCertificate resource to delete.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  sslCertificate = _messages.StringField(3, required=True)


class ComputeSslCertificatesGetRequest(_messages.Message):
  r"""A ComputeSslCertificatesGetRequest object.

  Fields:
    project: Project ID for this request.
    sslCertificate: Name of the SslCertificate resource to return.
  """

  project = _messages.StringField(1, required=True)
  sslCertificate = _messages.StringField(2, required=True)


class ComputeSslCertificatesInsertRequest(_messages.Message):
  r"""A ComputeSslCertificatesInsertRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    sslCertificate: A SslCertificate resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  sslCertificate = _messages.MessageField('SslCertificate', 3)


class ComputeSslCertificatesListRequest(_messages.Message):
  r"""A ComputeSslCertificatesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSslCertificatesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeSslCertificatesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeSslPoliciesDeleteRequest(_messages.Message):
  r"""A ComputeSslPoliciesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    sslPolicy: Name of the SSL policy to delete. The name must be 1-63
      characters long, and comply with RFC1035.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  sslPolicy = _messages.StringField(3, required=True)


class ComputeSslPoliciesGetRequest(_messages.Message):
  r"""A ComputeSslPoliciesGetRequest object.

  Fields:
    project: Project ID for this request.
    sslPolicy: Name of the SSL policy to update. The name must be 1-63
      characters long, and comply with RFC1035.
  """

  project = _messages.StringField(1, required=True)
  sslPolicy = _messages.StringField(2, required=True)


class ComputeSslPoliciesInsertRequest(_messages.Message):
  r"""A ComputeSslPoliciesInsertRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    sslPolicy: A SslPolicy resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  sslPolicy = _messages.MessageField('SslPolicy', 3)


class ComputeSslPoliciesListAvailableFeaturesRequest(_messages.Message):
  r"""A ComputeSslPoliciesListAvailableFeaturesRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSslPoliciesListRequest(_messages.Message):
  r"""A ComputeSslPoliciesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSslPoliciesPatchRequest(_messages.Message):
  r"""A ComputeSslPoliciesPatchRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    sslPolicy: Name of the SSL policy to update. The name must be 1-63
      characters long, and comply with RFC1035.
    sslPolicyResource: A SslPolicy resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  sslPolicy = _messages.StringField(3, required=True)
  sslPolicyResource = _messages.MessageField('SslPolicy', 4)


class ComputeSslPoliciesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeSslPoliciesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeSubnetworksAggregatedListRequest(_messages.Message):
  r"""A ComputeSubnetworksAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSubnetworksDeleteRequest(_messages.Message):
  r"""A ComputeSubnetworksDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    subnetwork: Name of the Subnetwork resource to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  subnetwork = _messages.StringField(4, required=True)


class ComputeSubnetworksExpandIpCidrRangeRequest(_messages.Message):
  r"""A ComputeSubnetworksExpandIpCidrRangeRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    subnetwork: Name of the Subnetwork resource to update.
    subnetworksExpandIpCidrRangeRequest: A SubnetworksExpandIpCidrRangeRequest
      resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  subnetwork = _messages.StringField(4, required=True)
  subnetworksExpandIpCidrRangeRequest = _messages.MessageField('SubnetworksExpandIpCidrRangeRequest', 5)


class ComputeSubnetworksGetIamPolicyRequest(_messages.Message):
  r"""A ComputeSubnetworksGetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)


class ComputeSubnetworksGetRequest(_messages.Message):
  r"""A ComputeSubnetworksGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    subnetwork: Name of the Subnetwork resource to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  subnetwork = _messages.StringField(3, required=True)


class ComputeSubnetworksInsertRequest(_messages.Message):
  r"""A ComputeSubnetworksInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    subnetwork: A Subnetwork resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  subnetwork = _messages.MessageField('Subnetwork', 4)


class ComputeSubnetworksListRequest(_messages.Message):
  r"""A ComputeSubnetworksListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeSubnetworksListUsableRequest(_messages.Message):
  r"""A ComputeSubnetworksListUsableRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeSubnetworksPatchRequest(_messages.Message):
  r"""A ComputeSubnetworksPatchRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    subnetwork: Name of the Subnetwork resource to patch.
    subnetworkResource: A Subnetwork resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  subnetwork = _messages.StringField(4, required=True)
  subnetworkResource = _messages.MessageField('Subnetwork', 5)


class ComputeSubnetworksSetIamPolicyRequest(_messages.Message):
  r"""A ComputeSubnetworksSetIamPolicyRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    regionSetPolicyRequest: A RegionSetPolicyRequest resource to be passed as
      the request body.
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetPolicyRequest = _messages.MessageField('RegionSetPolicyRequest', 3)
  resource = _messages.StringField(4, required=True)


class ComputeSubnetworksSetPrivateIpGoogleAccessRequest(_messages.Message):
  r"""A ComputeSubnetworksSetPrivateIpGoogleAccessRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    subnetwork: Name of the Subnetwork resource.
    subnetworksSetPrivateIpGoogleAccessRequest: A
      SubnetworksSetPrivateIpGoogleAccessRequest resource to be passed as the
      request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  subnetwork = _messages.StringField(4, required=True)
  subnetworksSetPrivateIpGoogleAccessRequest = _messages.MessageField('SubnetworksSetPrivateIpGoogleAccessRequest', 5)


class ComputeSubnetworksTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeSubnetworksTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeTargetHttpProxiesDeleteRequest(_messages.Message):
  r"""A ComputeTargetHttpProxiesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetHttpProxy: Name of the TargetHttpProxy resource to delete.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetHttpProxy = _messages.StringField(3, required=True)


class ComputeTargetHttpProxiesGetRequest(_messages.Message):
  r"""A ComputeTargetHttpProxiesGetRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpProxy: Name of the TargetHttpProxy resource to return.
  """

  project = _messages.StringField(1, required=True)
  targetHttpProxy = _messages.StringField(2, required=True)


class ComputeTargetHttpProxiesInsertRequest(_messages.Message):
  r"""A ComputeTargetHttpProxiesInsertRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetHttpProxy: A TargetHttpProxy resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetHttpProxy = _messages.MessageField('TargetHttpProxy', 3)


class ComputeTargetHttpProxiesListRequest(_messages.Message):
  r"""A ComputeTargetHttpProxiesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetHttpProxiesSetUrlMapRequest(_messages.Message):
  r"""A ComputeTargetHttpProxiesSetUrlMapRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetHttpProxy: Name of the TargetHttpProxy to set a URL map for.
    urlMapReference: A UrlMapReference resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetHttpProxy = _messages.StringField(3, required=True)
  urlMapReference = _messages.MessageField('UrlMapReference', 4)


class ComputeTargetHttpProxiesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeTargetHttpProxiesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeTargetHttpsProxiesDeleteRequest(_messages.Message):
  r"""A ComputeTargetHttpsProxiesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetHttpsProxy: Name of the TargetHttpsProxy resource to delete.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetHttpsProxy = _messages.StringField(3, required=True)


class ComputeTargetHttpsProxiesGetRequest(_messages.Message):
  r"""A ComputeTargetHttpsProxiesGetRequest object.

  Fields:
    project: Project ID for this request.
    targetHttpsProxy: Name of the TargetHttpsProxy resource to return.
  """

  project = _messages.StringField(1, required=True)
  targetHttpsProxy = _messages.StringField(2, required=True)


class ComputeTargetHttpsProxiesInsertRequest(_messages.Message):
  r"""A ComputeTargetHttpsProxiesInsertRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetHttpsProxy: A TargetHttpsProxy resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetHttpsProxy = _messages.MessageField('TargetHttpsProxy', 3)


class ComputeTargetHttpsProxiesListRequest(_messages.Message):
  r"""A ComputeTargetHttpsProxiesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetHttpsProxiesSetQuicOverrideRequest(_messages.Message):
  r"""A ComputeTargetHttpsProxiesSetQuicOverrideRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetHttpsProxiesSetQuicOverrideRequest: A
      TargetHttpsProxiesSetQuicOverrideRequest resource to be passed as the
      request body.
    targetHttpsProxy: Name of the TargetHttpsProxy resource to set the QUIC
      override policy for. The name should conform to RFC1035.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetHttpsProxiesSetQuicOverrideRequest = _messages.MessageField('TargetHttpsProxiesSetQuicOverrideRequest', 3)
  targetHttpsProxy = _messages.StringField(4, required=True)


class ComputeTargetHttpsProxiesSetSslCertificatesRequest(_messages.Message):
  r"""A ComputeTargetHttpsProxiesSetSslCertificatesRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetHttpsProxiesSetSslCertificatesRequest: A
      TargetHttpsProxiesSetSslCertificatesRequest resource to be passed as the
      request body.
    targetHttpsProxy: Name of the TargetHttpsProxy resource to set an
      SslCertificates resource for.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetHttpsProxiesSetSslCertificatesRequest = _messages.MessageField('TargetHttpsProxiesSetSslCertificatesRequest', 3)
  targetHttpsProxy = _messages.StringField(4, required=True)


class ComputeTargetHttpsProxiesSetSslPolicyRequest(_messages.Message):
  r"""A ComputeTargetHttpsProxiesSetSslPolicyRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    sslPolicyReference: A SslPolicyReference resource to be passed as the
      request body.
    targetHttpsProxy: Name of the TargetHttpsProxy resource whose SSL policy
      is to be set. The name must be 1-63 characters long, and comply with
      RFC1035.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  sslPolicyReference = _messages.MessageField('SslPolicyReference', 3)
  targetHttpsProxy = _messages.StringField(4, required=True)


class ComputeTargetHttpsProxiesSetUrlMapRequest(_messages.Message):
  r"""A ComputeTargetHttpsProxiesSetUrlMapRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetHttpsProxy: Name of the TargetHttpsProxy resource whose URL map is
      to be set.
    urlMapReference: A UrlMapReference resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetHttpsProxy = _messages.StringField(3, required=True)
  urlMapReference = _messages.MessageField('UrlMapReference', 4)


class ComputeTargetHttpsProxiesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeTargetHttpsProxiesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeTargetInstancesAggregatedListRequest(_messages.Message):
  r"""A ComputeTargetInstancesAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetInstancesDeleteRequest(_messages.Message):
  r"""A ComputeTargetInstancesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetInstance: Name of the TargetInstance resource to delete.
    zone: Name of the zone scoping this request.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetInstance = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ComputeTargetInstancesGetRequest(_messages.Message):
  r"""A ComputeTargetInstancesGetRequest object.

  Fields:
    project: Project ID for this request.
    targetInstance: Name of the TargetInstance resource to return.
    zone: Name of the zone scoping this request.
  """

  project = _messages.StringField(1, required=True)
  targetInstance = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeTargetInstancesInsertRequest(_messages.Message):
  r"""A ComputeTargetInstancesInsertRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetInstance: A TargetInstance resource to be passed as the request
      body.
    zone: Name of the zone scoping this request.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetInstance = _messages.MessageField('TargetInstance', 3)
  zone = _messages.StringField(4, required=True)


class ComputeTargetInstancesListRequest(_messages.Message):
  r"""A ComputeTargetInstancesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: Name of the zone scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeTargetInstancesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeTargetInstancesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
    zone: The name of the zone for this request.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)
  zone = _messages.StringField(4, required=True)


class ComputeTargetPoolsAddHealthCheckRequest(_messages.Message):
  r"""A ComputeTargetPoolsAddHealthCheckRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetPool: Name of the target pool to add a health check to.
    targetPoolsAddHealthCheckRequest: A TargetPoolsAddHealthCheckRequest
      resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  targetPool = _messages.StringField(4, required=True)
  targetPoolsAddHealthCheckRequest = _messages.MessageField('TargetPoolsAddHealthCheckRequest', 5)


class ComputeTargetPoolsAddInstanceRequest(_messages.Message):
  r"""A ComputeTargetPoolsAddInstanceRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetPool: Name of the TargetPool resource to add instances to.
    targetPoolsAddInstanceRequest: A TargetPoolsAddInstanceRequest resource to
      be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  targetPool = _messages.StringField(4, required=True)
  targetPoolsAddInstanceRequest = _messages.MessageField('TargetPoolsAddInstanceRequest', 5)


class ComputeTargetPoolsAggregatedListRequest(_messages.Message):
  r"""A ComputeTargetPoolsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetPoolsDeleteRequest(_messages.Message):
  r"""A ComputeTargetPoolsDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetPool: Name of the TargetPool resource to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  targetPool = _messages.StringField(4, required=True)


class ComputeTargetPoolsGetHealthRequest(_messages.Message):
  r"""A ComputeTargetPoolsGetHealthRequest object.

  Fields:
    instanceReference: A InstanceReference resource to be passed as the
      request body.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetPool: Name of the TargetPool resource to which the queried instance
      belongs.
  """

  instanceReference = _messages.MessageField('InstanceReference', 1)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  targetPool = _messages.StringField(4, required=True)


class ComputeTargetPoolsGetRequest(_messages.Message):
  r"""A ComputeTargetPoolsGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    targetPool: Name of the TargetPool resource to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetPool = _messages.StringField(3, required=True)


class ComputeTargetPoolsInsertRequest(_messages.Message):
  r"""A ComputeTargetPoolsInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetPool: A TargetPool resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  targetPool = _messages.MessageField('TargetPool', 4)


class ComputeTargetPoolsListRequest(_messages.Message):
  r"""A ComputeTargetPoolsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region scoping this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeTargetPoolsRemoveHealthCheckRequest(_messages.Message):
  r"""A ComputeTargetPoolsRemoveHealthCheckRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetPool: Name of the target pool to remove health checks from.
    targetPoolsRemoveHealthCheckRequest: A TargetPoolsRemoveHealthCheckRequest
      resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  targetPool = _messages.StringField(4, required=True)
  targetPoolsRemoveHealthCheckRequest = _messages.MessageField('TargetPoolsRemoveHealthCheckRequest', 5)


class ComputeTargetPoolsRemoveInstanceRequest(_messages.Message):
  r"""A ComputeTargetPoolsRemoveInstanceRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetPool: Name of the TargetPool resource to remove instances from.
    targetPoolsRemoveInstanceRequest: A TargetPoolsRemoveInstanceRequest
      resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  targetPool = _messages.StringField(4, required=True)
  targetPoolsRemoveInstanceRequest = _messages.MessageField('TargetPoolsRemoveInstanceRequest', 5)


class ComputeTargetPoolsSetBackupRequest(_messages.Message):
  r"""A ComputeTargetPoolsSetBackupRequest object.

  Fields:
    failoverRatio: New failoverRatio value for the target pool.
    project: Project ID for this request.
    region: Name of the region scoping this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetPool: Name of the TargetPool resource to set a backup pool for.
    targetReference: A TargetReference resource to be passed as the request
      body.
  """

  failoverRatio = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  project = _messages.StringField(2, required=True)
  region = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  targetPool = _messages.StringField(5, required=True)
  targetReference = _messages.MessageField('TargetReference', 6)


class ComputeTargetPoolsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeTargetPoolsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeTargetSslProxiesDeleteRequest(_messages.Message):
  r"""A ComputeTargetSslProxiesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetSslProxy: Name of the TargetSslProxy resource to delete.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetSslProxy = _messages.StringField(3, required=True)


class ComputeTargetSslProxiesGetRequest(_messages.Message):
  r"""A ComputeTargetSslProxiesGetRequest object.

  Fields:
    project: Project ID for this request.
    targetSslProxy: Name of the TargetSslProxy resource to return.
  """

  project = _messages.StringField(1, required=True)
  targetSslProxy = _messages.StringField(2, required=True)


class ComputeTargetSslProxiesInsertRequest(_messages.Message):
  r"""A ComputeTargetSslProxiesInsertRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetSslProxy: A TargetSslProxy resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetSslProxy = _messages.MessageField('TargetSslProxy', 3)


class ComputeTargetSslProxiesListRequest(_messages.Message):
  r"""A ComputeTargetSslProxiesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetSslProxiesSetBackendServiceRequest(_messages.Message):
  r"""A ComputeTargetSslProxiesSetBackendServiceRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetSslProxiesSetBackendServiceRequest: A
      TargetSslProxiesSetBackendServiceRequest resource to be passed as the
      request body.
    targetSslProxy: Name of the TargetSslProxy resource whose BackendService
      resource is to be set.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetSslProxiesSetBackendServiceRequest = _messages.MessageField('TargetSslProxiesSetBackendServiceRequest', 3)
  targetSslProxy = _messages.StringField(4, required=True)


class ComputeTargetSslProxiesSetProxyHeaderRequest(_messages.Message):
  r"""A ComputeTargetSslProxiesSetProxyHeaderRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetSslProxiesSetProxyHeaderRequest: A
      TargetSslProxiesSetProxyHeaderRequest resource to be passed as the
      request body.
    targetSslProxy: Name of the TargetSslProxy resource whose ProxyHeader is
      to be set.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetSslProxiesSetProxyHeaderRequest = _messages.MessageField('TargetSslProxiesSetProxyHeaderRequest', 3)
  targetSslProxy = _messages.StringField(4, required=True)


class ComputeTargetSslProxiesSetSslCertificatesRequest(_messages.Message):
  r"""A ComputeTargetSslProxiesSetSslCertificatesRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetSslProxiesSetSslCertificatesRequest: A
      TargetSslProxiesSetSslCertificatesRequest resource to be passed as the
      request body.
    targetSslProxy: Name of the TargetSslProxy resource whose SslCertificate
      resource is to be set.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetSslProxiesSetSslCertificatesRequest = _messages.MessageField('TargetSslProxiesSetSslCertificatesRequest', 3)
  targetSslProxy = _messages.StringField(4, required=True)


class ComputeTargetSslProxiesSetSslPolicyRequest(_messages.Message):
  r"""A ComputeTargetSslProxiesSetSslPolicyRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    sslPolicyReference: A SslPolicyReference resource to be passed as the
      request body.
    targetSslProxy: Name of the TargetSslProxy resource whose SSL policy is to
      be set. The name must be 1-63 characters long, and comply with RFC1035.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  sslPolicyReference = _messages.MessageField('SslPolicyReference', 3)
  targetSslProxy = _messages.StringField(4, required=True)


class ComputeTargetSslProxiesTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeTargetSslProxiesTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeTargetTcpProxiesDeleteRequest(_messages.Message):
  r"""A ComputeTargetTcpProxiesDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetTcpProxy: Name of the TargetTcpProxy resource to delete.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetTcpProxy = _messages.StringField(3, required=True)


class ComputeTargetTcpProxiesGetRequest(_messages.Message):
  r"""A ComputeTargetTcpProxiesGetRequest object.

  Fields:
    project: Project ID for this request.
    targetTcpProxy: Name of the TargetTcpProxy resource to return.
  """

  project = _messages.StringField(1, required=True)
  targetTcpProxy = _messages.StringField(2, required=True)


class ComputeTargetTcpProxiesInsertRequest(_messages.Message):
  r"""A ComputeTargetTcpProxiesInsertRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetTcpProxy: A TargetTcpProxy resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetTcpProxy = _messages.MessageField('TargetTcpProxy', 3)


class ComputeTargetTcpProxiesListRequest(_messages.Message):
  r"""A ComputeTargetTcpProxiesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetTcpProxiesSetBackendServiceRequest(_messages.Message):
  r"""A ComputeTargetTcpProxiesSetBackendServiceRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetTcpProxiesSetBackendServiceRequest: A
      TargetTcpProxiesSetBackendServiceRequest resource to be passed as the
      request body.
    targetTcpProxy: Name of the TargetTcpProxy resource whose BackendService
      resource is to be set.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetTcpProxiesSetBackendServiceRequest = _messages.MessageField('TargetTcpProxiesSetBackendServiceRequest', 3)
  targetTcpProxy = _messages.StringField(4, required=True)


class ComputeTargetTcpProxiesSetProxyHeaderRequest(_messages.Message):
  r"""A ComputeTargetTcpProxiesSetProxyHeaderRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetTcpProxiesSetProxyHeaderRequest: A
      TargetTcpProxiesSetProxyHeaderRequest resource to be passed as the
      request body.
    targetTcpProxy: Name of the TargetTcpProxy resource whose ProxyHeader is
      to be set.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  targetTcpProxiesSetProxyHeaderRequest = _messages.MessageField('TargetTcpProxiesSetProxyHeaderRequest', 3)
  targetTcpProxy = _messages.StringField(4, required=True)


class ComputeTargetVpnGatewaysAggregatedListRequest(_messages.Message):
  r"""A ComputeTargetVpnGatewaysAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeTargetVpnGatewaysDeleteRequest(_messages.Message):
  r"""A ComputeTargetVpnGatewaysDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetVpnGateway: Name of the target VPN gateway to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  targetVpnGateway = _messages.StringField(4, required=True)


class ComputeTargetVpnGatewaysGetRequest(_messages.Message):
  r"""A ComputeTargetVpnGatewaysGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    targetVpnGateway: Name of the target VPN gateway to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  targetVpnGateway = _messages.StringField(3, required=True)


class ComputeTargetVpnGatewaysInsertRequest(_messages.Message):
  r"""A ComputeTargetVpnGatewaysInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    targetVpnGateway: A TargetVpnGateway resource to be passed as the request
      body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  targetVpnGateway = _messages.MessageField('TargetVpnGateway', 4)


class ComputeTargetVpnGatewaysListRequest(_messages.Message):
  r"""A ComputeTargetVpnGatewaysListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeTargetVpnGatewaysSetLabelsRequest(_messages.Message):
  r"""A ComputeTargetVpnGatewaysSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  requestId = _messages.StringField(4)
  resource = _messages.StringField(5, required=True)


class ComputeTargetVpnGatewaysTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeTargetVpnGatewaysTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeUrlMapsDeleteRequest(_messages.Message):
  r"""A ComputeUrlMapsDeleteRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    urlMap: Name of the UrlMap resource to delete.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  urlMap = _messages.StringField(3, required=True)


class ComputeUrlMapsGetRequest(_messages.Message):
  r"""A ComputeUrlMapsGetRequest object.

  Fields:
    project: Project ID for this request.
    urlMap: Name of the UrlMap resource to return.
  """

  project = _messages.StringField(1, required=True)
  urlMap = _messages.StringField(2, required=True)


class ComputeUrlMapsInsertRequest(_messages.Message):
  r"""A ComputeUrlMapsInsertRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    urlMap: A UrlMap resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  urlMap = _messages.MessageField('UrlMap', 3)


class ComputeUrlMapsInvalidateCacheRequest(_messages.Message):
  r"""A ComputeUrlMapsInvalidateCacheRequest object.

  Fields:
    cacheInvalidationRule: A CacheInvalidationRule resource to be passed as
      the request body.
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    urlMap: Name of the UrlMap scoping this request.
  """

  cacheInvalidationRule = _messages.MessageField('CacheInvalidationRule', 1)
  project = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  urlMap = _messages.StringField(4, required=True)


class ComputeUrlMapsListRequest(_messages.Message):
  r"""A ComputeUrlMapsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeUrlMapsPatchRequest(_messages.Message):
  r"""A ComputeUrlMapsPatchRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    urlMap: Name of the UrlMap resource to patch.
    urlMapResource: A UrlMap resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  urlMap = _messages.StringField(3, required=True)
  urlMapResource = _messages.MessageField('UrlMap', 4)


class ComputeUrlMapsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeUrlMapsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  resource = _messages.StringField(2, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 3)


class ComputeUrlMapsUpdateRequest(_messages.Message):
  r"""A ComputeUrlMapsUpdateRequest object.

  Fields:
    project: Project ID for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    urlMap: Name of the UrlMap resource to update.
    urlMapResource: A UrlMap resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  urlMap = _messages.StringField(3, required=True)
  urlMapResource = _messages.MessageField('UrlMap', 4)


class ComputeUrlMapsValidateRequest(_messages.Message):
  r"""A ComputeUrlMapsValidateRequest object.

  Fields:
    project: Project ID for this request.
    urlMap: Name of the UrlMap resource to be validated as.
    urlMapsValidateRequest: A UrlMapsValidateRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  urlMap = _messages.StringField(2, required=True)
  urlMapsValidateRequest = _messages.MessageField('UrlMapsValidateRequest', 3)


class ComputeVpnTunnelsAggregatedListRequest(_messages.Message):
  r"""A ComputeVpnTunnelsAggregatedListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class ComputeVpnTunnelsDeleteRequest(_messages.Message):
  r"""A ComputeVpnTunnelsDeleteRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    vpnTunnel: Name of the VpnTunnel resource to delete.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  vpnTunnel = _messages.StringField(4, required=True)


class ComputeVpnTunnelsGetRequest(_messages.Message):
  r"""A ComputeVpnTunnelsGetRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    vpnTunnel: Name of the VpnTunnel resource to return.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  vpnTunnel = _messages.StringField(3, required=True)


class ComputeVpnTunnelsInsertRequest(_messages.Message):
  r"""A ComputeVpnTunnelsInsertRequest object.

  Fields:
    project: Project ID for this request.
    region: Name of the region for this request.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    vpnTunnel: A VpnTunnel resource to be passed as the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  vpnTunnel = _messages.MessageField('VpnTunnel', 4)


class ComputeVpnTunnelsListRequest(_messages.Message):
  r"""A ComputeVpnTunnelsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    region: Name of the region for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  region = _messages.StringField(6, required=True)


class ComputeVpnTunnelsSetLabelsRequest(_messages.Message):
  r"""A ComputeVpnTunnelsSetLabelsRequest object.

  Fields:
    project: Project ID for this request.
    region: The region for this request.
    regionSetLabelsRequest: A RegionSetLabelsRequest resource to be passed as
      the request body.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed.  For example,
      consider a situation where you make an initial request and the request
      times out. If you make the request again with the same request ID, the
      server can check if original operation with the same request ID was
      received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments.  The request
      ID must be a valid UUID with the exception that zero UUID is not
      supported (00000000-0000-0000-0000-000000000000).
    resource: Name of the resource for this request.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  regionSetLabelsRequest = _messages.MessageField('RegionSetLabelsRequest', 3)
  requestId = _messages.StringField(4)
  resource = _messages.StringField(5, required=True)


class ComputeVpnTunnelsTestIamPermissionsRequest(_messages.Message):
  r"""A ComputeVpnTunnelsTestIamPermissionsRequest object.

  Fields:
    project: Project ID for this request.
    region: The name of the region for this request.
    resource: Name of the resource for this request.
    testPermissionsRequest: A TestPermissionsRequest resource to be passed as
      the request body.
  """

  project = _messages.StringField(1, required=True)
  region = _messages.StringField(2, required=True)
  resource = _messages.StringField(3, required=True)
  testPermissionsRequest = _messages.MessageField('TestPermissionsRequest', 4)


class ComputeZoneOperationsDeleteRequest(_messages.Message):
  r"""A ComputeZoneOperationsDeleteRequest object.

  Fields:
    operation: Name of the Operations resource to delete.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeZoneOperationsDeleteResponse(_messages.Message):
  r"""An empty ComputeZoneOperationsDelete response."""


class ComputeZoneOperationsGetRequest(_messages.Message):
  r"""A ComputeZoneOperationsGetRequest object.

  Fields:
    operation: Name of the Operations resource to return.
    project: Project ID for this request.
    zone: Name of the zone for this request.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ComputeZoneOperationsListRequest(_messages.Message):
  r"""A ComputeZoneOperationsListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
    zone: Name of the zone for request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  zone = _messages.StringField(6, required=True)


class ComputeZonesGetRequest(_messages.Message):
  r"""A ComputeZonesGetRequest object.

  Fields:
    project: Project ID for this request.
    zone: Name of the zone resource to return.
  """

  project = _messages.StringField(1, required=True)
  zone = _messages.StringField(2, required=True)


class ComputeZonesListRequest(_messages.Message):
  r"""A ComputeZonesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression must specify the field name, a comparison operator, and
      the value that you want to use for filtering. The value must be a
      string, a number, or a boolean. The comparison operator must be either
      =, !=, >, or <.  For example, if you are filtering Compute Engine
      instances, you can exclude instances named example-instance by
      specifying name != example-instance.  You can also filter nested fields.
      For example, you could specify scheduling.automaticRestart = false to
      include instances only if they are not scheduled for automatic restarts.
      You can use filtering on nested fields to filter based on resource
      labels.  To filter on multiple expressions, provide each separate
      expression within parentheses. For example, (scheduling.automaticRestart
      = true) (cpuPlatform = "Intel Skylake"). By default, each expression is
      an AND expression. However, you can include AND and OR expressions
      explicitly. For example, (cpuPlatform = "Intel Skylake") OR (cpuPlatform
      = "Intel Broadwell") AND (scheduling.automaticRestart = true).
    maxResults: The maximum number of results per page that should be
      returned. If the number of available results is larger than maxResults,
      Compute Engine returns a nextPageToken that can be used to get the next
      page of results in subsequent list requests. Acceptable values are 0 to
      500, inclusive. (Default: 500)
    orderBy: Sorts list results by a certain order. By default, results are
      returned in alphanumerical order based on the resource name.  You can
      also sort results in descending order based on the creation timestamp
      using orderBy="creationTimestamp desc". This sorts results based on the
      creationTimestamp field in reverse chronological order (newest result
      first). Use this to sort resources like operations so that the newest
      operation is returned first.  Currently, only sorting by name or
      creationTimestamp desc is supported.
    pageToken: Specifies a page token to use. Set pageToken to the
      nextPageToken returned by a previous list request to get the next page
      of results.
    project: Project ID for this request.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class Condition(_messages.Message):
  r"""A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    value: DEPRECATED. Use 'values' instead.
    values: The objects of the condition. This is mutually exclusive with
      'value'.
  """

  class IamValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by the IAM system.

    Values:
      APPROVER: <no description>
      ATTRIBUTION: <no description>
      AUTHORITY: <no description>
      CREDENTIALS_TYPE: <no description>
      JUSTIFICATION_TYPE: <no description>
      NO_ATTR: <no description>
      SECURITY_REALM: <no description>
    """
    APPROVER = 0
    ATTRIBUTION = 1
    AUTHORITY = 2
    CREDENTIALS_TYPE = 3
    JUSTIFICATION_TYPE = 4
    NO_ATTR = 5
    SECURITY_REALM = 6

  class OpValueValuesEnum(_messages.Enum):
    r"""An operator to apply the subject with.

    Values:
      DISCHARGED: <no description>
      EQUALS: <no description>
      IN: <no description>
      NOT_EQUALS: <no description>
      NOT_IN: <no description>
      NO_OP: <no description>
    """
    DISCHARGED = 0
    EQUALS = 1
    IN = 2
    NOT_EQUALS = 3
    NOT_IN = 4
    NO_OP = 5

  class SysValueValuesEnum(_messages.Enum):
    r"""Trusted attributes supplied by any service that owns resources and
    uses the IAM system for access control.

    Values:
      IP: <no description>
      NAME: <no description>
      NO_ATTR: <no description>
      REGION: <no description>
      SERVICE: <no description>
    """
    IP = 0
    NAME = 1
    NO_ATTR = 2
    REGION = 3
    SERVICE = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  value = _messages.StringField(5)
  values = _messages.StringField(6, repeated=True)


class ConnectionDraining(_messages.Message):
  r"""Message containing connection draining configuration.

  Fields:
    drainingTimeoutSec: Time for which instance will be drained (not accept
      new connections, but still work to finish started).
  """

  drainingTimeoutSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class CustomerEncryptionKey(_messages.Message):
  r"""Represents a customer-supplied encryption key

  Fields:
    kmsKeyName: The name of the encryption key that is stored in Google Cloud
      KMS.
    rawKey: Specifies a 256-bit customer-supplied encryption key, encoded in
      RFC 4648 base64 to either encrypt or decrypt this resource.
    rsaEncryptedKey: Specifies an RFC 4648 base64 encoded, RSA-wrapped
      2048-bit customer-supplied encryption key to either encrypt or decrypt
      this resource.  The key must meet the following requirements before you
      can provide it to Compute Engine:   - The key is wrapped using a RSA
      public key certificate provided by Google.  - After being wrapped, the
      key must be encoded in RFC 4648 base64 encoding.  Gets the RSA public
      key certificate provided by Google at: https://cloud-
      certs.storage.googleapis.com/google-cloud-csek-ingress.pem
    sha256: [Output only] The RFC 4648 base64 encoded SHA-256 hash of the
      customer-supplied encryption key that protects this resource.
  """

  kmsKeyName = _messages.StringField(1)
  rawKey = _messages.StringField(2)
  rsaEncryptedKey = _messages.StringField(3)
  sha256 = _messages.StringField(4)


class CustomerEncryptionKeyProtectedDisk(_messages.Message):
  r"""A CustomerEncryptionKeyProtectedDisk object.

  Fields:
    diskEncryptionKey: Decrypts data associated with the disk with a customer-
      supplied encryption key.
    source: Specifies a valid partial or full URL to an existing Persistent
      Disk resource. This field is only applicable for persistent disks.
  """

  diskEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 1)
  source = _messages.StringField(2)


class DeprecationStatus(_messages.Message):
  r"""Deprecation status for a public resource.

  Enums:
    StateValueValuesEnum: The deprecation state of this resource. This can be
      DEPRECATED, OBSOLETE, or DELETED. Operations which create a new resource
      using a DEPRECATED resource will return successfully, but with a warning
      indicating the deprecated resource and recommending its replacement.
      Operations which use OBSOLETE or DELETED resources will be rejected and
      result in an error.

  Fields:
    deleted: An optional RFC3339 timestamp on or after which the state of this
      resource is intended to change to DELETED. This is only informational
      and the status will not change unless the client explicitly changes it.
    deprecated: An optional RFC3339 timestamp on or after which the state of
      this resource is intended to change to DEPRECATED. This is only
      informational and the status will not change unless the client
      explicitly changes it.
    obsolete: An optional RFC3339 timestamp on or after which the state of
      this resource is intended to change to OBSOLETE. This is only
      informational and the status will not change unless the client
      explicitly changes it.
    replacement: The URL of the suggested replacement for a deprecated
      resource. The suggested replacement resource must be the same kind of
      resource as the deprecated resource.
    state: The deprecation state of this resource. This can be DEPRECATED,
      OBSOLETE, or DELETED. Operations which create a new resource using a
      DEPRECATED resource will return successfully, but with a warning
      indicating the deprecated resource and recommending its replacement.
      Operations which use OBSOLETE or DELETED resources will be rejected and
      result in an error.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The deprecation state of this resource. This can be DEPRECATED,
    OBSOLETE, or DELETED. Operations which create a new resource using a
    DEPRECATED resource will return successfully, but with a warning
    indicating the deprecated resource and recommending its replacement.
    Operations which use OBSOLETE or DELETED resources will be rejected and
    result in an error.

    Values:
      DELETED: <no description>
      DEPRECATED: <no description>
      OBSOLETE: <no description>
    """
    DELETED = 0
    DEPRECATED = 1
    OBSOLETE = 2

  deleted = _messages.StringField(1)
  deprecated = _messages.StringField(2)
  obsolete = _messages.StringField(3)
  replacement = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class Disk(_messages.Message):
  r"""A Disk resource. (== resource_for beta.disks ==) (== resource_for
  v1.disks ==)

  Enums:
    StatusValueValuesEnum: [Output Only] The status of disk creation.
    StorageTypeValueValuesEnum: [Deprecated] Storage type of the persistent
      disk.

  Messages:
    LabelsValue: Labels to apply to this disk. These can be later modified by
      the setLabels method.

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    diskEncryptionKey: Encrypts the disk using a customer-supplied encryption
      key.  After you encrypt a disk with a customer-supplied key, you must
      provide the same key if you use the disk later (e.g. to create a disk
      snapshot or an image, or to attach the disk to a virtual machine).
      Customer-supplied encryption keys do not protect access to metadata of
      the disk.  If you do not provide an encryption key when creating the
      disk, then the disk will be encrypted using an automatically generated
      key and you do not need to provide a key to use the disk later.
    guestOsFeatures: A list of features to enable on the guest operating
      system. Applicable only for bootable images. Read  Enabling guest
      operating system features to see a list of available options.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#disk for disks.
    labelFingerprint: A fingerprint for the labels being applied to this disk,
      which is essentially a hash of the labels set used for optimistic
      locking. The fingerprint is initially generated by Compute Engine and
      changes after every request to modify or update labels. You must always
      provide an up-to-date fingerprint hash in order to update or change
      labels.  To see the latest fingerprint, make a get() request to retrieve
      a disk.
    labels: Labels to apply to this disk. These can be later modified by the
      setLabels method.
    lastAttachTimestamp: [Output Only] Last attach timestamp in RFC3339 text
      format.
    lastDetachTimestamp: [Output Only] Last detach timestamp in RFC3339 text
      format.
    licenseCodes: Integer license codes indicating which licenses are attached
      to this disk.
    licenses: A list of publicly visible licenses. Reserved for Google's use.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    options: Internal use only.
    region: [Output Only] URL of the region where the disk resides. Only
      applicable for regional resources. You must specify this field as part
      of the HTTP request URL. It is not settable as a field in the request
      body.
    replicaZones: URLs of the zones where the disk should be replicated to.
      Only applicable for regional resources.
    resourcePolicies: Resource policies applied to this disk for automatic
      snapshot creations.
    selfLink: [Output Only] Server-defined fully-qualified URL for this
      resource.
    sizeGb: Size of the persistent disk, specified in GB. You can specify this
      field when creating a persistent disk using the sourceImage or
      sourceSnapshot parameter, or specify it alone to create an empty
      persistent disk.  If you specify this field along with sourceImage or
      sourceSnapshot, the value of sizeGb must not be less than the size of
      the sourceImage or the size of the snapshot. Acceptable values are 1 to
      65536, inclusive.
    sourceImage: The source image used to create this disk. If the source
      image is deleted, this field will not be set.  To create a disk with one
      of the public operating system images, specify the image by its family
      name. For example, specify family/debian-9 to use the latest Debian 9
      image: projects/debian-cloud/global/images/family/debian-9
      Alternatively, use a specific version of a public operating system
      image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
      To create a disk with a custom image that you created, specify the image
      name in the following format: global/images/my-custom-image   You can
      also specify a custom image by its image family, which returns the
      latest version of the image in that family. Replace the image name with
      family/family-name: global/images/family/my-image-family
    sourceImageEncryptionKey: The customer-supplied encryption key of the
      source image. Required if the source image is protected by a customer-
      supplied encryption key.
    sourceImageId: [Output Only] The ID value of the image used to create this
      disk. This value identifies the exact image that was used to create this
      persistent disk. For example, if you created the persistent disk from an
      image that was later deleted and recreated under the same name, the
      source image ID would identify the exact version of the image that was
      used.
    sourceSnapshot: The source snapshot used to create this disk. You can
      provide this as a partial or full URL to the resource. For example, the
      following are valid values:   - https://www.googleapis.com/compute/v1/pr
      ojects/project/global/snapshots/snapshot  -
      projects/project/global/snapshots/snapshot  - global/snapshots/snapshot
    sourceSnapshotEncryptionKey: The customer-supplied encryption key of the
      source snapshot. Required if the source snapshot is protected by a
      customer-supplied encryption key.
    sourceSnapshotId: [Output Only] The unique ID of the snapshot used to
      create this disk. This value identifies the exact snapshot that was used
      to create this persistent disk. For example, if you created the
      persistent disk from a snapshot that was later deleted and recreated
      under the same name, the source snapshot ID would identify the exact
      version of the snapshot that was used.
    status: [Output Only] The status of disk creation.
    storageType: [Deprecated] Storage type of the persistent disk.
    type: URL of the disk type resource describing which disk type to use to
      create the disk. Provide this when creating the disk. For example:
      project/zones/zone/diskTypes/pd-standard or pd-ssd
    users: [Output Only] Links to the users of the disk (attached instances)
      in form: project/zones/zone/instances/instance
    zone: [Output Only] URL of the zone where the disk resides. You must
      specify this field as part of the HTTP request URL. It is not settable
      as a field in the request body.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output Only] The status of disk creation.

    Values:
      CREATING: <no description>
      FAILED: <no description>
      READY: <no description>
      RESTORING: <no description>
    """
    CREATING = 0
    FAILED = 1
    READY = 2
    RESTORING = 3

  class StorageTypeValueValuesEnum(_messages.Enum):
    r"""[Deprecated] Storage type of the persistent disk.

    Values:
      HDD: <no description>
      SSD: <no description>
    """
    HDD = 0
    SSD = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels to apply to this disk. These can be later modified by the
    setLabels method.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  diskEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 3)
  guestOsFeatures = _messages.MessageField('GuestOsFeature', 4, repeated=True)
  id = _messages.IntegerField(5, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(6, default=u'compute#disk')
  labelFingerprint = _messages.BytesField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  lastAttachTimestamp = _messages.StringField(9)
  lastDetachTimestamp = _messages.StringField(10)
  licenseCodes = _messages.IntegerField(11, repeated=True)
  licenses = _messages.StringField(12, repeated=True)
  name = _messages.StringField(13)
  options = _messages.StringField(14)
  region = _messages.StringField(15)
  replicaZones = _messages.StringField(16, repeated=True)
  resourcePolicies = _messages.StringField(17, repeated=True)
  selfLink = _messages.StringField(18)
  sizeGb = _messages.IntegerField(19)
  sourceImage = _messages.StringField(20)
  sourceImageEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 21)
  sourceImageId = _messages.StringField(22)
  sourceSnapshot = _messages.StringField(23)
  sourceSnapshotEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 24)
  sourceSnapshotId = _messages.StringField(25)
  status = _messages.EnumField('StatusValueValuesEnum', 26)
  storageType = _messages.EnumField('StorageTypeValueValuesEnum', 27)
  type = _messages.StringField(28)
  users = _messages.StringField(29, repeated=True)
  zone = _messages.StringField(30)


class DiskAggregatedList(_messages.Message):
  r"""A DiskAggregatedList object.

  Messages:
    ItemsValue: A list of DisksScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of DisksScopedList resources.
    kind: [Output Only] Type of resource. Always compute#diskAggregatedList
      for aggregated lists of persistent disks.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of DisksScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of disks.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A DisksScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('DisksScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#diskAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class DiskInstantiationConfig(_messages.Message):
  r"""A specification of the desired way to instantiate a disk in the instance
  template when its created from a source instance.

  Enums:
    InstantiateFromValueValuesEnum: Specifies whether to include the disk and
      what image to use. Possible values are:   - source-image: to use the
      same image that was used to create the source instance's corresponding
      disk. Applicable to the boot disk and additional read-write disks.  -
      source-image-family: to use the same image family that was used to
      create the source instance's corresponding disk. Applicable to the boot
      disk and additional read-write disks.  - custom-image: to use a user-
      provided image url for disk creation. Applicable to the boot disk and
      additional read-write disks.  - attach-read-only: to attach a read-only
      disk. Applicable to read-only disks.  - do-not-include: to exclude a
      disk from the template. Applicable to additional read-write disks, local
      SSDs, and read-only disks.

  Fields:
    autoDelete: Specifies whether the disk will be auto-deleted when the
      instance is deleted (but not when the disk is detached from the
      instance).
    customImage: The custom source image to be used to restore this disk when
      instantiating this instance template.
    deviceName: Specifies the device name of the disk to which the
      configurations apply to.
    instantiateFrom: Specifies whether to include the disk and what image to
      use. Possible values are:   - source-image: to use the same image that
      was used to create the source instance's corresponding disk. Applicable
      to the boot disk and additional read-write disks.  - source-image-
      family: to use the same image family that was used to create the source
      instance's corresponding disk. Applicable to the boot disk and
      additional read-write disks.  - custom-image: to use a user-provided
      image url for disk creation. Applicable to the boot disk and additional
      read-write disks.  - attach-read-only: to attach a read-only disk.
      Applicable to read-only disks.  - do-not-include: to exclude a disk from
      the template. Applicable to additional read-write disks, local SSDs, and
      read-only disks.
  """

  class InstantiateFromValueValuesEnum(_messages.Enum):
    r"""Specifies whether to include the disk and what image to use. Possible
    values are:   - source-image: to use the same image that was used to
    create the source instance's corresponding disk. Applicable to the boot
    disk and additional read-write disks.  - source-image-family: to use the
    same image family that was used to create the source instance's
    corresponding disk. Applicable to the boot disk and additional read-write
    disks.  - custom-image: to use a user-provided image url for disk
    creation. Applicable to the boot disk and additional read-write disks.  -
    attach-read-only: to attach a read-only disk. Applicable to read-only
    disks.  - do-not-include: to exclude a disk from the template. Applicable
    to additional read-write disks, local SSDs, and read-only disks.

    Values:
      ATTACH_READ_ONLY: <no description>
      BLANK: <no description>
      CUSTOM_IMAGE: <no description>
      DEFAULT: <no description>
      DO_NOT_INCLUDE: <no description>
      SOURCE_IMAGE: <no description>
      SOURCE_IMAGE_FAMILY: <no description>
    """
    ATTACH_READ_ONLY = 0
    BLANK = 1
    CUSTOM_IMAGE = 2
    DEFAULT = 3
    DO_NOT_INCLUDE = 4
    SOURCE_IMAGE = 5
    SOURCE_IMAGE_FAMILY = 6

  autoDelete = _messages.BooleanField(1)
  customImage = _messages.StringField(2)
  deviceName = _messages.StringField(3)
  instantiateFrom = _messages.EnumField('InstantiateFromValueValuesEnum', 4)


class DiskList(_messages.Message):
  r"""A list of Disk resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of Disk resources.
    kind: [Output Only] Type of resource. Always compute#diskList for lists of
      disks.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('Disk', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#diskList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class DiskMoveRequest(_messages.Message):
  r"""A DiskMoveRequest object.

  Fields:
    destinationZone: The URL of the destination zone to move the disk. This
      can be a full or partial URL. For example, the following are all valid
      URLs to a zone:   -
      https://www.googleapis.com/compute/v1/projects/project/zones/zone  -
      projects/project/zones/zone  - zones/zone
    targetDisk: The URL of the target disk to move. This can be a full or
      partial URL. For example, the following are all valid URLs to a disk:
      - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disk
      s/disk  - projects/project/zones/zone/disks/disk  -
      zones/zone/disks/disk
  """

  destinationZone = _messages.StringField(1)
  targetDisk = _messages.StringField(2)


class DiskType(_messages.Message):
  r"""A DiskType resource. (== resource_for beta.diskTypes ==) (==
  resource_for v1.diskTypes ==)

  Fields:
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    defaultDiskSizeGb: [Output Only] Server-defined default disk size in GB.
    deprecated: [Output Only] The deprecation status associated with this disk
      type.
    description: [Output Only] An optional description of this resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#diskType for disk
      types.
    name: [Output Only] Name of the resource.
    region: [Output Only] URL of the region where the disk type resides. Only
      applicable for regional resources. You must specify this field as part
      of the HTTP request URL. It is not settable as a field in the request
      body.
    selfLink: [Output Only] Server-defined URL for the resource.
    validDiskSize: [Output Only] An optional textual description of the valid
      disk size, such as "10GB-10TB".
    zone: [Output Only] URL of the zone where the disk type resides. You must
      specify this field as part of the HTTP request URL. It is not settable
      as a field in the request body.
  """

  creationTimestamp = _messages.StringField(1)
  defaultDiskSizeGb = _messages.IntegerField(2)
  deprecated = _messages.MessageField('DeprecationStatus', 3)
  description = _messages.StringField(4)
  id = _messages.IntegerField(5, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(6, default=u'compute#diskType')
  name = _messages.StringField(7)
  region = _messages.StringField(8)
  selfLink = _messages.StringField(9)
  validDiskSize = _messages.StringField(10)
  zone = _messages.StringField(11)


class DiskTypeAggregatedList(_messages.Message):
  r"""A DiskTypeAggregatedList object.

  Messages:
    ItemsValue: A list of DiskTypesScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of DiskTypesScopedList resources.
    kind: [Output Only] Type of resource. Always
      compute#diskTypeAggregatedList.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of DiskTypesScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of disk types.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A DiskTypesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('DiskTypesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#diskTypeAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class DiskTypeList(_messages.Message):
  r"""Contains a list of disk types.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of DiskType resources.
    kind: [Output Only] Type of resource. Always compute#diskTypeList for disk
      types.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('DiskType', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#diskTypeList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class DiskTypesScopedList(_messages.Message):
  r"""A DiskTypesScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of disk types when the list is empty.

  Fields:
    diskTypes: [Output Only] A list of disk types contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      disk types when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning which replaces the list of disk
    types when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  diskTypes = _messages.MessageField('DiskType', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class DisksAddResourcePoliciesRequest(_messages.Message):
  r"""A DisksAddResourcePoliciesRequest object.

  Fields:
    resourcePolicies: Resource policies to be added to this disk.
  """

  resourcePolicies = _messages.StringField(1, repeated=True)


class DisksRemoveResourcePoliciesRequest(_messages.Message):
  r"""A DisksRemoveResourcePoliciesRequest object.

  Fields:
    resourcePolicies: Resource policies to be removed from this disk.
  """

  resourcePolicies = _messages.StringField(1, repeated=True)


class DisksResizeRequest(_messages.Message):
  r"""A DisksResizeRequest object.

  Fields:
    sizeGb: The new size of the persistent disk, which is specified in GB.
  """

  sizeGb = _messages.IntegerField(1)


class DisksScopedList(_messages.Message):
  r"""A DisksScopedList object.

  Messages:
    WarningValue: [Output Only] Informational warning which replaces the list
      of disks when the list is empty.

  Fields:
    disks: [Output Only] A list of disks contained in this scope.
    warning: [Output Only] Informational warning which replaces the list of
      disks when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning which replaces the list of disks
    when the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  disks = _messages.MessageField('Disk', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class DistributionPolicy(_messages.Message):
  r"""A DistributionPolicy object.

  Fields:
    zones: Zones where the regional managed instance group will create and
      manage instances.
  """

  zones = _messages.MessageField('DistributionPolicyZoneConfiguration', 1, repeated=True)


class DistributionPolicyZoneConfiguration(_messages.Message):
  r"""A DistributionPolicyZoneConfiguration object.

  Fields:
    zone: The URL of the zone. The zone must exist in the region where the
      managed instance group is located.
  """

  zone = _messages.StringField(1)


class Expr(_messages.Message):
  r"""Represents an expression text. Example:  title: "User account presence"
  description: "Determines whether the request has a user account" expression:
  "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Firewall(_messages.Message):
  r"""Represents a Firewall resource.

  Enums:
    DirectionValueValuesEnum: Direction of traffic to which this firewall
      applies; default is INGRESS. Note: For INGRESS traffic, it is NOT
      supported to specify destinationRanges; For EGRESS traffic, it is NOT
      supported to specify sourceRanges OR sourceTags.

  Messages:
    AllowedValueListEntry: A AllowedValueListEntry object.
    DeniedValueListEntry: A DeniedValueListEntry object.

  Fields:
    allowed: The list of ALLOW rules specified by this firewall. Each rule
      specifies a protocol and port-range tuple that describes a permitted
      connection.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    denied: The list of DENY rules specified by this firewall. Each rule
      specifies a protocol and port-range tuple that describes a denied
      connection.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    destinationRanges: If destination ranges are specified, the firewall will
      apply only to traffic that has destination IP address in these ranges.
      These ranges must be expressed in CIDR format. Only IPv4 is supported.
    direction: Direction of traffic to which this firewall applies; default is
      INGRESS. Note: For INGRESS traffic, it is NOT supported to specify
      destinationRanges; For EGRESS traffic, it is NOT supported to specify
      sourceRanges OR sourceTags.
    disabled: Denotes whether the firewall rule is disabled, i.e not applied
      to the network it is associated with. When set to true, the firewall
      rule is not enforced and the network behaves as if it did not exist. If
      this is unspecified, the firewall rule will be enabled.
    enableLogging: This field denotes whether to enable logging for a
      particular firewall rule. If logging is enabled, logs will be exported
      to Stackdriver.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#firewall for
      firewall rules.
    name: Name of the resource; provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    network: URL of the network resource for this firewall rule. If not
      specified when creating a firewall rule, the default network is used:
      global/networks/default If you choose to specify this property, you can
      specify the network as a full or partial URL. For example, the following
      are all valid URLs:   -
      https://www.googleapis.com/compute/v1/projects/myproject/global/networks
      /my-network  - projects/myproject/global/networks/my-network  -
      global/networks/default
    priority: Priority for this rule. This is an integer between 0 and 65535,
      both inclusive. When not specified, the value assumed is 1000. Relative
      priorities determine precedence of conflicting rules. Lower value of
      priority implies higher precedence (eg, a rule with priority 0 has
      higher precedence than a rule with priority 1). DENY rules take
      precedence over ALLOW rules having equal priority.
    selfLink: [Output Only] Server-defined URL for the resource.
    sourceRanges: If source ranges are specified, the firewall will apply only
      to traffic that has source IP address in these ranges. These ranges must
      be expressed in CIDR format. One or both of sourceRanges and sourceTags
      may be set. If both properties are set, the firewall will apply to
      traffic that has source IP address within sourceRanges OR the source IP
      that belongs to a tag listed in the sourceTags property. The connection
      does not need to match both properties for the firewall to apply. Only
      IPv4 is supported.
    sourceServiceAccounts: If source service accounts are specified, the
      firewall will apply only to traffic originating from an instance with a
      service account in this list. Source service accounts cannot be used to
      control traffic to an instance's external IP address because service
      accounts are associated with an instance, not an IP address.
      sourceRanges can be set at the same time as sourceServiceAccounts. If
      both are set, the firewall will apply to traffic that has source IP
      address within sourceRanges OR the source IP belongs to an instance with
      service account listed in sourceServiceAccount. The connection does not
      need to match both properties for the firewall to apply.
      sourceServiceAccounts cannot be used at the same time as sourceTags or
      targetTags.
    sourceTags: If source tags are specified, the firewall rule applies only
      to traffic with source IPs that match the primary network interfaces of
      VM instances that have the tag and are in the same VPC network. Source
      tags cannot be used to control traffic to an instance's external IP
      address, it only applies to traffic between instances in the same
      virtual network. Because tags are associated with instances, not IP
      addresses. One or both of sourceRanges and sourceTags may be set. If
      both properties are set, the firewall will apply to traffic that has
      source IP address within sourceRanges OR the source IP that belongs to a
      tag listed in the sourceTags property. The connection does not need to
      match both properties for the firewall to apply.
    targetServiceAccounts: A list of service accounts indicating sets of
      instances located in the network that may make network connections as
      specified in allowed[]. targetServiceAccounts cannot be used at the same
      time as targetTags or sourceTags. If neither targetServiceAccounts nor
      targetTags are specified, the firewall rule applies to all instances on
      the specified network.
    targetTags: A list of tags that controls which instances the firewall rule
      applies to. If targetTags are specified, then the firewall rule applies
      only to instances in the VPC network that have one of those tags. If no
      targetTags are specified, the firewall rule applies to all instances on
      the specified network.
  """

  class DirectionValueValuesEnum(_messages.Enum):
    r"""Direction of traffic to which this firewall applies; default is
    INGRESS. Note: For INGRESS traffic, it is NOT supported to specify
    destinationRanges; For EGRESS traffic, it is NOT supported to specify
    sourceRanges OR sourceTags.

    Values:
      EGRESS: <no description>
      INGRESS: <no description>
    """
    EGRESS = 0
    INGRESS = 1

  class AllowedValueListEntry(_messages.Message):
    r"""A AllowedValueListEntry object.

    Fields:
      IPProtocol: The IP protocol to which this rule applies. The protocol
        type is required when creating a firewall rule. This value can either
        be one of the following well known protocol strings (tcp, udp, icmp,
        esp, ah, ipip, sctp), or the IP protocol number.
      ports: An optional list of ports to which this rule applies. This field
        is only applicable for UDP or TCP protocol. Each entry must be either
        an integer or a range. If not specified, this rule applies to
        connections through any port.  Example inputs include: ["22"],
        ["80","443"], and ["12345-12349"].
    """

    IPProtocol = _messages.StringField(1)
    ports = _messages.StringField(2, repeated=True)

  class DeniedValueListEntry(_messages.Message):
    r"""A DeniedValueListEntry object.

    Fields:
      IPProtocol: The IP protocol to which this rule applies. The protocol
        type is required when creating a firewall rule. This value can either
        be one of the following well known protocol strings (tcp, udp, icmp,
        esp, ah, ipip, sctp), or the IP protocol number.
      ports: An optional list of ports to which this rule applies. This field
        is only applicable for UDP or TCP protocol. Each entry must be either
        an integer or a range. If not specified, this rule applies to
        connections through any port.  Example inputs include: ["22"],
        ["80","443"], and ["12345-12349"].
    """

    IPProtocol = _messages.StringField(1)
    ports = _messages.StringField(2, repeated=True)

  allowed = _messages.MessageField('AllowedValueListEntry', 1, repeated=True)
  creationTimestamp = _messages.StringField(2)
  denied = _messages.MessageField('DeniedValueListEntry', 3, repeated=True)
  description = _messages.StringField(4)
  destinationRanges = _messages.StringField(5, repeated=True)
  direction = _messages.EnumField('DirectionValueValuesEnum', 6)
  disabled = _messages.BooleanField(7)
  enableLogging = _messages.BooleanField(8)
  id = _messages.IntegerField(9, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(10, default=u'compute#firewall')
  name = _messages.StringField(11)
  network = _messages.StringField(12)
  priority = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  selfLink = _messages.StringField(14)
  sourceRanges = _messages.StringField(15, repeated=True)
  sourceServiceAccounts = _messages.StringField(16, repeated=True)
  sourceTags = _messages.StringField(17, repeated=True)
  targetServiceAccounts = _messages.StringField(18, repeated=True)
  targetTags = _messages.StringField(19, repeated=True)


class FirewallList(_messages.Message):
  r"""Contains a list of firewalls.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of Firewall resources.
    kind: [Output Only] Type of resource. Always compute#firewallList for
      lists of firewalls.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('Firewall', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#firewallList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class FixedOrPercent(_messages.Message):
  r"""Encapsulates numeric value that can be either absolute or relative.

  Fields:
    calculated: [Output Only] Absolute value of VM instances calculated based
      on the specific mode.    - If the value is fixed, then the caculated
      value is equal to the fixed value.  - If the value is a percent, then
      the calculated value is percent/100 * targetSize. For example, the
      calculated value of a 80% of a managed instance group with 150 instances
      would be (80/100 * 150) = 120 VM instances. If there is a remainder, the
      number is rounded up.
    fixed: Specifies a fixed number of VM instances. This must be a positive
      integer.
    percent: Specifies a percentage of instances between 0 to 100%, inclusive.
      For example, specify 80 for 80%.
  """

  calculated = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  fixed = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  percent = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ForwardingRule(_messages.Message):
  r"""A ForwardingRule resource. A ForwardingRule resource specifies which
  pool of target virtual machines to forward a packet to if it matches the
  given [IPAddress, IPProtocol, ports] tuple. (== resource_for
  beta.forwardingRules ==) (== resource_for v1.forwardingRules ==) (==
  resource_for beta.globalForwardingRules ==) (== resource_for
  v1.globalForwardingRules ==) (== resource_for beta.regionForwardingRules ==)
  (== resource_for v1.regionForwardingRules ==)

  Enums:
    IPProtocolValueValuesEnum: The IP protocol to which this rule applies.
      Valid options are TCP, UDP, ESP, AH, SCTP or ICMP.  When the load
      balancing scheme is INTERNAL, only TCP and UDP are valid. When the load
      balancing scheme is INTERNAL_SELF_MANAGED, only TCPis valid.
    IpVersionValueValuesEnum: The IP Version that will be used by this
      forwarding rule. Valid options are IPV4 or IPV6. This can only be
      specified for an external global forwarding rule.
    LoadBalancingSchemeValueValuesEnum: This signifies what the ForwardingRule
      will be used for and can only take the following values: INTERNAL,
      INTERNAL_SELF_MANAGED, EXTERNAL. The value of INTERNAL means that this
      will be used for Internal Network Load Balancing (TCP, UDP). The value
      of INTERNAL_SELF_MANAGED means that this will be used for Internal
      Global HTTP(S) LB. The value of EXTERNAL means that this will be used
      for External Load Balancing (HTTP(S) LB, External TCP/UDP LB, SSL Proxy)
    NetworkTierValueValuesEnum: This signifies the networking tier used for
      configuring this load balancer and can only take the following values:
      PREMIUM , STANDARD.  For regional ForwardingRule, the valid values are
      PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is
      PREMIUM.  If this field is not specified, it is assumed to be PREMIUM.
      If IPAddress is specified, this value must be equal to the networkTier
      of the Address.

  Messages:
    LabelsValue: Labels to apply to this resource. These can be later modified
      by the setLabels method. Each label key/value pair must comply with
      RFC1035. Label values may be empty.

  Fields:
    IPAddress: The IP address that this forwarding rule is serving on behalf
      of.  Addresses are restricted based on the forwarding rule's load
      balancing scheme (EXTERNAL or INTERNAL) and scope (global or regional).
      When the load balancing scheme is EXTERNAL, for global forwarding rules,
      the address must be a global IP, and for regional forwarding rules, the
      address must live in the same region as the forwarding rule. If this
      field is empty, an ephemeral IPv4 address from the same scope (global or
      regional) will be assigned. A regional forwarding rule supports IPv4
      only. A global forwarding rule supports either IPv4 or IPv6.  When the
      load balancing scheme is INTERNAL_SELF_MANAGED, this must be a URL
      reference to an existing Address resource ( internal regional static IP
      address), with a purpose of GCE_END_POINT and address_type of INTERNAL.
      When the load balancing scheme is INTERNAL, this can only be an RFC 1918
      IP address belonging to the network/subnet configured for the forwarding
      rule. By default, if this field is empty, an ephemeral internal IP
      address will be automatically allocated from the IP range of the subnet
      or network configured for this forwarding rule.  An address can be
      specified either by a literal IP address or a URL reference to an
      existing Address resource. The following examples are all valid:   -
      100.1.2.3  - https://www.googleapis.com/compute/v1/projects/project/regi
      ons/region/addresses/address  -
      projects/project/regions/region/addresses/address  -
      regions/region/addresses/address  - global/addresses/address  - address
    IPProtocol: The IP protocol to which this rule applies. Valid options are
      TCP, UDP, ESP, AH, SCTP or ICMP.  When the load balancing scheme is
      INTERNAL, only TCP and UDP are valid. When the load balancing scheme is
      INTERNAL_SELF_MANAGED, only TCPis valid.
    backendService: This field is only used for INTERNAL load balancing.  For
      internal load balancing, this field identifies the BackendService
      resource to receive the matched traffic.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    ipVersion: The IP Version that will be used by this forwarding rule. Valid
      options are IPV4 or IPV6. This can only be specified for an external
      global forwarding rule.
    kind: [Output Only] Type of the resource. Always compute#forwardingRule
      for Forwarding Rule resources.
    labelFingerprint: A fingerprint for the labels being applied to this
      resource, which is essentially a hash of the labels set used for
      optimistic locking. The fingerprint is initially generated by Compute
      Engine and changes after every request to modify or update labels. You
      must always provide an up-to-date fingerprint hash in order to update or
      change labels.  To see the latest fingerprint, make a get() request to
      retrieve a ForwardingRule.
    labels: Labels to apply to this resource. These can be later modified by
      the setLabels method. Each label key/value pair must comply with
      RFC1035. Label values may be empty.
    loadBalancingScheme: This signifies what the ForwardingRule will be used
      for and can only take the following values: INTERNAL,
      INTERNAL_SELF_MANAGED, EXTERNAL. The value of INTERNAL means that this
      will be used for Internal Network Load Balancing (TCP, UDP). The value
      of INTERNAL_SELF_MANAGED means that this will be used for Internal
      Global HTTP(S) LB. The value of EXTERNAL means that this will be used
      for External Load Balancing (HTTP(S) LB, External TCP/UDP LB, SSL Proxy)
    name: Name of the resource; provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    network: This field is not used for external load balancing.  For INTERNAL
      and INTERNAL_SELF_MANAGED load balancing, this field identifies the
      network that the load balanced IP should belong to for this Forwarding
      Rule. If this field is not specified, the default network will be used.
    networkTier: This signifies the networking tier used for configuring this
      load balancer and can only take the following values: PREMIUM ,
      STANDARD.  For regional ForwardingRule, the valid values are PREMIUM and
      STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.  If this
      field is not specified, it is assumed to be PREMIUM. If IPAddress is
      specified, this value must be equal to the networkTier of the Address.
    portRange: This field is used along with the target field for
      TargetHttpProxy, TargetHttpsProxy, TargetSslProxy, TargetTcpProxy,
      TargetVpnGateway, TargetPool, TargetInstance.  Applicable only when
      IPProtocol is TCP, UDP, or SCTP, only packets addressed to ports in the
      specified range will be forwarded to target. Forwarding rules with the
      same [IPAddress, IPProtocol] pair must have disjoint port ranges.  Some
      types of forwarding target have constraints on the acceptable ports:   -
      TargetHttpProxy: 80, 8080  - TargetHttpsProxy: 443  - TargetTcpProxy:
      25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222  -
      TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
      1688, 1883, 5222  - TargetVpnGateway: 500, 4500
    ports: This field is used along with the backend_service field for
      internal load balancing.  When the load balancing scheme is INTERNAL, a
      single port or a comma separated list of ports can be configured. Only
      packets addressed to these ports will be forwarded to the backends
      configured with this forwarding rule.  You may specify a maximum of up
      to 5 ports.
    region: [Output Only] URL of the region where the regional forwarding rule
      resides. This field is not applicable to global forwarding rules. You
      must specify this field as part of the HTTP request URL. It is not
      settable as a field in the request body.
    selfLink: [Output Only] Server-defined URL for the resource.
    serviceLabel: An optional prefix to the service name for this Forwarding
      Rule. If specified, will be the first label of the fully qualified
      service name.  The label must be 1-63 characters long, and comply with
      RFC1035. Specifically, the label must be 1-63 characters long and match
      the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the
      first character must be a lowercase letter, and all following characters
      must be a dash, lowercase letter, or digit, except the last character,
      which cannot be a dash.  This field is only used for internal load
      balancing.
    serviceName: [Output Only] The internal fully qualified service name for
      this Forwarding Rule.  This field is only used for internal load
      balancing.
    subnetwork: This field is only used for INTERNAL load balancing.  For
      internal load balancing, this field identifies the subnetwork that the
      load balanced IP should belong to for this Forwarding Rule.  If the
      network specified is in auto subnet mode, this field is optional.
      However, if the network is in custom subnet mode, a subnetwork must be
      specified.
    target: The URL of the target resource to receive the matched traffic. For
      regional forwarding rules, this target must live in the same region as
      the forwarding rule. For global forwarding rules, this target must be a
      global load balancing resource. The forwarded traffic must be of a type
      appropriate to the target object. For INTERNAL_SELF_MANAGED" load
      balancing, only HTTP and HTTPS targets are valid.
  """

  class IPProtocolValueValuesEnum(_messages.Enum):
    r"""The IP protocol to which this rule applies. Valid options are TCP,
    UDP, ESP, AH, SCTP or ICMP.  When the load balancing scheme is INTERNAL,
    only TCP and UDP are valid. When the load balancing scheme is
    INTERNAL_SELF_MANAGED, only TCPis valid.

    Values:
      AH: <no description>
      ESP: <no description>
      ICMP: <no description>
      SCTP: <no description>
      TCP: <no description>
      UDP: <no description>
    """
    AH = 0
    ESP = 1
    ICMP = 2
    SCTP = 3
    TCP = 4
    UDP = 5

  class IpVersionValueValuesEnum(_messages.Enum):
    r"""The IP Version that will be used by this forwarding rule. Valid
    options are IPV4 or IPV6. This can only be specified for an external
    global forwarding rule.

    Values:
      IPV4: <no description>
      IPV6: <no description>
      UNSPECIFIED_VERSION: <no description>
    """
    IPV4 = 0
    IPV6 = 1
    UNSPECIFIED_VERSION = 2

  class LoadBalancingSchemeValueValuesEnum(_messages.Enum):
    r"""This signifies what the ForwardingRule will be used for and can only
    take the following values: INTERNAL, INTERNAL_SELF_MANAGED, EXTERNAL. The
    value of INTERNAL means that this will be used for Internal Network Load
    Balancing (TCP, UDP). The value of INTERNAL_SELF_MANAGED means that this
    will be used for Internal Global HTTP(S) LB. The value of EXTERNAL means
    that this will be used for External Load Balancing (HTTP(S) LB, External
    TCP/UDP LB, SSL Proxy)

    Values:
      EXTERNAL: <no description>
      INTERNAL: <no description>
      INVALID: <no description>
    """
    EXTERNAL = 0
    INTERNAL = 1
    INVALID = 2

  class NetworkTierValueValuesEnum(_messages.Enum):
    r"""This signifies the networking tier used for configuring this load
    balancer and can only take the following values: PREMIUM , STANDARD.  For
    regional ForwardingRule, the valid values are PREMIUM and STANDARD. For
    GlobalForwardingRule, the valid value is PREMIUM.  If this field is not
    specified, it is assumed to be PREMIUM. If IPAddress is specified, this
    value must be equal to the networkTier of the Address.

    Values:
      PREMIUM: <no description>
      STANDARD: <no description>
    """
    PREMIUM = 0
    STANDARD = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels to apply to this resource. These can be later modified by the
    setLabels method. Each label key/value pair must comply with RFC1035.
    Label values may be empty.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  IPAddress = _messages.StringField(1)
  IPProtocol = _messages.EnumField('IPProtocolValueValuesEnum', 2)
  backendService = _messages.StringField(3)
  creationTimestamp = _messages.StringField(4)
  description = _messages.StringField(5)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  ipVersion = _messages.EnumField('IpVersionValueValuesEnum', 7)
  kind = _messages.StringField(8, default=u'compute#forwardingRule')
  labelFingerprint = _messages.BytesField(9)
  labels = _messages.MessageField('LabelsValue', 10)
  loadBalancingScheme = _messages.EnumField('LoadBalancingSchemeValueValuesEnum', 11)
  name = _messages.StringField(12)
  network = _messages.StringField(13)
  networkTier = _messages.EnumField('NetworkTierValueValuesEnum', 14)
  portRange = _messages.StringField(15)
  ports = _messages.StringField(16, repeated=True)
  region = _messages.StringField(17)
  selfLink = _messages.StringField(18)
  serviceLabel = _messages.StringField(19)
  serviceName = _messages.StringField(20)
  subnetwork = _messages.StringField(21)
  target = _messages.StringField(22)


class ForwardingRuleAggregatedList(_messages.Message):
  r"""A ForwardingRuleAggregatedList object.

  Messages:
    ItemsValue: A list of ForwardingRulesScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of ForwardingRulesScopedList resources.
    kind: [Output Only] Type of resource. Always
      compute#forwardingRuleAggregatedList for lists of forwarding rules.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of ForwardingRulesScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: Name of the scope containing this set of
        addresses.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A ForwardingRulesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ForwardingRulesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#forwardingRuleAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class ForwardingRuleList(_messages.Message):
  r"""Contains a list of ForwardingRule resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of ForwardingRule resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ForwardingRule', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#forwardingRuleList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class ForwardingRuleReference(_messages.Message):
  r"""A ForwardingRuleReference object.

  Fields:
    forwardingRule: A string attribute.
  """

  forwardingRule = _messages.StringField(1)


class ForwardingRulesScopedList(_messages.Message):
  r"""A ForwardingRulesScopedList object.

  Messages:
    WarningValue: Informational warning which replaces the list of forwarding
      rules when the list is empty.

  Fields:
    forwardingRules: A list of forwarding rules contained in this scope.
    warning: Informational warning which replaces the list of forwarding rules
      when the list is empty.
  """

  class WarningValue(_messages.Message):
    r"""Informational warning which replaces the list of forwarding rules when
    the list is empty.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  forwardingRules = _messages.MessageField('ForwardingRule', 1, repeated=True)
  warning = _messages.MessageField('WarningValue', 2)


class GlobalSetLabelsRequest(_messages.Message):
  r"""A GlobalSetLabelsRequest object.

  Messages:
    LabelsValue: A list of labels to apply for this resource. Each label key &
      value must comply with RFC1035. Specifically, the name must be 1-63
      characters long and match the regular expression
      `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a
      lowercase letter, and all following characters must be a dash, lowercase
      letter, or digit, except the last character, which cannot be a dash. For
      example, "webserver-frontend": "images". A label value can also be empty
      (e.g. "my-label": "").

  Fields:
    labelFingerprint: The fingerprint of the previous set of labels for this
      resource, used to detect conflicts. The fingerprint is initially
      generated by Compute Engine and changes after every request to modify or
      update labels. You must always provide an up-to-date fingerprint hash
      when updating or changing labels. Make a get() request to the resource
      to get the latest fingerprint.
    labels: A list of labels to apply for this resource. Each label key &
      value must comply with RFC1035. Specifically, the name must be 1-63
      characters long and match the regular expression
      `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a
      lowercase letter, and all following characters must be a dash, lowercase
      letter, or digit, except the last character, which cannot be a dash. For
      example, "webserver-frontend": "images". A label value can also be empty
      (e.g. "my-label": "").
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""A list of labels to apply for this resource. Each label key & value
    must comply with RFC1035. Specifically, the name must be 1-63 characters
    long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which
    means the first character must be a lowercase letter, and all following
    characters must be a dash, lowercase letter, or digit, except the last
    character, which cannot be a dash. For example, "webserver-frontend":
    "images". A label value can also be empty (e.g. "my-label": "").

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labelFingerprint = _messages.BytesField(1)
  labels = _messages.MessageField('LabelsValue', 2)


class GlobalSetPolicyRequest(_messages.Message):
  r"""A GlobalSetPolicyRequest object.

  Fields:
    bindings: Flatten Policy to create a backwacd compatible wire-format.
      Deprecated. Use 'policy' to specify bindings.
    etag: Flatten Policy to create a backward compatible wire-format.
      Deprecated. Use 'policy' to specify the etag.
    policy: REQUIRED: The complete policy to be applied to the 'resource'. The
      size of the policy is limited to a few 10s of KB. An empty policy is in
      general a valid policy but certain services (like Projects) might reject
      them.
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  policy = _messages.MessageField('Policy', 3)


class GuestAttributes(_messages.Message):
  r"""A guest attributes entry.

  Fields:
    kind: [Output Only] Type of the resource. Always compute#guestAttributes
      for guest attributes entry.
    queryPath: The path to be queried. This can be the default namespace ('/')
      or a nested namespace ('//') or a specified key ('//')
    queryValue: [Output Only] The value of the requested queried path.
    selfLink: [Output Only] Server-defined URL for this resource.
    variableKey: The key to search for.
    variableValue: [Output Only] The value found for the requested key.
  """

  kind = _messages.StringField(1, default=u'compute#guestAttributes')
  queryPath = _messages.StringField(2)
  queryValue = _messages.MessageField('GuestAttributesValue', 3)
  selfLink = _messages.StringField(4)
  variableKey = _messages.StringField(5)
  variableValue = _messages.StringField(6)


class GuestAttributesEntry(_messages.Message):
  r"""A guest attributes namespace/key/value entry.

  Fields:
    key: Key for the guest attribute entry.
    namespace: Namespace for the guest attribute entry.
    value: Value for the guest attribute entry.
  """

  key = _messages.StringField(1)
  namespace = _messages.StringField(2)
  value = _messages.StringField(3)


class GuestAttributesValue(_messages.Message):
  r"""Array of guest attribute namespace/key/value tuples.

  Fields:
    items: A GuestAttributesEntry attribute.
  """

  items = _messages.MessageField('GuestAttributesEntry', 1, repeated=True)


class GuestOsFeature(_messages.Message):
  r"""Guest OS features.

  Enums:
    TypeValueValuesEnum: The ID of a supported feature. Read  Enabling guest
      operating system features to see a list of available options.

  Fields:
    type: The ID of a supported feature. Read  Enabling guest operating system
      features to see a list of available options.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The ID of a supported feature. Read  Enabling guest operating system
    features to see a list of available options.

    Values:
      FEATURE_TYPE_UNSPECIFIED: <no description>
      MULTI_IP_SUBNET: <no description>
      SECURE_BOOT: <no description>
      UEFI_COMPATIBLE: <no description>
      VIRTIO_SCSI_MULTIQUEUE: <no description>
      WINDOWS: <no description>
    """
    FEATURE_TYPE_UNSPECIFIED = 0
    MULTI_IP_SUBNET = 1
    SECURE_BOOT = 2
    UEFI_COMPATIBLE = 3
    VIRTIO_SCSI_MULTIQUEUE = 4
    WINDOWS = 5

  type = _messages.EnumField('TypeValueValuesEnum', 1)


class HTTP2HealthCheck(_messages.Message):
  r"""A HTTP2HealthCheck object.

  Enums:
    PortSpecificationValueValuesEnum: Specifies how port is selected for
      health checking, can be one of following values: USE_FIXED_PORT: The
      port number in port is used for health checking. USE_NAMED_PORT: The
      portName is used for health checking. USE_SERVING_PORT: For
      NetworkEndpointGroup, the port specified for each network endpoint is
      used for health checking. For other backends, the port or named port
      specified in the Backend Service is used for health checking.   If not
      specified, HTTP2 health check follows behavior specified in port and
      portName fields.
    ProxyHeaderValueValuesEnum: Specifies the type of proxy header to append
      before sending data to the backend, either NONE or PROXY_V1. The default
      is NONE.

  Fields:
    host: The value of the host header in the HTTP/2 health check request. If
      left empty (default value), the IP on behalf of which this health check
      is performed will be used.
    port: The TCP port number for the health check request. The default value
      is 443. Valid values are 1 through 65535.
    portName: Port name as defined in InstanceGroup#NamedPort#name. If both
      port and port_name are defined, port takes precedence.
    portSpecification: Specifies how port is selected for health checking, can
      be one of following values: USE_FIXED_PORT: The port number in port is
      used for health checking. USE_NAMED_PORT: The portName is used for
      health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
      specified for each network endpoint is used for health checking. For
      other backends, the port or named port specified in the Backend Service
      is used for health checking.   If not specified, HTTP2 health check
      follows behavior specified in port and portName fields.
    proxyHeader: Specifies the type of proxy header to append before sending
      data to the backend, either NONE or PROXY_V1. The default is NONE.
    requestPath: The request path of the HTTP/2 health check request. The
      default value is /.
    response: The string to match anywhere in the first 1024 bytes of the
      response body. If left empty (the default value), the status code
      determines health. The response data can only be ASCII.
  """

  class PortSpecificationValueValuesEnum(_messages.Enum):
    r"""Specifies how port is selected for health checking, can be one of
    following values: USE_FIXED_PORT: The port number in port is used for
    health checking. USE_NAMED_PORT: The portName is used for health checking.
    USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the port
    or named port specified in the Backend Service is used for health
    checking.   If not specified, HTTP2 health check follows behavior
    specified in port and portName fields.

    Values:
      USE_FIXED_PORT: <no description>
      USE_NAMED_PORT: <no description>
      USE_SERVING_PORT: <no description>
    """
    USE_FIXED_PORT = 0
    USE_NAMED_PORT = 1
    USE_SERVING_PORT = 2

  class ProxyHeaderValueValuesEnum(_messages.Enum):
    r"""Specifies the type of proxy header to append before sending data to
    the backend, either NONE or PROXY_V1. The default is NONE.

    Values:
      NONE: <no description>
      PROXY_V1: <no description>
    """
    NONE = 0
    PROXY_V1 = 1

  host = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  portName = _messages.StringField(3)
  portSpecification = _messages.EnumField('PortSpecificationValueValuesEnum', 4)
  proxyHeader = _messages.EnumField('ProxyHeaderValueValuesEnum', 5)
  requestPath = _messages.StringField(6)
  response = _messages.StringField(7)


class HTTPHealthCheck(_messages.Message):
  r"""A HTTPHealthCheck object.

  Enums:
    PortSpecificationValueValuesEnum: Specifies how port is selected for
      health checking, can be one of following values: USE_FIXED_PORT: The
      port number in port is used for health checking. USE_NAMED_PORT: The
      portName is used for health checking. USE_SERVING_PORT: For
      NetworkEndpointGroup, the port specified for each network endpoint is
      used for health checking. For other backends, the port or named port
      specified in the Backend Service is used for health checking.   If not
      specified, HTTP health check follows behavior specified in port and
      portName fields.
    ProxyHeaderValueValuesEnum: Specifies the type of proxy header to append
      before sending data to the backend, either NONE or PROXY_V1. The default
      is NONE.

  Fields:
    host: The value of the host header in the HTTP health check request. If
      left empty (default value), the IP on behalf of which this health check
      is performed will be used.
    port: The TCP port number for the health check request. The default value
      is 80. Valid values are 1 through 65535.
    portName: Port name as defined in InstanceGroup#NamedPort#name. If both
      port and port_name are defined, port takes precedence.
    portSpecification: Specifies how port is selected for health checking, can
      be one of following values: USE_FIXED_PORT: The port number in port is
      used for health checking. USE_NAMED_PORT: The portName is used for
      health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
      specified for each network endpoint is used for health checking. For
      other backends, the port or named port specified in the Backend Service
      is used for health checking.   If not specified, HTTP health check
      follows behavior specified in port and portName fields.
    proxyHeader: Specifies the type of proxy header to append before sending
      data to the backend, either NONE or PROXY_V1. The default is NONE.
    requestPath: The request path of the HTTP health check request. The
      default value is /.
    response: The string to match anywhere in the first 1024 bytes of the
      response body. If left empty (the default value), the status code
      determines health. The response data can only be ASCII.
  """

  class PortSpecificationValueValuesEnum(_messages.Enum):
    r"""Specifies how port is selected for health checking, can be one of
    following values: USE_FIXED_PORT: The port number in port is used for
    health checking. USE_NAMED_PORT: The portName is used for health checking.
    USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the port
    or named port specified in the Backend Service is used for health
    checking.   If not specified, HTTP health check follows behavior specified
    in port and portName fields.

    Values:
      USE_FIXED_PORT: <no description>
      USE_NAMED_PORT: <no description>
      USE_SERVING_PORT: <no description>
    """
    USE_FIXED_PORT = 0
    USE_NAMED_PORT = 1
    USE_SERVING_PORT = 2

  class ProxyHeaderValueValuesEnum(_messages.Enum):
    r"""Specifies the type of proxy header to append before sending data to
    the backend, either NONE or PROXY_V1. The default is NONE.

    Values:
      NONE: <no description>
      PROXY_V1: <no description>
    """
    NONE = 0
    PROXY_V1 = 1

  host = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  portName = _messages.StringField(3)
  portSpecification = _messages.EnumField('PortSpecificationValueValuesEnum', 4)
  proxyHeader = _messages.EnumField('ProxyHeaderValueValuesEnum', 5)
  requestPath = _messages.StringField(6)
  response = _messages.StringField(7)


class HTTPSHealthCheck(_messages.Message):
  r"""A HTTPSHealthCheck object.

  Enums:
    PortSpecificationValueValuesEnum: Specifies how port is selected for
      health checking, can be one of following values: USE_FIXED_PORT: The
      port number in port is used for health checking. USE_NAMED_PORT: The
      portName is used for health checking. USE_SERVING_PORT: For
      NetworkEndpointGroup, the port specified for each network endpoint is
      used for health checking. For other backends, the port or named port
      specified in the Backend Service is used for health checking.   If not
      specified, HTTPS health check follows behavior specified in port and
      portName fields.
    ProxyHeaderValueValuesEnum: Specifies the type of proxy header to append
      before sending data to the backend, either NONE or PROXY_V1. The default
      is NONE.

  Fields:
    host: The value of the host header in the HTTPS health check request. If
      left empty (default value), the IP on behalf of which this health check
      is performed will be used.
    port: The TCP port number for the health check request. The default value
      is 443. Valid values are 1 through 65535.
    portName: Port name as defined in InstanceGroup#NamedPort#name. If both
      port and port_name are defined, port takes precedence.
    portSpecification: Specifies how port is selected for health checking, can
      be one of following values: USE_FIXED_PORT: The port number in port is
      used for health checking. USE_NAMED_PORT: The portName is used for
      health checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
      specified for each network endpoint is used for health checking. For
      other backends, the port or named port specified in the Backend Service
      is used for health checking.   If not specified, HTTPS health check
      follows behavior specified in port and portName fields.
    proxyHeader: Specifies the type of proxy header to append before sending
      data to the backend, either NONE or PROXY_V1. The default is NONE.
    requestPath: The request path of the HTTPS health check request. The
      default value is /.
    response: The string to match anywhere in the first 1024 bytes of the
      response body. If left empty (the default value), the status code
      determines health. The response data can only be ASCII.
  """

  class PortSpecificationValueValuesEnum(_messages.Enum):
    r"""Specifies how port is selected for health checking, can be one of
    following values: USE_FIXED_PORT: The port number in port is used for
    health checking. USE_NAMED_PORT: The portName is used for health checking.
    USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the port
    or named port specified in the Backend Service is used for health
    checking.   If not specified, HTTPS health check follows behavior
    specified in port and portName fields.

    Values:
      USE_FIXED_PORT: <no description>
      USE_NAMED_PORT: <no description>
      USE_SERVING_PORT: <no description>
    """
    USE_FIXED_PORT = 0
    USE_NAMED_PORT = 1
    USE_SERVING_PORT = 2

  class ProxyHeaderValueValuesEnum(_messages.Enum):
    r"""Specifies the type of proxy header to append before sending data to
    the backend, either NONE or PROXY_V1. The default is NONE.

    Values:
      NONE: <no description>
      PROXY_V1: <no description>
    """
    NONE = 0
    PROXY_V1 = 1

  host = _messages.StringField(1)
  port = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  portName = _messages.StringField(3)
  portSpecification = _messages.EnumField('PortSpecificationValueValuesEnum', 4)
  proxyHeader = _messages.EnumField('ProxyHeaderValueValuesEnum', 5)
  requestPath = _messages.StringField(6)
  response = _messages.StringField(7)


class HealthCheck(_messages.Message):
  r"""An HealthCheck resource. This resource defines a template for how
  individual virtual machines should be checked for health, via one of the
  supported protocols.

  Enums:
    TypeValueValuesEnum: Specifies the type of the healthCheck, either TCP,
      SSL, HTTP or HTTPS. If not specified, the default is TCP. Exactly one of
      the protocol-specific health check field must be specified, which must
      match type field.

  Fields:
    checkIntervalSec: How often (in seconds) to send a health check. The
      default value is 5 seconds.
    creationTimestamp: [Output Only] Creation timestamp in 3339 text format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    healthyThreshold: A so-far unhealthy instance will be marked healthy after
      this many consecutive successes. The default value is 2.
    http2HealthCheck: A HTTP2HealthCheck attribute.
    httpHealthCheck: A HTTPHealthCheck attribute.
    httpsHealthCheck: A HTTPSHealthCheck attribute.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: Type of the resource.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    selfLink: [Output Only] Server-defined URL for the resource.
    sslHealthCheck: A SSLHealthCheck attribute.
    tcpHealthCheck: A TCPHealthCheck attribute.
    timeoutSec: How long (in seconds) to wait before claiming failure. The
      default value is 5 seconds. It is invalid for timeoutSec to have greater
      value than checkIntervalSec.
    type: Specifies the type of the healthCheck, either TCP, SSL, HTTP or
      HTTPS. If not specified, the default is TCP. Exactly one of the
      protocol-specific health check field must be specified, which must match
      type field.
    unhealthyThreshold: A so-far healthy instance will be marked unhealthy
      after this many consecutive failures. The default value is 2.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Specifies the type of the healthCheck, either TCP, SSL, HTTP or HTTPS.
    If not specified, the default is TCP. Exactly one of the protocol-specific
    health check field must be specified, which must match type field.

    Values:
      HTTP: <no description>
      HTTP2: <no description>
      HTTPS: <no description>
      INVALID: <no description>
      SSL: <no description>
      TCP: <no description>
    """
    HTTP = 0
    HTTP2 = 1
    HTTPS = 2
    INVALID = 3
    SSL = 4
    TCP = 5

  checkIntervalSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  healthyThreshold = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  http2HealthCheck = _messages.MessageField('HTTP2HealthCheck', 5)
  httpHealthCheck = _messages.MessageField('HTTPHealthCheck', 6)
  httpsHealthCheck = _messages.MessageField('HTTPSHealthCheck', 7)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(9, default=u'compute#healthCheck')
  name = _messages.StringField(10)
  selfLink = _messages.StringField(11)
  sslHealthCheck = _messages.MessageField('SSLHealthCheck', 12)
  tcpHealthCheck = _messages.MessageField('TCPHealthCheck', 13)
  timeoutSec = _messages.IntegerField(14, variant=_messages.Variant.INT32)
  type = _messages.EnumField('TypeValueValuesEnum', 15)
  unhealthyThreshold = _messages.IntegerField(16, variant=_messages.Variant.INT32)


class HealthCheckList(_messages.Message):
  r"""Contains a list of HealthCheck resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of HealthCheck resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('HealthCheck', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#healthCheckList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class HealthCheckReference(_messages.Message):
  r"""A full or valid partial URL to a health check. For example, the
  following are valid URLs:   -
  https://www.googleapis.com/compute/beta/projects/project-
  id/global/httpHealthChecks/health-check  - projects/project-
  id/global/httpHealthChecks/health-check  - global/httpHealthChecks/health-
  check

  Fields:
    healthCheck: A string attribute.
  """

  healthCheck = _messages.StringField(1)


class HealthStatus(_messages.Message):
  r"""A HealthStatus object.

  Enums:
    HealthStateValueValuesEnum: Health state of the instance.

  Fields:
    healthState: Health state of the instance.
    instance: URL of the instance resource.
    ipAddress: The IP address represented by this resource.
    port: The port on the instance.
  """

  class HealthStateValueValuesEnum(_messages.Enum):
    r"""Health state of the instance.

    Values:
      HEALTHY: <no description>
      UNHEALTHY: <no description>
    """
    HEALTHY = 0
    UNHEALTHY = 1

  healthState = _messages.EnumField('HealthStateValueValuesEnum', 1)
  instance = _messages.StringField(2)
  ipAddress = _messages.StringField(3)
  port = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class HealthStatusForNetworkEndpoint(_messages.Message):
  r"""A HealthStatusForNetworkEndpoint object.

  Enums:
    HealthStateValueValuesEnum: Health state of the network endpoint
      determined based on the health checks configured.

  Fields:
    backendService: URL of the backend service associated with the health
      state of the network endpoint.
    forwardingRule: URL of the forwarding rule associated with the health
      state of the network endpoint.
    healthCheck: URL of the health check associated with the health state of
      the network endpoint.
    healthState: Health state of the network endpoint determined based on the
      health checks configured.
  """

  class HealthStateValueValuesEnum(_messages.Enum):
    r"""Health state of the network endpoint determined based on the health
    checks configured.

    Values:
      DRAINING: <no description>
      HEALTHY: <no description>
      UNHEALTHY: <no description>
      UNKNOWN: <no description>
    """
    DRAINING = 0
    HEALTHY = 1
    UNHEALTHY = 2
    UNKNOWN = 3

  backendService = _messages.MessageField('BackendServiceReference', 1)
  forwardingRule = _messages.MessageField('ForwardingRuleReference', 2)
  healthCheck = _messages.MessageField('HealthCheckReference', 3)
  healthState = _messages.EnumField('HealthStateValueValuesEnum', 4)


class HostRule(_messages.Message):
  r"""UrlMaps A host-matching rule for a URL. If matched, will use the named
  PathMatcher to select the BackendService.

  Fields:
    description: An optional description of this resource. Provide this
      property when you create the resource.
    hosts: The list of host patterns to match. They must be valid hostnames,
      except * will match any string of ([a-z0-9-.]*). In that case, * must be
      the first character and must be followed in the pattern by either - or
      ..
    pathMatcher: The name of the PathMatcher to use to match the path portion
      of the URL if the hostRule matches the URL's host portion.
  """

  description = _messages.StringField(1)
  hosts = _messages.StringField(2, repeated=True)
  pathMatcher = _messages.StringField(3)


class HttpHealthCheck(_messages.Message):
  r"""An HttpHealthCheck resource. This resource defines a template for how
  individual instances should be checked for health, via HTTP.

  Fields:
    checkIntervalSec: How often (in seconds) to send a health check. The
      default value is 5 seconds.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    healthyThreshold: A so-far unhealthy instance will be marked healthy after
      this many consecutive successes. The default value is 2.
    host: The value of the host header in the HTTP health check request. If
      left empty (default value), the public IP on behalf of which this health
      check is performed will be used.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#httpHealthCheck
      for HTTP health checks.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    port: The TCP port number for the HTTP health check request. The default
      value is 80.
    requestPath: The request path of the HTTP health check request. The
      default value is /.
    selfLink: [Output Only] Server-defined URL for the resource.
    timeoutSec: How long (in seconds) to wait before claiming failure. The
      default value is 5 seconds. It is invalid for timeoutSec to have greater
      value than checkIntervalSec.
    unhealthyThreshold: A so-far healthy instance will be marked unhealthy
      after this many consecutive failures. The default value is 2.
  """

  checkIntervalSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  healthyThreshold = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  host = _messages.StringField(5)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(7, default=u'compute#httpHealthCheck')
  name = _messages.StringField(8)
  port = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  requestPath = _messages.StringField(10)
  selfLink = _messages.StringField(11)
  timeoutSec = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  unhealthyThreshold = _messages.IntegerField(13, variant=_messages.Variant.INT32)


class HttpHealthCheckList(_messages.Message):
  r"""Contains a list of HttpHealthCheck resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of HttpHealthCheck resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('HttpHealthCheck', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#httpHealthCheckList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class HttpsHealthCheck(_messages.Message):
  r"""An HttpsHealthCheck resource. This resource defines a template for how
  individual instances should be checked for health, via HTTPS.

  Fields:
    checkIntervalSec: How often (in seconds) to send a health check. The
      default value is 5 seconds.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    healthyThreshold: A so-far unhealthy instance will be marked healthy after
      this many consecutive successes. The default value is 2.
    host: The value of the host header in the HTTPS health check request. If
      left empty (default value), the public IP on behalf of which this health
      check is performed will be used.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: Type of the resource.
    name: Name of the resource. Provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    port: The TCP port number for the HTTPS health check request. The default
      value is 443.
    requestPath: The request path of the HTTPS health check request. The
      default value is "/".
    selfLink: [Output Only] Server-defined URL for the resource.
    timeoutSec: How long (in seconds) to wait before claiming failure. The
      default value is 5 seconds. It is invalid for timeoutSec to have a
      greater value than checkIntervalSec.
    unhealthyThreshold: A so-far healthy instance will be marked unhealthy
      after this many consecutive failures. The default value is 2.
  """

  checkIntervalSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  healthyThreshold = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  host = _messages.StringField(5)
  id = _messages.IntegerField(6, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(7, default=u'compute#httpsHealthCheck')
  name = _messages.StringField(8)
  port = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  requestPath = _messages.StringField(10)
  selfLink = _messages.StringField(11)
  timeoutSec = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  unhealthyThreshold = _messages.IntegerField(13, variant=_messages.Variant.INT32)


class HttpsHealthCheckList(_messages.Message):
  r"""Contains a list of HttpsHealthCheck resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of HttpsHealthCheck resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('HttpsHealthCheck', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#httpsHealthCheckList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class Image(_messages.Message):
  r"""An Image resource. (== resource_for beta.images ==) (== resource_for
  v1.images ==)

  Enums:
    SourceTypeValueValuesEnum: The type of the image used to create this disk.
      The default and only value is RAW
    StatusValueValuesEnum: [Output Only] The status of the image. An image can
      be used to create other resources, such as instances, only after the
      image has been successfully created and the status is set to READY.
      Possible values are FAILED, PENDING, or READY.

  Messages:
    LabelsValue: Labels to apply to this image. These can be later modified by
      the setLabels method.
    RawDiskValue: The parameters of the raw disk image.

  Fields:
    archiveSizeBytes: Size of the image tar.gz archive stored in Google Cloud
      Storage (in bytes).
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    deprecated: The deprecation status associated with this image.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    diskSizeGb: Size of the image when restored onto a persistent disk (in
      GB).
    family: The name of the image family to which this image belongs. You can
      create disks by specifying an image family instead of a specific image
      name. The image family always returns its latest image that is not
      deprecated. The name of the image family must comply with RFC1035.
    guestOsFeatures: A list of features to enable on the guest operating
      system. Applicable only for bootable images. Read  Enabling guest
      operating system features to see a list of available options.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    imageEncryptionKey: Encrypts the image using a customer-supplied
      encryption key.  After you encrypt an image with a customer-supplied
      key, you must provide the same key if you use the image later (e.g. to
      create a disk from the image).  Customer-supplied encryption keys do not
      protect access to metadata of the disk.  If you do not provide an
      encryption key when creating the image, then the disk will be encrypted
      using an automatically generated key and you do not need to provide a
      key to use the image later.
    kind: [Output Only] Type of the resource. Always compute#image for images.
    labelFingerprint: A fingerprint for the labels being applied to this
      image, which is essentially a hash of the labels used for optimistic
      locking. The fingerprint is initially generated by Compute Engine and
      changes after every request to modify or update labels. You must always
      provide an up-to-date fingerprint hash in order to update or change
      labels.  To see the latest fingerprint, make a get() request to retrieve
      an image.
    labels: Labels to apply to this image. These can be later modified by the
      setLabels method.
    licenseCodes: Integer license codes indicating which licenses are attached
      to this image.
    licenses: Any applicable license URI.
    name: Name of the resource; provided by the client when the resource is
      created. The name must be 1-63 characters long, and comply with RFC1035.
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
      character must be a lowercase letter, and all following characters must
      be a dash, lowercase letter, or digit, except the last character, which
      cannot be a dash.
    rawDisk: The parameters of the raw disk image.
    selfLink: [Output Only] Server-defined URL for the resource.
    sourceDisk: URL of the source disk used to create this image. This can be
      a full or valid partial URL. You must provide either this property or
      the rawDisk.source property but not both to create an image. For
      example, the following are valid values:   - https://www.googleapis.com/
      compute/v1/projects/project/zones/zone/disks/disk  -
      projects/project/zones/zone/disks/disk  - zones/zone/disks/disk
    sourceDiskEncryptionKey: The customer-supplied encryption key of the
      source disk. Required if the source disk is protected by a customer-
      supplied encryption key.
    sourceDiskId: [Output Only] The ID value of the disk used to create this
      image. This value may be used to determine whether the image was taken
      from the current or a previous instance of a given disk name.
    sourceImage: URL of the source image used to create this image. This can
      be a full or valid partial URL. You must provide exactly one of:   -
      this property, or   - the rawDisk.source property, or   - the sourceDisk
      property   in order to create an image.
    sourceImageEncryptionKey: The customer-supplied encryption key of the
      source image. Required if the source image is protected by a customer-
      supplied encryption key.
    sourceImageId: [Output Only] The ID value of the image used to create this
      image. This value may be used to determine whether the image was taken
      from the current or a previous instance of a given image name.
    sourceSnapshot: URL of the source snapshot used to create this image. This
      can be a full or valid partial URL. You must provide exactly one of:   -
      this property, or   - the sourceImage property, or   - the
      rawDisk.source property, or   - the sourceDisk property   in order to
      create an image.
    sourceSnapshotEncryptionKey: The customer-supplied encryption key of the
      source snapshot. Required if the source snapshot is protected by a
      customer-supplied encryption key.
    sourceSnapshotId: [Output Only] The ID value of the snapshot used to
      create this image. This value may be used to determine whether the
      snapshot was taken from the current or a previous instance of a given
      snapshot name.
    sourceType: The type of the image used to create this disk. The default
      and only value is RAW
    status: [Output Only] The status of the image. An image can be used to
      create other resources, such as instances, only after the image has been
      successfully created and the status is set to READY. Possible values are
      FAILED, PENDING, or READY.
  """

  class SourceTypeValueValuesEnum(_messages.Enum):
    r"""The type of the image used to create this disk. The default and only
    value is RAW

    Values:
      RAW: <no description>
    """
    RAW = 0

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output Only] The status of the image. An image can be used to create
    other resources, such as instances, only after the image has been
    successfully created and the status is set to READY. Possible values are
    FAILED, PENDING, or READY.

    Values:
      FAILED: <no description>
      PENDING: <no description>
      READY: <no description>
    """
    FAILED = 0
    PENDING = 1
    READY = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels to apply to this image. These can be later modified by the
    setLabels method.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class RawDiskValue(_messages.Message):
    r"""The parameters of the raw disk image.

    Enums:
      ContainerTypeValueValuesEnum: The format used to encode and transmit the
        block device, which should be TAR. This is just a container and
        transmission format and not a runtime format. Provided by the client
        when the disk image is created.

    Fields:
      containerType: The format used to encode and transmit the block device,
        which should be TAR. This is just a container and transmission format
        and not a runtime format. Provided by the client when the disk image
        is created.
      sha1Checksum: An optional SHA1 checksum of the disk image before
        unpackaging; provided by the client when the disk image is created.
      source: The full Google Cloud Storage URL where the disk image is
        stored. You must provide either this property or the sourceDisk
        property but not both.
    """

    class ContainerTypeValueValuesEnum(_messages.Enum):
      r"""The format used to encode and transmit the block device, which
      should be TAR. This is just a container and transmission format and not
      a runtime format. Provided by the client when the disk image is created.

      Values:
        TAR: <no description>
      """
      TAR = 0

    containerType = _messages.EnumField('ContainerTypeValueValuesEnum', 1)
    sha1Checksum = _messages.StringField(2)
    source = _messages.StringField(3)

  archiveSizeBytes = _messages.IntegerField(1)
  creationTimestamp = _messages.StringField(2)
  deprecated = _messages.MessageField('DeprecationStatus', 3)
  description = _messages.StringField(4)
  diskSizeGb = _messages.IntegerField(5)
  family = _messages.StringField(6)
  guestOsFeatures = _messages.MessageField('GuestOsFeature', 7, repeated=True)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  imageEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 9)
  kind = _messages.StringField(10, default=u'compute#image')
  labelFingerprint = _messages.BytesField(11)
  labels = _messages.MessageField('LabelsValue', 12)
  licenseCodes = _messages.IntegerField(13, repeated=True)
  licenses = _messages.StringField(14, repeated=True)
  name = _messages.StringField(15)
  rawDisk = _messages.MessageField('RawDiskValue', 16)
  selfLink = _messages.StringField(17)
  sourceDisk = _messages.StringField(18)
  sourceDiskEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 19)
  sourceDiskId = _messages.StringField(20)
  sourceImage = _messages.StringField(21)
  sourceImageEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 22)
  sourceImageId = _messages.StringField(23)
  sourceSnapshot = _messages.StringField(24)
  sourceSnapshotEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 25)
  sourceSnapshotId = _messages.StringField(26)
  sourceType = _messages.EnumField('SourceTypeValueValuesEnum', 27, default=u'RAW')
  status = _messages.EnumField('StatusValueValuesEnum', 28)


class ImageList(_messages.Message):
  r"""Contains a list of images.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of Image resources.
    kind: Type of resource.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('Image', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#imageList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class Instance(_messages.Message):
  r"""An Instance resource. (== resource_for beta.instances ==) (==
  resource_for v1.instances ==)

  Enums:
    StatusValueValuesEnum: [Output Only] The status of the instance. One of
      the following values: PROVISIONING, STAGING, RUNNING, STOPPING, STOPPED,
      SUSPENDING, SUSPENDED, and TERMINATED.

  Messages:
    LabelsValue: Labels to apply to this instance. These can be later modified
      by the setLabels method.

  Fields:
    canIpForward: Allows this instance to send and receive packets with non-
      matching destination or source IPs. This is required if you plan to use
      this instance to forward routes. For more information, see Enabling IP
      Forwarding.
    cpuPlatform: [Output Only] The CPU platform used by this instance.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    deletionProtection: Whether the resource should be protected against
      deletion.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    disks: Array of disks associated with this instance. Persistent disks must
      be created before you can assign them.
    guestAccelerators: A list of the type and count of accelerator cards
      attached to the instance.
    id: [Output Only] The unique identifier for the resource. This identifier
      is defined by the server.
    kind: [Output Only] Type of the resource. Always compute#instance for
      instances.
    labelFingerprint: A fingerprint for this request, which is essentially a
      hash of the label's contents and used for optimistic locking. The
      fingerprint is initially generated by Compute Engine and changes after
      every request to modify or update labels. You must always provide an up-
      to-date fingerprint hash in order to update or change labels.  To see
      the latest fingerprint, make get() request to the instance.
    labels: Labels to apply to this instance. These can be later modified by
      the setLabels method.
    machineType: Full or partial URL of the machine type resource to use for
      this instance, in the format: zones/zone/machineTypes/machine-type. This
      is provided by the client when the instance is created. For example, the
      following is a valid partial url to a predefined machine type: zones/us-
      central1-f/machineTypes/n1-standard-1   To create a custom machine type,
      provide a URL to a machine type in the following format, where CPUS is 1
      or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the
      total memory for this instance. Memory must be a multiple of 256 MB and
      must be supplied in MB (e.g. 5 GB of memory is 5120 MB):
      zones/zone/machineTypes/custom-CPUS-MEMORY   For example: zones/us-
      central1-f/machineTypes/custom-4-5120   For a full list of restrictions,
      read the Specifications for custom machine types.
    metadata: The metadata key/value pairs assigned to this instance. This
      includes custom metadata and predefined keys.
    minCpuPlatform: Specifies a minimum CPU platform for the VM instance.
      Applicable values are the friendly names of CPU platforms, such as
      minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
    name: The name of the resource, provided by the client when initially
      creating the resource. The resource name must be 1-63 characters long,
      and comply with RFC1035. Specifically, the name must be 1-63 characters
      long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which
      means the first character must be a lowercase letter, and all following
      characters must be a dash, lowercase letter, or digit, except the last
      character, which cannot be a dash.
    networkInterfaces: An array of network configurations for this instance.
      These specify how interfaces are configured to interact with other
      network services, such as connecting to the internet. Multiple
      interfaces are supported per instance.
    scheduling: Sets the scheduling options for this instance.
    selfLink: [Output Only] Server-defined URL for this resource.
    serviceAccounts: A list of service accounts, with their specified scopes,
      authorized for this instance. Only one service account per VM instance
      is supported.  Service accounts generate access tokens that can be
      accessed through the metadata server and used to authenticate
      applications on the instance. See Service Accounts for more information.
    shieldedVmConfig: A ShieldedVmConfig attribute.
    shieldedVmIntegrityPolicy: A ShieldedVmIntegrityPolicy attribute.
    startRestricted: [Output Only] Whether a VM has been restricted for start
      because Compute Engine has detected suspicious activity.
    status: [Output Only] The status of the instance. One of the following
      values: PROVISIONING, STAGING, RUNNING, STOPPING, STOPPED, SUSPENDING,
      SUSPENDED, and TERMINATED.
    statusMessage: [Output Only] An optional, human-readable explanation of
      the status.
    tags: Tags to apply to this instance. Tags are used to identify valid
      sources or targets for network firewalls and are specified by the client
      during instance creation. The tags can be later modified by the setTags
      method. Each tag within the list must comply with RFC1035. Multiple tags
      can be specified via the 'tags.items' field.
    zone: [Output Only] URL of the zone where the instance resides. You must
      specify this field as part of the HTTP request URL. It is not settable
      as a field in the request body.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output Only] The status of the instance. One of the following values:
    PROVISIONING, STAGING, RUNNING, STOPPING, STOPPED, SUSPENDING, SUSPENDED,
    and TERMINATED.

    Values:
      PROVISIONING: <no description>
      RUNNING: <no description>
      STAGING: <no description>
      STOPPED: <no description>
      STOPPING: <no description>
      SUSPENDED: <no description>
      SUSPENDING: <no description>
      TERMINATED: <no description>
    """
    PROVISIONING = 0
    RUNNING = 1
    STAGING = 2
    STOPPED = 3
    STOPPING = 4
    SUSPENDED = 5
    SUSPENDING = 6
    TERMINATED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels to apply to this instance. These can be later modified by the
    setLabels method.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canIpForward = _messages.BooleanField(1)
  cpuPlatform = _messages.StringField(2)
  creationTimestamp = _messages.StringField(3)
  deletionProtection = _messages.BooleanField(4)
  description = _messages.StringField(5)
  disks = _messages.MessageField('AttachedDisk', 6, repeated=True)
  guestAccelerators = _messages.MessageField('AcceleratorConfig', 7, repeated=True)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(9, default=u'compute#instance')
  labelFingerprint = _messages.BytesField(10)
  labels = _messages.MessageField('LabelsValue', 11)
  machineType = _messages.StringField(12)
  metadata = _messages.MessageField('Metadata', 13)
  minCpuPlatform = _messages.StringField(14)
  name = _messages.StringField(15)
  networkInterfaces = _messages.MessageField('NetworkInterface', 16, repeated=True)
  scheduling = _messages.MessageField('Scheduling', 17)
  selfLink = _messages.StringField(18)
  serviceAccounts = _messages.MessageField('ServiceAccount', 19, repeated=True)
  shieldedVmConfig = _messages.MessageField('ShieldedVmConfig', 20)
  shieldedVmIntegrityPolicy = _messages.MessageField('ShieldedVmIntegrityPolicy', 21)
  startRestricted = _messages.BooleanField(22)
  status = _messages.EnumField('StatusValueValuesEnum', 23)
  statusMessage = _messages.StringField(24)
  tags = _messages.MessageField('Tags', 25)
  zone = _messages.StringField(26)


class InstanceAggregatedList(_messages.Message):
  r"""A InstanceAggregatedList object.

  Messages:
    ItemsValue: A list of InstancesScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of InstancesScopedList resources.
    kind: [Output Only] Type of resource. Always
      compute#instanceAggregatedList for aggregated lists of Instance
      resources.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of InstancesScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] Name of the scope containing this
        set of instances.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A InstancesScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('InstancesScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#instanceAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class InstanceGroup(_messages.Message):
  r"""InstanceGroups (== resource_for beta.instanceGroups ==) (== resource_for
  v1.instanceGroups ==) (== resource_for beta.regionInstanceGroups ==) (==
  resource_for v1.regionInstanceGroups ==)

  Fields:
    creationTimestamp: [Output Only] The creation timestamp for this instance
      group in RFC3339 text format.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    fingerprint: [Output Only] The fingerprint of the named ports. The system
      uses this fingerprint to detect conflicts when multiple users change the
      named ports concurrently.
    id: [Output Only] A unique identifier for this instance group, generated
      by the server.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroup for instance groups.
    name: The name of the instance group. The name must be 1-63 characters
      long, and comply with RFC1035.
    namedPorts: Assigns a name to a port number. For example: {name: "http",
      port: 80}  This allows the system to reference ports by the assigned
      name instead of a port number. Named ports can also contain multiple
      ports. For example: [{name: "http", port: 80},{name: "http", port:
      8080}]   Named ports apply to all instances in this instance group.
    network: The URL of the network to which all instances in the instance
      group belong.
    region: [Output Only] The URL of the region where the instance group is
      located (for regional resources).
    selfLink: [Output Only] The URL for this instance group. The server
      generates this URL.
    size: [Output Only] The total number of instances in the instance group.
    subnetwork: [Output Only] The URL of the subnetwork to which all instances
      in the instance group belong.
    zone: [Output Only] The URL of the zone where the instance group is
      located (for zonal resources).
  """

  creationTimestamp = _messages.StringField(1)
  description = _messages.StringField(2)
  fingerprint = _messages.BytesField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#instanceGroup')
  name = _messages.StringField(6)
  namedPorts = _messages.MessageField('NamedPort', 7, repeated=True)
  network = _messages.StringField(8)
  region = _messages.StringField(9)
  selfLink = _messages.StringField(10)
  size = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  subnetwork = _messages.StringField(12)
  zone = _messages.StringField(13)


class InstanceGroupAggregatedList(_messages.Message):
  r"""A InstanceGroupAggregatedList object.

  Messages:
    ItemsValue: A list of InstanceGroupsScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of InstanceGroupsScopedList resources.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupAggregatedList for aggregated lists of instance
      groups.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of InstanceGroupsScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: The name of the scope that contains this set of
        instance groups.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A InstanceGroupsScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('InstanceGroupsScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#instanceGroupAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class InstanceGroupList(_messages.Message):
  r"""A list of InstanceGroup resources.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of InstanceGroup resources.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupList for instance group lists.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('InstanceGroup', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#instanceGroupList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class InstanceGroupManager(_messages.Message):
  r"""An Instance Group Manager resource. (== resource_for
  beta.instanceGroupManagers ==) (== resource_for v1.instanceGroupManagers ==)
  (== resource_for beta.regionInstanceGroupManagers ==) (== resource_for
  v1.regionInstanceGroupManagers ==)

  Enums:
    FailoverActionValueValuesEnum: The action to perform in case of zone
      failure. Only one value is supported, NO_FAILOVER. The default is
      NO_FAILOVER.

  Fields:
    autoHealingPolicies: The autohealing policy for this managed instance
      group. You can specify only one value.
    baseInstanceName: The base instance name to use for instances in this
      group. The value must be 1-58 characters long. Instances are named by
      appending a hyphen and a random four-character string to the base
      instance name. The base instance name must comply with RFC1035.
    creationTimestamp: [Output Only] The creation timestamp for this managed
      instance group in RFC3339 text format.
    currentActions: [Output Only] The list of instance actions and the number
      of instances in this managed instance group that are scheduled for each
      of those actions.
    description: An optional description of this resource. Provide this
      property when you create the resource.
    distributionPolicy: Policy specifying intended distribution of instances
      in regional managed instance group.
    failoverAction: The action to perform in case of zone failure. Only one
      value is supported, NO_FAILOVER. The default is NO_FAILOVER.
    fingerprint: Fingerprint of this resource. This field may be used in
      optimistic locking. It will be ignored when inserting an
      InstanceGroupManager. An up-to-date fingerprint must be provided in
      order to update the InstanceGroupManager.  To see the latest
      fingerprint, make a get() request to retrieve an InstanceGroupManager.
    id: [Output Only] A unique identifier for this resource type. The server
      generates this identifier.
    instanceGroup: [Output Only] The URL of the Instance Group resource.
    instanceTemplate: The URL of the instance template that is specified for
      this managed instance group. The group uses this template to create all
      new instances in the managed instance group.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupManager for managed instance groups.
    name: The name of the managed instance group. The name must be 1-63
      characters long, and comply with RFC1035.
    namedPorts: Named ports configured for the Instance Groups complementary
      to this Instance Group Manager.
    pendingActions: [Output Only] The list of instance actions and the number
      of instances in this managed instance group that are pending for each of
      those actions.
    region: [Output Only] The URL of the region where the managed instance
      group resides (for regional resources).
    selfLink: [Output Only] The URL for this managed instance group. The
      server defines this URL.
    serviceAccount: The service account to be used as credentials for all
      operations performed by the managed instance group on instances. The
      service accounts needs all permissions required to create and delete
      instances. By default, the service account
      {projectNumber}@cloudservices.gserviceaccount.com is used.
    status: [Output Only] The status of this managed instance group.
    targetPools: The URLs for all TargetPool resources to which instances in
      the instanceGroup field are added. The target pools automatically apply
      to all of the instances in the managed instance group.
    targetSize: The target number of running instances for this managed
      instance group. Deleting or abandoning instances reduces this number.
      Resizing the group changes this number.
    updatePolicy: The update policy for this managed instance group.
    versions: Specifies the instance templates used by this managed instance
      group to create instances.  Each version is defined by an
      instanceTemplate. Every template can appear at most once per instance
      group. This field overrides the top-level instanceTemplate field. Read
      more about the relationships between these fields. Exactly one version
      must leave the targetSize field unset. That version will be applied to
      all remaining instances. For more information, read about canary
      updates.
    zone: [Output Only] The URL of the zone where the managed instance group
      is located (for zonal resources).
  """

  class FailoverActionValueValuesEnum(_messages.Enum):
    r"""The action to perform in case of zone failure. Only one value is
    supported, NO_FAILOVER. The default is NO_FAILOVER.

    Values:
      NO_FAILOVER: <no description>
      UNKNOWN: <no description>
    """
    NO_FAILOVER = 0
    UNKNOWN = 1

  autoHealingPolicies = _messages.MessageField('InstanceGroupManagerAutoHealingPolicy', 1, repeated=True)
  baseInstanceName = _messages.StringField(2)
  creationTimestamp = _messages.StringField(3)
  currentActions = _messages.MessageField('InstanceGroupManagerActionsSummary', 4)
  description = _messages.StringField(5)
  distributionPolicy = _messages.MessageField('DistributionPolicy', 6)
  failoverAction = _messages.EnumField('FailoverActionValueValuesEnum', 7)
  fingerprint = _messages.BytesField(8)
  id = _messages.IntegerField(9, variant=_messages.Variant.UINT64)
  instanceGroup = _messages.StringField(10)
  instanceTemplate = _messages.StringField(11)
  kind = _messages.StringField(12, default=u'compute#instanceGroupManager')
  name = _messages.StringField(13)
  namedPorts = _messages.MessageField('NamedPort', 14, repeated=True)
  pendingActions = _messages.MessageField('InstanceGroupManagerPendingActionsSummary', 15)
  region = _messages.StringField(16)
  selfLink = _messages.StringField(17)
  serviceAccount = _messages.StringField(18)
  status = _messages.MessageField('InstanceGroupManagerStatus', 19)
  targetPools = _messages.StringField(20, repeated=True)
  targetSize = _messages.IntegerField(21, variant=_messages.Variant.INT32)
  updatePolicy = _messages.MessageField('InstanceGroupManagerUpdatePolicy', 22)
  versions = _messages.MessageField('InstanceGroupManagerVersion', 23, repeated=True)
  zone = _messages.StringField(24)


class InstanceGroupManagerActionsSummary(_messages.Message):
  r"""A InstanceGroupManagerActionsSummary object.

  Fields:
    abandoning: [Output Only] The total number of instances in the managed
      instance group that are scheduled to be abandoned. Abandoning an
      instance removes it from the managed instance group without deleting it.
    creating: [Output Only] The number of instances in the managed instance
      group that are scheduled to be created or are currently being created.
      If the group fails to create any of these instances, it tries again
      until it creates the instance successfully.  If you have disabled
      creation retries, this field will not be populated; instead, the
      creatingWithoutRetries field will be populated.
    creatingWithoutRetries: [Output Only] The number of instances that the
      managed instance group will attempt to create. The group attempts to
      create each instance only once. If the group fails to create any of
      these instances, it decreases the group's targetSize value accordingly.
    deleting: [Output Only] The number of instances in the managed instance
      group that are scheduled to be deleted or are currently being deleted.
    none: [Output Only] The number of instances in the managed instance group
      that are running and have no scheduled actions.
    recreating: [Output Only] The number of instances in the managed instance
      group that are scheduled to be recreated or are currently being being
      recreated. Recreating an instance deletes the existing root persistent
      disk and creates a new disk from the image that is defined in the
      instance template.
    refreshing: [Output Only] The number of instances in the managed instance
      group that are being reconfigured with properties that do not require a
      restart or a recreate action. For example, setting or removing target
      pools for the instance.
    restarting: [Output Only] The number of instances in the managed instance
      group that are scheduled to be restarted or are currently being
      restarted.
    verifying: [Output Only] The number of instances in the managed instance
      group that are being verified. See the managedInstances[].currentAction
      property in the listManagedInstances method documentation.
  """

  abandoning = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  creating = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  creatingWithoutRetries = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  deleting = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  none = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  recreating = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  refreshing = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  restarting = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  verifying = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class InstanceGroupManagerAggregatedList(_messages.Message):
  r"""A InstanceGroupManagerAggregatedList object.

  Messages:
    ItemsValue: A list of InstanceGroupManagersScopedList resources.
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of InstanceGroupManagersScopedList resources.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupManagerAggregatedList for an aggregated list of
      managed instance groups.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ItemsValue(_messages.Message):
    r"""A list of InstanceGroupManagersScopedList resources.

    Messages:
      AdditionalProperty: An additional property for a ItemsValue object.

    Fields:
      additionalProperties: [Output Only] The name of the scope that contains
        this set of managed instance groups.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ItemsValue object.

      Fields:
        key: Name of the additional property.
        value: A InstanceGroupManagersScopedList attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('InstanceGroupManagersScopedList', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('ItemsValue', 2)
  kind = _messages.StringField(3, default=u'compute#instanceGroupManagerAggregatedList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class InstanceGroupManagerAutoHealingPolicy(_messages.Message):
  r"""InstanceGroupManagerAutoHealingPolicy message type.

  Fields:
    healthCheck: The URL for the health check that signals autohealing.
    initialDelaySec: The number of seconds that the managed instance group
      waits before it applies autohealing policies to new instances or
      recently recreated instances. This initial delay allows instances to
      initialize and run their startup scripts before the instance group
      determines that they are UNHEALTHY. This prevents the managed instance
      group from recreating its instances prematurely. This value must be from
      range [0, 3600].
  """

  healthCheck = _messages.StringField(1)
  initialDelaySec = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class InstanceGroupManagerList(_messages.Message):
  r"""[Output Only] A list of managed instance groups.

  Messages:
    WarningValue: [Output Only] Informational warning message.

  Fields:
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    items: A list of InstanceGroupManager resources.
    kind: [Output Only] The resource type, which is always
      compute#instanceGroupManagerList for a list of managed instance groups.
    nextPageToken: [Output Only] This token allows you to get the next page of
      results for list requests. If the number of results is larger than
      maxResults, use the nextPageToken as a value for the query parameter
      pageToken in the next list request. Subsequent list requests will have
      their own nextPageToken to continue paging through the results.
    selfLink: [Output Only] Server-defined URL for this resource.
    warning: [Output Only] Informational warning message.
  """

  class WarningValue(_messages.Message):
    r"""[Output Only] Informational warning message.

    Enums:
      CodeValueValuesEnum: [Output Only] A warning code, if applicable. For
        example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no
        results in the response.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: [Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
      data: [Output Only] Metadata about this warning in key: value format.
        For example: "data": [ { "key": "scope", "value": "zones/us-east1-d" }
      message: [Output Only] A human-readable description of the warning code.
    """

    class CodeValueValuesEnum(_messages.Enum):
      r"""[Output Only] A warning code, if applicable. For example, Compute
      Engine returns NO_RESULTS_ON_PAGE if there are no results in the
      response.

      Values:
        CLEANUP_FAILED: <no description>
        DEPRECATED_RESOURCE_USED: <no description>
        DEPRECATED_TYPE_USED: <no description>
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE: <no description>
        EXPERIMENTAL_TYPE_USED: <no description>
        EXTERNAL_API_WARNING: <no description>
        FIELD_VALUE_OVERRIDEN: <no description>
        INJECTED_KERNELS_DEPRECATED: <no description>
        MISSING_TYPE_DEPENDENCY: <no description>
        NEXT_HOP_ADDRESS_NOT_ASSIGNED: <no description>
        NEXT_HOP_CANNOT_IP_FORWARD: <no description>
        NEXT_HOP_INSTANCE_NOT_FOUND: <no description>
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK: <no description>
        NEXT_HOP_NOT_RUNNING: <no description>
        NOT_CRITICAL_ERROR: <no description>
        NO_RESULTS_ON_PAGE: <no description>
        REQUIRED_TOS_AGREEMENT: <no description>
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING: <no description>
        RESOURCE_NOT_DELETED: <no description>
        SCHEMA_VALIDATION_IGNORED: <no description>
        SINGLE_INSTANCE_PROPERTY_TEMPLATE: <no description>
        UNDECLARED_PROPERTIES: <no description>
        UNREACHABLE: <no description>
      """
      CLEANUP_FAILED = 0
      DEPRECATED_RESOURCE_USED = 1
      DEPRECATED_TYPE_USED = 2
      DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 3
      EXPERIMENTAL_TYPE_USED = 4
      EXTERNAL_API_WARNING = 5
      FIELD_VALUE_OVERRIDEN = 6
      INJECTED_KERNELS_DEPRECATED = 7
      MISSING_TYPE_DEPENDENCY = 8
      NEXT_HOP_ADDRESS_NOT_ASSIGNED = 9
      NEXT_HOP_CANNOT_IP_FORWARD = 10
      NEXT_HOP_INSTANCE_NOT_FOUND = 11
      NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 12
      NEXT_HOP_NOT_RUNNING = 13
      NOT_CRITICAL_ERROR = 14
      NO_RESULTS_ON_PAGE = 15
      REQUIRED_TOS_AGREEMENT = 16
      RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 17
      RESOURCE_NOT_DELETED = 18
      SCHEMA_VALIDATION_IGNORED = 19
      SINGLE_INSTANCE_PROPERTY_TEMPLATE = 20
      UNDECLARED_PROPERTIES = 21
      UNREACHABLE = 22

    class DataValueListEntry(_messages.Message):
      r"""A DataValueListEntry object.

      Fields:
        key: [Output Only] A key that provides more detail on the warning
          being returned. For example, for warnings where there are no results
          in a list request for a particular zone, this key might be scope and
          the key value might be the zone name. Other examples might be a key
          indicating a deprecated resource and a suggested replacement, or a
          warning about invalid network settings (for example, if an instance
          attempts to perform IP forwarding but is not enabled for IP
          forwarding).
        value: [Output Only] A warning data value corresponding to the key.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.EnumField('CodeValueValuesEnum', 1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  id = _messages.StringField(1)
  items = _messages.MessageField('InstanceGroupManager', 2, repeated=True)
  kind = _messages.StringField(3, default=u'compute#instanceGroupManagerList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)
  warning = _messages.MessageField('WarningValue', 6)


class InstanceGroupManagerPendingActionsSummary(_messages.Message):
  r"""A InstanceGroupManagerPendingActionsSummary object.

  Fields:
    creating: [Output Only] The number of instances in the managed instance
      gr