"""Generated message classes for kubernetespolicy version v1alpha1.

The Kubernetes Policy API provides hooks to synchronize policies between GCP
and Kubernetes clusters enabling policy management for clusters through GCP.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'kubernetespolicy'


class AggregationRule(_messages.Message):
  r"""AggregationRule describes how to locate ClusterRoles to aggregate into
  the ClusterRole

  Fields:
    clusterRoleSelectors: ClusterRoleSelectors holds a list of selectors which
      will be used to find ClusterRoles and create the rules. If any of the
      selectors match, then the ClusterRole's permissions will be added
      +optional
  """

  clusterRoleSelectors = _messages.MessageField('LabelSelector', 1, repeated=True)


class AllowedFlexVolume(_messages.Message):
  r"""AllowedFlexVolume represents a single Flexvolume that is allowed to be
  used.

  Fields:
    driver: Driver is the name of the Flexvolume driver.
  """

  driver = _messages.StringField(1)


class AllowedHostPath(_messages.Message):
  r"""defines the host volume conditions that will be enabled by a policy for
  pods to use. It requires the path prefix to be defined.

  Fields:
    pathPrefix: is the path prefix that the host volume must match. It does
      not support `*`. Trailing slashes are trimmed when validating the path
      prefix with a host path.  Examples: `/foo` would allow `/foo`, `/foo/`
      and `/foo/bar` `/foo` would not allow `/food` or `/etc/foo`
  """

  pathPrefix = _messages.StringField(1)


class ClusterPolicy(_messages.Message):
  r"""ClusterPolicy is the top-level object for the policy node data
  definition.  It holds a policy defined for a single org unit (namespace).
  +protobuf=true

  Fields:
    metadata: Standard object's metadata. +optional
    spec: The actual object definition, per K8S object definition style.
      +optional
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  spec = _messages.MessageField('ClusterPolicySpec', 2)


class ClusterPolicyList(_messages.Message):
  r"""ClusterPolicyList holds a list of cluster level policies, returned as
  response to a List call on the cluster policy hierarchy. +protobuf=true

  Fields:
    items: Items is a list of policy nodes that apply.
    metadata: Standard object's metadata. +optional
  """

  items = _messages.MessageField('ClusterPolicy', 1, repeated=True)
  metadata = _messages.MessageField('ListMeta', 2)


class ClusterPolicySpec(_messages.Message):
  r"""ClusterPolicySpec defines the policies that will exist at the cluster
  level. +protobuf=true

  Fields:
    clusterRoleBindingsV1: +optional
    clusterRolesV1: +optional
    podSecurityPolicyV1Beta1: +optional
  """

  clusterRoleBindingsV1 = _messages.MessageField('ClusterRoleBinding', 1, repeated=True)
  clusterRolesV1 = _messages.MessageField('ClusterRole', 2, repeated=True)
  podSecurityPolicyV1Beta1 = _messages.MessageField('PodSecurityPolicy', 3, repeated=True)


class ClusterRole(_messages.Message):
  r"""ClusterRole is a cluster level, logical grouping of PolicyRules that can
  be referenced as a unit by a RoleBinding or ClusterRoleBinding.

  Fields:
    aggregationRule: AggregationRule is an optional field that describes how
      to build the Rules for this ClusterRole. If AggregationRule is set, then
      the Rules are controller managed and direct changes to Rules will be
      stomped by the controller. +optional
    metadata: Standard object's metadata. +optional
    rules: Rules holds all the PolicyRules for this ClusterRole
  """

  aggregationRule = _messages.MessageField('AggregationRule', 1)
  metadata = _messages.MessageField('ObjectMeta', 2)
  rules = _messages.MessageField('PolicyRule', 3, repeated=True)


class ClusterRoleBinding(_messages.Message):
  r"""ClusterRoleBinding references a ClusterRole, but not contain it.  It can
  reference a ClusterRole in the global namespace, and adds who information
  via Subject.

  Fields:
    metadata: Standard object's metadata. +optional
    roleRef: RoleRef can only reference a ClusterRole in the global namespace.
      If the RoleRef cannot be resolved, the Authorizer must return an error.
    subjects: Subjects holds references to the objects the role applies to.
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  roleRef = _messages.MessageField('RoleRef', 2)
  subjects = _messages.MessageField('Subject', 3, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class FSGroupStrategyOptions(_messages.Message):
  r"""FSGroupStrategyOptions defines the strategy type and options used to
  create the strategy.

  Fields:
    ranges: Ranges are the allowed ranges of fs groups.  If you would like to
      force a single fs group then supply a single range with the same start
      and end. +optional
    rule: Rule is the strategy that will dictate what FSGroup is used in the
      SecurityContext. +optional
  """

  ranges = _messages.MessageField('IDRange', 1, repeated=True)
  rule = _messages.StringField(2)


class HostPortRange(_messages.Message):
  r"""Host Port Range defines a range of host ports that will be enabled by a
  policy for pods to use.  It requires both the start and end to be defined.

  Fields:
    max: max is the end of the range, inclusive.
    min: min is the start of the range, inclusive.
  """

  max = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  min = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class IDRange(_messages.Message):
  r"""ID Range provides a min/max of an allowed range of IDs.

  Fields:
    max: Max is the end of the range, inclusive.
    min: Min is the start of the range, inclusive.
  """

  max = _messages.IntegerField(1)
  min = _messages.IntegerField(2)


class Initializer(_messages.Message):
  r"""Initializer is information about an initializer that has not yet
  completed.

  Fields:
    name: name of the process that is responsible for initializing this
      object.
  """

  name = _messages.StringField(1)


class Initializers(_messages.Message):
  r"""Initializers tracks the progress of initialization.

  Fields:
    pending: Pending is a list of initializers that must execute in order
      before this object is visible. When the last pending initializer is
      removed, and no failing result is set, the initializers struct will be
      set to nil and the object is considered as initialized and visible to
      all clients. +patchMergeKey=name +patchStrategy=merge
    result: If result is set with the Failure field, the object will be
      persisted to storage and then deleted, ensuring that other clients can
      observe the deletion.
  """

  pending = _messages.MessageField('Initializer', 1, repeated=True)
  result = _messages.MessageField('Status', 2)


class KubernetespolicyProjectsNamespacesDeleteRequest(_messages.Message):
  r"""A KubernetespolicyProjectsNamespacesDeleteRequest object.

  Fields:
    name: The globally unique one platform name for the namespace such as
      projects/{project}/namespaces/{namespace}
    validateOnly: If true the request will be validated but not executed.
  """

  name = _messages.StringField(1, required=True)
  validateOnly = _messages.BooleanField(2)


class KubernetespolicyProjectsNamespacesGetRequest(_messages.Message):
  r"""A KubernetespolicyProjectsNamespacesGetRequest object.

  Fields:
    name: The globally unique one platform name for the namespace such as
      projects/{project}/namespaces/{namespace}
  """

  name = _messages.StringField(1, required=True)


class KubernetespolicyProjectsNamespacesListRequest(_messages.Message):
  r"""A KubernetespolicyProjectsNamespacesListRequest object.

  Fields:
    pageSize: Specifies the number of results to return per page. Only one
      namespace per project is available so this is parameter can be ignored.
    pageToken: Token returned from the previous response in next_page_token.
    parent: The parent under which to list the namespaces, currently only
      project id is supported
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LabelSelector(_messages.Message):
  r"""A label selector is a label query over a set of resources. The result of
  matchLabels and matchExpressions are ANDed. An empty label selector matches
  all objects. A null label selector matches no objects.

  Messages:
    MatchLabelsValue: matchLabels is a map of {key,value} pairs. A single
      {key,value} in the matchLabels map is equivalent to an element of
      matchExpressions, whose key field is "key", the operator is "In", and
      the values array contains only "value". The requirements are ANDed.
      +optional

  Fields:
    matchExpressions: matchExpressions is a list of label selector
      requirements. The requirements are ANDed. +optional
    matchLabels: matchLabels is a map of {key,value} pairs. A single
      {key,value} in the matchLabels map is equivalent to an element of
      matchExpressions, whose key field is "key", the operator is "In", and
      the values array contains only "value". The requirements are ANDed.
      +optional
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MatchLabelsValue(_messages.Message):
    r"""matchLabels is a map of {key,value} pairs. A single {key,value} in the
    matchLabels map is equivalent to an element of matchExpressions, whose key
    field is "key", the operator is "In", and the values array contains only
    "value". The requirements are ANDed. +optional

    Messages:
      AdditionalProperty: An additional property for a MatchLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type MatchLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MatchLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  matchExpressions = _messages.MessageField('LabelSelectorRequirement', 1, repeated=True)
  matchLabels = _messages.MessageField('MatchLabelsValue', 2)


class LabelSelectorRequirement(_messages.Message):
  r"""A label selector requirement is a selector that contains values, a key,
  and an operator that relates the key and values.

  Fields:
    key: key is the label key that the selector applies to. +patchMergeKey=key
      +patchStrategy=merge
    operator: operator represents a key's relationship to a set of values.
      Valid operators are In, NotIn, Exists and DoesNotExist.
    values: values is an array of string values. If the operator is In or
      NotIn, the values array must be non-empty. If the operator is Exists or
      DoesNotExist, the values array must be empty. This array is replaced
      during a strategic merge patch. +optional
  """

  key = _messages.StringField(1)
  operator = _messages.StringField(2)
  values = _messages.StringField(3, repeated=True)


class ListMeta(_messages.Message):
  r"""ListMeta describes metadata that synthetic resources must have,
  including lists and various status objects. A resource may have only one of
  {ObjectMeta, ListMeta}.

  Fields:
    continue_: continue may be set if the user set a limit on the number of
      items returned, and indicates that the server has more data available.
      The value is opaque and may be used to issue another request to the
      endpoint that served this list to retrieve the next set of available
      objects. Continuing a list may not be possible if the server
      configuration has changed or more than a few minutes have passed. The
      resourceVersion field returned when using this continue value will be
      identical to the value in the first response.
    resourceVersion: String that identifies the server's internal version of
      this object that can be used by clients to determine when objects have
      changed. Value must be treated as opaque by clients and passed
      unmodified back to the server. Populated by the system. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-conventions.md
      #concurrency-control-and-consistency +optional
    selfLink: selfLink is a URL representing this object. Populated by the
      system. Read-only. +optional
  """

  continue_ = _messages.StringField(1)
  resourceVersion = _messages.StringField(2)
  selfLink = _messages.StringField(3)


class ListNamespacesResponse(_messages.Message):
  r"""Response for the ListNamespace method.

  Fields:
    nextPageToken: Next page token for pagination, currently only one
      namespace can be in a project so this will be unused.
    resources: The list of namespaces in the response
  """

  nextPageToken = _messages.StringField(1)
  resources = _messages.MessageField('Namespace', 2, repeated=True)


class Namespace(_messages.Message):
  r"""The Namespace represents a Kubernetes Managed Namespace definition in
  GCP that will be manifested as a Kubernetes namespace in multiple Kubernetes
  clusters enrolled in the environment.

  Fields:
    kubernetesName: A human friendly name, unique per environment, and
      consistent with the restrictions for Kubernetes Names in
      https://kubernetes.io/docs/concepts/overview/working-with-objects/names/
      (e.g. "my-workloads") limited to 64 characters. This will be the name of
      the namespace created in each of the clusters.
    name: A generated globally unique name for the namespace such as
      projects/{project}/namespaces/{namespace} (the number will be the same
      as project number, but clients should not rely on that fact)
    organization: Output only. The organization of the Namespace, in the
      format of organizations/{organization_id}
    parent: The parent node of the namespace in the Cloud Resource Manager
      hierarchy, which must be a project (e.g. projects/{project})
  """

  kubernetesName = _messages.StringField(1)
  name = _messages.StringField(2)
  organization = _messages.StringField(3)
  parent = _messages.StringField(4)


class ObjectMeta(_messages.Message):
  r"""ObjectMeta is metadata that all persisted resources must have, which
  includes all objects users must create.

  Messages:
    AnnotationsValue: Annotations is an unstructured key value map stored with
      a resource that may be set by external tools to store and retrieve
      arbitrary metadata. They are not queryable and should be preserved when
      modifying objects. More info: http://kubernetes.io/docs/user-
      guide/annotations +optional
    LabelsValue: Map of string keys and values that can be used to organize
      and categorize (scope and select) objects. May match selectors of
      replication controllers and services. More info:
      http://kubernetes.io/docs/user-guide/labels +optional

  Fields:
    annotations: Annotations is an unstructured key value map stored with a
      resource that may be set by external tools to store and retrieve
      arbitrary metadata. They are not queryable and should be preserved when
      modifying objects. More info: http://kubernetes.io/docs/user-
      guide/annotations +optional
    clusterName: The name of the cluster which the object belongs to. This is
      used to distinguish resources with same name and namespace in different
      clusters. This field is not set anywhere right now and apiserver is
      going to ignore it if set in create or update request. +optional
    creationTimestamp: CreationTimestamp is a timestamp representing the
      server time when this object was created. It is not guaranteed to be set
      in happens-before order across separate operations. Clients may not set
      this value. It is represented in RFC3339 form and is in UTC.  Populated
      by the system. Read-only. Null for lists. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    deletionGracePeriodSeconds: Number of seconds allowed for this object to
      gracefully terminate before it will be removed from the system. Only set
      when deletionTimestamp is also set. May only be shortened. Read-only.
      +optional
    deletionTimestamp: DeletionTimestamp is RFC 3339 date and time at which
      this resource will be deleted. This field is set by the server when a
      graceful deletion is requested by the user, and is not directly settable
      by a client. The resource is expected to be deleted (no longer visible
      from resource lists, and not reachable by name) after the time in this
      field, once the finalizers list is empty. As long as the finalizers list
      contains items, deletion is blocked. Once the deletionTimestamp is set,
      this value may not be unset or be set further into the future, although
      it may be shortened or the resource may be deleted prior to this time.
      For example, a user may request that a pod is deleted in 30 seconds. The
      Kubelet will react by sending a graceful termination signal to the
      containers in the pod. After that 30 seconds, the Kubelet will send a
      hard termination signal (SIGKILL) to the container and after cleanup,
      remove the pod from the API. In the presence of network partitions, this
      object may still exist after this timestamp, until an administrator or
      automated process can determine the resource is fully terminated. If not
      set, graceful deletion of the object has not been requested.  Populated
      by the system when a graceful deletion is requested. Read-only. More
      info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    finalizers: Must be empty before the object is deleted from the registry.
      Each entry is an identifier for the responsible component that will
      remove the entry from the list. If the deletionTimestamp of the object
      is non-nil, entries in this list can only be removed. +optional
      +patchStrategy=merge
    generateName: GenerateName is an optional prefix, used by the server, to
      generate a unique name ONLY IF the Name field has not been provided. If
      this field is used, the name returned to the client will be different
      than the name passed. This value will also be combined with a unique
      suffix. The provided value has the same validation rules as the Name
      field, and may be truncated by the length of the suffix required to make
      the value unique on the server.  If this field is specified and the
      generated name exists, the server will NOT return a 409 - instead, it
      will either return 201 Created or 500 with Reason ServerTimeout
      indicating a unique name could not be found in the time allotted, and
      the client should retry (optionally after the time indicated in the
      Retry-After header).  Applied only if Name is not specified. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#idempotency +optional
    generation: A sequence number representing a specific generation of the
      desired state. Populated by the system. Read-only. +optional
    initializers: An initializer is a controller which enforces some system
      invariant at object creation time. This field is a list of initializers
      that have not yet acted on this object. If nil or empty, this object has
      been completely initialized. Otherwise, the object is considered
      uninitialized and is hidden (in list/watch and get calls) from clients
      that haven't explicitly asked to observe uninitialized objects.  When an
      object is created, the system will populate this list with the current
      set of initializers. Only privileged users may set or modify this list.
      Once it is empty, it may not be modified further by any user.
    labels: Map of string keys and values that can be used to organize and
      categorize (scope and select) objects. May match selectors of
      replication controllers and services. More info:
      http://kubernetes.io/docs/user-guide/labels +optional
    name: Name must be unique within a namespace. Is required when creating
      resources, although some resources may allow a client to request the
      generation of an appropriate name automatically. Name is primarily
      intended for creation idempotence and configuration definition. Cannot
      be updated. More info: http://kubernetes.io/docs/user-
      guide/identifiers#names +optional
    namespace: Namespace defines the space within each name must be unique. An
      empty namespace is equivalent to the "default" namespace, but "default"
      is the canonical representation. Not all objects are required to be
      scoped to a namespace - the value of this field for those objects will
      be empty.  Must be a DNS_LABEL. Cannot be updated. More info:
      http://kubernetes.io/docs/user-guide/namespaces +optional
    ownerReferences: List of objects depended by this object. If ALL objects
      in the list have been deleted, this object will be garbage collected. If
      this object is managed by a controller, then an entry in this list will
      point to this controller, with the controller field set to true. There
      cannot be more than one managing controller. +optional
      +patchMergeKey=uid +patchStrategy=merge
    resourceVersion: An opaque value that represents the internal version of
      this object that can be used by clients to determine when objects have
      changed. May be used for optimistic concurrency, change detection, and
      the watch operation on a resource or set of resources. Clients must
      treat these values as opaque and passed unmodified back to the server.
      They may only be valid for a particular resource or set of resources.
      Populated by the system. Read-only. Value must be treated as opaque by
      clients and . More info: https://git.k8s.io/community/contributors/devel
      /api-conventions.md#concurrency-control-and-consistency +optional
    selfLink: SelfLink is a URL representing this object. Populated by the
      system. Read-only. +optional
    uid: UID is the unique in time and space value for this object. It is
      typically generated by the server on successful creation of a resource
      and is not allowed to change on PUT operations.  Populated by the
      system. Read-only. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids +optional
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations is an unstructured key value map stored with a resource
    that may be set by external tools to store and retrieve arbitrary
    metadata. They are not queryable and should be preserved when modifying
    objects. More info: http://kubernetes.io/docs/user-guide/annotations
    +optional

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Map of string keys and values that can be used to organize and
    categorize (scope and select) objects. May match selectors of replication
    controllers and services. More info: http://kubernetes.io/docs/user-
    guide/labels +optional

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  clusterName = _messages.StringField(2)
  creationTimestamp = _messages.MessageField('Time', 3)
  deletionGracePeriodSeconds = _messages.IntegerField(4)
  deletionTimestamp = _messages.MessageField('Time', 5)
  finalizers = _messages.StringField(6, repeated=True)
  generateName = _messages.StringField(7)
  generation = _messages.IntegerField(8)
  initializers = _messages.MessageField('Initializers', 9)
  labels = _messages.MessageField('LabelsValue', 10)
  name = _messages.StringField(11)
  namespace = _messages.StringField(12)
  ownerReferences = _messages.MessageField('OwnerReference', 13, repeated=True)
  resourceVersion = _messages.StringField(14)
  selfLink = _messages.StringField(15)
  uid = _messages.StringField(16)


class OwnerReference(_messages.Message):
  r"""OwnerReference contains enough information to let you identify an owning
  object. Currently, an owning object must be in the same namespace, so there
  is no namespace field.

  Fields:
    apiVersion: API version of the referent.
    blockOwnerDeletion: If true, AND if the owner has the "foregroundDeletion"
      finalizer, then the owner cannot be deleted from the key-value store
      until this reference is removed. Defaults to false. To set this field, a
      user needs "delete" permission of the owner, otherwise 422
      (Unprocessable Entity) will be returned. +optional
    controller: If true, this reference points to the managing controller.
      +optional
    kind: Kind of the referent. More info:
      https://git.k8s.io/community/contributors/devel/api-conventions.md
      #types-kinds
    name: Name of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#names
    uid: UID of the referent. More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids
  """

  apiVersion = _messages.StringField(1)
  blockOwnerDeletion = _messages.BooleanField(2)
  controller = _messages.BooleanField(3)
  kind = _messages.StringField(4)
  name = _messages.StringField(5)
  uid = _messages.StringField(6)


class PodSecurityPolicy(_messages.Message):
  r"""Pod Security Policy governs the ability to make requests that affect the
  Security Context that will be applied to a pod and container.

  Fields:
    metadata: Standard object's metadata. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    spec: spec defines the policy enforced. +optional
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  spec = _messages.MessageField('PodSecurityPolicySpec', 2)


class PodSecurityPolicySpec(_messages.Message):
  r"""Pod Security Policy Spec defines the policy enforced.

  Fields:
    allowPrivilegeEscalation: AllowPrivilegeEscalation determines if a pod can
      request to allow privilege escalation. If unspecified, defaults to true.
      +optional
    allowedCapabilities: AllowedCapabilities is a list of capabilities that
      can be requested to add to the container. Capabilities in this field may
      be added at the pod author's discretion. You must not list a capability
      in both AllowedCapabilities and RequiredDropCapabilities. +optional
    allowedFlexVolumes: AllowedFlexVolumes is a whitelist of allowed
      Flexvolumes.  Empty or nil indicates that all Flexvolumes may be used.
      This parameter is effective only when the usage of the Flexvolumes is
      allowed in the "Volumes" field. +optional
    allowedHostPaths: is a white list of allowed host paths. Empty indicates
      that all host paths may be used. +optional
    defaultAddCapabilities: DefaultAddCapabilities is the default set of
      capabilities that will be added to the container unless the pod spec
      specifically drops the capability.  You may not list a capability in
      both DefaultAddCapabilities and RequiredDropCapabilities. Capabilities
      added here are implicitly allowed, and need not be included in the
      AllowedCapabilities list. +optional
    defaultAllowPrivilegeEscalation: DefaultAllowPrivilegeEscalation controls
      the default setting for whether a process can gain more privileges than
      its parent process. +optional
    fsGroup: FSGroup is the strategy that will dictate what fs group is used
      by the SecurityContext.
    hostIPC: hostIPC determines if the policy allows the use of HostIPC in the
      pod spec. +optional
    hostNetwork: hostNetwork determines if the policy allows the use of
      HostNetwork in the pod spec. +optional
    hostPID: hostPID determines if the policy allows the use of HostPID in the
      pod spec. +optional
    hostPorts: hostPorts determines which host port ranges are allowed to be
      exposed. +optional
    privileged: privileged determines if a pod can request to be run as
      privileged. +optional
    readOnlyRootFilesystem: ReadOnlyRootFilesystem when set to true will force
      containers to run with a read only root file system.  If the container
      specifically requests to run with a non-read only root file system the
      PSP should deny the pod. If set to false the container may run with a
      read only root file system if it wishes but it will not be forced to.
      +optional
    requiredDropCapabilities: RequiredDropCapabilities are the capabilities
      that will be dropped from the container.  These are required to be
      dropped and cannot be added. +optional
    runAsUser: runAsUser is the strategy that will dictate the allowable
      RunAsUser values that may be set.
    seLinux: seLinux is the strategy that will dictate the allowable labels
      that may be set.
    supplementalGroups: SupplementalGroups is the strategy that will dictate
      what supplemental groups are used by the SecurityContext.
    volumes: volumes is a white list of allowed volume plugins.  Empty
      indicates that all plugins may be used. +optional
  """

  allowPrivilegeEscalation = _messages.BooleanField(1)
  allowedCapabilities = _messages.StringField(2, repeated=True)
  allowedFlexVolumes = _messages.MessageField('AllowedFlexVolume', 3, repeated=True)
  allowedHostPaths = _messages.MessageField('AllowedHostPath', 4, repeated=True)
  defaultAddCapabilities = _messages.StringField(5, repeated=True)
  defaultAllowPrivilegeEscalation = _messages.BooleanField(6)
  fsGroup = _messages.MessageField('FSGroupStrategyOptions', 7)
  hostIPC = _messages.BooleanField(8)
  hostNetwork = _messages.BooleanField(9)
  hostPID = _messages.BooleanField(10)
  hostPorts = _messages.MessageField('HostPortRange', 11, repeated=True)
  privileged = _messages.BooleanField(12)
  readOnlyRootFilesystem = _messages.BooleanField(13)
  requiredDropCapabilities = _messages.StringField(14, repeated=True)
  runAsUser = _messages.MessageField('RunAsUserStrategyOptions', 15)
  seLinux = _messages.MessageField('SELinuxStrategyOptions', 16)
  supplementalGroups = _messages.MessageField('SupplementalGroupsStrategyOptions', 17)
  volumes = _messages.StringField(18, repeated=True)


class PolicyNode(_messages.Message):
  r"""PolicyNode is the top-level object for the policy node data definition.
  It holds a policy defined for a single org unit (namespace). +protobuf=true

  Fields:
    metadata: Standard object's metadata. The Name field of the policy node
      must match the namespace name. +optional
    spec: The actual object definition, per K8S object definition style.
      +optional
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  spec = _messages.MessageField('PolicyNodeSpec', 2)


class PolicyNodeList(_messages.Message):
  r"""PolicyNodeList holds a list of namespace policies, as response to a List
  call on the policy hierarchy API. +protobuf=true

  Fields:
    items: Items is a list of policy nodes that apply.
    metadata: Standard object's metadata. +optional
  """

  items = _messages.MessageField('PolicyNode', 1, repeated=True)
  metadata = _messages.MessageField('ListMeta', 2)


class PolicyNodeSpec(_messages.Message):
  r"""PolicyNodeSpec contains all the information about a policy linkage.
  +protobuf=true

  Fields:
    parent: The parent org unit +optional
    resourceQuotaV1: +optional
    roleBindingsV1: +optional
    rolesV1: +optional
    type: The type of the PolicyNode.
  """

  parent = _messages.StringField(1)
  resourceQuotaV1 = _messages.MessageField('ResourceQuota', 2)
  roleBindingsV1 = _messages.MessageField('RoleBinding', 3, repeated=True)
  rolesV1 = _messages.MessageField('Role', 4, repeated=True)
  type = _messages.StringField(5)


class PolicyRule(_messages.Message):
  r"""PolicyRule holds information that describes a policy rule, but does not
  contain information about who the rule applies to or which namespace the
  rule applies to.

  Fields:
    apiGroups: APIGroups is the name of the APIGroup that contains the
      resources.  If multiple API groups are specified, any action requested
      against one of the enumerated resources in any API group will be
      allowed. +optional
    nonResourceURLs: NonResourceURLs is a set of partial urls that a user
      should have access to.  *s are allowed, but only as the full, final step
      in the path Since non-resource URLs are not namespaced, this field is
      only applicable for ClusterRoles referenced from a ClusterRoleBinding.
      Rules can either apply to API resources (such as "pods" or "secrets") or
      non-resource URL paths (such as "/api"),  but not both. +optional
    resourceNames: ResourceNames is an optional white list of names that the
      rule applies to.  An empty set means that everything is allowed.
      +optional
    resources: Resources is a list of resources this rule applies to.
      ResourceAll represents all resources. +optional
    verbs: Verbs is a list of Verbs that apply to ALL the ResourceKinds and
      AttributeRestrictions contained in this rule.  VerbAll represents all
      kinds.
  """

  apiGroups = _messages.StringField(1, repeated=True)
  nonResourceURLs = _messages.StringField(2, repeated=True)
  resourceNames = _messages.StringField(3, repeated=True)
  resources = _messages.StringField(4, repeated=True)
  verbs = _messages.StringField(5, repeated=True)


class Quantity(_messages.Message):
  r"""Quantity is a fixed-point representation of a number. It provides
  convenient marshaling/unmarshaling in JSON and YAML, in addition to String()
  and Int64() accessors.  The serialization format is:  <quantity>        ::=
  <signedNumber><suffix>   (Note that <suffix> may be empty, from the "" case
  in <decimalSI>.) <digit>           ::= 0 | 1 | ... | 9 <digits>          ::=
  <digit> | <digit><digits> <number>          ::= <digits> | <digits>.<digits>
  | <digits>. | .<digits> <sign>            ::= "+" | "-" <signedNumber>
  ::= <number> | <sign><number> <suffix>          ::= <binarySI> |
  <decimalExponent> | <decimalSI> <binarySI>        ::= Ki | Mi | Gi | Ti | Pi
  | Ei   (International System of units; See:
  http://physics.nist.gov/cuu/Units/binary.html) <decimalSI>       ::= m | ""
  | k | M | G | T | P | E   (Note that 1024 = 1Ki but 1000 = 1k; I didn't
  choose the capitalization.) <decimalExponent> ::= "e" <signedNumber> | "E"
  <signedNumber>  No matter which of the three exponent forms is used, no
  quantity may represent a number greater than 2^63-1 in magnitude, nor may it
  have more than 3 decimal places. Numbers larger or more precise will be
  capped or rounded up. (E.g.: 0.1m will rounded up to 1m.) This may be
  extended in the future if we require larger or smaller quantities.  When a
  Quantity is parsed from a string, it will remember the type of suffix it
  had, and will use the same type again when it is serialized.  Before
  serializing, Quantity will be put in "canonical form". This means that
  Exponent/suffix will be adjusted up or down (with a corresponding increase
  or decrease in Mantissa) such that:   a. No precision is lost   b. No
  fractional digits will be emitted   c. The exponent (or suffix) is as large
  as possible. The sign will be omitted unless the number is negative.
  Examples:   1.5 will be serialized as "1500m"   1.5Gi will be serialized as
  "1536Mi"  NOTE: We reserve the right to amend this canonical format, perhaps
  to   allow 1.5 to be canonical.

  Fields:
    string: A string attribute.
  """

  string = _messages.StringField(1)


class ResourceQuota(_messages.Message):
  r"""ResourceQuota sets aggregate quota restrictions enforced per namespace

  Fields:
    metadata: Standard object's metadata. More info:
      https://git.k8s.io/community/contributors/devel/api-
      conventions.md#metadata +optional
    spec: Spec defines the desired quota.
      https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-
      and-status +optional
    status: Status defines the actual enforced quota and its current usage.
      https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-
      and-status +optional
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  spec = _messages.MessageField('ResourceQuotaSpec', 2)
  status = _messages.MessageField('ResourceQuotaStatus', 3)


class ResourceQuotaSpec(_messages.Message):
  r"""ResourceQuotaSpec defines the desired hard limits to enforce for Quota.

  Messages:
    HardValue: Hard is the set of desired hard limits for each named resource.
      More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
      +optional

  Fields:
    hard: Hard is the set of desired hard limits for each named resource. More
      info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
      +optional
    scopes: A collection of filters that must match each object tracked by a
      quota. If not specified, the quota matches all objects. +optional
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HardValue(_messages.Message):
    r"""Hard is the set of desired hard limits for each named resource. More
    info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
    +optional

    Messages:
      AdditionalProperty: An additional property for a HardValue object.

    Fields:
      additionalProperties: Additional properties of type HardValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HardValue object.

      Fields:
        key: Name of the additional property.
        value: A Quantity attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Quantity', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  hard = _messages.MessageField('HardValue', 1)
  scopes = _messages.StringField(2, repeated=True)


class ResourceQuotaStatus(_messages.Message):
  r"""ResourceQuotaStatus defines the enforced hard limits and observed use.

  Messages:
    HardValue: Hard is the set of enforced hard limits for each named
      resource. More info: https://kubernetes.io/docs/concepts/policy
      /resource-quotas/ +optional
    UsedValue: Used is the current observed total usage of the resource in the
      namespace. +optional

  Fields:
    hard: Hard is the set of enforced hard limits for each named resource.
      More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
      +optional
    used: Used is the current observed total usage of the resource in the
      namespace. +optional
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HardValue(_messages.Message):
    r"""Hard is the set of enforced hard limits for each named resource. More
    info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
    +optional

    Messages:
      AdditionalProperty: An additional property for a HardValue object.

    Fields:
      additionalProperties: Additional properties of type HardValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HardValue object.

      Fields:
        key: Name of the additional property.
        value: A Quantity attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Quantity', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UsedValue(_messages.Message):
    r"""Used is the current observed total usage of the resource in the
    namespace. +optional

    Messages:
      AdditionalProperty: An additional property for a UsedValue object.

    Fields:
      additionalProperties: Additional properties of type UsedValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UsedValue object.

      Fields:
        key: Name of the additional property.
        value: A Quantity attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Quantity', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  hard = _messages.MessageField('HardValue', 1)
  used = _messages.MessageField('UsedValue', 2)


class Role(_messages.Message):
  r"""Role is a namespaced, logical grouping of PolicyRules that can be
  referenced as a unit by a RoleBinding.

  Fields:
    metadata: Standard object's metadata. +optional
    rules: Rules holds all the PolicyRules for this Role
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  rules = _messages.MessageField('PolicyRule', 2, repeated=True)


class RoleBinding(_messages.Message):
  r"""RoleBinding references a role, but does not contain it.  It can
  reference a Role in the same namespace or a ClusterRole in the global
  namespace. It adds who information via Subjects and namespace information by
  which namespace it exists in.  RoleBindings in a given namespace only have
  effect in that namespace.

  Fields:
    metadata: Standard object's metadata. +optional
    roleRef: RoleRef can reference a Role in the current namespace or a
      ClusterRole in the global namespace. If the RoleRef cannot be resolved,
      the Authorizer must return an error.
    subjects: Subjects holds references to the objects the role applies to.
  """

  metadata = _messages.MessageField('ObjectMeta', 1)
  roleRef = _messages.MessageField('RoleRef', 2)
  subjects = _messages.MessageField('Subject', 3, repeated=True)


class RoleRef(_messages.Message):
  r"""RoleRef contains information that points to the role being used

  Fields:
    apiGroup: APIGroup is the group for the resource being referenced
    kind: Kind is the type of resource being referenced
    name: Name is the name of resource being referenced
  """

  apiGroup = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)


class RunAsUserStrategyOptions(_messages.Message):
  r"""Run A sUser Strategy Options defines the strategy type and any options
  used to create the strategy.

  Fields:
    ranges: Ranges are the allowed ranges of uids that may be used. +optional
    rule: Rule is the strategy that will dictate the allowable RunAsUser
      values that may be set.
  """

  ranges = _messages.MessageField('IDRange', 1, repeated=True)
  rule = _messages.StringField(2)


class SELinuxOptions(_messages.Message):
  r"""SELinuxOptions are the labels to be applied to the container

  Fields:
    level: Level is SELinux level label that applies to the container.
      +optional
    role: Role is a SELinux role label that applies to the container.
      +optional
    type: Type is a SELinux type label that applies to the container.
      +optional
    user: User is a SELinux user label that applies to the container.
      +optional
  """

  level = _messages.StringField(1)
  role = _messages.StringField(2)
  type = _messages.StringField(3)
  user = _messages.StringField(4)


class SELinuxStrategyOptions(_messages.Message):
  r"""SELinux  Strategy Options defines the strategy type and any options used
  to create the strategy.

  Fields:
    rule: type is the strategy that will dictate the allowable labels that may
      be set.
    seLinuxOptions: seLinuxOptions required to run as; required for MustRunAs
      More info: https://kubernetes.io/docs/tasks/configure-pod-container
      /security-context/ +optional
  """

  rule = _messages.StringField(1)
  seLinuxOptions = _messages.MessageField('SELinuxOptions', 2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""Status is a return value for calls that don't return other objects.

  Fields:
    code: Suggested HTTP return code for this status, 0 if not set. +optional
    details: Extended data associated with the reason.  Each reason may define
      its own extended details. This field is optional and the data returned
      is not guaranteed to conform to any schema except that defined by the
      reason type. +optional
    message: A human-readable description of the status of this operation.
      +optional
    metadata: Standard list metadata. More info:
      https://git.k8s.io/community/contributors/devel/api-conventions.md
      #types-kinds +optional
    reason: A machine-readable description of why this operation is in the
      "Failure" status. If this value is empty there is no information
      available. A Reason clarifies an HTTP status code but does not override
      it. +optional
    status: Status of the operation. One of: "Success" or "Failure". More
      info: https://git.k8s.io/community/contributors/devel/api-conventions.md
      #spec-and-status +optional
  """

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('StatusDetails', 2)
  message = _messages.StringField(3)
  metadata = _messages.MessageField('ListMeta', 4)
  reason = _messages.StringField(5)
  status = _messages.StringField(6)


class StatusCause(_messages.Message):
  r"""StatusCause provides more information about an api.Status failure,
  including cases when multiple errors are encountered.

  Fields:
    field: The field of the resource that has caused this error, as named by
      its JSON serialization. May include dot and postfix notation for nested
      attributes. Arrays are zero-indexed.  Fields may appear more than once
      in an array of causes due to fields having multiple errors. Optional.
      Examples:   "name" - the field "name" on the current resource
      "items[0].name" - the field "name" on the first array entry in "items"
      +optional
    message: A human-readable description of the cause of the error.  This
      field may be presented as-is to a reader. +optional
    reason: A machine-readable description of the cause of the error. If this
      value is empty there is no information available. +optional
  """

  field = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)


class StatusDetails(_messages.Message):
  r"""StatusDetails is a set of additional properties that MAY be set by the
  server to provide additional information about a response. The Reason field
  of a Status object defines what attributes will be set. Clients must ignore
  fields that do not match the defined type of each attribute, and should
  assume that any attribute may be empty, invalid, or under defined.

  Fields:
    causes: The Causes array includes more details associated with the
      StatusReason failure. Not all StatusReasons may provide detailed causes.
      +optional
    group: The group attribute of the resource associated with the status
      StatusReason. +optional
    kind: The kind attribute of the resource associated with the status
      StatusReason. On some operations may differ from the requested resource
      Kind. More info: https://git.k8s.io/community/contributors/devel/api-
      conventions.md#types-kinds +optional
    name: The name attribute of the resource associated with the status
      StatusReason (when there is a single name which can be described).
      +optional
    retryAfterSeconds: If specified, the time in seconds before the operation
      should be retried. Some errors may indicate the client must take an
      alternate action - for those errors this field may indicate how long to
      wait before taking the alternate action. +optional
    uid: UID of the resource. (when there is a single resource which can be
      described). More info: http://kubernetes.io/docs/user-
      guide/identifiers#uids +optional
  """

  causes = _messages.MessageField('StatusCause', 1, repeated=True)
  group = _messages.StringField(2)
  kind = _messages.StringField(3)
  name = _messages.StringField(4)
  retryAfterSeconds = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  uid = _messages.StringField(6)


class Subject(_messages.Message):
  r"""Subject contains a reference to the object or user identities a role
  binding applies to.  This can either hold a direct API object reference, or
  a value for non-objects such as user and group names.

  Fields:
    apiGroup: APIGroup holds the API group of the referenced subject. Defaults
      to "" for ServiceAccount subjects. Defaults to
      "rbac.authorization.k8s.io" for User and Group subjects. +optional
    kind: Kind of object being referenced. Values defined by this API group
      are "User", "Group", and "ServiceAccount". If the Authorizer does not
      recognized the kind value, the Authorizer should report an error.
    name: Name of the object being referenced.
    namespace: Namespace of the referenced object.  If the object kind is non-
      namespace, such as "User" or "Group", and this value is not empty the
      Authorizer should report an error. +optional
  """

  apiGroup = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)
  namespace = _messages.StringField(4)


class SupplementalGroupsStrategyOptions(_messages.Message):
  r"""SupplementalGroupsStrategyOptions defines the strategy type and options
  used to create the strategy.

  Fields:
    ranges: Ranges are the allowed ranges of supplemental groups.  If you
      would like to force a single supplemental group then supply a single
      range with the same start and end. +optional
    rule: Rule is the strategy that will dictate what supplemental groups is
      used in the SecurityContext. +optional
  """

  ranges = _messages.MessageField('IDRange', 1, repeated=True)
  rule = _messages.StringField(2)


class Time(_messages.Message):
  r"""Time is a wrapper around time.Time which supports correct marshaling to
  YAML and JSON.  Wrappers are provided for many of the factory methods that
  the time package offers.  +protobuf.options.marshal=false
  +protobuf.as=Timestamp +protobuf.options.(gogoproto.goproto_stringer)=false

  Fields:
    nanos: Non-negative fractions of a second at nanosecond resolution.
      Negative second values with fractions must still have non-negative nanos
      values that count forward in time. Must be from 0 to 999,999,999
      inclusive. This field may be limited in precision depending on context.
    seconds: Represents seconds of UTC time since Unix epoch
      1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
      9999-12-31T23:59:59Z inclusive.
  """

  nanos = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(2)


encoding.AddCustomJsonFieldMapping(
    ListMeta, 'continue_', 'continue')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
