<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Apache et les variables d'environnement - Serveur HTTP Apache Version 2.4</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="./style/css/prettify.css" />
<script src="./style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="./images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.4</a></div><div id="page-content"><div id="preamble"><h1>Apache et les variables d'environnement</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/env.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/env.html" title="Fran&#231;ais">&nbsp;fr&nbsp;</a> |
<a href="./ja/env.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/env.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/env.html" hreflang="tr" rel="alternate" title="T&#252;rk&#231;e">&nbsp;tr&nbsp;</a></p>
</div>

     <p>Deux types de variables d'environnement affectent le serveur
     HTTP Apache.</p>

    <p>Le premier type correspond aux variables d'environnement
    contr&#244;l&#233;es par le syst&#232;me d'exploitation sous-jacent et d&#233;finies
    avant le d&#233;marrage du serveur. Leurs valeurs peuvent &#234;tre utilis&#233;es
    directement dans les fichiers de configuration, et peuvent
    &#233;ventuellement &#234;tre transmises aux scripts CGI et SSI via la
    directive PassEnv.</p>

    <p>Le second type correspond aux variables nomm&#233;es appel&#233;es aussi
    <em>variables d'environnement</em> dans lesquelles le serveur HTTP
    Apache stocke des informations via un m&#233;canisme sp&#233;cial. Ces
    informations peuvent servir &#224; contr&#244;ler diverses op&#233;rations comme
    l'enregistrement des traces ou le contr&#244;le d'acc&#232;s. On utilise aussi ces
    variables dans le m&#233;canisme de communication avec les programmes externes
    comme les scripts CGI. Ce document pr&#233;sente diff&#233;rentes m&#233;thodes pour
    manipuler et utiliser ces variables.</p>

    <p>Bien que ces variables soient r&#233;f&#233;renc&#233;es comme <em>variables
    d'environnement</em>, il ne faut pas les confondre avec les variables
    d'environnement contr&#244;l&#233;es par le syst&#232;me d'exploitation sous-jacent.
    En fait, ces variables sont stock&#233;es et manipul&#233;es dans une structure
    interne &#224; Apache. Elles ne deviennent de v&#233;ritables variables
    d'environnement du syst&#232;me d'exploitation que lorsqu'elles sont mises &#224; la
    disposition de scripts CGI et de scripts inclus c&#244;t&#233; serveur (SSI). Si vous
    souhaitez manipuler l'environnement du syst&#232;me d'exploitation sous lequel
    le serveur s'ex&#233;cute, vous devez utiliser les m&#233;canismes standards de
    manipulation de l'environnement fournis par l'interpr&#233;teur de commandes
    (shell) de votre syst&#232;me d'exploitation.</p>
  </div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#setting">D&#233;finition des variables d'environnement</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#using">Utilisation des variables d'environnement</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#special">Variables d'environnement &#224; usage sp&#233;cial</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#examples">Exemples</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="setting" id="setting">D&#233;finition des variables d'environnement</a></h2>
    
    <table class="related"><tr><th>Modules Apparent&#233;s</th><th>Directives Apparent&#233;es</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code></li><li><code class="module"><a href="./mod/mod_env.html">mod_env</a></code></li><li><code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code></li><li><code class="module"><a href="./mod/mod_setenvif.html">mod_setenvif</a></code></li><li><code class="module"><a href="./mod/mod_unique_id.html">mod_unique_id</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_setenvif.html#browsermatch">BrowserMatch</a></code></li><li><code class="directive"><a href="./mod/mod_setenvif.html#browsermatchnocase">BrowserMatchNoCase</a></code></li><li><code class="directive"><a href="./mod/mod_env.html#passenv">PassEnv</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code></li><li><code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code></li><li><code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code></li><li><code class="directive"><a href="./mod/mod_setenvif.html#setenvifnocase">SetEnvIfNoCase</a></code></li><li><code class="directive"><a href="./mod/mod_env.html#unsetenv">UnsetEnv</a></code></li></ul></td></tr></table>

    <h3><a name="basic-manipulation" id="basic-manipulation">Manipulations de base de l'environnement</a></h3>
        

        <p>La m&#233;thode la plus &#233;l&#233;mentaire pour d&#233;finir une variable
	d'environnement au niveau d'Apache consiste &#224; utiliser la directive
	inconditionnelle <code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code>. Les variables peuvent aussi &#234;tre transmises depuis
	l'environnement du shell &#224; partir duquel le serveur a &#233;t&#233; d&#233;marr&#233; en
	utilisant la directive
        <code class="directive"><a href="./mod/mod_env.html#passenv">PassEnv</a></code>.</p>

    
    <h3><a name="conditional" id="conditional">D&#233;finitions conditionnelles en fonction des requ&#234;tes</a></h3>
        

        <p>Pour plus de souplesse, les directives fournies par le module
        <code class="module"><a href="./mod/mod_setenvif.html">mod_setenvif</a></code> permettent de d&#233;finir les
	variables d'environnement en tenant compte des caract&#233;ristiques
	de chaque requ&#234;te. Par exemple, une
	variable pourrait n'&#234;tre d&#233;finie que lorsqu'un navigateur sp&#233;cifique
	(User-Agent) a g&#233;n&#233;r&#233; la requ&#234;te, ou seulement quand un en-t&#234;te
	Referer particulier est pr&#233;sent. La directive
	<code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> du module
	<code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> qui utilise l'option
	<code>[E=...]</code> pour d&#233;finir
	les variables d'environnement apporte encore plus de souplesse.</p>

    
    <h3><a name="unique-identifiers" id="unique-identifiers">Identifiants uniques</a></h3>
        

        <p>Finalement, le module <code class="module"><a href="./mod/mod_unique_id.html">mod_unique_id</a></code> d&#233;finit la variable
	d'environnement <code>UNIQUE_ID</code> pour chaque requ&#234;te &#224; une valeur
	qui est garantie unique parmi "toutes" les requ&#234;tes sous des
	conditions tr&#232;s sp&#233;cifiques.</p>

    
    <h3><a name="standard-cgi" id="standard-cgi">Variables CGI standards</a></h3>
        

        <p>En plus de l'ensemble des variables d'environnement internes &#224; la
	configuration d'Apache et de celles transmises depuis le shell,
	les scripts CGI	et les pages SSI
	se voient affect&#233;s un ensemble de variables
	d'environnement contenant des m&#233;ta-informations &#224; propos de la requ&#234;te
	comme pr&#233;conis&#233; dans la
	<a href="http://www.ietf.org/rfc/rfc3875">sp&#233;cification
	sur les CGIs</a>.</p>

    
    <h3><a name="caveats" id="caveats">Quelques mises en garde</a></h3>
        

        <ul>
          <li>Les directives de manipulation de l'environnement ne permettent
	  pas de supplanter ou modifier les variables CGI standards.</li>

          <li>Lorsqu'on utilise <code class="program"><a href="./programs/suexec.html">suexec</a></code> pour ex&#233;cuter des
	  scripts CGI, l'environnement est nettoy&#233; et r&#233;duit &#224; un ensemble de
	  variables <em>s&#251;res</em> avant l'ex&#233;cution du script. La liste des
	  variables <em>s&#251;res</em> est d&#233;finie &#224; la compilation dans
          <code>suexec.c</code>.</li>

          <li>Pour des raisons de portabilit&#233;, les noms des variables
	  d'environnement ne peuvent contenir que des lettres, des chiffres, et
	  le caract&#232;re "souslign&#233;". En outre, le premier caract&#232;re ne doit pas
	  &#234;tre un chiffre. Les caract&#232;res qui ne satisfont pas &#224; ces conditions
	  seront remplac&#233;s par un caract&#232;re "souslign&#233;" quand ils seront
	  transmis aux scripts CGI et aux pages SSI.</li>

	  <li>Les contenus d'en-t&#234;tes HTTP transmis aux scripts de type
	  CGI ou autre via des variables d'environnement constituent un
	  cas particulier (voir plus loin). Leur nom est converti en
	  majuscules et seuls les tirets sont remplac&#233;s par des
	  caract&#232;res '_' ("soulign&#233;") ; si le format du nom de l'en-t&#234;te
	  n'est pas valide, celui-ci est ignor&#233;. Voir <a href="#fixheader">plus loin</a> pour une solution de
	  contournement du probl&#232;me.</li>

          <li>La directive <code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code> s'ex&#233;cute assez tard au
	  cours du traitement de la requ&#234;te, ce qui signifie que des
	  directives telles que <code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code> et <code class="directive"><a href="./mod/mod_rewrite.html#rewritecond">RewriteCond</a></code> ne verront pas
	  les variables qu'elle aura d&#233;finies.</li>

	  <li>Lorsque le serveur cherche un chemin via une <a class="glossarylink" href="./glossary.html#subrequest" title="voir glossaire">sous-requ&#234;te</a> interne (par exemple la
   recherche d'un <code class="directive"><a href="./mod/mod_dir.html#directoryindex">DirectoryIndex</a></code>), ou lorsqu'il g&#233;n&#232;re un
   listing du contenu d'un r&#233;pertoire via le module
   <code class="module"><a href="./mod/mod_autoindex.html">mod_autoindex</a></code>, la sous-requ&#234;te n'h&#233;rite pas des
   variables d'environnement sp&#233;cifiques &#224; la requ&#234;te. En outre, &#224; cause
   des phases de l'API auxquelles <code class="module"><a href="./mod/mod_setenvif.html">mod_setenvif</a></code> prend
   part, les directives <code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code> ne sont pas &#233;valu&#233;es
   s&#233;par&#233;ment dans la sous-requ&#234;te.</li>
        </ul>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="using" id="using">Utilisation des variables d'environnement</a></h2>
    

    <table class="related"><tr><th>Modules Apparent&#233;s</th><th>Directives Apparent&#233;es</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_authz_host.html">mod_authz_host</a></code></li><li><code class="module"><a href="./mod/mod_cgi.html">mod_cgi</a></code></li><li><code class="module"><a href="./mod/mod_ext_filter.html">mod_ext_filter</a></code></li><li><code class="module"><a href="./mod/mod_headers.html">mod_headers</a></code></li><li><code class="module"><a href="./mod/mod_include.html">mod_include</a></code></li><li><code class="module"><a href="./mod/mod_log_config.html">mod_log_config</a></code></li><li><code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_authz_core.html#require">Require</a></code></li><li><code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code></li><li><code class="directive"><a href="./mod/mod_access_compat.html#deny">Deny</a></code></li><li><code class="directive"><a href="./mod/mod_ext_filter.html#extfilterdefine">ExtFilterDefine</a></code></li><li><code class="directive"><a href="./mod/mod_headers.html#header">Header</a></code></li><li><code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewritecond">RewriteCond</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code></li></ul></td></tr></table>

    <h3><a name="cgi-scripts" id="cgi-scripts">Scripts CGI</a></h3>
        

        <p>La communication d'informations aux scripts CGI constitue une des
	principales utilisations des variables d'environnement. Comme indiqu&#233;
	plus haut, l'environnement transmis aux scripts CGI comprend des
	m&#233;ta-informations standards &#224; propos de la requ&#234;te, en plus des
	variables d&#233;finies dans la configuration d'Apache. Pour plus de
	d&#233;tails, se r&#233;f&#233;rer au
        <a href="howto/cgi.html">tutoriel CGI</a>.</p>

    
    <h3><a name="ssi-pages" id="ssi-pages">Pages SSI</a></h3>
        

        <p>Les documents inclus c&#244;t&#233; serveur (SSI) trait&#233;s par le filtre
        <code>INCLUDES</code> du module <code class="module"><a href="./mod/mod_include.html">mod_include</a></code>,
	peuvent afficher les
	variables d'environnement &#224; l'aide de l'&#233;l&#233;ment <code>echo</code>,
	et peuvent utiliser des variables d'environnement dans les &#233;l&#233;ments
	de contr&#244;le de flux pour rendre certaines parties d'une page
        conditionnelles en fonction des caract&#233;ristiques de la requ&#234;te.
	Apache fournit aussi les variables d'environnement CGI standards
	aux pages SSI
	comme indiqu&#233; plus haut. Pour plus de d&#233;tails, se r&#233;f&#233;rer au
	<a href="howto/ssi.html">tutoriel SSI</a>.</p>

    
    <h3><a name="access-control" id="access-control">Contr&#244;le d'acc&#232;s</a></h3>
        

        <p>L'acc&#232;s au serveur peut &#234;tre contr&#244;l&#233; en fonction de la valeur de
	variables d'environnement &#224; l'aide des directives
	<code>allow from env=</code> et <code>deny from env=</code>.
	En association avec la directive
        <code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>, ceci conf&#232;re une
	grande souplesse au contr&#244;le d'acc&#232;s au serveur en fonction des
	caract&#233;ristiques du client. Par exemple, vous pouvez utiliser ces
        directives pour interdire l'acc&#232;s depuis un navigateur particulier
	(User-Agent).
        </p>

    
    <h3><a name="logging" id="logging">Enregistrement conditionnel des traces</a></h3>
        

        <p>Les variables d'environnement peuvent &#234;tre enregistr&#233;es dans le
	fichier de log des acc&#232;s &#224; l'aide de l'option <code>%e</code> de la
	directive <code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code>.
	En outre, la d&#233;cision de tracer ou non les requ&#234;tes peut &#234;tre prise
	en fonction de l'&#233;tat de variables d'environnement en utilisant la
	forme conditionnelle de la directive
        <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code>. En
	association avec la directive <code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>, ceci conf&#232;re une grande souplesse au contr&#244;le
	du tra&#231;age des requ&#234;tes. Par exemple, vous pouvez choisir de ne pas
	tracer les requ&#234;tes pour des noms de fichiers se terminant par
	<code>gif</code>, ou encore de ne tracer que les requ&#234;tes des clients
	n'appartenant pas &#224; votre sous-r&#233;seau.</p>

    
    <h3><a name="response-headers" id="response-headers">En-t&#234;tes de r&#233;ponse conditionnels</a></h3>
        

        <p>La directive <code class="directive"><a href="./mod/mod_headers.html#header">Header</a></code>
        peut se baser sur la pr&#233;sence ou l'absence d'une variable
	d'environnement pour d&#233;cider si un certain en-t&#234;te HTTP sera plac&#233;
	dans la r&#233;ponse au client. Ceci permet, par exemple, de n'envoyer un
	certain en-t&#234;te de r&#233;ponse que si un en-t&#234;te correspondant est pr&#233;sent
	dans la requ&#234;te du client.</p>

    

    <h3><a name="external-filter" id="external-filter">Activation de filtres externes</a></h3>
        

        <p>Les filtres externes configur&#233;s par le module
	<code class="module"><a href="./mod/mod_ext_filter.html">mod_ext_filter</a></code> &#224; l'aide de la directive <code class="directive"><a href="./mod/mod_ext_filter.html#extfilterdefine">ExtFilterDefine</a></code> peuvent &#234;tre
	activ&#233;s de mani&#232;re conditionnelle en fonction d'une variable
	d'environnement &#224; l'aide des options
        <code>disableenv=</code> et <code>enableenv=</code>.</p>
    

    <h3><a name="url-rewriting" id="url-rewriting">R&#233;&#233;criture d'URL</a></h3>
        

        <p>La forme <code>%{ENV:<em>variable</em>}</code> de
	<em>TestString</em> dans la
	directive <code class="directive"><a href="./mod/mod_rewrite.html#rewritecond">RewriteCond</a></code>
        permet au moteur de r&#233;&#233;criture du module
	<code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> de prendre des
	d&#233;cisions conditionn&#233;es par des variables d'environnement.
        Notez que les variables accessibles dans
	<code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> sans le pr&#233;fixe
        <code>ENV:</code> ne sont pas de v&#233;ritables variables
	d'environnement. Ce sont plut&#244;t des variables sp&#233;cifiques &#224;
	<code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code>
        qui ne sont pas accessibles pour les autres modules.</p>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="special" id="special">Variables d'environnement &#224; usage sp&#233;cial</a></h2>
    

        <p>Des probl&#232;mes d'interop&#233;rabilit&#233; ont conduit &#224; l'introduction de
	m&#233;canismes permettant de modifier le comportement d'Apache lorsqu'il
	dialogue avec certains clients. Afin de rendre ces m&#233;canismes aussi
	souples que possible, ils sont invoqu&#233;s en d&#233;finissant des variables
	d'environnement, en g&#233;n&#233;ral &#224; l'aide de la directive
	<code class="directive"><a href="./mod/mod_setenvif.html#browsermatch">BrowserMatch</a></code>, bien que les
	directives <code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code> et
	<code class="directive"><a href="./mod/mod_env.html#passenv">PassEnv</a></code> puissent aussi &#234;tre
	utilis&#233;es, par exemple.</p>

    <h3><a name="downgrade" id="downgrade">downgrade-1.0</a></h3>
        

        <p>Ceci force le traitement d'une requ&#234;te comme une requ&#234;te HTTP/1.0
        m&#234;me si elle a &#233;t&#233; r&#233;dig&#233;e dans un langage plus r&#233;cent.</p>

    
    <h3><a name="force-gzip" id="force-gzip">force-gzip</a></h3>
        
          <p>Si le filtre <code>DEFLATE</code> est activ&#233;, cette variable
	  d'environnement ignorera les r&#233;glages accept-encoding de votre
	  navigateur et enverra une sortie compress&#233;e inconditionnellement.</p>
    
    <h3><a name="force-no-vary" id="force-no-vary">force-no-vary</a></h3>
        

        <p>Cette variable entra&#238;ne la suppression de tout champ
	<code>Vary</code> des en-t&#234;tes de la r&#233;ponse avant que cette derni&#232;re
	soit renvoy&#233;e au client. Certains clients n'interpr&#232;tent pas ce champ
	correctement, et la d&#233;finition de cette variable permet de contourner
	ce probl&#232;me, mais implique aussi la d&#233;finition de
	<strong>force-response-1.0</strong>.</p>

    
    <h3><a name="force-response" id="force-response">force-response-1.0</a></h3>
        

      <p>Cette variable force une r&#233;ponse en langage HTTP/1.0 aux clients
      qui envoient des requ&#234;tes dans le m&#234;me langage. Elle fut impl&#233;ment&#233;e &#224;
      l'origine suite &#224; des probl&#232;mes avec les mandataires d'AOL. Certains
      clients en langage HTTP/1.0 ne r&#233;agissent pas correctement face &#224; une
      r&#233;ponse en langage HTTP/1.1, et cette variable peut &#234;tre utilis&#233;e pour
      assurer l'interop&#233;rabilit&#233; avec eux.</p>

    

    <h3><a name="gzip-only-text-html" id="gzip-only-text-html">gzip-only-text/html</a></h3>
        

        <p>Positionn&#233;e &#224; "1", cette variable d&#233;sactive le filtre en sortie
	<code>DEFLATE</code> fourni par le module <code class="module"><a href="./mod/mod_deflate.html">mod_deflate</a></code> pour les
	types de contenu autres que <code>text/html</code>. Si vous pr&#233;f&#233;rez
	utiliser des fichiers compress&#233;s statiquement,
	<code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> &#233;value aussi la variable (non
	seulement pour gzip, mais aussi pour tous les encodages autres que
	"identity").</p>
    

    <h3><a name="no-gzip" id="no-gzip">no-gzip</a></h3>

        <p>Quand cette variable est d&#233;finie, le filtre <code>DEFLATE</code> du
	module <code class="module"><a href="./mod/mod_deflate.html">mod_deflate</a></code> est d&#233;sactiv&#233;, et
        <code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> refusera de d&#233;livrer des ressources
	encod&#233;es.</p>

    

    <h3><a name="no-cache" id="no-cache">no-cache</a></h3>
    	<p><em>Disponible dans les versions 2.2.12 et ult&#233;rieures d'Apache</em></p>

        <p>Lorsque cette variable est d&#233;finie,
	<code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> ne sauvegardera pas de r&#233;ponse
	susceptible d'&#234;tre mise en cache. Cette variable d'environnement
	n'a aucune incidence sur le fait qu'une r&#233;ponse d&#233;j&#224; enregistr&#233;e
	dans la cache soit utilis&#233;e ou non pour la requ&#234;te courante.</p>

    

    <h3><a name="nokeepalive" id="nokeepalive">nokeepalive</a></h3>
        

        <p>Quand cette variable est d&#233;finie, la directive
	<code class="directive"><a href="./mod/core.html#keepalive">KeepAlive</a></code> est d&#233;sactiv&#233;e.</p>

    

    <h3><a name="prefer-language" id="prefer-language">prefer-language</a></h3>

        <p>Cette variable modifie le comportement du module
	<code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code>. Si elle contient un symbole de
	langage (tel que <code>en</code>, <code>ja</code>
        ou <code>x-klingon</code>), <code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> essaie de
	d&#233;livrer une variante dans ce langage. S'il n'existe pas de telle
	variante, le processus normal de
	<a href="content-negotiation.html">n&#233;gociation</a> s'applique.</p>

    

    <h3><a name="redirect-carefully" id="redirect-carefully">redirect-carefully</a></h3>
        

        <p>Cette variable force le serveur &#224; &#234;tre plus prudent lors de l'envoi
	d'une redirection au client. Elle est en g&#233;n&#233;ral utilis&#233;e quand un
	client pr&#233;sente un probl&#232;me connu avec les redirections. Elle fut
	impl&#233;ment&#233;e &#224; l'origine suite a un probl&#232;me rencontr&#233; avec le logiciel
	WebFolders de Microsoft qui ne g&#232;re pas correctement les redirections
	vers des ressources de type r&#233;pertoire via des m&#233;thodes DAV.</p>

    

   <h3><a name="suppress-error-charset" id="suppress-error-charset">suppress-error-charset</a></h3>
       

    <p><em>Disponible dans les versions post&#233;rieures &#224; 2.0.54</em></p>

    <p>Quand Apache g&#233;n&#232;re une redirection en r&#233;ponse &#224; une requ&#234;te client,
    la r&#233;ponse inclut un texte destin&#233; &#224; &#234;tre affich&#233; au cas o&#249; le client ne
    suivrait pas, ou ne pourrait pas suivre automatiquement la redirection.
    Habituellement, Apache marque ce texte en accord avec le jeu de caract&#232;res
    qu'il utilise, &#224; savoir ISO-8859-1.</p>
    <p> Cependant, si la redirection fait r&#233;f&#233;rence &#224; une page qui utilise un
    jeu de caract&#232;res diff&#233;rent, certaines versions de navigateurs obsol&#232;tes
    essaieront d'utiliser le jeu de caract&#232;res du texte de la redirection
    plut&#244;t que celui de la page r&#233;elle.
    Ceci peut entra&#238;ner, par exemple, un rendu incorrect du Grec.</p>
    <p>Si cette variable d'environnement est d&#233;finie, Apache omettra le jeu de
    caract&#232;res pour le texte de la redirection, et les navigateurs obsol&#232;tes
    pr&#233;cit&#233;s utiliseront correctement celui de la page de destination.</p>

    <div class="warning">
      <h3>Note concernant la s&#233;curit&#233;</h3>

      <p>L'envoi de pages d'erreur sans sp&#233;cifier un jeu de caract&#232;res peut
      conduire &#224; des attaques de type "cross-site-scripting" pour les
      navigateurs qui ne respectent pas la sp&#233;cification HTTP/1.1 (MSIE) et
      tentent de d&#233;duire le jeu de caract&#232;res &#224; partir du contenu. De tels
      navigateurs peuvent &#234;tre facilement tromp&#233;s et utiliser le jeu de
      caract&#232;res UTF-7 ; les contenus des donn&#233;es en entr&#233;e de type UTF-7
      (comme les URI de requ&#234;te) ne seront alors plus prot&#233;g&#233;s par les
      m&#233;canismes d'&#233;chappement usuels con&#231;us pour pr&#233;venir les attaques
      de type "cross-site-scripting".</p>
    </div>

   

   <h3><a name="proxy" id="proxy">force-proxy-request-1.0, proxy-nokeepalive, proxy-sendchunked,
   proxy-sendcl, proxy-chain-auth, proxy-interim-response, proxy-initial-not-pooled</a></h3>

   <p>Ces directives modifient le comportement protocolaire du module
   <code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code>.  Voir la documentation sur
   <code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code> et <code class="module"><a href="./mod/mod_proxy_http.html">mod_proxy_http</a></code> pour plus de d&#233;tails.</p>
   

  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples</a></h2>
    

    <h3><a name="fixheader" id="fixheader">Transmission du contenu d'en-t&#234;tes non valides aux scripts
      CGI</a></h3>
      

      <p>Avec la version 2.4, Apache est plus strict avec la conversion
      des en-t&#234;tes HTTP en variables d'environnement dans
      <code class="module"><a href="./mod/mod_cgi.html">mod_cgi</a></code> et d'autres modules : dans les versions
      pr&#233;c&#233;dentes, tout caract&#232;re invalide dans les noms d'en-t&#234;tes
      &#233;tait tout simplement remplac&#233; par un caract&#232;re '_', ce qui
      pouvait exposer &#224; des attaques de type cross-site-scripting via
      injection d'en-t&#234;tes (voir <a href="http://events.ccc.de/congress/2007/Fahrplan/events/2212.en.html">Bogues
      du Web inhabituelles</a>, planche 19/20).</p>

      <p>Si vous devez supporter un client qui envoie des en-t&#234;tes non
      conformes et si ceux-ci ne peuvent pas &#234;tre corrig&#233;s, il existe
      une solution de contournement simple mettant en jeu les modules
      <code class="module"><a href="./mod/mod_setenvif.html">mod_setenvif</a></code> et <code class="module"><a href="./mod/mod_headers.html">mod_headers</a></code>,
      et permettant de prendre en compte ces en-t&#234;tes :</p>

<pre class="prettyprint lang-config"># L'exemple suivant montre comment prendre en compte un en-t&#234;te<br />
# Accept_Encoding non conforme envoy&#233; par un client.
#
SetEnvIfNoCase ^Accept.Encoding$ ^(.*)$ fix_accept_encoding=$1
RequestHeader set Accept-Encoding %{fix_accept_encoding}e env=fix_accept_encoding</pre>


    

    <h3><a name="misbehaving" id="misbehaving">Modification du comportement protocolaire face &#224; des clients
	r&#233;agissant de mani&#232;re non conforme</a></h3>
        

        <p>Les versions ant&#233;rieures recommandaient l'ajout de ces lignes dans
        httpd.conf pour tenir compte de probl&#232;mes connus avec certains clients.
	Comme les clients concern&#233;s sont maintenant tr&#232;s peu utilis&#233;s, cet
	ajout n'est pratiquement plus n&#233;cessaire.</p>
<pre class="prettyprint lang-config">#
# The following directives modify normal HTTP response behavior.
# The first directive disables keepalive for Netscape 2.x and browsers that
# spoof it. There are known problems with these browser implementations.
# The second directive is for Microsoft Internet Explorer 4.0b2
# which has a broken HTTP/1.1 implementation and does not properly
# support keepalive when it is used on 301 or 302 (redirect) responses.
#
BrowserMatch "Mozilla/2" nokeepalive
BrowserMatch "MSIE 4\.0b2;" nokeepalive downgrade-1.0 force-response-1.0

#
# The following directive disables HTTP/1.1 responses to browsers which
# are in violation of the HTTP/1.0 spec by not being able to grok a
# basic 1.1 response.
#
BrowserMatch "RealPlayer 4\.0" force-response-1.0
BrowserMatch "Java/1\.0" force-response-1.0
BrowserMatch "JDK/1\.0" force-response-1.0</pre>


    
    <h3><a name="no-img-log" id="no-img-log">Ne pas tracer les requ&#234;tes pour des images dans le fichier de
	trace des acc&#232;s</a></h3>
        

        <p>Dans cet exemple, les requ&#234;tes pour des images n'apparaissent pas
	dans le fichier de trace des acc&#232;s. Il peut &#234;tre facilement adapt&#233; pour
	emp&#234;cher le tra&#231;age de r&#233;pertoires particuliers, ou de requ&#234;tes
        en provenance de certains h&#244;tes.</p>
         <pre class="prettyprint lang-config">SetEnvIf Request_URI \.gif image-request
SetEnvIf Request_URI \.jpg image-request
SetEnvIf Request_URI \.png image-request
CustomLog logs/access_log common env=!image-request</pre>


    
    <h3><a name="image-theft" id="image-theft">Pr&#233;vention du "Vol d'image"</a></h3>
        

        <p>Cet exemple montre comment emp&#234;cher les utilisateurs ne faisant pas
	partie de votre serveur d'utiliser des images de votre serveur comme
	images en ligne dans leurs pages. Cette configuration n'est pas
	recommand&#233;e, mais elle peut fonctionner dans des circonstances bien
	d&#233;finies. Nous supposons que toutes vos images sont enregistr&#233;es dans
	un r&#233;pertoire nomm&#233; <code>/web/images</code>.</p>
    	<pre class="prettyprint lang-config">SetEnvIf Referer "^http://www\.example\.com/" local_referal
# Autorise les navigateurs qui n'envoient aucune information de Referer
SetEnvIf Referer "^$" local_referal
&lt;Directory "/web/images"&gt;
    Require env local_referal
&lt;/Directory&gt;</pre>


        <p>Pour plus d'informations sur cette technique, voir le tutoriel sur
	ServerWatch
	"<a href="http://www.serverwatch.com/tutorials/article.php/1132731">Keeping Your Images from Adorning Other Sites</a>".</p>
    
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/env.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/env.html" title="Fran&#231;ais">&nbsp;fr&nbsp;</a> |
<a href="./ja/env.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/env.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/env.html" hreflang="tr" rel="alternate" title="T&#252;rk&#231;e">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="./images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/env.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris&#233; sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>