<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_privileges - Serveur HTTP Apache Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_privileges</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_privileges.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_privileges.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Support des privilges de Solaris et de l'excution des
serveurs virtuels sous diffrents identifiants
utilisateurs.</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>privileges_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_privileges.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3 d'Apache sur les
plates-formes Solaris 10 et OpenSolaris</td></tr></table>
<h3>Sommaire</h3>

<p>Ce module permet l'excution de diffrents serveurs virtuels sous
diffrents identifiants Unix <var>User</var> et <var>Group</var>,
et avec diffrents <a href="http://sosc-dr.sun.com/bigadmin/features/articles/least_privilege.jsp">Privilges
Solaris</a>. En particulier, il apporte au problme de
sparation des privilges entre les diffrents serveurs virtuels la
solution que devait apporter le module MPM abandonn perchild. Il
apporte aussi d'autres amliorations en matire de scurit.</p>

<p> la diffrence de perchild, <code class="module"><a href="../mod/mod_privileges.html">mod_privileges</a></code> n'est
pas un module MPM. Il travaille <em>au sein</em> d'un modle de
traitement pour dfinir les privilges et les User/Group <em>pour chaque
requte</em> dans un mme processus. Il n'est donc pas compatible avec
les MPM threads, et refusera de s'excuter en cas d'utilisation d'un de
ces derniers.</p>

<p><code class="module"><a href="../mod/mod_privileges.html">mod_privileges</a></code> traite des problmes de scurit
similaires  ceux de <a href="../suexec.html">suexec</a> ; mais  la
diffrence de ce dernier, il ne s'applique pas seulement aux programmes
CGI, mais  l'ensemble du cycle de traitement d'une requte, y compris
les applications in-process et les sous-processus. Il convient
particulirement  l'excution des applications PHP sous
<strong>mod_php</strong>, qui est lui-mme incompatible avec les modules
MPM threads. Il est galement bien adapt aux autres applications de type
script in-process comme <strong>mod_perl</strong>,
<strong>mod_python</strong>, et <strong>mod_ruby</strong>, ainsi qu'aux
applications en langage C telles que les modules Apache pour lesquels la
sparation des privilges constitue un problme.</p>

</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#security">Considrations  propos de scurit</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#dtraceprivileges">DTracePrivileges</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#privilegesmode">PrivilegesMode</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#vhostcgimode">VHostCGIMode</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#vhostcgiprivs">VHostCGIPrivs</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#vhostgroup">VHostGroup</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#vhostprivs">VHostPrivs</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#vhostsecure">VHostSecure</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#vhostuser">VHostUser</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_privileges">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_privileges">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="security" id="security">Considrations  propos de scurit</a></h2>

<p><code class="module"><a href="../mod/mod_privileges.html">mod_privileges</a></code> introduit de nouveaux problmes de
scurit dans les situations o du <strong>code non sr</strong> peut
s'excuter <strong> l'intrieur du processus du serveur web</strong>.
Ceci s'applique aux modules non srs, et aux scripts s'excutant sous
des modules comme mod_php ou mod_perl. Les scripts s'excutant en
externe (comme par exemple les scripts CGI ou ceux s'excutant sur un
serveur d'applications derrire mod_proxy ou mod_jk) ne sont pas
concerns.</p>

<p>Les principaux problmes de scurit que l'on rencontre avec
mod_privileges sont :</p>


<ul><li>L'excution sous un utilisateur systme pose les mmes problmes
de scurit que mod_suexec, et pratiquement les mmes que cgiwrap et
suphp.</li>
<li>Une extension utilisateur (module ou script) malveillante, crite en connaissant les mcanismes
utiliss par <strong>mod_privileges</strong>,
pourrait lever ses privilges  tout niveau
accessible au processus httpd dans tout serveur virtuel. Ceci introduit
de nouveaux risques si (et seulement si) mod_privileges est compil avec
l'option <var>BIG_SECURITY_HOLE</var>.</li>
<li>Une extension utilisateur (module ou script) malveillante, crite en connaissant les mcanismes
utiliss par <strong>mod_privileges</strong>,
pourrait lever ses privilges pour s'attribuer
l'identifiant utilisateur d'un autre utilisateur (et/ou groupe)
systme.</li>
</ul>

<p>La directive <code class="directive">PrivilegesMode</code> vous permet de
slectionner soit le mode <var>FAST</var>, soit le mode
<var>SECURE</var>. Vous pouvez panacher les modes en utilisant par
exemple le mode <var>FAST</var> pour les utilisateurs de confiance et
les chemins contenant du code entirement audit, tout en imposant le
mode <var>SECURE</var> o un utilisateur non sr a la possibilit
d'introduire du code.</p>
<p>Avant de dcrire les modes, il nous faut prsenter les cas
d'utilisation de la cible : "Benign" ou "Hostile". Dans une situation
"Benign", vous voulez sparer les utilisateurs pour leur confort, et les
protger, ainsi que le serveur, contre les risques induits par les
erreurs involontaires. Dans une situation "Hostile" - par exemple
l'hbergement d'un site commercial - il se peut que des utilisateurs
attaquent dlibrment le serveur ou s'attaquent entre eux.</p>
<dl>
<dt>Mode FAST</dt>
<dd>En mode <var>FAST</var>, les requtes sont traites "in-process"
avec les uid/gid et privilges slectionns, si bien que la
surcharge est ngligeable. Ceci convient aux situations "Benign", mais
n'est pas scuris contre un attaquant augmentant ses privilges avec un
module ou script "in-process".</dd>
<dt>Mode SECURE</dt>
<dd>Une requte en mode <var>SECURE</var> gnre un sous-processus qui
supprime les privilges. Ce comportement est trs similaire 
l'excution d'un programme CGI avec suexec, mais il reste valable tout
au long du cycle de traitement de la requte, avec en plus l'avantage
d'un contrle prcis des privilges.</dd>
</dl>
<p>Vous pouvez slectionner diffrents
<code class="directive">PrivilegesMode</code>s pour chaque serveur virtuel, et
mme dans un contexte de rpertoire  l'intrieur d'un serveur virtuel.
Le mode <var>FAST</var> convient lorsque les utilisateurs sont srs
et/ou n'ont pas le privilge de charger du code "in-process". Le mode
<var>SECURE</var> convient dans les cas o du code non sr peut
s'excuter "in-process".  Cependant, mme en mode <var>SECURE</var>, il
n'y a pas de protection contre un utilisateur malveillant qui a la
possibilit d'introduire du code supportant les privilges <em>avant le
dbut du cycle de traitement de la requte.</em></p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="dtraceprivileges" id="dtraceprivileges">Directive</a> <a name="DTracePrivileges" id="DTracePrivileges">DTracePrivileges</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si les privilges requis par dtrace sont
activs.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DTracePrivileges On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>DTracePrivileges Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_privileges</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>&gt;Disponible sous Solaris 10 et OpenSolaris avec les
modules MPM non-threads (<code class="module"><a href="../mod/prefork.html">prefork</a></code> ou MPM
personnalis).</td></tr>
</table>
    <p>Cette directive qui s'applique  l'ensemble du serveur permet de
    dterminer si Apache s'excutera avec les <a href="http://sosc-dr.sun.com/bigadmin/features/articles/least_privilege.jsp">privilges</a> requis pour excuter <a href="http://sosc-dr.sun.com/bigadmin/content/dtrace/">dtrace</a>.
    Notez que la dfinition <var>DTracePrivileges On</var> n'activera
    pas  elle-seule DTrace, mais que <var>DTracePrivileges Off</var>
    l'empchera de fonctionner.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="privilegesmode" id="privilegesmode">Directive</a> <a name="PrivilegesMode" id="PrivilegesMode">PrivilegesMode</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fait un compromis entre d'une part l'efficacit et la
vitesse de traitement et d'autre part la scurit  l'encontre des codes
malicieux supportant les privilges.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>PrivilegesMode FAST|SECURE|SELECTIVE</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>PrivilegesMode FAST</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_privileges</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible sous Solaris 10 et OpenSolaris avec des
modules MPMs non threads (comme <code class="module"><a href="../mod/prefork.html">prefork</a></code> ou un module
personnalis).</td></tr>
</table><p>Cette directive permet de faire un compromis entre les
performances et la scurit  l'encontre des codes malicieux supportant
les privilges. En mode <var>SECURE</var>, chaque requte est traite
dans un sous-processus scuris, ce qui induit une dgradation sensible
des performances. En mode <var>FAST</var>, le serveur n'est pas protg
contre l'augmentation de privilge comme dcrit plus haut.</p>
<p>Cette directive est sensiblement diffrente selon qu'elle se trouve
dans une section <code>&lt;Directory&gt;</code> (ou Location/Files/If)
ou au niveau global ou dans un <code>&lt;VirtualHost&gt;</code>.</p>
<p>Au niveau global, elle dfinit un comportement par dfaut dont
hriteront les serveurs virtuels. Dans un serveur virtuel, les modes
FAST ou SECURE agissent sur l'ensemble de la requte HTTP, et toute
dfinition de ces modes dans une section <code>&lt;Directory&gt;</code>
sera <strong>ignore</strong>. Le pseudo-mode SELECTIVE confie le choix
du mode FAST ou SECURE aux directives contenues dans une
section<code>&lt;Directory&gt;</code>.</p>
<p>Dans une section <code>&lt;Directory&gt;</code>, elle ne s'applique
que lorsque le mode SELECTIVE a t dfini pour le serveur virtuel.
Seuls FAST ou SECURE peuvent tre dfinis dans ce contexte (SELECTIVE
n'aurait pas de sens).</p>
<div class="warning"><h3>Avertissement</h3>
	Lorsque le mode SELECTIVE a t dfini pour un serveur virtuel,
	l'activation des privilges doit tre reporte <em>aprs</em>
	la dtermination, par la phase de comparaison du traitement de
	la requte, du contexte <code>&lt;Directory&gt;</code> qui
	s'applique  la requte. Ceci peut donner  un attaquant
	l'opportunit d'introduire du code via une directive <code class="directive"><a href="../mod/mod_rewrite.html#rewritemap">RewriteMap</a></code> s'excutant au
	niveau global ou d'un serveur virtuel <em>avant</em> que les
	privilges n'aient t supprims et l'uid/gid dfini.
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="vhostcgimode" id="vhostcgimode">Directive</a> <a name="VHostCGIMode" id="VHostCGIMode">VHostCGIMode</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si le serveur virtuel peut excuter des
sous-processus, et dfinit les privilges disponibles pour ces
dernier.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>VHostCGIMode On|Off|Secure</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>VHostCGIMode On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_privileges</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible sous Solaris 10 et OpenSolaris avec les
modules MPM non-threads (<code class="module"><a href="../mod/prefork.html">prefork</a></code> ou MPM
personnalis).</td></tr>
</table>
    <p>Dtermine si le serveur virtuel est autoris  excuter fork et
    exec, et dfinit les <a href="http://sosc-dr.sun.com/bigadmin/features/articles/least_privilege.jsp">privilges</a> requis pour excuter des sous-processus. Si cette
    directive est dfinie  <var>Off</var> le serveur virtuel ne
    disposera d'aucun privilge et ne pourra excuter ni des programmes
    ou scripts CGI classiques via le module traditionnel
    <code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code>, ni des programmes externes similaires tels
    que ceux crs via le module <code class="module"><a href="../mod/mod_ext_filter.html">mod_ext_filter</a></code> ou les
    programmes de rcriture externes utiliss par la directive
    <code class="directive"><a href="../mod/mod_rewrite.html#rewritemap">RewriteMap</a></code>. Notez que
    ceci n'empche pas l'excution de programmes CGI via d'autres
    processus et sous d'autres modles de scurit comme <a href="https://httpd.apache.org/mod_fcgid/">mod_fcgid</a>, ce qui est la
    solution recommande sous Solaris.</p>
    <p>Si cette directive est dfinie  <var>On</var> ou
    <var>Secure</var>, le serveur virtuel pourra excuter les scripts et
    programmes externes cits ci-dessus. Dfinir la directive
    <code class="directive">VHostCGIMode</code>  <var>Secure</var> a pour effet
    supplmentaire de n'accorder aucun privilge aux sous-processus,
    comme dcrit dans la directive
    <code class="directive">VHostSecure</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="vhostcgiprivs" id="vhostcgiprivs">Directive</a> <a name="VHostCGIPrivs" id="VHostCGIPrivs">VHostCGIPrivs</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Assigne des privilges au choix aux sous-processus crs
par un serveur virtuel.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>VHostPrivs [+-]?<var>nom-privilge</var> [[+-]?nom-privilge] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Aucun</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_privileges</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible sous Solaris 10 et OpenSolaris avec les
modules MPM non-threads (<code class="module"><a href="../mod/prefork.html">prefork</a></code> ou MPM
personnalis) et lorsque <code class="module"><a href="../mod/mod_privileges.html">mod_privileges</a></code> est construit
avec l'option de compilation
<var>BIG_SECURITY_HOLE</var>.</td></tr>
</table>
    <p>La directive <code class="directive">VHostCGIPrivs</code> permet
    d'assigner des <a href="http://sosc-dr.sun.com/bigadmin/features/articles/least_privilege.jsp">privilges</a> au choix aux sous-processus crs par un serveur
    virtuel, comme dcrit dans la directive
    <code class="directive">VHostCGIMode</code>. Chaque
    <var>nom-privilge</var> correspond  un privilge Solaris tel que
    <var>file_setid</var> ou <var>sys_nfs</var>.</p>

    <p><var>nom-privilge</var> peut tre ventuellement prfix par +
    ou -, ce qui va respectivement accorder ou refuser le privilge. Si
    <var>nom-privilge</var> est spcifi sans + ni -, tous les autres
    privilges pralablement assigns au serveur virtuel seront refuss.
    Cette directive permet de construire aisment votre propre jeu de
    privilges en annulant tout rglage par dfaut.</p>

    <div class="warning"><h3>Scurit</h3>
    <p>L'utilisation de cette directive peut ouvrir d'immenses trous de
    scurit dans les sous-processus Apache, jusqu' leur excution avec les
    droits de root. Ne l'utilisez que si vous tes absolument sr de
    comprendre ce que vous faites !</p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="vhostgroup" id="vhostgroup">Directive</a> <a name="VHostGroup" id="VHostGroup">VHostGroup</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit l'identifiant du groupe sous lequel s'excute un
serveur virtuel.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>VHostGroup <var>identifiant-groupe-unix</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Hrite de l'identifiant du groupe spcifi par la directive
<code class="directive"><a href="../mod/mod_unixd.html#group">Group</a></code></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_privileges</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible sous Solaris 10 et OpenSolaris avec les
modules MPM non-threads (<code class="module"><a href="../mod/prefork.html">prefork</a></code> ou MPM
personnalis).</td></tr>
</table>
    <p>La directive <code class="directive">VHostGroup</code> permet de dfinir
    l'identifiant du groupe unix sous lequel le serveur va traiter les
    requtes par l'intermdiaire d'un serveur virtuel. L'identifiant
    du groupe est dfini avant le traitement de la requte, puis
    restaur  sa valeur de dpart via les <a href="http://sosc-dr.sun.com/bigadmin/features/articles/least_privilege.jsp">Privilges
    Solaris</a>. Comme la dfinition
    s'applique au <em>processus</em>, cette directive est incompatible
    avec les modules MPM threads.</p>
    <p><var>Unix-group</var> peut tre :</p>
    <dl>
      <dt>Un nom de groupe</dt>
      <dd>Fait rfrence au groupe donn par son nom.</dd>

      <dt><code>#</code> suivi d'un numro de groupe.</dt>
      <dd>Fait rfrence au groupe donn par son numro.</dd>
    </dl>

    <div class="warning"><h3>Scurit</h3>
    <p>Cette directive ne peut pas tre utilise pour excuter Apache en
    tant que root ! Elle est tout de mme susceptible de poser des
    problmes de scurit similaires  ceux dcrits dans la
    documentation de <a href="../suexec.html">suexec</a>.</p></div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_unixd.html#group">Group</a></code></li>
<li><code class="directive"><a href="../mod/mod_suexec.html#suexecusergroup">SuexecUserGroup</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="vhostprivs" id="vhostprivs">Directive</a> <a name="VHostPrivs" id="VHostPrivs">VHostPrivs</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Assigne des privilges  un serveur virtuel.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>VHostPrivs [+-]?<var>nom-privilge</var> [[+-]?nom-privilge] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Aucun</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_privileges</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible sous Solaris 10 et OpenSolaris avec les
modules MPM non-threads (<code class="module"><a href="../mod/prefork.html">prefork</a></code> ou MPM
personnalis) et lorsque <code class="module"><a href="../mod/mod_privileges.html">mod_privileges</a></code> est construit
avec l'option de compilation
<var>BIG_SECURITY_HOLE</var>.</td></tr>
</table>
    <p>La directive <code class="directive">VHostPrivs</code> permet d'assigner
    des <a href="http://sosc-dr.sun.com/bigadmin/features/articles/least_privilege.jsp">privilges</a> au choix  un serveur virtuel. Chaque
    <var>nom-privilge</var> correspond  un privilge Solaris tel que
    <var>file_setid</var> ou <var>sys_nfs</var>.</p>

    <p><var>nom-privilge</var> peut tre ventuellement prfix par +
    ou -, ce qui va respectivement accorder ou refuser le privilge. Si
    <var>nom-privilge</var> est spcifi sans + ni -, tous les autres
    privilges pralablement assigns au serveur virtuel seront refuss.
    Cette directive permet de construire aisment votre propre jeu de
    privilges en annulant tout rglage par dfaut.</p>

    <div class="warning"><h3>Scurit</h3>
    <p>L'utilisation de cette directive peut ouvrir d'immenses trous de
    scurit dans Apache, jusqu'au traitement de requtes avec les
    droits de root. Ne l'utilisez que si vous tes absolument sr de
    comprendre ce que vous faites !</p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="vhostsecure" id="vhostsecure">Directive</a> <a name="VHostSecure" id="VHostSecure">VHostSecure</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si le serveur s'excute avec une scurit avance
pour les serveurs virtuels.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>VHostSecure On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>VHostSecure On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_privileges</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible sous Solaris 10 et OpenSolaris avec les
modules MPM non-threads (<code class="module"><a href="../mod/prefork.html">prefork</a></code> ou MPM
personnalis).</td></tr>
</table>
    <p>Dtermine si les serveurs virtuels traitent les requtes avec une
    scurit avance en supprimant les <a href="http://sosc-dr.sun.com/bigadmin/features/articles/least_privilege.jsp">Privilges</a> rarement requis par un serveur web, mais disponibles
    par dfaut pour un utilisateur Unix standard, et donc susceptibles
    d'tre demands par des modules et des applications. Il est
    recommand de conserver la dfinition par dfaut (On), sauf si elle
    empche une application de fonctionner. Comme la dfinition
    s'applique au <em>processus</em>, cette directive est incompatible
    avec les modules MPM threads.</p>
    <div class="note"><h3>Note</h3>
    <p>Le fait que la directive <code class="directive">VHostSecure</code>
    empche une application de fonctionner peut constituer un signal
    d'avertissement indiquant que la scurit de l'application doit tre
    revue.</p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="vhostuser" id="vhostuser">Directive</a> <a name="VHostUser" id="VHostUser">VHostUser</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit l'identifiant utilisateur sous lequel s'excute un
serveur virtuel.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>VHostUser <var>identifiant-utilisateur-unix</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Hrite de l'identifiant utilisateur spcifi par la directive
<code class="directive"><a href="../mod/mod_unixd.html#user">User</a></code></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Exprimental</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_privileges</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible sous Solaris 10 et OpenSolaris avec les
modules MPM non-threads (<code class="module"><a href="../mod/prefork.html">prefork</a></code> ou MPM
personnalis).</td></tr>
</table>
    <p>La directive <code class="directive">VHostUser</code> permet de dfinir
    l'identifiant utilisateur unix sous lequel le serveur va traiter les
    requtes par l'intermdiaire d'un serveur virtuel. L'identifiant
    utilisateur est dfini avant le traitement de la requte, puis
    restaur  sa valeur de dpart via les <a href="http://sosc-dr.sun.com/bigadmin/features/articles/least_privilege.jsp">Privilges
    Solaris</a>. Comme la dfinition
    s'applique au <em>processus</em>, cette directive est incompatible
    avec les modules MPM threads.</p>
    <p><var>identifiant-utilisateur-unix</var> peut tre :</p>
    <dl>
      <dt>Un nom d'utilisateur</dt>
      <dd>Fait rfrence  l'utilisateur donn par son nom.</dd>

      <dt><code>#</code> suivi d'un numro d'utilisateur.</dt>
      <dd>Fait rfrence  l'utilisateur donn par son numro.</dd>
    </dl>

    <div class="warning"><h3>Scurit</h3>
    <p>Cette directive ne peut pas tre utilise pour excuter Apache en
    tant que root ! Elle est tout de mme susceptible de poser des
    problmes de scurit similaires  ceux dcrits dans la
    documentation de <a href="../suexec.html">suexec</a>.</p></div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_unixd.html#user">User</a></code></li>
<li><code class="directive"><a href="../mod/mod_suexec.html#suexecusergroup">SuexecUserGroup</a></code></li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_privileges.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_privileges.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_privileges.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>