/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import com.jcraft.jsch.agentproxy.usocket.NCUSocketFactory;
import java.util.ArrayList;

public abstract class ConnectorFactory {
    protected String connectors = "pageant,ssh-agent";
    protected String usocketFactories = "nc,jna";
    protected String usocketPath = null;

    public void setPreferredConnectors(String connectors) {
        this.connectors = connectors;
    }

    public String getPreferredConnectors() {
        return this.connectors;
    }

    public void setPreferredUSocketFactories(String usocketFactories) {
        this.usocketFactories = usocketFactories;
    }

    public String getPreferredUSocketFactories() {
        return this.usocketFactories;
    }

    public void setUSocketPath(String usocketPath) {
        this.usocketPath = usocketPath;
    }

    public String getUSocketPath() {
        return this.usocketPath;
    }

    public Connector createConnector() throws AgentProxyException {
        ArrayList<String> trials = new ArrayList<String>();
        String[] _connectors = this.connectors.split(",");
        for (int i = 0; i < _connectors.length; ++i) {
            if (_connectors[i].trim().equals("pageant")) {
                if (!PageantConnector.isConnectorAvailable()) continue;
                try {
                    return new PageantConnector();
                }
                catch (AgentProxyException e2) {
                    trials.add("pageant");
                    continue;
                }
            }
            if (!_connectors[i].trim().equals("ssh-agent") || !SSHAgentConnector.isConnectorAvailable(this.usocketPath)) continue;
            String[] _usocketFactories = this.usocketFactories.split(",");
            for (int j = 0; j < _usocketFactories.length; ++j) {
                USocketFactory usf;
                if (_usocketFactories[j].trim().equals("nc")) {
                    try {
                        usf = new NCUSocketFactory();
                        return new SSHAgentConnector(usf, this.usocketPath);
                    }
                    catch (AgentProxyException e3) {
                        trials.add("ssh-agent:nc");
                        continue;
                    }
                }
                if (!_usocketFactories[j].trim().equals("jna")) continue;
                try {
                    usf = new JNAUSocketFactory();
                    return new SSHAgentConnector(usf, this.usocketPath);
                }
                catch (AgentProxyException e4) {
                    trials.add("ssh-agent:jna");
                }
            }
        }
        String message = "connector is not available: ";
        String foo = "";
        for (int i = 0; i < trials.size(); ++i) {
            message = message + foo + (String)trials.get(i);
            foo = ",";
        }
        throw new AgentProxyException(message);
    }

    public static ConnectorFactory getDefault() {
        return new Default();
    }

    static class Default
    extends ConnectorFactory {
        Default() {
            String osName = System.getProperty("os.name");
            if (osName != null && !osName.startsWith("Windows")) {
                this.setPreferredConnectors("ssh-agent");
            }
        }
    }
}

