/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.elasticsearch.index.analysis.TokenFilterFactory;

public class ASCIIFoldingTokenFilterFactory
extends AbstractTokenFilterFactory
implements MultiTermAwareComponent {
    public static final ParseField PRESERVE_ORIGINAL = new ParseField("preserve_original", new String[0]);
    public static final boolean DEFAULT_PRESERVE_ORIGINAL = false;
    private final boolean preserveOriginal;

    public ASCIIFoldingTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.preserveOriginal = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), PRESERVE_ORIGINAL.getPreferredName(), Boolean.valueOf(false), this.deprecationLogger);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ASCIIFoldingFilter(tokenStream, this.preserveOriginal);
    }

    public Object getMultiTermComponent() {
        if (!this.preserveOriginal) {
            return this;
        }
        return new TokenFilterFactory(){

            public String name() {
                return ASCIIFoldingTokenFilterFactory.this.name();
            }

            public TokenStream create(TokenStream tokenStream) {
                return new ASCIIFoldingFilter(tokenStream, false);
            }
        };
    }
}

