/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.xlib;

import gnu.awt.xlib.XCanvasPeer;
import gnu.gcj.xlib.Display;
import gnu.gcj.xlib.Screen;
import gnu.gcj.xlib.WMSizeHints;
import gnu.gcj.xlib.Window;
import gnu.gcj.xlib.XConfigureEvent;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.peer.FramePeer;

public class XFramePeer
extends XCanvasPeer
implements FramePeer {
    private boolean processingConfigureNotify = false;
    static final Insets INSETS_0_PROTOTYPE = new Insets(0, 0, 0, 0);

    public XFramePeer(Frame frame) {
        super(frame);
        if (frame.getFont() == null) {
            frame.setFont(new Font("helvetica", 0, 12));
        }
        if (frame.getBackground() == null) {
            frame.setBackground(Color.lightGray);
        }
        if (frame.getForeground() == null) {
            frame.setForeground(Color.black);
        }
    }

    Window locateParentWindow(Rectangle bounds) {
        Screen screen = this.config.getVisual().getScreen();
        return screen.getRootWindow();
    }

    void initWindowProperties() {
        Frame frame = (Frame)this.component;
        this.setResizable(frame.isResizable());
        String title = frame.getTitle();
        if (!title.equals("")) {
            this.setTitle(title);
        }
    }

    long getBasicEventMask() {
        return super.getBasicEventMask() | 0x20000L;
    }

    void configureNotify(XConfigureEvent configEvent) {
        this.processingConfigureNotify = true;
        this.component.setBounds(configEvent.getBounds());
        this.processingConfigureNotify = false;
    }

    public void setBounds(int x, int y, int width, int height) {
        if (!this.processingConfigureNotify) {
            super.setBounds(x, y, width, height);
        }
    }

    public Insets getInsets() {
        return (Insets)INSETS_0_PROTOTYPE.clone();
    }

    public Insets insets() {
        return this.getInsets();
    }

    public void beginValidate() {
    }

    public void endValidate() {
        Frame frame = (Frame)this.component;
        this.setResizable(frame.isResizable());
    }

    public void toBack() {
        this.window.toBack();
    }

    public void toFront() {
        this.window.toFront();
    }

    public void setIconImage(Image image) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setMenuBar(MenuBar mb) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String title) {
        Display display = this.window.getDisplay();
        synchronized (display) {
            this.window.setProperty("WM_NAME", "STRING", title);
            this.ensureFlush();
        }
    }

    public void setResizable(boolean resizable) {
        Frame frame = (Frame)this.component;
        WMSizeHints sizeHints = new WMSizeHints();
        if (resizable) {
            Dimension minSize = frame.getMinimumSize();
            sizeHints.setMinSize(minSize.width, minSize.height);
            Dimension maxSize = frame.getMaximumSize();
            if (maxSize.width < Short.MAX_VALUE || maxSize.height < Short.MAX_VALUE) {
                maxSize.width = Math.min(maxSize.width, Short.MAX_VALUE);
                maxSize.height = Math.min(maxSize.height, Short.MAX_VALUE);
                sizeHints.setMaxSize(maxSize.width, maxSize.height);
            }
        } else {
            Dimension size = frame.getSize();
            sizeHints.setMinSize(size.width, size.height);
            sizeHints.setMaxSize(size.width, size.height);
        }
        sizeHints.applyNormalHints(this.window);
    }

    public int getState() {
        return 0;
    }

    public void setState(int state) {
    }

    public void setMaximizedBounds(Rectangle r) {
    }

    public void beginLayout() {
    }

    public void endLayout() {
    }

    public boolean isPaintPending() {
        return false;
    }

    public void setBoundsPrivate(int x, int y, int width, int height) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Rectangle getBoundsPrivate() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void updateAlwaysOnTop() {
    }

    public boolean requestWindowFocus() {
        return false;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void updateFocusableWindowState() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setModalBlocked(Dialog blocker, boolean blocked) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void updateMinimumSize() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void updateIconImages() {
        throw new UnsupportedOperationException("not implemented yet");
    }
}

