/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.autofit;

import gnu.java.awt.font.autofit.GlyphHints;
import gnu.java.awt.font.autofit.HintScaler;
import gnu.java.awt.font.autofit.Latin;
import gnu.java.awt.font.autofit.LatinMetrics;
import gnu.java.awt.font.opentype.Hinter;
import gnu.java.awt.font.opentype.OpenTypeFont;
import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Zone;

public class AutoHinter
implements Hinter {
    Latin latinScript;
    LatinMetrics metrics;
    GlyphHints hints;
    HintScaler scaler = new HintScaler();

    public void init(OpenTypeFont font) {
        this.latinScript = new Latin();
        this.metrics = new LatinMetrics(font);
        this.latinScript.initMetrics(this.metrics, font);
        this.scaler.face = font;
    }

    public void applyHints(Zone outline) {
        if (this.hints == null) {
            this.hints = new GlyphHints();
        }
        this.scaler.xScale = Fixed.valueOf16(outline.scaleX * 64.0);
        this.scaler.yScale = Fixed.valueOf16(outline.scaleY * 64.0);
        this.latinScript.scaleMetrics(this.metrics, this.scaler);
        this.latinScript.applyHints(this.hints, outline, this.metrics);
    }

    public void setFlags(int flags) {
        if (this.hints == null) {
            this.hints = new GlyphHints();
        }
        this.hints.flags = flags;
    }
}

