/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.autofit;

import gnu.java.awt.font.autofit.Edge;
import gnu.java.awt.font.autofit.Segment;

class AxisHints {
    Segment[] segments = new Segment[4];
    int majorDir;
    int numSegments;
    int numEdges;
    Edge[] edges = new Edge[4];

    AxisHints() {
    }

    Segment newSegment() {
        Segment seg;
        if (this.numSegments >= this.segments.length) {
            int newMax = this.segments.length;
            newMax += (newMax >> 2) + 4;
            Segment[] newSegs = new Segment[newMax];
            System.arraycopy(this.segments, 0, newSegs, 0, this.numSegments);
            this.segments = newSegs;
        }
        this.segments[this.numSegments] = seg = new Segment();
        ++this.numSegments;
        return seg;
    }

    public Edge newEdge(int pos) {
        if (this.numEdges >= this.edges.length) {
            int newMax = this.edges.length;
            newMax += (newMax >> 2) + 4;
            Edge[] newEdges = new Edge[newMax];
            System.arraycopy(this.edges, 0, newEdges, 0, this.numEdges);
            this.edges = newEdges;
        }
        int edgeIndex = this.numEdges;
        Edge edge = this.edges[edgeIndex] = new Edge();
        while (edgeIndex > 0 && this.edges[edgeIndex - 1].fpos > pos) {
            this.edges[edgeIndex] = this.edges[edgeIndex - 1];
            --edgeIndex;
        }
        this.edges[edgeIndex] = edge;
        ++this.numEdges;
        edge.fpos = pos;
        return edge;
    }

    int getEdgeIndex(Edge edge2) {
        int idx = -1;
        int i = 0;
        while (i < this.numEdges) {
            if (this.edges[i] == edge2) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }
}

