/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.io;

public class ObjectIdentityMap2Int {
    private static final int[] PRIMES = new int[]{31, 61, 127, 251, 509, 1021, 2039, 4093, 8191, 16381, 32749, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD, 33554393, 0x3FFFFFB, 134217689, 0xFFFFFC7, 0x1FFFFFFD, 0x3FFFFFDD, Integer.MAX_VALUE};
    private static final Object NIL = new Object();
    private Object[] objectTable;
    private int[] intTable;
    private int size = 0;
    private int cap = 0;
    private int limit = 0;

    public ObjectIdentityMap2Int() {
        this.alloc(0);
    }

    private void alloc(int c) {
        if (c >= PRIMES.length) {
            throw new InternalError("Hash table size overflow");
        }
        this.cap = c;
        int len = PRIMES[c];
        this.objectTable = new Object[len];
        this.intTable = new int[len];
        this.limit = len / 4 * 3;
        this.size = 0;
    }

    public void put(Object o, int i) {
        if (i < 0) {
            throw new IllegalArgumentException("int argument must be postive: " + i);
        }
        o = o == null ? NIL : o;
        int s = this.slot(o);
        this.intTable[s] = i;
        if (this.objectTable[s] == null) {
            this.objectTable[s] = o;
            ++this.size;
            if (this.size >= this.limit) {
                this.rehash();
            }
        }
    }

    private int slot(Object o) {
        int len;
        Object[] ot = this.objectTable;
        int hc = System.identityHashCode(o);
        int result = hc % (len = ot.length);
        result = result < 0 ? -result : result;
        int delta = 16 - (hc & 0xF);
        Object existing = ot[result];
        while (existing != null && existing != o) {
            if ((result += delta) >= len) {
                result -= len;
            }
            existing = ot[result];
        }
        return result;
    }

    private void rehash() {
        Object[] ot = this.objectTable;
        int[] it = this.intTable;
        this.alloc(this.cap + 1);
        int i = 0;
        while (i < ot.length) {
            this.put(ot[i], it[i]);
            ++i;
        }
    }

    public int get(Object o) {
        o = o == null ? NIL : o;
        int s = this.slot(o);
        return this.objectTable[s] == null ? -1 : this.intTable[s];
    }

    public void clear() {
        Object[] ot = this.objectTable;
        this.size = 0;
        int i = 0;
        while (i < ot.length) {
            ot[i] = null;
            ++i;
        }
    }
}

