/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.assembly;

import gnu.javax.crypto.assembly.Cascade;
import gnu.javax.crypto.assembly.Transformer;
import gnu.javax.crypto.assembly.TransformerException;
import java.security.InvalidKeyException;
import java.util.Map;

class CascadeTransformer
extends Transformer {
    private Cascade delegate;
    private int blockSize;

    CascadeTransformer(Cascade delegate) {
        this.delegate = delegate;
    }

    void initDelegate(Map attributes) throws TransformerException {
        attributes.put("gnu.crypto.assembly.cascade.direction", this.wired);
        try {
            this.delegate.init(attributes);
        }
        catch (InvalidKeyException x) {
            throw new TransformerException("initDelegate()", x);
        }
        this.blockSize = this.delegate.currentBlockSize();
    }

    int delegateBlockSize() {
        return this.blockSize;
    }

    void resetDelegate() {
        this.delegate.reset();
        this.blockSize = 0;
    }

    byte[] updateDelegate(byte[] in, int offset, int length) throws TransformerException {
        byte[] result = this.updateInternal(in, offset, length);
        return result;
    }

    byte[] lastUpdateDelegate() throws TransformerException {
        if (this.inBuffer.size() != 0) {
            IllegalStateException cause = new IllegalStateException("Cascade transformer, after last update, must be empty but isn't");
            throw new TransformerException("lastUpdateDelegate()", cause);
        }
        return new byte[0];
    }

    private byte[] updateInternal(byte[] in, int offset, int length) {
        byte[] result;
        int i = 0;
        while (i < length) {
            this.inBuffer.write(in[offset++] & 0xFF);
            if (this.inBuffer.size() >= this.blockSize) {
                result = this.inBuffer.toByteArray();
                this.inBuffer.reset();
                this.delegate.update(result, 0, result, 0);
                this.outBuffer.write(result, 0, this.blockSize);
            }
            ++i;
        }
        result = this.outBuffer.toByteArray();
        this.outBuffer.reset();
        return result;
    }
}

