/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGData;
import gnu.javax.imageio.png.PNGException;
import gnu.javax.imageio.png.PNGFilter;
import gnu.javax.imageio.png.PNGHeader;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class PNGDecoder {
    private PNGHeader header;
    private byte[] raster;
    private byte[] scanline;
    private byte[] lastScanline;
    private byte[] filterType;
    private int offset;
    private int length;
    private int currentScanline;
    private final int stride;
    private Inflater inflater;
    private boolean readFilter;
    private int bpp;

    public PNGDecoder(PNGHeader header) {
        this.header = header;
        this.offset = 0;
        this.inflater = new Inflater();
        this.stride = header.getScanlineStride();
        this.length = this.stride * header.getHeight();
        this.raster = new byte[this.length];
        this.scanline = new byte[this.stride];
        this.lastScanline = new byte[this.stride];
        this.currentScanline = 0;
        this.readFilter = true;
        this.bpp = header.bytesPerPixel();
        this.filterType = new byte[1];
        this.inflater = new Inflater();
    }

    private int getBytes(byte[] buf, int offset) throws PNGException {
        try {
            return this.inflater.inflate(buf, offset, buf.length - offset);
        }
        catch (DataFormatException dataFormatException) {
            throw new PNGException("Error inflating data.");
        }
    }

    public void addData(PNGData chunk) throws PNGException {
        int n = 0;
        if (this.isFinished()) {
            return;
        }
        chunk.feedToInflater(this.inflater);
        do {
            if (this.readFilter && this.getBytes(this.filterType, 0) < 1) {
                return;
            }
            n = this.getBytes(this.scanline, this.offset);
            if (this.offset + n < this.stride) {
                this.offset += n;
                this.readFilter = false;
                continue;
            }
            this.scanline = PNGFilter.unFilterScanline(this.filterType[0], this.scanline, this.lastScanline, this.bpp);
            System.arraycopy(this.scanline, 0, this.raster, this.currentScanline * this.stride, this.stride);
            this.lastScanline = this.scanline;
            this.scanline = new byte[this.scanline.length];
            ++this.currentScanline;
            this.readFilter = true;
            this.offset = 0;
        } while (n > 0 && this.currentScanline < this.header.getHeight());
    }

    public WritableRaster getRaster(PNGHeader header) {
        SampleModel sm = null;
        DataBuffer db = null;
        int width = header.getWidth();
        int height = header.getHeight();
        int depth = header.getDepth();
        block0 : switch (header.getColorType()) {
            case 4: {
                int t;
                if (depth == 8) {
                    t = 0;
                    db = this.getByteBuffer();
                } else {
                    t = 1;
                    db = this.getShortBuffer();
                }
                int[] nArray = new int[2];
                nArray[1] = 1;
                sm = new ComponentSampleModel(t, width, height, 2, width * 2, nArray);
                break;
            }
            case 0: {
                switch (depth) {
                    case 16: {
                        sm = new ComponentSampleModel(1, width, height, 1, width, new int[1]);
                        db = this.getShortBuffer();
                        break block0;
                    }
                    case 8: {
                        sm = new ComponentSampleModel(0, width, height, 1, width, new int[1]);
                        db = this.getByteBuffer();
                        break block0;
                    }
                }
                sm = new MultiPixelPackedSampleModel(0, width, height, depth);
                db = this.getByteBuffer();
                break;
            }
            case 2: {
                int t;
                if (depth == 8) {
                    t = 0;
                    db = this.getByteBuffer();
                } else {
                    t = 1;
                    db = this.getShortBuffer();
                }
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                sm = new ComponentSampleModel(t, width, height, 3, 3 * width, nArray);
                break;
            }
            case 6: {
                int t;
                if (depth == 8) {
                    t = 0;
                    db = this.getByteBuffer();
                } else {
                    t = 1;
                    db = this.getShortBuffer();
                }
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                sm = new ComponentSampleModel(t, width, height, 4, width * 4, nArray);
                break;
            }
            case 3: {
                sm = depth == 8 ? new SinglePixelPackedSampleModel(0, width, height, new int[]{255}) : new MultiPixelPackedSampleModel(0, width, height, depth);
                db = this.getByteBuffer();
            }
        }
        return Raster.createWritableRaster(sm, db, null);
    }

    private DataBuffer getShortBuffer() {
        short[] data = new short[this.raster.length >> 1];
        int i = 0;
        while (i < data.length) {
            data[i] = (short)((this.raster[i * 2] & 0xFF) << 8 | this.raster[i * 2 + 1] & 0xFF);
            ++i;
        }
        return new DataBufferUShort(data, data.length);
    }

    private DataBuffer getByteBuffer() {
        return new DataBufferByte(this.raster, this.raster.length);
    }

    public ColorModel getColorModel(ColorSpace cs, int colorType, int depth) {
        int[] bits;
        boolean hasAlpha = false;
        switch (colorType) {
            case 4: {
                if (cs == null) {
                    cs = ColorSpace.getInstance(1003);
                }
                hasAlpha = true;
                bits = new int[]{depth, depth};
                break;
            }
            case 2: {
                bits = new int[]{depth, depth, depth};
                break;
            }
            case 6: {
                hasAlpha = true;
                bits = new int[]{depth, depth, depth, depth};
                break;
            }
            case 0: {
                if (depth < 8) {
                    return this.grayPalette(depth);
                }
                if (cs == null) {
                    cs = ColorSpace.getInstance(1003);
                }
                bits = new int[]{depth};
                break;
            }
            default: {
                return null;
            }
        }
        if (cs == null) {
            cs = ColorSpace.getInstance(1000);
        }
        return new ComponentColorModel(cs, bits, hasAlpha, false, hasAlpha ? 3 : 1, depth == 16 ? 1 : 0);
    }

    private IndexColorModel grayPalette(int depth) {
        byte[] c = new byte[1 << depth];
        int i = 0;
        while (i < c.length) {
            c[i] = (byte)(255.0 * ((double)i / ((double)c.length - 1.0)));
            ++i;
        }
        return new IndexColorModel(8, c.length, c, c, c);
    }

    public byte[] getRaster() {
        return this.raster;
    }

    public boolean isFinished() {
        return this.currentScanline >= this.header.getHeight();
    }
}

