/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.naming.jndi.url.rmi;

import gnu.javax.naming.jndi.url.rmi.ContextContinuation;
import gnu.javax.naming.jndi.url.rmi.ListBindingsEnumeration;
import gnu.javax.naming.jndi.url.rmi.ListEnumeration;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class rmiURLContext
implements Context {
    public static final String DEFAULT_REGISTRY_LOCATION = "rmi://localhost:1099";
    static WeakHashMap registryCache = new WeakHashMap();
    Properties properties = new Properties();
    boolean lookupCalled;

    public Object addToEnvironment(String key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.properties.put(key, value);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.properties;
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.properties.remove(propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registry getRegistry(String netAddress) throws NamingException {
        Registry registry;
        WeakHashMap weakHashMap = registryCache;
        synchronized (weakHashMap) {
            registry = (Registry)registryCache.get(netAddress);
        }
        if (registry == null) {
            int port;
            int colon = netAddress.lastIndexOf(58);
            try {
                if (colon >= 0) {
                    port = Integer.parseInt(netAddress.substring(colon + 1));
                    netAddress = netAddress.substring(0, colon);
                } else {
                    port = 1099;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidNameException(netAddress);
            }
            try {
                registry = LocateRegistry.getRegistry(netAddress, port);
            }
            catch (RemoteException e) {
                throw new CommunicationException(e.toString());
            }
            WeakHashMap weakHashMap2 = registryCache;
            synchronized (weakHashMap2) {
                registryCache.put(netAddress, registry);
            }
        }
        return registry;
    }

    public rmiURLContext(Map props) {
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        try {
            String[] n = this.split(name);
            this.getRegistry(n[0]).bind(n[1], (Remote)obj);
        }
        catch (AccessException e) {
            throw new NamingException("access:" + e.toString());
        }
        catch (RemoteException e) {
            throw new CommunicationException(e.toString());
        }
        catch (AlreadyBoundException alreadyBoundException) {
            throw new NameAlreadyBoundException(name);
        }
        catch (ClassCastException classCastException) {
            throw new NamingException("Only Remote can be bound:" + obj.getClass().getName());
        }
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            return new rmiURLContext(this.properties);
        }
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String name) throws NamingException {
        if (name.length() == 0) {
            return new rmiURLContext(this.properties);
        }
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getNameInNamespace() throws NamingException {
        return this.properties.getProperty("java.naming.provider.url", DEFAULT_REGISTRY_LOCATION);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        try {
            String[] n = this.split(name);
            if (n[1].length() > 0) {
                throw new InvalidNameException(String.valueOf(name) + ", the name part must be empty");
            }
            return new ListEnumeration(this.getRegistry(n[0]).list());
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        try {
            String[] n = this.split(name);
            if (n[1].length() > 0) {
                throw new InvalidNameException(String.valueOf(name) + ", the name part must be empty");
            }
            Registry r = this.getRegistry(n[0]);
            return new ListBindingsEnumeration(r.list(), r);
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return new ContextContinuation(this.properties, this.getRegistry(name));
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        try {
            String[] n = this.split(name);
            this.getRegistry(n[0]).rebind(n[1], (Remote)obj);
        }
        catch (AccessException e) {
            throw new NamingException("access:" + e.toString());
        }
        catch (RemoteException e) {
            throw new CommunicationException(e.toString());
        }
        catch (ClassCastException classCastException) {
            throw new NamingException("Only Remote can be bound:" + obj.getClass().getName());
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public synchronized void rename(String oldName, String newName) throws NamingException {
        try {
            String[] n = this.split(oldName);
            Registry r = this.getRegistry(n[0]);
            Remote object = r.lookup(n[1]);
            r.unbind(oldName);
            try {
                String[] n2 = this.split(newName);
                Registry r2 = this.getRegistry(n2[0]);
                r2.bind(n2[1], object);
            }
            catch (AlreadyBoundException alreadyBoundException) {
                try {
                    r.bind(oldName, object);
                }
                catch (AlreadyBoundException alreadyBoundException2) {
                    throw new InternalError();
                }
                throw new NameAlreadyBoundException(newName);
            }
        }
        catch (AccessException e) {
            throw new NamingException(e.toString());
        }
        catch (RemoteException e) {
            throw new CommunicationException(e.toString());
        }
        catch (NotBoundException e) {
            throw new CommunicationException(e.toString());
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String name) throws NamingException {
        try {
            String[] n = this.split(name);
            this.getRegistry(n[0]).unbind(n[1]);
        }
        catch (AccessException e) {
            throw new NamingException(e.toString());
        }
        catch (RemoteException e) {
            throw new CommunicationException(e.toString());
        }
        catch (NotBoundException e) {
            throw new CommunicationException(e.toString());
        }
    }

    public void close() throws NamingException {
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        try {
            String[] n = this.split(name);
            return this.getRegistry(n[0]).lookup(n[1]);
        }
        catch (AccessException e) {
            throw new NamingException(e.toString());
        }
        catch (RemoteException e) {
            throw new CommunicationException(e.toString());
        }
        catch (NotBoundException notBoundException) {
            throw new NameNotFoundException(name);
        }
    }

    public String[] split(String address) throws NamingException {
        String name;
        String net;
        if (!address.startsWith("rmi://")) {
            throw new InvalidNameException(String.valueOf(address) + " should be like 'rmi://localhost:1099/name'");
        }
        String a = address.substring("rmi://".length());
        int sfx = a.indexOf(47);
        while (sfx > 0 && a.charAt(sfx - 1) == '\\') {
            sfx = a.indexOf(47, sfx + 1);
        }
        if (sfx >= 0) {
            net = a.substring(0, sfx);
            name = a.substring(sfx + 1);
        } else {
            net = a;
            name = "";
        }
        return new String[]{net, name};
    }
}

