/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import java.util.logging.Level;

public abstract class DelegatedTask
implements Runnable {
    private static final SystemLogger logger = SystemLogger.SYSTEM;
    private boolean hasRun = false;
    protected Throwable thrown;

    protected DelegatedTask() {
    }

    public final void run() {
        if (this.hasRun) {
            throw new IllegalStateException("task already ran");
        }
        try {
            try {
                logger.logv(Component.SSL_DELEGATED_TASK, "running delegated task {0} in {1}", this, Thread.currentThread());
                this.implRun();
            }
            catch (Throwable t) {
                logger.log((Level)Component.SSL_DELEGATED_TASK, "task threw exception", t);
                this.thrown = t;
                this.hasRun = true;
            }
        }
        finally {
            this.hasRun = true;
        }
    }

    public final boolean hasRun() {
        return this.hasRun;
    }

    public final Throwable thrown() {
        return this.thrown;
    }

    protected abstract void implRun() throws Throwable;
}

