/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.AbstractSessionContext;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.SessionStoreException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SimpleSessionContext
extends AbstractSessionContext {
    public static final int DEFAULT_TIMEOUT = 300;
    private final HashMap<Session.ID, Session> store = new HashMap();
    private int storeLimit = 0;

    public SimpleSessionContext() {
        super(300);
    }

    protected Session implGet(byte[] sessionId) {
        return this.store.get(new Session.ID(sessionId));
    }

    public void load(char[] password) throws SessionStoreException {
    }

    public void put(Session session) {
        if (this.storeLimit > 0 && this.store.size() >= this.storeLimit) {
            Session oldest = null;
            for (Map.Entry<Session.ID, Session> e : this.store.entrySet()) {
                Session s = e.getValue();
                long stamp = s.getLastAccessedTime();
                if (oldest != null && oldest.getLastAccessedTime() <= stamp) continue;
                oldest = s;
            }
            this.store.remove(oldest.id());
        }
        this.store.put(session.id(), session);
    }

    public void remove(byte[] sessionId) {
        this.store.remove(new Session.ID(sessionId));
    }

    public void store(char[] password) throws SessionStoreException {
    }

    public Enumeration getIds() {
        return new Enumeration(){
            Iterator<Session.ID> it;
            {
                this.it = SimpleSessionContext.this.store.keySet().iterator();
            }

            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            public Object nextElement() {
                return this.it.next().id();
            }
        };
    }

    public int getSessionCacheSize() {
        return this.storeLimit;
    }

    public void setSessionCacheSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("cache size must be nonnegative");
        }
        this.storeLimit = size;
    }
}

