/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.SAXEventSink;
import java.util.LinkedList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ls.LSParserFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class FilteredSAXEventSink
extends SAXEventSink {
    final LSParserFilter filter;
    final int whatToShow;
    LinkedList nodes;
    LinkedList decisions;
    boolean rejecting;

    FilteredSAXEventSink(LSParserFilter filter) {
        this.filter = filter;
        this.whatToShow = filter.getWhatToShow();
    }

    public void startDocument() throws SAXException {
        if (this.interrupted) {
            return;
        }
        this.nodes = new LinkedList();
        this.decisions = new LinkedList();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        if (this.interrupted) {
            return;
        }
        super.endDocument();
        switch (this.getDecision(this.ctx, false)) {
            case 2: {
                this.ctx = null;
                this.doc = null;
            }
        }
        this.nodes = null;
        this.decisions = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.rejecting || this.interrupted) {
            return;
        }
        Element element = this.createElement(uri, localName, qName, atts);
        this.ctx = element;
        short decision = this.getDecision(element, true);
        this.nodes.addLast(element);
        this.decisions.addLast(new Short(decision));
        switch (decision) {
            case 2: {
                this.rejecting = true;
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    protected Attr createAttr(Attributes atts, int index) {
        Attr attr = super.createAttr(atts, index);
        short decision = this.getDecision(attr, false);
        switch (decision) {
            case 2: {
                return null;
            }
            case 4: {
                this.interrupted = true;
                return null;
            }
        }
        return attr;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.rejecting || this.interrupted) {
            return;
        }
        super.endElement(uri, localName, qName);
        Element element = (Element)this.nodes.removeLast();
        DomDocument parent = this.nodes.isEmpty() ? this.doc : (Node)this.nodes.getLast();
        this.ctx = parent;
        short decision = (Short)this.decisions.removeLast();
        switch (decision) {
            case 3: {
                Node child = element.getFirstChild();
                while (child != null) {
                    parent.insertBefore(child, element);
                    child = child.getNextSibling();
                }
                return;
            }
            case 2: {
                this.rejecting = false;
            }
        }
        decision = this.getDecision(element, false);
        switch (decision) {
            case 1: {
                parent.appendChild(element);
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    public void characters(char[] c, int off, int len) throws SAXException {
        if (this.rejecting || this.interrupted) {
            return;
        }
        Text text = this.createText(c, off, len);
        short decision = this.getDecision(text, false);
        switch (decision) {
            case 1: {
                this.ctx.appendChild(text);
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.rejecting || this.interrupted || this.inDTD) {
            return;
        }
        Node pi = this.createProcessingInstruction(target, data);
        short decision = this.getDecision(pi, false);
        switch (decision) {
            case 1: {
                this.ctx.appendChild(pi);
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        Node doctype;
        if (this.interrupted) {
            return;
        }
        this.ctx = doctype = this.createDocumentType(name, publicId, systemId);
        this.inDTD = true;
        this.nodes.addLast(doctype);
        this.decisions.addLast(new Short(1));
    }

    public void endDTD() throws SAXException {
        if (this.interrupted) {
            return;
        }
        Node doctype = (Node)this.nodes.removeLast();
        this.decisions.removeLast();
        this.inDTD = false;
        this.ctx = this.doc;
        short decision = this.getDecision(doctype, false);
        switch (decision) {
            case 1: {
                this.ctx.appendChild(doctype);
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    public void comment(char[] c, int off, int len) throws SAXException {
        if (this.rejecting || this.interrupted || this.inDTD) {
            return;
        }
        Node comment = this.createComment(c, off, len);
        short decision = this.getDecision(comment, false);
        switch (decision) {
            case 1: {
                this.ctx.appendChild(comment);
                break;
            }
            case 4: {
                this.interrupted = true;
            }
        }
    }

    short getDecision(Node node2, boolean start) {
        boolean show;
        boolean bl = show = this.whatToShow == -1;
        if (!show) {
            switch (node2.getNodeType()) {
                case 2: {
                    show = (this.whatToShow & 2) != 0;
                    break;
                }
                case 3: {
                    show = (this.whatToShow & 4) != 0;
                    break;
                }
                case 4: {
                    show = (this.whatToShow & 8) != 0;
                    break;
                }
                case 1: {
                    show = (this.whatToShow & 1) != 0;
                    break;
                }
                case 8: {
                    show = (this.whatToShow & 0x80) != 0;
                    break;
                }
                case 9: {
                    show = (this.whatToShow & 0x100) != 0;
                    break;
                }
                case 7: {
                    show = (this.whatToShow & 0x40) != 0;
                    break;
                }
                case 11: {
                    show = (this.whatToShow & 0x400) != 0;
                    break;
                }
                case 10: {
                    show = (this.whatToShow & 0x200) != 0;
                    break;
                }
                case 5: {
                    show = (this.whatToShow & 0x10) != 0;
                    break;
                }
                case 6: {
                    show = (this.whatToShow & 0x20) != 0;
                    break;
                }
                case 12: {
                    boolean bl2 = show = (this.whatToShow & 0x800) != 0;
                }
            }
        }
        if (!show) {
            return 1;
        }
        if (start) {
            return this.filter.startElement((Element)node2);
        }
        return this.filter.acceptNode(node2);
    }
}

