/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.xmlschema;

import gnu.xml.validation.datatype.SimpleType;
import gnu.xml.validation.datatype.Type;
import gnu.xml.validation.xmlschema.AttributeDeclaration;
import gnu.xml.validation.xmlschema.ElementDeclaration;
import gnu.xml.validation.xmlschema.ValidationException;
import gnu.xml.validation.xmlschema.XMLSchema;
import gnu.xml.validation.xmlschema.XMLSchemaAttributeTypeInfo;
import gnu.xml.validation.xmlschema.XMLSchemaElementTypeInfo;
import gnu.xml.validation.xmlschema.XMLSchemaTypeInfoProvider;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.helpers.NamespaceSupport;

final class XMLSchemaValidatorHandler
extends ValidatorHandler {
    final XMLSchema schema;
    final TypeInfoProvider typeInfoProvider;
    final NamespaceSupport namespaceSupport;
    final DatatypeLibrary typeLibrary;
    Locator loc;
    ContentHandler contentHandler;
    ErrorHandler errorHandler;
    LSResourceResolver resourceResolver;
    final LinkedList context;
    final ArrayList attributes;

    XMLSchemaValidatorHandler(XMLSchema schema) {
        this.schema = schema;
        this.typeInfoProvider = new XMLSchemaTypeInfoProvider(this);
        this.namespaceSupport = new NamespaceSupport();
        this.context = new LinkedList();
        this.attributes = new ArrayList();
        this.typeLibrary = new DatatypeLibraryLoader().createDatatypeLibrary("http://www.w3.org/2001/XMLSchema");
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public TypeInfoProvider getTypeInfoProvider() {
        return this.typeInfoProvider;
    }

    TypeInfo getElementTypeInfo() {
        return (XMLSchemaElementTypeInfo)this.context.getFirst();
    }

    TypeInfo getAttributeTypeInfo(int index) {
        return (XMLSchemaAttributeTypeInfo)this.attributes.get(index);
    }

    boolean isIdAttribute(int index) {
        XMLSchemaAttributeTypeInfo typeInfo = (XMLSchemaAttributeTypeInfo)this.attributes.get(index);
        return typeInfo.id;
    }

    boolean isSpecified(int index) {
        XMLSchemaAttributeTypeInfo typeInfo = (XMLSchemaAttributeTypeInfo)this.attributes.get(index);
        return typeInfo.specified;
    }

    public void setDocumentLocator(Locator locator) {
        this.loc = locator;
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        this.namespaceSupport.reset();
        this.context.clear();
        this.attributes.clear();
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceSupport.declarePrefix(prefix, uri);
        if (this.contentHandler != null) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.namespaceSupport.pushContext();
        QName name = new QName(uri, localName);
        ElementDeclaration decl = (ElementDeclaration)this.schema.elementDeclarations.get(name);
        String xsiType = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        xsiType = xsiType.trim();
        String xsiNil = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        Type type = decl.datatype;
        if (xsiType.length() > 0) {
            try {
                Type specifiedType;
                type = specifiedType = this.resolveType(xsiType);
            }
            catch (DatatypeException e) {
                ValidationException e2 = new ValidationException("Can't resolve type " + xsiType, this.loc);
                e2.initCause(e);
                throw e2;
            }
        }
        XMLSchemaElementTypeInfo typeInfo = new XMLSchemaElementTypeInfo(this.schema, decl, type);
        if (decl == null) {
            throw new ValidationException("No declaration for " + name, this.loc);
        }
        if (decl.isAbstract) {
            throw new ValidationException("Declaration for " + name + " is abstract", this.loc);
        }
        if (xsiNil.length() > 0) {
            if (!decl.nillable) {
                throw new ValidationException("Declaration for " + name + " is nillable but xsi:nil present", this.loc);
            }
            if ("true".equals(xsiNil)) {
                typeInfo.nil = true;
                if (decl.type == 2) {
                    throw new ValidationException("Declaration for " + name + " is fixed but xsi:nil is true", this.loc);
                }
            }
        }
        if (!this.context.isEmpty()) {
            XMLSchemaElementTypeInfo parent = (XMLSchemaElementTypeInfo)this.context.getFirst();
            if (parent.nil) {
                throw new ValidationException("Parent of " + qName + " is declared xsi:nil", this.loc);
            }
        }
        this.context.addFirst(typeInfo);
        int len = atts.getLength();
        Attributes2Impl atts2 = new Attributes2Impl();
        int count = 0;
        int i = 0;
        while (i < len) {
            String attUri = atts.getURI(i);
            String attLocalName = atts.getLocalName(i);
            String attQName = atts.getQName(i);
            String attValue = atts.getValue(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attUri)) {
                QName attName = new QName(attUri, attLocalName);
                AttributeDeclaration attDecl = (AttributeDeclaration)this.schema.attributeDeclarations.get(attName);
                boolean declared = attDecl != null;
                String attType = attDecl != null ? attDecl.datatype.toString() : "CDATA";
                XMLSchemaAttributeTypeInfo attTypeInfo = new XMLSchemaAttributeTypeInfo(this.schema, attDecl, true);
                this.attributes.add(attTypeInfo);
                atts2.addAttribute(attUri, attLocalName, attQName, attType, attValue);
                atts2.setDeclared(count, declared);
                atts2.setSpecified(count, true);
                ++count;
            }
            ++i;
        }
        if (this.contentHandler != null) {
            this.contentHandler.startElement(uri, localName, qName, atts2);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.context.removeFirst();
        this.attributes.clear();
        this.namespaceSupport.popContext();
        if (this.contentHandler != null) {
            this.contentHandler.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        XMLSchemaElementTypeInfo parent = (XMLSchemaElementTypeInfo)this.context.getFirst();
        if (parent.nil) {
            throw new ValidationException(String.valueOf(parent.decl.name.toString()) + " is declared xsi:nil", this.loc);
        }
        if (this.contentHandler != null) {
            this.contentHandler.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.skippedEntity(name);
        }
    }

    Type resolveType(String value) throws DatatypeException {
        String uri;
        QName name = QName.valueOf(value);
        String prefix = name.getPrefix();
        String localName = name.getLocalPart();
        if (prefix != null && prefix.length() > 0 && !"http://www.w3.org/2001/XMLSchema".equals(uri = this.namespaceSupport.getURI(prefix))) {
            return null;
        }
        if ("anyType".equals(localName)) {
            return Type.ANY_TYPE;
        }
        return (SimpleType)this.typeLibrary.createDatatype(localName);
    }
}

