/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.io.Serializable;
import java.util.EventListener;
import java.util.TooManyListenersException;
import javax.swing.Timer;

public class DropTarget
implements DropTargetListener,
EventListener,
Serializable {
    private static final long serialVersionUID = -6283860791671019047L;
    private Component component;
    private FlavorMap flavorMap;
    private int actions;
    private DropTargetPeer peer;
    private DropTargetContext dropTargetContext;
    private DropTargetListener dropTargetListener;
    private DropTargetAutoScroller autoscroller;
    private boolean active = true;

    public DropTarget() {
        this(null, 3, null, true, null);
    }

    public DropTarget(Component c, DropTargetListener dtl) {
        this(c, 3, dtl, true, null);
    }

    public DropTarget(Component c, int i, DropTargetListener dtl) {
        this(c, i, dtl, true, null);
    }

    public DropTarget(Component c, int i, DropTargetListener dtl, boolean b) {
        this(c, i, dtl, b, null);
    }

    public DropTarget(Component c, int i, DropTargetListener dtl, boolean b, FlavorMap fm) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.setComponent(c);
        this.setDefaultActions(i);
        this.dropTargetListener = dtl;
        this.flavorMap = fm == null ? SystemFlavorMap.getDefaultFlavorMap() : fm;
        this.setActive(b);
        if (c != null) {
            c.setDropTarget(this);
        }
    }

    public void setComponent(Component c) {
        if (this.component != null) {
            this.clearAutoscroll();
        }
        this.component = c;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setDefaultActions(int ops) {
        this.actions = ops;
    }

    public int getDefaultActions() {
        return this.actions;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            this.clearAutoscroll();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void addDropTargetListener(DropTargetListener dtl) throws TooManyListenersException {
        if (dtl == null) {
            return;
        }
        if (dtl.equals(this)) {
            throw new IllegalArgumentException();
        }
        if (this.dropTargetListener != null) {
            throw new TooManyListenersException();
        }
        this.dropTargetListener = dtl;
    }

    public void removeDropTargetListener(DropTargetListener dtl) {
        if (this.dropTargetListener != null) {
            this.dropTargetListener = null;
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.active) {
            if (this.dropTargetListener != null) {
                this.dropTargetListener.dragEnter(dtde);
            }
            this.initializeAutoscrolling(dtde.getLocation());
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (this.active) {
            if (this.dropTargetListener != null) {
                this.dropTargetListener.dragOver(dtde);
            }
            this.updateAutoscroll(dtde.getLocation());
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        if (this.active) {
            if (this.dropTargetListener != null) {
                this.dropTargetListener.dropActionChanged(dtde);
            }
            this.updateAutoscroll(dtde.getLocation());
        }
    }

    public void dragExit(DropTargetEvent dte) {
        if (this.active) {
            if (this.dropTargetListener != null) {
                this.dropTargetListener.dragExit(dte);
            }
            this.clearAutoscroll();
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        this.clearAutoscroll();
        if (this.dropTargetListener != null) {
            this.dropTargetListener.drop(dtde);
        }
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public void setFlavorMap(FlavorMap fm) {
        this.flavorMap = fm;
    }

    public void addNotify(ComponentPeer p) {
        Component c = this.component;
        while (c != null && p instanceof LightweightPeer) {
            p = c.getPeer();
            c = c.getParent();
        }
        if (p instanceof DropTargetPeer) {
            this.peer = (DropTargetPeer)((Object)p);
            this.peer.addDropTarget(this);
        } else {
            this.peer = null;
        }
    }

    public void removeNotify(ComponentPeer p) {
        this.peer.removeDropTarget(this);
        this.peer = null;
        p = null;
    }

    public DropTargetContext getDropTargetContext() {
        if (this.dropTargetContext == null) {
            this.dropTargetContext = this.createDropTargetContext();
        }
        return this.dropTargetContext;
    }

    protected DropTargetContext createDropTargetContext() {
        if (this.dropTargetContext == null) {
            this.dropTargetContext = new DropTargetContext(this);
        }
        return this.dropTargetContext;
    }

    protected DropTargetAutoScroller createDropTargetAutoScroller(Component c, Point p) {
        return new DropTargetAutoScroller(c, p);
    }

    protected void initializeAutoscrolling(Point p) {
        if (this.component instanceof Autoscroll) {
            this.autoscroller = this.createDropTargetAutoScroller(this.component, p);
        }
    }

    protected void updateAutoscroll(Point dragCursorLocn) {
        if (this.autoscroller != null) {
            this.autoscroller.updateLocation(dragCursorLocn);
        }
    }

    protected void clearAutoscroll() {
        if (this.autoscroller != null) {
            this.autoscroller.stop();
            this.autoscroller = null;
        }
    }

    protected static class DropTargetAutoScroller
    implements ActionListener {
        private static final int HYSTERESIS = 10;
        private static final int DELAY = 100;
        private Component component;
        private Point point;
        private Timer timer;
        private Rectangle outer;
        private Rectangle inner;

        protected DropTargetAutoScroller(Component c, Point p) {
            this.component = c;
            this.point = p;
            this.timer = new Timer(100, this);
            this.timer.setCoalesce(true);
            this.timer.start();
        }

        protected void updateLocation(Point newLocn) {
            Point previous = this.point;
            this.point = newLocn;
            if (Math.abs(this.point.x - previous.x) > 10 || Math.abs(this.point.y - previous.y) > 10) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }

        protected void stop() {
            this.timer.start();
        }

        public void actionPerformed(ActionEvent e) {
            Autoscroll autoScroll = (Autoscroll)((Object)this.component);
            Insets i = autoScroll.getAutoscrollInsets();
            int width = this.component.getWidth();
            int height = this.component.getHeight();
            if (width != this.outer.width || height != this.outer.height) {
                this.outer.setBounds(0, 0, width, height);
            }
            if (this.inner.x != i.left || this.inner.y != i.top) {
                this.inner.setLocation(i.left, i.top);
            }
            int inWidth = width - i.left - i.right;
            int inHeight = height - i.top - i.bottom;
            if (inWidth != this.inner.width || inHeight != this.inner.height) {
                this.inner.setSize(inWidth, inHeight);
            }
            if (this.outer.contains(this.point) && !this.inner.contains(this.point)) {
                autoScroll.autoscroll(this.point);
            }
        }
    }
}

