/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import gnu.java.util.ZoneInfo;
import java.io.File;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.SimpleTimeZone;
import java.util.VMTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private String ID;
    private static TimeZone defaultZone0;
    private static final long serialVersionUID = 3581463369166924961L;
    private static String zoneinfo_dir;
    private static String[] availableIDs;
    private static HashMap<String, String> aliases0;
    private static HashMap<String, TimeZone> timezones0;

    static {
        availableIDs = null;
    }

    private static synchronized TimeZone defaultZone() {
        if (defaultZone0 == null) {
            defaultZone0 = AccessController.doPrivileged(new PrivilegedAction<TimeZone>(){

                @Override
                public TimeZone run() {
                    TimeZone zone = null;
                    String tzid = System.getProperty("user.timezone");
                    if (tzid != null && !tzid.equals("")) {
                        zone = TimeZone.getDefaultTimeZone(tzid);
                    }
                    if (zone == null) {
                        zone = VMTimeZone.getDefaultTimeZoneId();
                    }
                    if (zone == null) {
                        zone = TimeZone.getTimeZone("GMT");
                    }
                    return zone;
                }
            });
        }
        return defaultZone0;
    }

    static HashMap<String, TimeZone> timezones() {
        if (timezones0 == null) {
            HashMap<String, TimeZone> timezones = new HashMap<String, TimeZone>();
            timezones0 = timezones;
            zoneinfo_dir = SystemProperties.getProperty("gnu.java.util.zoneinfo.dir");
            if (zoneinfo_dir != null && !new File(zoneinfo_dir).isDirectory()) {
                zoneinfo_dir = null;
            }
            if (zoneinfo_dir != null) {
                aliases0 = new HashMap();
                aliases0.put("ACT", "Australia/Darwin");
                aliases0.put("AET", "Australia/Sydney");
                aliases0.put("AGT", "America/Argentina/Buenos_Aires");
                aliases0.put("ART", "Africa/Cairo");
                aliases0.put("AST", "America/Juneau");
                aliases0.put("BST", "Asia/Colombo");
                aliases0.put("CAT", "Africa/Gaborone");
                aliases0.put("CNT", "America/St_Johns");
                aliases0.put("CST", "CST6CDT");
                aliases0.put("CTT", "Asia/Brunei");
                aliases0.put("EAT", "Indian/Comoro");
                aliases0.put("ECT", "CET");
                aliases0.put("EST", "EST5EDT");
                aliases0.put("EST5", "EST5EDT");
                aliases0.put("IET", "EST5EDT");
                aliases0.put("IST", "Asia/Calcutta");
                aliases0.put("JST", "Asia/Seoul");
                aliases0.put("MIT", "Pacific/Niue");
                aliases0.put("MST", "MST7MDT");
                aliases0.put("MST7", "MST7MDT");
                aliases0.put("NET", "Indian/Mauritius");
                aliases0.put("NST", "Pacific/Auckland");
                aliases0.put("PLT", "Indian/Kerguelen");
                aliases0.put("PNT", "MST7MDT");
                aliases0.put("PRT", "America/Anguilla");
                aliases0.put("PST", "PST8PDT");
                aliases0.put("SST", "Pacific/Ponape");
                aliases0.put("VST", "Asia/Bangkok");
                return timezones;
            }
            SimpleTimeZone tz = new SimpleTimeZone(-39600000, "MIT");
            timezones0.put("MIT", tz);
            timezones0.put("Pacific/Apia", tz);
            timezones0.put("Pacific/Midway", tz);
            timezones0.put("Pacific/Niue", tz);
            timezones0.put("Pacific/Pago_Pago", tz);
            tz = new SimpleTimeZone(-36000000, "America/Adak", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("America/Adak", tz);
            tz = new SimpleTimeZone(-36000000, "HST");
            timezones0.put("HST", tz);
            timezones0.put("Pacific/Fakaofo", tz);
            timezones0.put("Pacific/Honolulu", tz);
            timezones0.put("Pacific/Johnston", tz);
            timezones0.put("Pacific/Rarotonga", tz);
            timezones0.put("Pacific/Tahiti", tz);
            tz = new SimpleTimeZone(-34200000, "Pacific/Marquesas");
            timezones0.put("Pacific/Marquesas", tz);
            tz = new SimpleTimeZone(-32400000, "AST", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("AST", tz);
            timezones0.put("America/Anchorage", tz);
            timezones0.put("America/Juneau", tz);
            timezones0.put("America/Nome", tz);
            timezones0.put("America/Yakutat", tz);
            tz = new SimpleTimeZone(-32400000, "Pacific/Gambier");
            timezones0.put("Pacific/Gambier", tz);
            tz = new SimpleTimeZone(-28800000, "America/Tijuana", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("America/Tijuana", tz);
            tz = new SimpleTimeZone(-28800000, "PST", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("PST", tz);
            timezones0.put("PST8PDT", tz);
            timezones0.put("America/Dawson", tz);
            timezones0.put("America/Los_Angeles", tz);
            timezones0.put("America/Vancouver", tz);
            timezones0.put("America/Whitehorse", tz);
            timezones0.put("US/Pacific-New", tz);
            tz = new SimpleTimeZone(-28800000, "Pacific/Pitcairn");
            timezones0.put("Pacific/Pitcairn", tz);
            tz = new SimpleTimeZone(-25200000, "America/Chihuahua", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("America/Chihuahua", tz);
            timezones0.put("America/Mazatlan", tz);
            tz = new SimpleTimeZone(-25200000, "MST7");
            timezones0.put("MST7", tz);
            timezones0.put("PNT", tz);
            timezones0.put("America/Dawson_Creek", tz);
            timezones0.put("America/Hermosillo", tz);
            timezones0.put("America/Phoenix", tz);
            tz = new SimpleTimeZone(-25200000, "MST", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("MST", tz);
            timezones0.put("MST7MDT", tz);
            timezones0.put("America/Boise", tz);
            timezones0.put("America/Cambridge_Bay", tz);
            timezones0.put("America/Denver", tz);
            timezones0.put("America/Edmonton", tz);
            timezones0.put("America/Inuvik", tz);
            timezones0.put("America/Shiprock", tz);
            timezones0.put("America/Yellowknife", tz);
            tz = new SimpleTimeZone(-21600000, "America/Cancun", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("America/Cancun", tz);
            timezones0.put("America/Merida", tz);
            timezones0.put("America/Mexico_City", tz);
            timezones0.put("America/Monterrey", tz);
            tz = new SimpleTimeZone(-21600000, "America/Belize");
            timezones0.put("America/Belize", tz);
            timezones0.put("America/Costa_Rica", tz);
            timezones0.put("America/El_Salvador", tz);
            timezones0.put("America/Guatemala", tz);
            timezones0.put("America/Managua", tz);
            timezones0.put("America/Regina", tz);
            timezones0.put("America/Swift_Current", tz);
            timezones0.put("America/Tegucigalpa", tz);
            timezones0.put("Pacific/Galapagos", tz);
            tz = new SimpleTimeZone(-21600000, "CST", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("CST", tz);
            timezones0.put("CST6CDT", tz);
            timezones0.put("America/Chicago", tz);
            timezones0.put("America/Indiana/Knox", tz);
            timezones0.put("America/Indiana/Petersburg", tz);
            timezones0.put("America/Indiana/Vincennes", tz);
            timezones0.put("America/Menominee", tz);
            timezones0.put("America/North_Dakota/Center", tz);
            timezones0.put("America/North_Dakota/New_Salem", tz);
            timezones0.put("America/Rainy_River", tz);
            timezones0.put("America/Rankin_Inlet", tz);
            timezones0.put("America/Winnipeg", tz);
            tz = new SimpleTimeZone(-21600000, "Pacific/Easter", 9, 2, 7, 79200000, 2, 2, 7, 79200000);
            timezones0.put("Pacific/Easter", tz);
            tz = new SimpleTimeZone(-18000000, "EST5");
            timezones0.put("EST5", tz);
            timezones0.put("IET", tz);
            timezones0.put("America/Atikokan", tz);
            timezones0.put("America/Bogota", tz);
            timezones0.put("America/Cayman", tz);
            timezones0.put("America/Eirunepe", tz);
            timezones0.put("America/Guayaquil", tz);
            timezones0.put("America/Jamaica", tz);
            timezones0.put("America/Lima", tz);
            timezones0.put("America/Panama", tz);
            timezones0.put("America/Rio_Branco", tz);
            tz = new SimpleTimeZone(-18000000, "America/Havana", 3, 1, 1, 0, 9, -1, 1, 3600000);
            timezones0.put("America/Havana", tz);
            tz = new SimpleTimeZone(-18000000, "America/Grand_Turk", 3, 1, 1, 0, 9, -1, 1, 0);
            timezones0.put("America/Grand_Turk", tz);
            timezones0.put("America/Port-au-Prince", tz);
            tz = new SimpleTimeZone(-18000000, "EST", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("EST", tz);
            timezones0.put("EST5EDT", tz);
            timezones0.put("America/Detroit", tz);
            timezones0.put("America/Indiana/Indianapolis", tz);
            timezones0.put("America/Indiana/Marengo", tz);
            timezones0.put("America/Indiana/Vevay", tz);
            timezones0.put("America/Iqaluit", tz);
            timezones0.put("America/Kentucky/Louisville", tz);
            timezones0.put("America/Kentucky/Monticello", tz);
            timezones0.put("America/Montreal", tz);
            timezones0.put("America/Nassau", tz);
            timezones0.put("America/New_York", tz);
            timezones0.put("America/Nipigon", tz);
            timezones0.put("America/Pangnirtung", tz);
            timezones0.put("America/Thunder_Bay", tz);
            timezones0.put("America/Toronto", tz);
            tz = new SimpleTimeZone(-14400000, "America/Asuncion", 9, 3, 1, 0, 2, 2, 1, 0);
            timezones0.put("America/Asuncion", tz);
            tz = new SimpleTimeZone(-14400000, "PRT");
            timezones0.put("PRT", tz);
            timezones0.put("America/Anguilla", tz);
            timezones0.put("America/Antigua", tz);
            timezones0.put("America/Aruba", tz);
            timezones0.put("America/Barbados", tz);
            timezones0.put("America/Blanc-Sablon", tz);
            timezones0.put("America/Boa_Vista", tz);
            timezones0.put("America/Caracas", tz);
            timezones0.put("America/Curacao", tz);
            timezones0.put("America/Dominica", tz);
            timezones0.put("America/Grenada", tz);
            timezones0.put("America/Guadeloupe", tz);
            timezones0.put("America/Guyana", tz);
            timezones0.put("America/La_Paz", tz);
            timezones0.put("America/Manaus", tz);
            timezones0.put("America/Martinique", tz);
            timezones0.put("America/Montserrat", tz);
            timezones0.put("America/Port_of_Spain", tz);
            timezones0.put("America/Porto_Velho", tz);
            timezones0.put("America/Puerto_Rico", tz);
            timezones0.put("America/Santo_Domingo", tz);
            timezones0.put("America/St_Kitts", tz);
            timezones0.put("America/St_Lucia", tz);
            timezones0.put("America/St_Thomas", tz);
            timezones0.put("America/St_Vincent", tz);
            timezones0.put("America/Tortola", tz);
            tz = new SimpleTimeZone(-14400000, "America/Campo_Grande", 10, 1, 1, 0, 1, -1, 1, 0);
            timezones0.put("America/Campo_Grande", tz);
            timezones0.put("America/Cuiaba", tz);
            tz = new SimpleTimeZone(-14400000, "America/Goose_Bay", 2, 2, 1, 60000, 10, 1, 1, 60000);
            timezones0.put("America/Goose_Bay", tz);
            tz = new SimpleTimeZone(-14400000, "America/Glace_Bay", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("America/Glace_Bay", tz);
            timezones0.put("America/Halifax", tz);
            timezones0.put("America/Moncton", tz);
            timezones0.put("America/Thule", tz);
            timezones0.put("Atlantic/Bermuda", tz);
            tz = new SimpleTimeZone(-14400000, "America/Santiago", 9, 9, -1, 0, 2, 9, -1, 0);
            timezones0.put("America/Santiago", tz);
            timezones0.put("Antarctica/Palmer", tz);
            tz = new SimpleTimeZone(-14400000, "Atlantic/Stanley", 8, 1, 1, 0x6DDD00, 3, 3, 1, 0x6DDD00);
            timezones0.put("Atlantic/Stanley", tz);
            tz = new SimpleTimeZone(-12600000, "CNT", 2, 2, 1, 60000, 10, 1, 1, 60000);
            timezones0.put("CNT", tz);
            timezones0.put("America/St_Johns", tz);
            tz = new SimpleTimeZone(-10800000, "America/Godthab", 2, 30, -7, 79200000, 9, 30, -7, 82800000);
            timezones0.put("America/Godthab", tz);
            tz = new SimpleTimeZone(-10800000, "America/Miquelon", 2, 2, 1, 0x6DDD00, 10, 1, 1, 0x6DDD00);
            timezones0.put("America/Miquelon", tz);
            tz = new SimpleTimeZone(-10800000, "America/Montevideo", 9, 1, 1, 0x6DDD00, 2, 2, 1, 0x6DDD00);
            timezones0.put("America/Montevideo", tz);
            tz = new SimpleTimeZone(-10800000, "America/Sao_Paulo", 10, 1, 1, 0, 1, -1, 1, 0);
            timezones0.put("America/Sao_Paulo", tz);
            tz = new SimpleTimeZone(-10800000, "AGT");
            timezones0.put("AGT", tz);
            timezones0.put("America/Araguaina", tz);
            timezones0.put("America/Argentina/Buenos_Aires", tz);
            timezones0.put("America/Argentina/Catamarca", tz);
            timezones0.put("America/Argentina/Cordoba", tz);
            timezones0.put("America/Argentina/Jujuy", tz);
            timezones0.put("America/Argentina/La_Rioja", tz);
            timezones0.put("America/Argentina/Mendoza", tz);
            timezones0.put("America/Argentina/Rio_Gallegos", tz);
            timezones0.put("America/Argentina/San_Juan", tz);
            timezones0.put("America/Argentina/Tucuman", tz);
            timezones0.put("America/Argentina/Ushuaia", tz);
            timezones0.put("America/Bahia", tz);
            timezones0.put("America/Belem", tz);
            timezones0.put("America/Cayenne", tz);
            timezones0.put("America/Fortaleza", tz);
            timezones0.put("America/Maceio", tz);
            timezones0.put("America/Paramaribo", tz);
            timezones0.put("America/Recife", tz);
            timezones0.put("Antarctica/Rothera", tz);
            tz = new SimpleTimeZone(-7200000, "America/Noronha");
            timezones0.put("America/Noronha", tz);
            timezones0.put("Atlantic/South_Georgia", tz);
            tz = new SimpleTimeZone(-3600000, "America/Scoresbysund", 2, -1, 1, 0, 9, -1, 1, 3600000);
            timezones0.put("America/Scoresbysund", tz);
            timezones0.put("Atlantic/Azores", tz);
            tz = new SimpleTimeZone(-3600000, "Atlantic/Cape_Verde");
            timezones0.put("Atlantic/Cape_Verde", tz);
            tz = new SimpleTimeZone(0, "GMT");
            timezones0.put("GMT", tz);
            timezones0.put("UTC", tz);
            timezones0.put("Africa/Abidjan", tz);
            timezones0.put("Africa/Accra", tz);
            timezones0.put("Africa/Bamako", tz);
            timezones0.put("Africa/Banjul", tz);
            timezones0.put("Africa/Bissau", tz);
            timezones0.put("Africa/Casablanca", tz);
            timezones0.put("Africa/Conakry", tz);
            timezones0.put("Africa/Dakar", tz);
            timezones0.put("Africa/El_Aaiun", tz);
            timezones0.put("Africa/Freetown", tz);
            timezones0.put("Africa/Lome", tz);
            timezones0.put("Africa/Monrovia", tz);
            timezones0.put("Africa/Nouakchott", tz);
            timezones0.put("Africa/Ouagadougou", tz);
            timezones0.put("Africa/Sao_Tome", tz);
            timezones0.put("America/Danmarkshavn", tz);
            timezones0.put("Atlantic/Reykjavik", tz);
            timezones0.put("Atlantic/St_Helena", tz);
            tz = new SimpleTimeZone(0, "WET", 2, -1, 1, 3600000, 9, -1, 1, 0x6DDD00);
            timezones0.put("WET", tz);
            timezones0.put("Atlantic/Canary", tz);
            timezones0.put("Atlantic/Faroe", tz);
            timezones0.put("Atlantic/Madeira", tz);
            timezones0.put("Europe/Dublin", tz);
            timezones0.put("Europe/Guernsey", tz);
            timezones0.put("Europe/Isle_of_Man", tz);
            timezones0.put("Europe/Jersey", tz);
            timezones0.put("Europe/Lisbon", tz);
            timezones0.put("Europe/London", tz);
            tz = new SimpleTimeZone(3600000, "Africa/Algiers");
            timezones0.put("Africa/Algiers", tz);
            timezones0.put("Africa/Bangui", tz);
            timezones0.put("Africa/Brazzaville", tz);
            timezones0.put("Africa/Douala", tz);
            timezones0.put("Africa/Kinshasa", tz);
            timezones0.put("Africa/Lagos", tz);
            timezones0.put("Africa/Libreville", tz);
            timezones0.put("Africa/Luanda", tz);
            timezones0.put("Africa/Malabo", tz);
            timezones0.put("Africa/Ndjamena", tz);
            timezones0.put("Africa/Niamey", tz);
            timezones0.put("Africa/Porto-Novo", tz);
            tz = new SimpleTimeZone(3600000, "Africa/Windhoek", 8, 1, 1, 0x6DDD00, 3, 1, 1, 0x6DDD00);
            timezones0.put("Africa/Windhoek", tz);
            tz = new SimpleTimeZone(3600000, "CET", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("CET", tz);
            timezones0.put("ECT", tz);
            timezones0.put("MET", tz);
            timezones0.put("Africa/Ceuta", tz);
            timezones0.put("Africa/Tunis", tz);
            timezones0.put("Arctic/Longyearbyen", tz);
            timezones0.put("Atlantic/Jan_Mayen", tz);
            timezones0.put("Europe/Amsterdam", tz);
            timezones0.put("Europe/Andorra", tz);
            timezones0.put("Europe/Belgrade", tz);
            timezones0.put("Europe/Berlin", tz);
            timezones0.put("Europe/Bratislava", tz);
            timezones0.put("Europe/Brussels", tz);
            timezones0.put("Europe/Budapest", tz);
            timezones0.put("Europe/Copenhagen", tz);
            timezones0.put("Europe/Gibraltar", tz);
            timezones0.put("Europe/Ljubljana", tz);
            timezones0.put("Europe/Luxembourg", tz);
            timezones0.put("Europe/Madrid", tz);
            timezones0.put("Europe/Malta", tz);
            timezones0.put("Europe/Monaco", tz);
            timezones0.put("Europe/Oslo", tz);
            timezones0.put("Europe/Paris", tz);
            timezones0.put("Europe/Podgorica", tz);
            timezones0.put("Europe/Prague", tz);
            timezones0.put("Europe/Rome", tz);
            timezones0.put("Europe/San_Marino", tz);
            timezones0.put("Europe/Sarajevo", tz);
            timezones0.put("Europe/Skopje", tz);
            timezones0.put("Europe/Stockholm", tz);
            timezones0.put("Europe/Tirane", tz);
            timezones0.put("Europe/Vaduz", tz);
            timezones0.put("Europe/Vatican", tz);
            timezones0.put("Europe/Vienna", tz);
            timezones0.put("Europe/Warsaw", tz);
            timezones0.put("Europe/Zagreb", tz);
            timezones0.put("Europe/Zurich", tz);
            tz = new SimpleTimeZone(0x6DDD00, "ART", 3, -1, 6, 0, 8, -1, 5, 86400000);
            timezones0.put("ART", tz);
            timezones0.put("Africa/Cairo", tz);
            tz = new SimpleTimeZone(0x6DDD00, "CAT");
            timezones0.put("CAT", tz);
            timezones0.put("Africa/Blantyre", tz);
            timezones0.put("Africa/Bujumbura", tz);
            timezones0.put("Africa/Gaborone", tz);
            timezones0.put("Africa/Harare", tz);
            timezones0.put("Africa/Johannesburg", tz);
            timezones0.put("Africa/Kigali", tz);
            timezones0.put("Africa/Lubumbashi", tz);
            timezones0.put("Africa/Lusaka", tz);
            timezones0.put("Africa/Maputo", tz);
            timezones0.put("Africa/Maseru", tz);
            timezones0.put("Africa/Mbabane", tz);
            timezones0.put("Africa/Tripoli", tz);
            timezones0.put("Asia/Jerusalem", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Asia/Amman", 2, -1, 5, 0, 9, -1, 6, 3600000);
            timezones0.put("Asia/Amman", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Asia/Beirut", 2, -1, 1, 0, 9, -1, 1, 0);
            timezones0.put("Asia/Beirut", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Asia/Damascus", 3, 1, 0, 0, 9, 1, 0, 0);
            timezones0.put("Asia/Damascus", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Asia/Gaza", 3, 1, 0, 0, 9, 3, 6, 0);
            timezones0.put("Asia/Gaza", tz);
            tz = new SimpleTimeZone(0x6DDD00, "EET", 2, -1, 1, 10800000, 9, -1, 1, 14400000);
            timezones0.put("EET", tz);
            timezones0.put("Asia/Istanbul", tz);
            timezones0.put("Asia/Nicosia", tz);
            timezones0.put("Europe/Athens", tz);
            timezones0.put("Europe/Bucharest", tz);
            timezones0.put("Europe/Chisinau", tz);
            timezones0.put("Europe/Helsinki", tz);
            timezones0.put("Europe/Istanbul", tz);
            timezones0.put("Europe/Kiev", tz);
            timezones0.put("Europe/Mariehamn", tz);
            timezones0.put("Europe/Nicosia", tz);
            timezones0.put("Europe/Riga", tz);
            timezones0.put("Europe/Simferopol", tz);
            timezones0.put("Europe/Sofia", tz);
            timezones0.put("Europe/Tallinn", tz);
            timezones0.put("Europe/Uzhgorod", tz);
            timezones0.put("Europe/Vilnius", tz);
            timezones0.put("Europe/Zaporozhye", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Europe/Kaliningrad", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Europe/Kaliningrad", tz);
            timezones0.put("Europe/Minsk", tz);
            tz = new SimpleTimeZone(10800000, "Asia/Baghdad", 3, 1, 0, 10800000, 9, 1, 0, 14400000);
            timezones0.put("Asia/Baghdad", tz);
            tz = new SimpleTimeZone(10800000, "Europe/Moscow", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Europe/Moscow", tz);
            timezones0.put("Europe/Volgograd", tz);
            tz = new SimpleTimeZone(10800000, "EAT");
            timezones0.put("EAT", tz);
            timezones0.put("Africa/Addis_Ababa", tz);
            timezones0.put("Africa/Asmara", tz);
            timezones0.put("Africa/Dar_es_Salaam", tz);
            timezones0.put("Africa/Djibouti", tz);
            timezones0.put("Africa/Kampala", tz);
            timezones0.put("Africa/Khartoum", tz);
            timezones0.put("Africa/Mogadishu", tz);
            timezones0.put("Africa/Nairobi", tz);
            timezones0.put("Antarctica/Syowa", tz);
            timezones0.put("Asia/Aden", tz);
            timezones0.put("Asia/Bahrain", tz);
            timezones0.put("Asia/Kuwait", tz);
            timezones0.put("Asia/Qatar", tz);
            timezones0.put("Asia/Riyadh", tz);
            timezones0.put("Indian/Antananarivo", tz);
            timezones0.put("Indian/Comoro", tz);
            timezones0.put("Indian/Mayotte", tz);
            tz = new SimpleTimeZone(12600000, "Asia/Tehran");
            timezones0.put("Asia/Tehran", tz);
            tz = new SimpleTimeZone(14400000, "Asia/Baku", 2, -1, 1, 14400000, 9, -1, 1, 18000000);
            timezones0.put("Asia/Baku", tz);
            tz = new SimpleTimeZone(14400000, "Asia/Yerevan", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Yerevan", tz);
            timezones0.put("Europe/Samara", tz);
            tz = new SimpleTimeZone(14400000, "NET");
            timezones0.put("NET", tz);
            timezones0.put("Asia/Dubai", tz);
            timezones0.put("Asia/Muscat", tz);
            timezones0.put("Asia/Tbilisi", tz);
            timezones0.put("Indian/Mahe", tz);
            timezones0.put("Indian/Mauritius", tz);
            timezones0.put("Indian/Reunion", tz);
            tz = new SimpleTimeZone(16200000, "Asia/Kabul");
            timezones0.put("Asia/Kabul", tz);
            tz = new SimpleTimeZone(18000000, "Asia/Yekaterinburg", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Yekaterinburg", tz);
            tz = new SimpleTimeZone(18000000, "PLT");
            timezones0.put("PLT", tz);
            timezones0.put("Asia/Aqtau", tz);
            timezones0.put("Asia/Aqtobe", tz);
            timezones0.put("Asia/Ashgabat", tz);
            timezones0.put("Asia/Dushanbe", tz);
            timezones0.put("Asia/Karachi", tz);
            timezones0.put("Asia/Oral", tz);
            timezones0.put("Asia/Samarkand", tz);
            timezones0.put("Asia/Tashkent", tz);
            timezones0.put("Indian/Kerguelen", tz);
            timezones0.put("Indian/Maldives", tz);
            tz = new SimpleTimeZone(19800000, "BST");
            timezones0.put("BST", tz);
            timezones0.put("IST", tz);
            timezones0.put("Asia/Calcutta", tz);
            timezones0.put("Asia/Colombo", tz);
            tz = new SimpleTimeZone(20700000, "Asia/Katmandu");
            timezones0.put("Asia/Katmandu", tz);
            tz = new SimpleTimeZone(21600000, "Antarctica/Mawson");
            timezones0.put("Antarctica/Mawson", tz);
            timezones0.put("Antarctica/Vostok", tz);
            timezones0.put("Asia/Almaty", tz);
            timezones0.put("Asia/Bishkek", tz);
            timezones0.put("Asia/Dhaka", tz);
            timezones0.put("Asia/Qyzylorda", tz);
            timezones0.put("Asia/Thimphu", tz);
            timezones0.put("Indian/Chagos", tz);
            tz = new SimpleTimeZone(21600000, "Asia/Novosibirsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Novosibirsk", tz);
            timezones0.put("Asia/Omsk", tz);
            tz = new SimpleTimeZone(23400000, "Asia/Rangoon");
            timezones0.put("Asia/Rangoon", tz);
            timezones0.put("Indian/Cocos", tz);
            tz = new SimpleTimeZone(25200000, "VST");
            timezones0.put("VST", tz);
            timezones0.put("Antarctica/Davis", tz);
            timezones0.put("Asia/Bangkok", tz);
            timezones0.put("Asia/Jakarta", tz);
            timezones0.put("Asia/Phnom_Penh", tz);
            timezones0.put("Asia/Pontianak", tz);
            timezones0.put("Asia/Saigon", tz);
            timezones0.put("Asia/Vientiane", tz);
            timezones0.put("Indian/Christmas", tz);
            tz = new SimpleTimeZone(25200000, "Asia/Hovd", 2, -1, 7, 0x6DDD00, 8, -1, 7, 0x6DDD00);
            timezones0.put("Asia/Hovd", tz);
            tz = new SimpleTimeZone(25200000, "Asia/Krasnoyarsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Krasnoyarsk", tz);
            tz = new SimpleTimeZone(28800000, "CTT");
            timezones0.put("CTT", tz);
            timezones0.put("Antarctica/Casey", tz);
            timezones0.put("Asia/Brunei", tz);
            timezones0.put("Asia/Chongqing", tz);
            timezones0.put("Asia/Harbin", tz);
            timezones0.put("Asia/Hong_Kong", tz);
            timezones0.put("Asia/Kashgar", tz);
            timezones0.put("Asia/Kuala_Lumpur", tz);
            timezones0.put("Asia/Kuching", tz);
            timezones0.put("Asia/Macau", tz);
            timezones0.put("Asia/Makassar", tz);
            timezones0.put("Asia/Manila", tz);
            timezones0.put("Asia/Shanghai", tz);
            timezones0.put("Asia/Singapore", tz);
            timezones0.put("Asia/Taipei", tz);
            timezones0.put("Asia/Urumqi", tz);
            timezones0.put("Australia/Perth", tz);
            tz = new SimpleTimeZone(28800000, "Asia/Irkutsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Irkutsk", tz);
            tz = new SimpleTimeZone(28800000, "Asia/Ulaanbaatar", 2, -1, 7, 0x6DDD00, 8, -1, 7, 0x6DDD00);
            timezones0.put("Asia/Ulaanbaatar", tz);
            tz = new SimpleTimeZone(31500000, "Australia/Eucla");
            timezones0.put("Australia/Eucla", tz);
            tz = new SimpleTimeZone(32400000, "Asia/Choibalsan", 2, -1, 7, 0x6DDD00, 8, -1, 7, 0x6DDD00);
            timezones0.put("Asia/Choibalsan", tz);
            tz = new SimpleTimeZone(32400000, "JST");
            timezones0.put("JST", tz);
            timezones0.put("Asia/Dili", tz);
            timezones0.put("Asia/Jayapura", tz);
            timezones0.put("Asia/Pyongyang", tz);
            timezones0.put("Asia/Seoul", tz);
            timezones0.put("Asia/Tokyo", tz);
            timezones0.put("Pacific/Palau", tz);
            tz = new SimpleTimeZone(32400000, "Asia/Yakutsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Yakutsk", tz);
            tz = new SimpleTimeZone(34200000, "Australia/Adelaide", 9, -1, 1, 0x6DDD00, 2, -1, 1, 10800000);
            timezones0.put("Australia/Adelaide", tz);
            timezones0.put("Australia/Broken_Hill", tz);
            tz = new SimpleTimeZone(34200000, "ACT");
            timezones0.put("ACT", tz);
            timezones0.put("Australia/Darwin", tz);
            tz = new SimpleTimeZone(36000000, "Antarctica/DumontDUrville");
            timezones0.put("Antarctica/DumontDUrville", tz);
            timezones0.put("Australia/Brisbane", tz);
            timezones0.put("Australia/Lindeman", tz);
            timezones0.put("Pacific/Guam", tz);
            timezones0.put("Pacific/Port_Moresby", tz);
            timezones0.put("Pacific/Saipan", tz);
            timezones0.put("Pacific/Truk", tz);
            tz = new SimpleTimeZone(36000000, "Asia/Sakhalin", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Sakhalin", tz);
            timezones0.put("Asia/Vladivostok", tz);
            tz = new SimpleTimeZone(36000000, "Australia/Currie", 9, 1, 1, 0x6DDD00, 2, -1, 1, 10800000);
            timezones0.put("Australia/Currie", tz);
            timezones0.put("Australia/Hobart", tz);
            tz = new SimpleTimeZone(36000000, "AET", 9, -1, 1, 0x6DDD00, 2, -1, 1, 10800000);
            timezones0.put("AET", tz);
            timezones0.put("Australia/Melbourne", tz);
            timezones0.put("Australia/Sydney", tz);
            tz = new SimpleTimeZone(37800000, "Australia/Lord_Howe", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00, 1800000);
            timezones0.put("Australia/Lord_Howe", tz);
            tz = new SimpleTimeZone(39600000, "Asia/Magadan", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Magadan", tz);
            tz = new SimpleTimeZone(39600000, "SST");
            timezones0.put("SST", tz);
            timezones0.put("Pacific/Efate", tz);
            timezones0.put("Pacific/Guadalcanal", tz);
            timezones0.put("Pacific/Kosrae", tz);
            timezones0.put("Pacific/Noumea", tz);
            timezones0.put("Pacific/Ponape", tz);
            tz = new SimpleTimeZone(41400000, "Pacific/Norfolk");
            timezones0.put("Pacific/Norfolk", tz);
            tz = new SimpleTimeZone(43200000, "NST", 9, 1, 1, 0x6DDD00, 2, 3, 1, 10800000);
            timezones0.put("NST", tz);
            timezones0.put("Antarctica/McMurdo", tz);
            timezones0.put("Antarctica/South_Pole", tz);
            timezones0.put("Pacific/Auckland", tz);
            tz = new SimpleTimeZone(43200000, "Asia/Anadyr", 2, -1, 1, 0x6DDD00, 9, -1, 1, 10800000);
            timezones0.put("Asia/Anadyr", tz);
            timezones0.put("Asia/Kamchatka", tz);
            tz = new SimpleTimeZone(43200000, "Pacific/Fiji");
            timezones0.put("Pacific/Fiji", tz);
            timezones0.put("Pacific/Funafuti", tz);
            timezones0.put("Pacific/Kwajalein", tz);
            timezones0.put("Pacific/Majuro", tz);
            timezones0.put("Pacific/Nauru", tz);
            timezones0.put("Pacific/Tarawa", tz);
            timezones0.put("Pacific/Wake", tz);
            timezones0.put("Pacific/Wallis", tz);
            tz = new SimpleTimeZone(45900000, "Pacific/Chatham", 9, 1, 1, 9900000, 2, 3, 1, 13500000);
            timezones0.put("Pacific/Chatham", tz);
            tz = new SimpleTimeZone(46800000, "Pacific/Enderbury");
            timezones0.put("Pacific/Enderbury", tz);
            timezones0.put("Pacific/Tongatapu", tz);
            tz = new SimpleTimeZone(50400000, "Pacific/Kiritimati");
            timezones0.put("Pacific/Kiritimati", tz);
        }
        return timezones0;
    }

    static TimeZone getDefaultTimeZone(String sysTimeZoneId) {
        String stdName = null;
        try {
            int dstOffs;
            TimeZone tz;
            char c;
            int idLength = sysTimeZoneId.length();
            int index = 0;
            while ((c = sysTimeZoneId.charAt(index)) != '+' && c != '-' && c != ',' && c != ':' && !Character.isDigit(c) && c != '\u0000' && ++index < idLength) {
            }
            if (index >= idLength) {
                return TimeZone.getTimeZoneInternal(sysTimeZoneId);
            }
            stdName = sysTimeZoneId.substring(0, index);
            int prevIndex = index;
            while (((c = sysTimeZoneId.charAt(index++)) == '-' || c == '+' || c == ':' || Character.isDigit(c)) && index < idLength) {
            }
            if (index < idLength) {
                --index;
            }
            String offset = sysTimeZoneId.substring(prevIndex, index);
            prevIndex = index;
            int stdOffs = offset.charAt(0) == '+' || offset.charAt(0) == '-' ? TimeZone.parseTime(offset.substring(1)) : TimeZone.parseTime(offset);
            if (offset.charAt(0) == '-') {
                stdOffs = -stdOffs;
            }
            stdOffs = -stdOffs;
            if (index >= idLength) {
                tz = TimeZone.getTimeZoneInternal(stdName);
                if (tz != null && tz.getRawOffset() == stdOffs) {
                    return tz;
                }
                return new SimpleTimeZone(stdOffs, stdName);
            }
            while ((c = sysTimeZoneId.charAt(index)) != '+' && c != '-' && c != ',' && c != ':' && !Character.isDigit(c) && c != '\u0000' && ++index < idLength) {
            }
            if (index >= idLength) {
                tz = TimeZone.getTimeZoneInternal(stdName);
                if (tz != null && tz.getRawOffset() == stdOffs && tz.useDaylightTime()) {
                    return tz;
                }
                return new SimpleTimeZone(stdOffs, stdName);
            }
            prevIndex = index;
            while (((c = sysTimeZoneId.charAt(index++)) == '-' || c == '+' || c == ':' || Character.isDigit(c)) && index < idLength) {
            }
            if (index < idLength) {
                --index;
            }
            if (index == prevIndex && (c == ',' || c == ';')) {
                dstOffs = stdOffs + 3600000;
            } else {
                offset = sysTimeZoneId.substring(prevIndex, index);
                prevIndex = index;
                dstOffs = offset.charAt(0) == '+' || offset.charAt(0) == '-' ? TimeZone.parseTime(offset.substring(1)) : TimeZone.parseTime(offset);
                if (offset.charAt(0) == '-') {
                    dstOffs = -dstOffs;
                }
                dstOffs = -dstOffs;
            }
            if (index >= idLength) {
                tz = TimeZone.getTimeZoneInternal(stdName);
                if (tz != null && tz.getRawOffset() == stdOffs && tz.useDaylightTime() && tz.getDSTSavings() == dstOffs - stdOffs) {
                    return tz;
                }
                return new SimpleTimeZone(stdOffs, stdName);
            }
            if (sysTimeZoneId.charAt(index) == ',' || sysTimeZoneId.charAt(index) == ';') {
                int endMillis;
                String endDate;
                int startMillis;
                String startDate;
                int offs = ++index;
                while (sysTimeZoneId.charAt(index) != ',' && sysTimeZoneId.charAt(index) != ';') {
                    ++index;
                }
                String startTime = sysTimeZoneId.substring(offs, index);
                String endTime = sysTimeZoneId.substring(++index);
                index = startTime.indexOf(47);
                if (index != -1) {
                    startDate = startTime.substring(0, index);
                    startMillis = TimeZone.parseTime(startTime.substring(index + 1));
                } else {
                    startDate = startTime;
                    startMillis = 0x6DDD00;
                }
                index = endTime.indexOf(47);
                if (index != -1) {
                    endDate = endTime.substring(0, index);
                    endMillis = TimeZone.parseTime(endTime.substring(index + 1));
                } else {
                    endDate = endTime;
                    endMillis = 0x6DDD00;
                }
                int[] start = TimeZone.getDateParams(startDate);
                int[] end = TimeZone.getDateParams(endDate);
                return new SimpleTimeZone(stdOffs, stdName, start[0], start[1], start[2], startMillis, end[0], end[1], end[2], endMillis, dstOffs - stdOffs);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    private static int[] getDateParams(String date) {
        int julianDay;
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        int[] dayCount = nArray;
        if (date.charAt(0) == 'M' || date.charAt(0) == 'm') {
            int day;
            int month = Integer.parseInt(date.substring(1, date.indexOf(46)));
            int week = Integer.parseInt(date.substring(date.indexOf(46) + 1, date.lastIndexOf(46)));
            int dayOfWeek = Integer.parseInt(date.substring(date.lastIndexOf(46) + 1));
            ++dayOfWeek;
            if (week == 5) {
                day = -1;
            } else {
                day = (week - 1) * 7 + 1;
                dayOfWeek = -dayOfWeek;
            }
            return new int[]{--month, day, dayOfWeek};
        }
        if (date.charAt(0) != 'J' || date.charAt(0) != 'j') {
            julianDay = Integer.parseInt(date.substring(1));
            ++julianDay;
            int[] nArray2 = new int[12];
            nArray2[1] = 31;
            nArray2[2] = 60;
            nArray2[3] = 91;
            nArray2[4] = 121;
            nArray2[5] = 152;
            nArray2[6] = 182;
            nArray2[7] = 213;
            nArray2[8] = 244;
            nArray2[9] = 274;
            nArray2[10] = 305;
            nArray2[11] = 335;
            dayCount = nArray2;
        } else {
            julianDay = Integer.parseInt(date);
        }
        int i = 11;
        while (i > 0) {
            if (dayCount[i] < julianDay) break;
            --i;
        }
        int month = i;
        int[] nArray3 = new int[3];
        nArray3[0] = month;
        nArray3[1] = julianDay -= dayCount[i];
        return nArray3;
    }

    private static int parseTime(String time) {
        int millis = 0;
        int i = 0;
        while (i < time.length()) {
            if (time.charAt(i) == ':') break;
            ++i;
        }
        millis = 3600000 * Integer.parseInt(time.substring(0, i));
        if (i >= time.length()) {
            return millis;
        }
        int iprev = ++i;
        while (i < time.length()) {
            if (time.charAt(i) == ':') break;
            ++i;
        }
        millis += 60000 * Integer.parseInt(time.substring(iprev, i));
        if (i >= time.length()) {
            return millis;
        }
        return millis += 1000 * Integer.parseInt(time.substring(++i));
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long date) {
        return this.inDaylightTime(new Date(date)) ? this.getRawOffset() + this.getDSTSavings() : this.getRawOffset();
    }

    public abstract int getRawOffset();

    public abstract void setRawOffset(int var1);

    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.ID = id;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean dst, int style) {
        return this.getDisplayName(dst, style, Locale.getDefault());
    }

    public String getDisplayName(boolean dst, int style, Locale locale) {
        try {
            DateFormatSymbols dfs = new DateFormatSymbols(locale);
            String[][] zoneinfo = dfs.getZoneStrings();
            int i = 0;
            while (i < zoneinfo.length) {
                if (zoneinfo[i][0].equals(this.getID())) {
                    if (!dst) {
                        if (style == 0) {
                            return zoneinfo[i][2];
                        }
                        return zoneinfo[i][1];
                    }
                    if (style == 0) {
                        return zoneinfo[i][4];
                    }
                    return zoneinfo[i][3];
                }
                ++i;
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return this.getDefaultDisplayName(dst);
    }

    private String getDefaultDisplayName(boolean dst) {
        int offset = this.getRawOffset() + (dst ? this.getDSTSavings() : 0);
        CPStringBuilder sb = new CPStringBuilder(9);
        sb.append("GMT");
        int hours = Math.abs(offset /= 60000) / 60;
        int minutes = Math.abs(offset) % 60;
        if (minutes != 0 || hours != 0) {
            sb.append(offset >= 0 ? (char)'+' : '-');
            sb.append((char)(48 + hours / 10));
            sb.append((char)(48 + hours % 10));
            sb.append(':');
            sb.append((char)(48 + minutes / 10));
            sb.append((char)(48 + minutes % 10));
        }
        return sb.toString();
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public int getDSTSavings() {
        return this.useDaylightTime() ? 3600000 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static TimeZone getTimeZoneInternal(String ID2) {
        TimeZone tz = null;
        TimeZone tznew = null;
        int pass = 0;
        while (pass < 2) {
            Class<TimeZone> clazz = TimeZone.class;
            // MONITORENTER : java.util.TimeZone.class
            tz = TimeZone.timezones().get(ID2);
            if (tz != null) {
                if (!tz.getID().equals(ID2)) {
                    tz = (TimeZone)tz.clone();
                    tz.setID(ID2);
                    TimeZone.timezones().put(ID2, tz);
                }
                // MONITOREXIT : clazz
                return tz;
            }
            if (tznew != null) {
                TimeZone.timezones().put(ID2, tznew);
                // MONITOREXIT : clazz
                return tznew;
            }
            // MONITOREXIT : clazz
            if (pass == 1) return null;
            if (zoneinfo_dir == null) {
                return null;
            }
            String zonename = aliases0.get(ID2);
            if (zonename == null) {
                zonename = ID2;
            }
            if ((tznew = ZoneInfo.readTZFile(ID2, String.valueOf(zoneinfo_dir) + File.separatorChar + zonename)) == null) {
                return null;
            }
            ++pass;
        }
        return null;
    }

    public static TimeZone getTimeZone(String ID2) {
        TimeZone tz;
        if (ID2.startsWith("GMT") && ID2.length() > 3) {
            int pos = 3;
            int offset_direction = 1;
            if (ID2.charAt(pos) == '-') {
                offset_direction = -1;
                ++pos;
            } else if (ID2.charAt(pos) == '+') {
                ++pos;
            }
            try {
                int minute;
                int hour;
                String offset_str = ID2.substring(pos);
                int idx = offset_str.indexOf(":");
                if (idx != -1) {
                    hour = Integer.parseInt(offset_str.substring(0, idx));
                    minute = Integer.parseInt(offset_str.substring(idx + 1));
                } else {
                    int offset_length = offset_str.length();
                    if (offset_length <= 2) {
                        hour = Integer.parseInt(offset_str);
                        minute = 0;
                    } else {
                        hour = Integer.parseInt(offset_str.substring(0, offset_length - 2));
                        minute = Integer.parseInt(offset_str.substring(offset_length - 2));
                    }
                }
                CPStringBuilder sb = new CPStringBuilder(9);
                sb.append("GMT");
                sb.append(offset_direction >= 0 ? (char)'+' : '-');
                sb.append((char)(48 + hour / 10));
                sb.append((char)(48 + hour % 10));
                sb.append(':');
                sb.append((char)(48 + minute / 10));
                sb.append((char)(48 + minute % 10));
                ID2 = sb.toString();
                return new SimpleTimeZone((hour * 3600000 + minute * 60000) * offset_direction, ID2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((tz = TimeZone.getTimeZoneInternal(ID2)) != null) {
            return tz;
        }
        return new SimpleTimeZone(0, "GMT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAvailableIDs(int rawOffset) {
        Class<TimeZone> clazz = TimeZone.class;
        synchronized (TimeZone.class) {
            HashMap<String, TimeZone> h = TimeZone.timezones();
            int count = 0;
            if (zoneinfo_dir == null) {
                for (Map.Entry<String, TimeZone> entry : h.entrySet()) {
                    if (entry.getValue().getRawOffset() != rawOffset) continue;
                    ++count;
                }
                String[] ids = new String[count];
                count = 0;
                for (Map.Entry<String, TimeZone> entry : h.entrySet()) {
                    if (entry.getValue().getRawOffset() != rawOffset) continue;
                    ids[count++] = entry.getKey();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ids;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            String[] s = TimeZone.getAvailableIDs();
            int count2 = 0;
            int i = 0;
            while (i < s.length) {
                TimeZone t = TimeZone.getTimeZoneInternal(s[i]);
                if (t == null || t.getRawOffset() != rawOffset) {
                    s[i] = null;
                } else {
                    ++count2;
                }
                ++i;
            }
            String[] ids = new String[count2];
            count2 = 0;
            int i2 = 0;
            while (i2 < s.length) {
                if (s[i2] != null) {
                    ids[count2++] = s[i2];
                }
                ++i2;
            }
            return ids;
        }
    }

    private static int getAvailableIDs(File d, String prefix, ArrayList<String[]> list2) {
        String[] files = d.list();
        int count = files.length;
        boolean top = prefix.length() == 0;
        list2.add(files);
        int i = 0;
        while (i < files.length) {
            if (top && (files[i].equals("posix") || files[i].equals("right") || files[i].endsWith(".tab") || aliases0.get(files[i]) != null)) {
                files[i] = null;
                --count;
            } else {
                File f = new File(d, files[i]);
                if (f.isDirectory()) {
                    count += TimeZone.getAvailableIDs(f, String.valueOf(prefix) + files[i] + File.separatorChar, list2) - 1;
                    files[i] = null;
                } else {
                    files[i] = String.valueOf(prefix) + files[i];
                }
            }
            ++i;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAvailableIDs() {
        Class<TimeZone> clazz = TimeZone.class;
        synchronized (TimeZone.class) {
            HashMap<String, TimeZone> h = TimeZone.timezones();
            if (zoneinfo_dir == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return h.keySet().toArray(new String[h.size()]);
            }
            if (availableIDs != null) {
                String[] ids = new String[availableIDs.length];
                int i = 0;
                while (i < availableIDs.length) {
                    ids[i] = availableIDs[i];
                    ++i;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return ids;
            }
            File d = new File(zoneinfo_dir);
            ArrayList<String[]> list2 = new ArrayList<String[]>(30);
            int count = TimeZone.getAvailableIDs(d, "", list2) + aliases0.size();
            availableIDs = new String[count];
            String[] ids = new String[count];
            count = 0;
            int i = 0;
            while (i < list2.size()) {
                String[] s = list2.get(i);
                int j = 0;
                while (j < s.length) {
                    if (s[j] != null) {
                        TimeZone.availableIDs[count] = s[j];
                        ids[count++] = s[j];
                    }
                    ++j;
                }
                ++i;
            }
            for (Map.Entry<String, String> entry : aliases0.entrySet()) {
                TimeZone.availableIDs[count] = entry.getKey();
                ids[count++] = entry.getKey();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ids;
        }
    }

    public static TimeZone getDefault() {
        return (TimeZone)TimeZone.defaultZone().clone();
    }

    public static void setDefault(TimeZone zone) {
        defaultZone0 = zone;
    }

    public boolean hasSameRules(TimeZone other) {
        return other.getRawOffset() == this.getRawOffset();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

