/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageReader {
    private boolean aborted;
    protected Locale[] availableLocales = null;
    protected boolean ignoreMetadata = false;
    protected Object input = null;
    protected Locale locale = null;
    protected int minIndex = 0;
    protected ImageReaderSpi originatingProvider = null;
    protected List<IIOReadProgressListener> progressListeners = null;
    protected boolean seekForwardOnly = false;
    protected List<IIOReadUpdateListener> updateListeners = null;
    protected List<IIOReadWarningListener> warningListeners = null;
    protected List<Locale> warningLocales = null;

    protected ImageReader(ImageReaderSpi originatingProvider) {
        this.originatingProvider = originatingProvider;
    }

    public void abort() {
        this.aborted = true;
    }

    protected boolean abortRequested() {
        return this.aborted;
    }

    public void addIIOReadProgressListener(IIOReadProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList<IIOReadProgressListener>();
        }
        this.progressListeners.add(listener);
    }

    public void addIIOReadUpdateListener(IIOReadUpdateListener listener) {
        if (listener == null) {
            return;
        }
        if (this.updateListeners == null) {
            this.updateListeners = new ArrayList<IIOReadUpdateListener>();
        }
        this.updateListeners.add(listener);
    }

    public void addIIOReadWarningListener(IIOReadWarningListener listener) {
        if (listener == null) {
            return;
        }
        if (this.warningListeners == null) {
            this.warningListeners = new ArrayList<IIOReadWarningListener>();
        }
        this.warningListeners.add(listener);
    }

    public boolean canReadRaster() {
        return false;
    }

    protected void clearAbortRequest() {
        this.aborted = false;
    }

    public void dispose() {
    }

    public float getAspectRatio(int imageIndex) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("input is null");
        }
        return this.getWidth(imageIndex) / this.getHeight(imageIndex);
    }

    public Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            return null;
        }
        return (Locale[])this.availableLocales.clone();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public String getFormatName() throws IOException {
        return this.originatingProvider.getFormatNames()[0];
    }

    public abstract int getHeight(int var1) throws IOException;

    public abstract IIOMetadata getImageMetadata(int var1) throws IOException;

    public abstract Iterator<ImageTypeSpecifier> getImageTypes(int var1) throws IOException;

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        Class[] okClasses = this.originatingProvider.getInputTypes();
        if (okClasses == null) {
            if (!(input instanceof ImageInputStream)) {
                throw new IllegalArgumentException();
            }
        } else {
            boolean classOk = false;
            int i = 0;
            while (i < okClasses.length) {
                if (okClasses[i].isInstance(input)) {
                    classOk = true;
                }
                ++i;
            }
            if (!classOk) {
                throw new IllegalArgumentException();
            }
        }
        this.input = input;
        this.seekForwardOnly = seekForwardOnly;
        this.ignoreMetadata = ignoreMetadata;
        this.minIndex = 0;
    }

    public void setInput(Object in, boolean seekForwardOnly) {
        this.setInput(in, seekForwardOnly, false);
    }

    public void setInput(Object input) {
        this.setInput(input, false, false);
    }

    public Object getInput() {
        return this.input;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract int getNumImages(boolean var1) throws IOException;

    public int getNumThumbnails(int imageIndex) throws IOException {
        return 0;
    }

    public ImageReaderSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    public abstract IIOMetadata getStreamMetadata() throws IOException;

    public int getThumbnailHeight(int imageIndex, int thumbnailIndex) throws IOException {
        return this.readThumbnail(imageIndex, thumbnailIndex).getHeight();
    }

    public int getThumbnailWidth(int imageIndex, int thumbnailIndex) throws IOException {
        return this.readThumbnail(imageIndex, thumbnailIndex).getWidth();
    }

    public int getTileGridXOffset(int imageIndex) throws IOException {
        return 0;
    }

    public int getTileGridYOffset(int imageIndex) throws IOException {
        return 0;
    }

    public int getTileHeight(int imageIndex) throws IOException {
        return this.getHeight(imageIndex);
    }

    public int getTileWidth(int imageIndex) throws IOException {
        return this.getWidth(imageIndex);
    }

    public abstract int getWidth(int var1) throws IOException;

    public boolean hasThumbnails(int imageIndex) throws IOException {
        return this.getNumThumbnails(imageIndex) > 0;
    }

    public boolean isIgnoringMetadata() {
        return this.ignoreMetadata;
    }

    public boolean isImageTiled(int imageIndex) throws IOException {
        return false;
    }

    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        return false;
    }

    public boolean isSeekForwardOnly() {
        return this.seekForwardOnly;
    }

    protected void processImageComplete() {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.imageComplete(this);
            }
        }
    }

    protected void processImageProgress(float percentageDone) {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.imageProgress(this, percentageDone);
            }
        }
    }

    protected void processImageStarted(int imageIndex) {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.imageStarted(this, imageIndex);
            }
        }
    }

    protected void processImageUpdate(BufferedImage image, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.imageUpdate(this, image, minX, minY, width, height, periodX, periodY, bands);
            }
        }
    }

    protected void processPassComplete(BufferedImage image) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.passComplete(this, image);
            }
        }
    }

    protected void processPassStarted(BufferedImage image, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.passStarted(this, image, pass, minPass, maxPass, minX, minY, periodX, periodY, bands);
            }
        }
    }

    protected void processReadAborted() {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.readAborted(this);
            }
        }
    }

    protected void processSequenceComplete() {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.sequenceComplete(this);
            }
        }
    }

    protected void processSequenceStarted(int minIndex) {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.sequenceStarted(this, minIndex);
            }
        }
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.thumbnailComplete(this);
            }
        }
    }

    protected void processThumbnailPassComplete(BufferedImage thumbnail) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.thumbnailPassComplete(this, thumbnail);
            }
        }
    }

    protected void processThumbnailPassStarted(BufferedImage thumbnail, int pass, int minPass, int maxPass, int minX, int minY, int periodX, int periodY, int[] bands) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.thumbnailPassStarted(this, thumbnail, pass, minPass, maxPass, minX, minY, periodX, periodY, bands);
            }
        }
    }

    protected void processThumbnailProgress(float percentageDone) {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.thumbnailProgress(this, percentageDone);
            }
        }
    }

    protected void processThumbnailStarted(int imageIndex, int thumbnailIndex) {
        if (this.progressListeners != null) {
            for (IIOReadProgressListener listener : this.progressListeners) {
                listener.thumbnailStarted(this, imageIndex, thumbnailIndex);
            }
        }
    }

    protected void processThumbnailUpdate(BufferedImage image, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        if (this.updateListeners != null) {
            for (IIOReadUpdateListener listener : this.updateListeners) {
                listener.thumbnailUpdate(this, image, minX, minY, width, height, periodX, periodY, bands);
            }
        }
    }

    protected void processWarningOccurred(String warning) {
        if (warning == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (this.warningListeners != null) {
            for (IIOReadWarningListener listener : this.warningListeners) {
                listener.warningOccurred(this, warning);
            }
        }
    }

    protected void processWarningOccurred(String baseName, String keyword) {
        if (baseName == null || keyword == null) {
            throw new IllegalArgumentException("null argument");
        }
        ResourceBundle b = null;
        try {
            b = ResourceBundle.getBundle(baseName, this.getLocale());
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("no resource bundle found");
        }
        Object str = null;
        try {
            str = b.getObject(keyword);
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("no results found for keyword");
        }
        if (!(str instanceof String)) {
            throw new IllegalArgumentException("retrieved object not a String");
        }
        String warning = (String)str;
        if (this.warningListeners != null) {
            for (IIOReadWarningListener listener : this.warningListeners) {
                listener.warningOccurred(this, warning);
            }
        }
    }

    public abstract BufferedImage read(int var1, ImageReadParam var2) throws IOException;

    public boolean readerSupportsThumbnails() {
        return false;
    }

    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        throw new UnsupportedOperationException();
    }

    public BufferedImage readThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeAllIIOReadProgressListeners() {
        this.progressListeners = null;
    }

    public void removeAllIIOReadUpdateListeners() {
        this.updateListeners = null;
    }

    public void removeAllIIOReadWarningListeners() {
        this.warningListeners = null;
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.progressListeners != null) {
            this.progressListeners.remove(listener);
        }
    }

    public void removeIIOReadUpdateListener(IIOReadUpdateListener listener) {
        if (listener == null) {
            return;
        }
        if (this.updateListeners != null) {
            this.updateListeners.remove(listener);
        }
    }

    public void removeIIOReadWarningListener(IIOReadWarningListener listener) {
        if (listener == null) {
            return;
        }
        if (this.warningListeners != null) {
            this.warningListeners.remove(listener);
        }
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            boolean found = false;
            if (this.availableLocales != null) {
                int i = this.availableLocales.length - 1;
                while (i >= 0) {
                    if (this.availableLocales[i].equals(locale)) {
                        found = true;
                    }
                    --i;
                }
            }
            if (!found) {
                throw new IllegalArgumentException("looale not available");
            }
        }
        this.locale = locale;
    }

    protected static void checkReadParamBandSettings(ImageReadParam param, int numSrcBands, int numDstBands) {
        int[] srcBands = param.getSourceBands();
        int[] dstBands = param.getDestinationBands();
        boolean lengthsDiffer = false;
        boolean srcOOB = false;
        boolean dstOOB = false;
        if (srcBands == null) {
            if (dstBands == null) {
                if (numSrcBands != numDstBands) {
                    lengthsDiffer = true;
                }
            } else {
                if (numSrcBands != dstBands.length) {
                    lengthsDiffer = true;
                }
                int i = 0;
                while (i < dstBands.length) {
                    if (dstBands[i] > numSrcBands - 1) {
                        dstOOB = true;
                        break;
                    }
                    ++i;
                }
            }
        } else if (dstBands == null) {
            if (srcBands.length != numDstBands) {
                lengthsDiffer = true;
            }
            int i = 0;
            while (i < srcBands.length) {
                if (srcBands[i] > numDstBands - 1) {
                    srcOOB = true;
                    break;
                }
                ++i;
            }
        } else {
            if (srcBands.length != dstBands.length) {
                lengthsDiffer = true;
            }
            int i = 0;
            while (i < srcBands.length) {
                if (srcBands[i] > numDstBands - 1) {
                    srcOOB = true;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < dstBands.length) {
                if (dstBands[i] > numSrcBands - 1) {
                    dstOOB = true;
                    break;
                }
                ++i;
            }
        }
        if (lengthsDiffer) {
            throw new IllegalArgumentException("array lengths differ");
        }
        if (srcOOB) {
            throw new IllegalArgumentException("source band index out-of-bounds");
        }
        if (dstOOB) {
            throw new IllegalArgumentException("destination band index out-of-bounds");
        }
    }

    protected static void computeRegions(ImageReadParam param, int srcWidth, int srcHeight, BufferedImage image, Rectangle srcRegion, Rectangle destRegion) {
        if (srcRegion == null || destRegion == null) {
            throw new IllegalArgumentException("null region");
        }
        if (srcWidth == 0 || srcHeight == 0) {
            throw new IllegalArgumentException("zero-sized region");
        }
        srcRegion = ImageReader.getSourceRegion(param, srcWidth, srcHeight);
        destRegion = image != null ? new Rectangle(0, 0, image.getWidth(), image.getHeight()) : new Rectangle(0, 0, srcWidth, srcHeight);
        if (param != null) {
            Point offset = param.getDestinationOffset();
            if (offset.x < 0) {
                srcRegion.x -= offset.x;
                srcRegion.width += offset.x;
            }
            if (offset.y < 0) {
                srcRegion.y -= offset.y;
                srcRegion.height += offset.y;
            }
            srcRegion.width = srcRegion.width > destRegion.width ? destRegion.width : srcRegion.width;
            int n = srcRegion.height = srcRegion.height > destRegion.height ? destRegion.height : srcRegion.height;
            if (offset.x >= 0) {
                destRegion.x += offset.x;
                destRegion.width -= offset.x;
            }
            if (offset.y >= 0) {
                destRegion.y += offset.y;
                destRegion.height -= offset.y;
            }
        }
        if (srcRegion.isEmpty() || destRegion.isEmpty()) {
            throw new IllegalArgumentException("zero-sized region");
        }
    }

    protected static BufferedImage getDestination(ImageReadParam param, Iterator<ImageTypeSpecifier> imageTypes, int width, int height) throws IIOException {
        ImageTypeSpecifier o;
        ImageTypeSpecifier type;
        if (imageTypes == null || !imageTypes.hasNext()) {
            throw new IllegalArgumentException("imageTypes null or empty");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("negative dimension");
        }
        if (width * height < Math.min(width, height)) {
            throw new IllegalArgumentException("width * height > Integer.MAX_VALUE");
        }
        BufferedImage dest = null;
        ImageTypeSpecifier destType = null;
        if (param != null && (dest = param.getDestination()) == null && (type = param.getDestinationType()) != null) {
            Iterator<ImageTypeSpecifier> it = imageTypes;
            while (it.hasNext()) {
                o = it.next();
                if (!(o instanceof ImageTypeSpecifier)) {
                    throw new IllegalArgumentException("non-ImageTypeSpecifier object");
                }
                ImageTypeSpecifier t = o;
                if (t.equals(type)) {
                    dest = t.createBufferedImage(width, height);
                    break;
                }
                if (destType != null) continue;
                throw new IIOException("invalid destination type");
            }
        }
        if (dest == null) {
            Rectangle srcRegion = new Rectangle();
            Rectangle destRegion = new Rectangle();
            ImageReader.computeRegions(param, width, height, null, srcRegion, destRegion);
            if (destRegion.isEmpty()) {
                throw new IllegalArgumentException("destination region empty");
            }
            if (destType == null) {
                o = imageTypes.next();
                if (!(o instanceof ImageTypeSpecifier)) {
                    throw new IllegalArgumentException("non-ImageTypeSpecifier object");
                }
                dest = o.createBufferedImage(destRegion.width, destRegion.height);
            } else {
                dest = destType.createBufferedImage(destRegion.width, destRegion.height);
            }
        }
        return dest;
    }

    public IIOMetadata getImageMetadata(int imageIndex, String formatName, Set<String> nodeNames) throws IOException {
        if (formatName == null || nodeNames == null) {
            throw new IllegalArgumentException("null argument");
        }
        return this.getImageMetadata(imageIndex);
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public ImageTypeSpecifier getRawImageType(int imageIndex) throws IOException {
        return this.getImageTypes(imageIndex).next();
    }

    protected static Rectangle getSourceRegion(ImageReadParam param, int srcWidth, int srcHeight) {
        Rectangle clippedRegion = new Rectangle(0, 0, srcWidth, srcHeight);
        if (param != null) {
            Rectangle srcRegion = param.getSourceRegion();
            if (srcRegion != null) {
                clippedRegion.x = srcRegion.x > clippedRegion.x ? srcRegion.x : clippedRegion.x;
                clippedRegion.y = srcRegion.y > clippedRegion.y ? srcRegion.y : clippedRegion.y;
                clippedRegion.width = srcRegion.width > clippedRegion.width ? srcRegion.width : clippedRegion.width;
                clippedRegion.height = srcRegion.height > clippedRegion.height ? srcRegion.height : clippedRegion.height;
            }
            int xOffset = param.getSubsamplingXOffset();
            clippedRegion.x += xOffset;
            clippedRegion.width -= xOffset;
            int yOffset = param.getSubsamplingYOffset();
            clippedRegion.y += yOffset;
            clippedRegion.height -= yOffset;
        }
        return clippedRegion;
    }

    public IIOMetadata getStreamMetadata(String formatName, Set<String> nodeNames) throws IOException {
        if (formatName == null || nodeNames == null) {
            throw new IllegalArgumentException("null argument");
        }
        return this.getStreamMetadata();
    }

    public BufferedImage read(int imageIndex) throws IOException {
        return this.read(imageIndex, null);
    }

    public IIOImage readAll(int imageIndex, ImageReadParam param) throws IOException {
        ImageReader.checkReadParamBandSettings(param, param.getSourceBands().length, param.getDestinationBands().length);
        ArrayList<BufferedImage> l = new ArrayList<BufferedImage>();
        int i = 0;
        while (i < this.getNumThumbnails(imageIndex)) {
            l.add(this.readThumbnail(imageIndex, i));
            ++i;
        }
        return new IIOImage(ImageReader.getDestination(param, this.getImageTypes(imageIndex), this.getWidth(imageIndex), this.getHeight(imageIndex)), l, this.getImageMetadata(imageIndex));
    }

    public Iterator<IIOImage> readAll(Iterator<? extends ImageReadParam> params) throws IOException {
        ArrayList<IIOImage> l = new ArrayList<IIOImage>();
        int index = 0;
        while (params.hasNext()) {
            if (params != null && !(params instanceof ImageReadParam)) {
                throw new IllegalArgumentException("non-ImageReadParam found");
            }
            l.add(this.readAll(index++, params.next()));
        }
        return l.iterator();
    }

    public RenderedImage readAsRenderedImage(int imageIndex, ImageReadParam param) throws IOException {
        return this.read(imageIndex, param);
    }

    public BufferedImage readTile(int imageIndex, int tileX, int tileY) throws IOException {
        if (tileX != 0 || tileY != 0) {
            throw new IllegalArgumentException("tileX not 0 or tileY not 0");
        }
        return this.read(imageIndex);
    }

    public Raster readTileRaster(int imageIndex, int tileX, int tileY) throws IOException {
        if (!this.canReadRaster()) {
            throw new UnsupportedOperationException("cannot read rasters");
        }
        if (tileX != 0 || tileY != 0) {
            throw new IllegalArgumentException("tileX not 0 or tileY not 0");
        }
        return this.readRaster(imageIndex, null);
    }

    public void reset() {
        this.setInput(null, false);
        this.setLocale(null);
        this.removeAllIIOReadUpdateListeners();
        this.removeAllIIOReadWarningListeners();
        this.removeAllIIOReadProgressListeners();
        this.clearAbortRequest();
    }
}

