/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.util.Locale;
import javax.imageio.IIOParam;

public class ImageWriteParam
extends IIOParam {
    public static final int MODE_DISABLED = 0;
    public static final int MODE_DEFAULT = 1;
    public static final int MODE_EXPLICIT = 2;
    public static final int MODE_COPY_FROM_METADATA = 3;
    protected boolean canOffsetTiles;
    protected boolean canWriteCompressed;
    protected boolean canWriteProgressive;
    protected boolean canWriteTiles;
    protected int compressionMode = 3;
    protected float compressionQuality;
    protected String compressionType;
    protected String[] compressionTypes;
    protected Locale locale;
    protected Dimension[] preferredTileSizes;
    protected int progressiveMode = 3;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected int tileHeight;
    protected int tileWidth;
    protected int tilingMode;
    protected boolean tilingSet;

    protected ImageWriteParam() {
    }

    public ImageWriteParam(Locale locale) {
        this.locale = locale;
    }

    public float getBitRate(float quality) {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return -1.0f;
    }

    private void checkSupportsCompression() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("compression not supported");
        }
    }

    private void checkNotExplicitCompression() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("compression mode is not MODE_EXPLICIT");
        }
    }

    private void checkCompressionTypesSet() {
        if (this.getCompressionType() == null && this.getCompressionTypes() != null) {
            throw new IllegalStateException("no compression type set");
        }
    }

    private void checkSupportsProgressiveEncoding() {
        if (!this.canWriteProgressive()) {
            throw new UnsupportedOperationException("progressive output not supported");
        }
    }

    private void checkSupportsTiling() {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("tiling not supported");
        }
    }

    private void checkNotExplicitTiling() {
        if (this.getTilingMode() != 2) {
            throw new IllegalStateException("tiling mode not MODE_EXPLICIT");
        }
    }

    private void checkTilingInitialized() {
        if (!this.tilingSet) {
            throw new IllegalStateException("tiling parameters not set");
        }
    }

    private void checkMode(int mode) {
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException("mode not supported");
        }
    }

    public boolean canOffsetTiles() {
        return this.canOffsetTiles;
    }

    public boolean canWriteCompressed() {
        return this.canWriteCompressed;
    }

    public boolean canWriteProgressive() {
        return this.canWriteProgressive;
    }

    public boolean canWriteTiles() {
        return this.canWriteTiles;
    }

    public int getCompressionMode() {
        this.checkSupportsCompression();
        return this.compressionMode;
    }

    public float getCompressionQuality() {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return this.compressionQuality;
    }

    public String[] getCompressionQualityDescriptions() {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return null;
    }

    public float[] getCompressionQualityValues() {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return null;
    }

    public String getCompressionType() {
        this.checkNotExplicitCompression();
        return this.compressionType;
    }

    public String[] getCompressionTypes() {
        this.checkSupportsCompression();
        return this.compressionTypes != null ? (String[])this.compressionTypes.clone() : null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocalizedCompressionTypeName() {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return this.getCompressionType();
    }

    public Dimension[] getPreferredTileSizes() {
        this.checkSupportsTiling();
        return this.preferredTileSizes;
    }

    public int getProgressiveMode() {
        this.checkSupportsProgressiveEncoding();
        return this.progressiveMode;
    }

    public int getTileGridXOffset() {
        this.checkNotExplicitTiling();
        this.checkTilingInitialized();
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        this.checkNotExplicitTiling();
        this.checkTilingInitialized();
        return this.tileGridYOffset;
    }

    public int getTileHeight() {
        this.checkNotExplicitTiling();
        this.checkTilingInitialized();
        return this.tileHeight;
    }

    public int getTileWidth() {
        this.checkNotExplicitTiling();
        this.checkTilingInitialized();
        return this.tileWidth;
    }

    public int getTilingMode() {
        this.checkSupportsTiling();
        return this.tilingMode;
    }

    public boolean isCompressionLossless() {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        return true;
    }

    public void setCompressionMode(int mode) {
        this.checkSupportsCompression();
        this.checkMode(mode);
        this.compressionMode = mode;
        if (mode == 2) {
            this.unsetCompression();
        }
    }

    public void setCompressionQuality(float quality) {
        this.checkNotExplicitCompression();
        this.checkCompressionTypesSet();
        if (quality < 0.0f || quality > 1.0f) {
            throw new IllegalArgumentException("quality out of range");
        }
        this.compressionQuality = quality;
    }

    public void setCompressionType(String compressionType) {
        this.checkNotExplicitCompression();
        String[] types = this.getCompressionTypes();
        if (types == null) {
            throw new UnsupportedOperationException("no settable compression types");
        }
        if (compressionType == null) {
            this.compressionType = null;
        }
        int i = types.length - 1;
        while (i >= 0) {
            if (types[i].equals(compressionType)) {
                this.compressionType = compressionType;
                return;
            }
            --i;
        }
        throw new IllegalArgumentException("unknown compression type");
    }

    public void setProgressiveMode(int mode) {
        this.checkSupportsProgressiveEncoding();
        this.checkMode(mode);
        this.progressiveMode = mode;
    }

    public void setTiling(int tileWidth, int tileHeight, int tileGridXOffset, int tileGridYOffset) {
        this.checkNotExplicitTiling();
        if (!this.canOffsetTiles && tileGridXOffset != 0 && tileGridYOffset != 0) {
            throw new UnsupportedOperationException("tile offsets not supported");
        }
        if (tileWidth < 0 || tileHeight < 0) {
            throw new IllegalArgumentException("negative tile dimension");
        }
        if (this.preferredTileSizes != null) {
            boolean found = false;
            int i = 0;
            while (i < this.preferredTileSizes.length) {
                if (tileWidth >= this.preferredTileSizes[i].width && tileWidth <= this.preferredTileSizes[i + 1].width && tileHeight >= this.preferredTileSizes[i].height && tileHeight <= this.preferredTileSizes[i + 1].height) {
                    found = true;
                }
                i += 2;
            }
            if (!found) {
                throw new IllegalArgumentException("illegal tile size");
            }
        }
        this.tilingSet = true;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.tileGridXOffset = tileGridXOffset;
        this.tileGridYOffset = tileGridYOffset;
    }

    public void setTilingMode(int mode) {
        this.checkSupportsTiling();
        this.checkMode(mode);
        this.tilingMode = mode;
    }

    public void unsetCompression() {
        this.checkNotExplicitCompression();
        this.compressionType = null;
        this.compressionQuality = 1.0f;
    }

    public void unsetTiling() {
        this.checkNotExplicitTiling();
        this.tileWidth = 0;
        this.tileHeight = 0;
        this.tileGridXOffset = 0;
        this.tileGridYOffset = 0;
    }
}

