/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicPanelUI;
import javax.swing.text.View;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    transient ScrollingButton incrButton;
    transient ScrollingButton decrButton;
    transient ScrollingViewport viewport;
    transient ScrollingPanel panel;
    transient int currentScrollLocation;
    transient int currentScrollOffset;
    protected Rectangle calcRect;
    protected Rectangle[] rects;
    protected Insets contentBorderInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets tabInsets;
    protected Color darkShadow;
    protected Color focus;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected int runCount;
    protected int selectedRun;
    protected int tabRunOverlay;
    protected int textIconGap;
    protected int[] tabRuns;
    boolean tabRunsDirty;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected FocusListener focusListener;
    protected MouseListener mouseListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener tabChangeListener;
    protected JTabbedPane tabPane;
    transient LayoutManager layoutManager;
    transient Rectangle tabAreaRect;
    transient Rectangle contentRect;
    private int rolloverTab;
    private boolean tabsOpaque;
    private Component visibleComponent;
    private Color selectedColor;
    private Rectangle tempTextRect = new Rectangle();
    private Rectangle tempIconRect = new Rectangle();

    public BasicTabbedPaneUI() {
        this.rects = new Rectangle[0];
        this.tabRuns = new int[10];
    }

    ScrollingButton createIncreaseButton() {
        if (this.incrButton == null) {
            this.incrButton = new ScrollingButton(1);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.incrButton.setDirection(3);
        } else {
            this.incrButton.setDirection(5);
        }
        return this.incrButton;
    }

    ScrollingButton createDecreaseButton() {
        if (this.decrButton == null) {
            this.decrButton = new ScrollingButton(5);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.decrButton.setDirection(7);
        } else {
            this.decrButton.setDirection(1);
        }
        return this.decrButton;
    }

    Point findPointForIndex(int index) {
        int tabPlacement = this.tabPane.getTabPlacement();
        int selectedIndex = this.tabPane.getSelectedIndex();
        Insets insets = this.getSelectedTabPadInsets(tabPlacement);
        int w = 0;
        int h = 0;
        if (tabPlacement == 1 || tabPlacement == 3) {
            if (index > 0) {
                w += this.rects[index - 1].x + this.rects[index - 1].width;
                if (index > selectedIndex) {
                    w -= insets.left + insets.right;
                }
            }
        } else if (index > 0) {
            h += this.rects[index - 1].y + this.rects[index - 1].height;
            if (index > selectedIndex) {
                h -= insets.top + insets.bottom;
            }
        }
        Point p = new Point(w, h);
        return p;
    }

    final void scrollTab(int index, int placement) {
        if (index >= 0 && this.tabPane.isEnabledAt(index)) {
            switch (placement) {
                case 1: 
                case 3: {
                    int diff = this.rects[index].x + this.rects[index].width - this.decrButton.getX() - this.currentScrollOffset;
                    if (diff > 0) {
                        this.currentScrollOffset += diff;
                    } else {
                        diff = this.rects[index].x - this.currentScrollOffset;
                        if (diff < 0) {
                            this.currentScrollOffset = index == 0 ? 0 : (this.currentScrollOffset += diff);
                        }
                    }
                    this.currentScrollLocation = this.tabForCoordinate(this.tabPane, this.currentScrollOffset, this.rects[index].y);
                    break;
                }
                default: {
                    int diff = this.rects[index].y + this.rects[index].height - this.decrButton.getY() - this.currentScrollOffset;
                    if (diff > 0) {
                        this.currentScrollOffset += diff;
                    } else {
                        diff = this.rects[index].y - this.currentScrollOffset;
                        if (diff < 0) {
                            this.currentScrollOffset = index == 0 ? 0 : (this.currentScrollOffset += diff);
                        }
                    }
                    this.currentScrollLocation = this.tabForCoordinate(this.tabPane, this.rects[index].x, this.currentScrollOffset);
                }
            }
            this.updateViewPosition();
            this.updateButtons();
        }
    }

    final void updateButtons() {
        int tc = this.tabPane.getTabCount();
        switch (this.tabPane.getTabPlacement()) {
            case 1: 
            case 3: {
                this.incrButton.setEnabled(this.currentScrollLocation + 1 < tc && this.rects[tc - 1].x + this.rects[tc - 1].width - this.currentScrollOffset > this.decrButton.getX());
                break;
            }
            default: {
                this.incrButton.setEnabled(this.currentScrollLocation + 1 < tc && this.rects[tc - 1].y + this.rects[tc - 1].height - this.currentScrollOffset > this.decrButton.getY());
            }
        }
        this.decrButton.setEnabled(this.currentScrollOffset > 0);
    }

    final void updateViewPosition() {
        Point p = this.viewport.getViewPosition();
        switch (this.tabPane.getTabPlacement()) {
            case 2: 
            case 4: {
                p.x = 0;
                p.y = this.currentScrollOffset;
                break;
            }
            default: {
                p.x = this.currentScrollOffset;
                p.y = 0;
            }
        }
        this.viewport.setViewPosition(p);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicTabbedPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JTabbedPane) {
            this.tabPane = (JTabbedPane)c;
            this.installComponents();
            this.installDefaults();
            this.installListeners();
            this.installKeyboardActions();
            this.layoutManager = this.createLayoutManager();
            this.tabPane.setLayout(this.layoutManager);
        }
    }

    public void uninstallUI(JComponent c) {
        this.layoutManager = null;
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            return new TabbedPaneLayout();
        }
        this.runCount = 1;
        this.tabRuns[0] = 0;
        this.incrButton = this.createIncreaseButton();
        this.incrButton.addMouseListener(this.mouseListener);
        this.decrButton = this.createDecreaseButton();
        this.decrButton.addMouseListener(this.mouseListener);
        this.decrButton.setEnabled(false);
        this.panel = new ScrollingPanel();
        this.panel.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.panel.addMouseListener(this.mouseListener);
        this.panel.addFocusListener(this.focusListener);
        this.viewport = new ScrollingViewport();
        this.viewport.setBackground(Color.LIGHT_GRAY);
        this.viewport.setView(this.panel);
        this.viewport.setLayout(null);
        this.tabPane.add(this.incrButton);
        this.tabPane.add(this.decrButton);
        this.tabPane.add(this.viewport);
        return new TabbedPaneScrollLayout();
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
        if (this.incrButton != null) {
            this.tabPane.remove(this.incrButton);
        }
        if (this.decrButton != null) {
            this.tabPane.remove(this.decrButton);
        }
        if (this.viewport != null) {
            this.tabPane.remove(this.viewport);
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.tabPane.setOpaque(false);
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.highlight = UIManager.getColor("TabbedPane.light");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.selectedColor = UIManager.getColor("TabbedPane.contentAreaColor");
        if (this.selectedColor == null) {
            this.selectedColor = UIManager.getColor("control");
        }
        this.calcRect = new Rectangle();
        this.tabRuns = new int[10];
        this.tabAreaRect = new Rectangle();
        this.contentRect = new Rectangle();
    }

    protected void uninstallDefaults() {
        this.calcRect = null;
        this.tabAreaRect = null;
        this.contentRect = null;
        this.tabRuns = null;
        this.tempIconRect = null;
        this.tempTextRect = null;
        this.contentBorderInsets = null;
        this.tabAreaInsets = null;
        this.selectedTabPadInsets = null;
        this.tabInsets = null;
        this.focus = null;
        this.darkShadow = null;
        this.shadow = null;
        this.lightHighlight = null;
        this.highlight = null;
        this.selectedColor = null;
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseListener();
        this.tabChangeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.tabPane.addMouseListener(this.mouseListener);
        this.tabPane.addChangeListener(this.tabChangeListener);
        this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        this.tabPane.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        this.tabPane.removeFocusListener(this.focusListener);
        this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
        this.tabPane.removeChangeListener(this.tabChangeListener);
        this.tabPane.removeMouseListener(this.mouseListener);
        if (this.incrButton != null) {
            this.incrButton.removeMouseListener(this.mouseListener);
        }
        if (this.decrButton != null) {
            this.decrButton.removeMouseListener(this.mouseListener);
        }
        if (this.panel != null) {
            this.panel.removeMouseListener(this.mouseListener);
            this.panel.removeFocusListener(this.focusListener);
        }
        this.focusListener = null;
        this.propertyChangeListener = null;
        this.tabChangeListener = null;
        this.mouseListener = null;
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap keyMap = (InputMap)UIManager.get("TabbedPane.focusInputMap");
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, keyMap);
        keyMap = (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, keyMap);
        ActionMap map = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, map);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.layoutManager.minimumLayoutSize(this.tabPane);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void paint(Graphics g, JComponent c) {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (this.tabPane.getTabCount() == 0) {
            return;
        }
        int index = this.tabPane.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        int tabPlacement = this.tabPane.getTabPlacement();
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            g.setColor(this.highlight);
            g.fillRect(this.tabAreaRect.x, this.tabAreaRect.y, this.tabAreaRect.width, this.tabAreaRect.height);
            this.paintTabArea(g, tabPlacement, index);
        }
        this.paintContentBorder(g, tabPlacement, index);
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int tabCount = this.tabPane.getTabCount();
        int i = this.runCount - 1;
        while (i >= 0) {
            int start = this.tabRuns[i];
            int next = i == this.runCount - 1 ? this.tabRuns[0] : this.tabRuns[i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            int j = start;
            while (j <= end) {
                if (j != selectedIndex) {
                    this.paintTab(g, tabPlacement, this.rects, j, this.tempIconRect, this.tempTextRect);
                }
                ++j;
            }
            --i;
        }
        if (selectedIndex >= 0) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, this.tempIconRect, this.tempTextRect);
        }
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean isSelected;
        Rectangle rect = rects[tabIndex];
        boolean bl = isSelected = tabIndex == this.tabPane.getSelectedIndex();
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(g, tabPlacement, tabIndex, rect.x, rect.y, rect.width, rect.height, isSelected);
        }
        this.paintTabBorder(g, tabPlacement, tabIndex, rect.x, rect.y, rect.width, rect.height, isSelected);
        FontMetrics fm = this.getFontMetrics();
        Icon icon = this.getIconForTab(tabIndex);
        String title = this.tabPane.getTitleAt(tabIndex);
        this.layoutLabel(tabPlacement, fm, tabIndex, title, icon, rect, iconRect, textRect, isSelected);
        this.paintText(g, tabPlacement, this.tabPane.getFont(), fm, tabIndex, title, textRect, isSelected);
        this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        textRect.x = 0;
        textRect.y = 0;
        textRect.width = 0;
        textRect.height = 0;
        iconRect.x = 0;
        iconRect.y = 0;
        iconRect.width = 0;
        iconRect.height = 0;
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 4, tabRect, iconRect, textRect, this.textIconGap);
        int shiftX = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int shiftY = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += shiftX;
        iconRect.y += shiftY;
        textRect.x += shiftX;
        textRect.y += shiftY;
    }

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, g, iconRect.x, iconRect.y);
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View textView = this.getTextViewForTab(tabIndex);
        if (textView != null) {
            textView.paint(g, textRect);
            return;
        }
        int ascent = metrics.getAscent();
        int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            Color selectionForeground;
            Color fg = this.tabPane.getForegroundAt(tabIndex);
            if (isSelected && fg instanceof UIResource && (selectionForeground = UIManager.getColor("TabbedPane.selectionForeground")) != null) {
                fg = selectionForeground;
            }
            g.setColor(fg);
            if (mnemIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + ascent);
            } else {
                g.drawString(title, textRect.x, textRect.y + ascent);
            }
        } else {
            Color bg = this.tabPane.getBackgroundAt(tabIndex);
            g.setColor(bg.brighter());
            if (mnemIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + ascent);
            } else {
                g.drawString(title, textRect.x, textRect.y + ascent);
            }
            g.setColor(bg.darker());
            if (mnemIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x + 1, textRect.y + 1 + ascent);
            } else {
                g.drawString(title, textRect.x + 1, textRect.y + 1 + ascent);
            }
        }
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        switch (tabPlacement) {
            default: {
                return 1;
            }
            case 2: {
                return isSelected ? -1 : 1;
            }
            case 4: 
        }
        return isSelected ? 1 : -1;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        switch (tabPlacement) {
            default: {
                return isSelected ? -1 : 1;
            }
            case 3: {
                return isSelected ? 1 : -1;
            }
            case 2: 
            case 4: 
        }
        return 0;
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.tabPane.hasFocus() && isSelected) {
            int h;
            int w;
            int y;
            int x;
            Rectangle rect = rects[tabIndex];
            g.setColor(this.focus);
            switch (tabPlacement) {
                case 2: {
                    x = rect.x + 3;
                    y = rect.y + 3;
                    w = rect.width - 5;
                    h = rect.height - 6;
                    break;
                }
                case 4: {
                    x = rect.x + 2;
                    y = rect.y + 3;
                    w = rect.width - 6;
                    h = rect.height - 5;
                    break;
                }
                case 3: {
                    x = rect.x + 3;
                    y = rect.y + 2;
                    w = rect.width - 6;
                    h = rect.height - 5;
                    break;
                }
                default: {
                    x = rect.x + 3;
                    y = rect.y + 3;
                    w = rect.width - 6;
                    h = rect.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color saved = g.getColor();
        switch (tabPlacement) {
            case 1: {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h);
                g.drawLine(x + w - 2, y + 1, x + w - 1, y + 2);
                g.setColor(this.lightHighlight);
                g.drawLine(x, y + 3, x, y + h);
                g.drawLine(x + 3, y, x + w - 3, y);
                g.drawLine(x, y + 2, x + 2, y);
                break;
            }
            case 2: {
                g.setColor(this.lightHighlight);
                g.drawLine(x + 3, y, x + w - 1, y);
                g.drawLine(x + 2, y, x, y + 2);
                g.drawLine(x, y + 3, x, y + h - 4);
                g.drawLine(x, y + h - 3, x + 1, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                break;
            }
            case 3: {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y + h - 2);
                g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                g.drawLine(x + w - 1, y + h - 2, x + w - 3, y + h);
                g.drawLine(x + 2, y + h, x + w - 4, y + h);
                g.setColor(this.lightHighlight);
                g.drawLine(x, y, x, y + h - 3);
                g.drawLine(x, y + h - 2, x + 1, y + h - 1);
                break;
            }
            case 4: {
                g.setColor(this.lightHighlight);
                g.drawLine(x, y, x + w - 3, y);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 2, y + 1, x + w - 1, y + 2);
                g.drawLine(x + w - 1, y + 3, x + w - 1, y + h - 3);
                g.drawLine(x + w - 2, y + h - 2, x + w - 3, y + h - 1);
                g.drawLine(x, y + h - 1, x + w - 4, y + h - 1);
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                g.drawLine(x, y + h - 2, x + w - 3, y + h - 2);
            }
        }
        g.setColor(saved);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color saved = g.getColor();
        if (isSelected) {
            g.setColor(this.selectedColor);
        } else {
            Color bg = this.tabPane.getBackgroundAt(tabIndex);
            if (bg == null) {
                bg = Color.LIGHT_GRAY;
            }
            g.setColor(bg);
        }
        switch (tabPlacement) {
            case 1: {
                g.fillRect(x + 1, y + 1, w - 1, h - 1);
                break;
            }
            case 3: {
                g.fillRect(x, y, w - 1, h - 1);
                break;
            }
            case 2: {
                g.fillRect(x + 1, y + 1, w - 1, h - 2);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 1, h - 2);
            }
        }
        g.setColor(saved);
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.left - insets.right;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        if (this.tabPane.isOpaque()) {
            Color bg = UIManager.getColor("TabbedPane.contentAreaColor");
            g.setColor(bg);
            g.fillRect(x, y, w, h);
        }
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        g.setColor(this.lightHighlight);
        int startgap = this.rects[selectedIndex].x - this.currentScrollOffset;
        int endgap = this.rects[selectedIndex].x + this.rects[selectedIndex].width - this.currentScrollOffset;
        if (tabPlacement == 1 && startgap >= 0) {
            g.drawLine(x, y, startgap, y);
            g.drawLine(endgap, y, x + w - 1, y);
            g.setColor(this.selectedColor);
            g.drawLine(startgap, y, endgap - 1, y);
        } else {
            g.drawLine(x, y, x + w, y);
        }
        g.setColor(this.selectedColor);
        g.drawLine(x, y + 1, x + w - 1, y + 1);
        g.drawLine(x, y + 2, x + w - 1, y + 2);
        g.setColor(saved);
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        g.setColor(this.lightHighlight);
        int startgap = this.rects[selectedIndex].y - this.currentScrollOffset;
        int endgap = this.rects[selectedIndex].y + this.rects[selectedIndex].height - this.currentScrollOffset;
        if (tabPlacement == 2 && startgap >= 0) {
            g.drawLine(x, y, x, startgap);
            g.drawLine(x, endgap, x, y + h - 1);
            g.setColor(this.selectedColor);
            g.drawLine(x, startgap, x, endgap - 1);
        } else {
            g.drawLine(x, y, x, y + h - 1);
        }
        g.setColor(this.selectedColor);
        g.drawLine(x + 1, y + 1, x + 1, y + h - 4);
        g.setColor(saved);
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        int startgap = this.rects[selectedIndex].x - this.currentScrollOffset;
        int endgap = this.rects[selectedIndex].x + this.rects[selectedIndex].width - this.currentScrollOffset;
        if (tabPlacement == 3 && startgap >= 0) {
            g.setColor(this.shadow);
            g.drawLine(x + 1, y + h - 2, startgap, y + h - 2);
            g.drawLine(endgap, y + h - 2, x + w - 2, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h - 1, startgap, y + h - 1);
            g.drawLine(endgap, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(this.selectedColor);
            g.drawLine(startgap, y + h - 1, endgap - 1, y + h - 1);
            g.drawLine(startgap, y + h - 2, endgap - 1, y + h - 2);
        } else {
            g.setColor(this.shadow);
            g.drawLine(x + 1, y + h - 2, x + w - 1, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        }
        g.setColor(this.selectedColor);
        g.drawLine(x + 1, y + h - 3, x + w - 2, y + h - 3);
        g.setColor(saved);
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        int startgap = this.rects[selectedIndex].y - this.currentScrollOffset;
        int endgap = this.rects[selectedIndex].y + this.rects[selectedIndex].height - this.currentScrollOffset;
        if (tabPlacement == 4 && startgap >= 0) {
            g.setColor(this.shadow);
            g.drawLine(x + w - 2, y + 1, x + w - 2, startgap);
            g.drawLine(x + w - 2, endgap, x + w - 2, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, startgap);
            g.drawLine(x + w - 1, endgap, x + w - 1, y + h - 2);
            g.setColor(this.selectedColor);
            g.drawLine(x + w - 2, startgap, x + w - 2, endgap - 1);
            g.drawLine(x + w - 1, startgap, x + w - 1, endgap - 1);
        } else {
            g.setColor(this.shadow);
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 2);
        }
        g.setColor(this.selectedColor);
        g.drawLine(x + w - 3, y + 1, x + w - 3, y + h - 4);
        g.setColor(saved);
    }

    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        if (i >= this.rects.length) {
            this.layoutManager.layoutContainer(pane);
        }
        if (pane.getTabLayoutPolicy() == 1) {
            Rectangle r = new Rectangle(this.rects[i]);
            switch (pane.getTabPlacement()) {
                case 1: 
                case 3: {
                    r.x -= this.currentScrollOffset;
                    break;
                }
                default: {
                    r.y -= this.currentScrollOffset;
                }
            }
            return r;
        }
        return this.rects[i];
    }

    public int getTabRunCount(JTabbedPane pane) {
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        int tabCount = this.tabPane.getTabCount();
        int index = this.tabPane.getSelectedIndex();
        int i = 0;
        while (i < tabCount) {
            if (this.rects[i].contains(x, y)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.setBounds(this.getTabBounds(this.tabPane, tabIndex));
        return dest;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int tabCount) {
        if (this.rects.length < tabCount) {
            Rectangle[] old = this.rects;
            this.rects = new Rectangle[tabCount];
            System.arraycopy(old, 0, this.rects, 0, old.length);
            int i = old.length;
            while (i < this.rects.length) {
                this.rects[i] = new Rectangle();
                ++i;
            }
        }
    }

    protected void expandTabRunsArray() {
        if (this.tabRuns == null) {
            this.tabRuns = new int[10];
        } else {
            int[] newRuns = new int[this.tabRuns.length + 10];
            System.arraycopy(this.tabRuns, 0, newRuns, 0, this.tabRuns.length);
            this.tabRuns = newRuns;
        }
    }

    protected int getRunForTab(int tabCount, int tabIndex) {
        if (this.runCount == 1 && tabIndex < tabCount && tabIndex >= 0) {
            return 0;
        }
        int i = 0;
        while (i < this.runCount) {
            int last;
            int first = this.lastTabInRun(tabCount, this.getPreviousTabRun(i)) + 1;
            if (first == tabCount) {
                first = 0;
            }
            if ((last = this.lastTabInRun(tabCount, i)) >= tabIndex && first <= tabIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int lastTabInRun(int tabCount, int run) {
        int lastTab;
        if (this.runCount == 1) {
            lastTab = tabCount - 1;
        } else {
            int nextRun = run == this.runCount - 1 ? 0 : run + 1;
            lastTab = this.tabRuns[nextRun] == 0 ? tabCount - 1 : this.tabRuns[nextRun] - 1;
        }
        return lastTab;
    }

    protected int getTabRunOverlay(int tabPlacement) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int tabPlacement, int run) {
        return 0;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return true;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    protected Icon getIconForTab(int tabIndex) {
        if (this.tabPane.isEnabledAt(tabIndex)) {
            return this.tabPane.getIconAt(tabIndex);
        }
        return this.tabPane.getDisabledIconAt(tabIndex);
    }

    protected View getTextViewForTab(int tabIndex) {
        return null;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = fontHeight;
        Icon icon = this.getIconForTab(tabIndex);
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        if (icon != null) {
            height = Math.max(height, icon.getIconHeight());
        }
        return height += tabInsets.top + tabInsets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        this.maxTabHeight = 0;
        FontMetrics fm = this.getFontMetrics();
        int fontHeight = fm.getHeight();
        int i = 0;
        while (i < this.tabPane.getTabCount()) {
            this.maxTabHeight = Math.max(this.calculateTabHeight(tabPlacement, i, fontHeight), this.maxTabHeight);
            ++i;
        }
        return this.maxTabHeight;
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        View v;
        Icon icon = this.getIconForTab(tabIndex);
        Insets insets = this.getTabInsets(tabPlacement, tabIndex);
        int width = insets.bottom + insets.right + 3;
        if (icon != null) {
            width += icon.getIconWidth() + this.textIconGap;
        }
        if ((v = this.getTextViewForTab(tabIndex)) != null) {
            width = (int)((float)width + v.getPreferredSpan(0));
        } else {
            String label = this.tabPane.getTitleAt(tabIndex);
            width += metrics.stringWidth(label);
        }
        return width;
    }

    protected int calculateMaxTabWidth(int tabPlacement) {
        this.maxTabWidth = 0;
        FontMetrics fm = this.getFontMetrics();
        int i = 0;
        while (i < this.tabPane.getTabCount()) {
            this.maxTabWidth = Math.max(this.calculateTabWidth(tabPlacement, i, fm), this.maxTabWidth);
            ++i;
        }
        return this.maxTabWidth;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        Insets insets = this.getTabAreaInsets(tabPlacement);
        int tabAreaHeight = horizRunCount * maxTabHeight - (horizRunCount - 1) * this.getTabRunOverlay(tabPlacement);
        return tabAreaHeight += insets.top + insets.bottom;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        Insets insets = this.getTabAreaInsets(tabPlacement);
        int tabAreaWidth = vertRunCount * maxTabWidth - (vertRunCount - 1) * this.getTabRunOverlay(tabPlacement);
        return tabAreaWidth += insets.left + insets.right;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, target, tabPlacement);
        return target;
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, target, tabPlacement);
        return target;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.contentBorderInsets, target, tabPlacement);
        return target;
    }

    protected FontMetrics getFontMetrics() {
        FontMetrics fm = this.tabPane.getFontMetrics(this.tabPane.getFont());
        return fm;
    }

    protected void navigateSelectedTab(int direction) {
        int offset;
        int tabPlacement = this.tabPane.getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            if (direction == 7) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (direction == 3) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                offset = this.getTabRunOffset(tabPlacement, this.tabPane.getTabCount(), this.tabPane.getSelectedIndex(), tabPlacement == 1 ? direction == 1 : direction == 5);
                this.selectAdjacentRunTab(tabPlacement, this.tabPane.getSelectedIndex(), offset);
            }
        }
        if (tabPlacement == 2 || tabPlacement == 4) {
            if (direction == 1) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (direction == 5) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                offset = this.getTabRunOffset(tabPlacement, this.tabPane.getTabCount(), this.tabPane.getSelectedIndex(), tabPlacement == 2 ? direction == 7 : direction == 3);
                this.selectAdjacentRunTab(tabPlacement, this.tabPane.getSelectedIndex(), offset);
            }
        }
    }

    protected void selectNextTabInRun(int current) {
        current = this.getNextTabIndexInRun(this.tabPane.getTabCount(), current);
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            this.scrollTab(current, this.tabPane.getTabPlacement());
        }
        this.tabPane.setSelectedIndex(current);
    }

    protected void selectPreviousTabInRun(int current) {
        current = this.getPreviousTabIndexInRun(this.tabPane.getTabCount(), current);
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            this.scrollTab(current, this.tabPane.getTabPlacement());
        }
        this.tabPane.setSelectedIndex(current);
    }

    protected void selectNextTab(int current) {
        current = this.getNextTabIndex(current);
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            this.scrollTab(current, this.tabPane.getTabPlacement());
        }
        this.tabPane.setSelectedIndex(current);
    }

    protected void selectPreviousTab(int current) {
        current = this.getPreviousTabIndex(current);
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            this.scrollTab(current, this.tabPane.getTabPlacement());
        }
        this.tabPane.setSelectedIndex(current);
    }

    protected void selectAdjacentRunTab(int tabPlacement, int tabIndex, int offset) {
        int x = this.rects[tabIndex].x + this.rects[tabIndex].width / 2;
        int y = this.rects[tabIndex].y + this.rects[tabIndex].height / 2;
        switch (tabPlacement) {
            case 1: 
            case 3: {
                y += offset;
                break;
            }
            case 2: 
            case 4: {
                x += offset;
            }
        }
        int index = this.tabForCoordinate(this.tabPane, x, y);
        if (index != -1) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                this.scrollTab(index, tabPlacement);
            }
            this.tabPane.setSelectedIndex(index);
        }
    }

    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        int currRun = this.getRunForTab(tabCount, tabIndex);
        int nextRun = forward ? this.getNextTabRun(currRun) : this.getPreviousTabRun(currRun);
        int offset = tabPlacement == 1 || tabPlacement == 3 ? this.rects[this.lastTabInRun((int)tabCount, (int)nextRun)].y - this.rects[this.lastTabInRun((int)tabCount, (int)currRun)].y : this.rects[this.lastTabInRun((int)tabCount, (int)nextRun)].x - this.rects[this.lastTabInRun((int)tabCount, (int)currRun)].x;
        return offset;
    }

    protected int getPreviousTabIndex(int base) {
        if (--base < 0) {
            return this.tabPane.getTabCount() - 1;
        }
        return base;
    }

    protected int getNextTabIndex(int base) {
        if (++base == this.tabPane.getTabCount()) {
            return 0;
        }
        return base;
    }

    protected int getNextTabIndexInRun(int tabCount, int base) {
        int index = this.getNextTabIndex(base);
        int run = this.getRunForTab(tabCount, base);
        if (base == this.lastTabInRun(tabCount, run)) {
            index = run > 0 ? this.lastTabInRun(tabCount, this.getPreviousTabRun(run)) + 1 : 0;
        }
        return index;
    }

    protected int getPreviousTabIndexInRun(int tabCount, int base) {
        int run;
        int index = this.getPreviousTabIndex(base);
        if (index == this.lastTabInRun(tabCount, this.getPreviousTabRun(run = this.getRunForTab(tabCount, base)))) {
            index = this.lastTabInRun(tabCount, run);
        }
        return index;
    }

    protected int getPreviousTabRun(int baseRun) {
        int prevRun;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((prevRun = --baseRun) < 0) {
            prevRun = this.getTabRunCount(this.tabPane) - 1;
        }
        return prevRun;
    }

    protected int getNextTabRun(int baseRun) {
        int nextRun;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((nextRun = ++baseRun) == this.getTabRunCount(this.tabPane)) {
            nextRun = 0;
        }
        return nextRun;
    }

    protected static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        switch (targetPlacement) {
            default: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.right = topInsets.right;
                targetInsets.bottom = topInsets.bottom;
                break;
            }
            case 2: {
                targetInsets.left = topInsets.top;
                targetInsets.top = topInsets.left;
                targetInsets.right = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.bottom = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
            }
        }
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIManager.get("TabbedPane.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.put("TabbedPane.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigatePageDown", new NavigatePageDownAction());
        map.put("navigatePageUp", new NavigatePageUpAction());
        map.put("navigateDown", new NavigateAction("navigateDown", 5));
        map.put("navigateUp", new NavigateAction("navigateUp", 1));
        map.put("navigateLeft", new NavigateAction("navigateLeft", 7));
        map.put("navigateRight", new NavigateAction("navigateRight", 3));
        map.put("requestFocusForVisibleComponent", new RequestFocusForVisibleComponentAction());
        map.put("requestFocus", new RequestFocusAction());
        return map;
    }

    protected void setRolloverTab(int index) {
        this.rolloverTab = index;
    }

    protected int getRolloverTab() {
        return this.rolloverTab;
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent e) {
            Object source = e.getSource();
            if (source == BasicTabbedPaneUI.this.panel) {
                BasicTabbedPaneUI.this.tabPane.requestFocus();
            } else if (source == BasicTabbedPaneUI.this.tabPane) {
                BasicTabbedPaneUI.this.tabPane.repaint();
            }
        }

        public void focusLost(FocusEvent e) {
            if (e.getOppositeComponent() == BasicTabbedPaneUI.this.tabPane.getSelectedComponent()) {
                BasicTabbedPaneUI.this.tabPane.requestFocus();
            } else if (e.getSource() == BasicTabbedPaneUI.this.tabPane) {
                BasicTabbedPaneUI.this.tabPane.repaint();
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mouseReleased(MouseEvent e) {
            Object s = e.getSource();
            if (BasicTabbedPaneUI.this.tabPane != e.getSource()) {
                this.redispatchEvent(e);
                e.setSource(s);
            }
        }

        public void mousePressed(MouseEvent e) {
            Object s = e.getSource();
            if (BasicTabbedPaneUI.this.tabPane != e.getSource()) {
                this.redispatchEvent(e);
                e.setSource(s);
            }
            int placement = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            if (s == BasicTabbedPaneUI.this.incrButton) {
                if (!BasicTabbedPaneUI.this.incrButton.isEnabled()) {
                    return;
                }
                ++BasicTabbedPaneUI.this.currentScrollLocation;
                switch (placement) {
                    case 1: 
                    case 3: {
                        BasicTabbedPaneUI.this.currentScrollOffset = BasicTabbedPaneUI.this.getTabAreaInsets((int)placement).left;
                        int i = 0;
                        while (i < BasicTabbedPaneUI.this.currentScrollLocation) {
                            BasicTabbedPaneUI.this.currentScrollOffset += BasicTabbedPaneUI.this.rects[i].width;
                            ++i;
                        }
                        break;
                    }
                    default: {
                        BasicTabbedPaneUI.this.currentScrollOffset = BasicTabbedPaneUI.this.getTabAreaInsets((int)placement).top;
                        int i = 0;
                        while (i < BasicTabbedPaneUI.this.currentScrollLocation) {
                            BasicTabbedPaneUI.this.currentScrollOffset += BasicTabbedPaneUI.this.rects[i].height;
                            ++i;
                        }
                        break block0;
                    }
                }
                BasicTabbedPaneUI.this.updateViewPosition();
                BasicTabbedPaneUI.this.updateButtons();
                BasicTabbedPaneUI.this.tabPane.repaint();
            } else if (s == BasicTabbedPaneUI.this.decrButton) {
                if (!BasicTabbedPaneUI.this.decrButton.isEnabled()) {
                    return;
                }
                if (BasicTabbedPaneUI.this.currentScrollLocation > 0) {
                    --BasicTabbedPaneUI.this.currentScrollLocation;
                }
                BasicTabbedPaneUI.this.currentScrollOffset = 0;
                switch (placement) {
                    case 1: 
                    case 3: {
                        if (BasicTabbedPaneUI.this.currentScrollLocation > 0) {
                            BasicTabbedPaneUI.this.currentScrollOffset = BasicTabbedPaneUI.this.getTabAreaInsets((int)placement).left;
                        }
                        int i = 0;
                        while (i < BasicTabbedPaneUI.this.currentScrollLocation) {
                            BasicTabbedPaneUI.this.currentScrollOffset += BasicTabbedPaneUI.this.rects[i].width;
                            ++i;
                        }
                        break;
                    }
                    default: {
                        if (BasicTabbedPaneUI.this.currentScrollLocation > 0) {
                            BasicTabbedPaneUI.this.currentScrollOffset = BasicTabbedPaneUI.this.getTabAreaInsets((int)placement).top;
                        }
                        int i = 0;
                        while (i < BasicTabbedPaneUI.this.currentScrollLocation) {
                            BasicTabbedPaneUI.this.currentScrollOffset += BasicTabbedPaneUI.this.rects[i].height;
                            ++i;
                        }
                        break block3;
                    }
                }
                BasicTabbedPaneUI.this.updateViewPosition();
                BasicTabbedPaneUI.this.updateButtons();
                BasicTabbedPaneUI.this.tabPane.repaint();
            } else if (BasicTabbedPaneUI.this.tabPane.isEnabled()) {
                int index = BasicTabbedPaneUI.this.tabForCoordinate(BasicTabbedPaneUI.this.tabPane, e.getX(), e.getY());
                if (!BasicTabbedPaneUI.this.tabPane.isEnabledAt(index)) {
                    return;
                }
                if (BasicTabbedPaneUI.this.tabPane.getTabLayoutPolicy() == 1 && s == BasicTabbedPaneUI.this.panel) {
                    BasicTabbedPaneUI.this.scrollTab(index, placement);
                    BasicTabbedPaneUI.this.tabPane.setSelectedIndex(index);
                    BasicTabbedPaneUI.this.tabPane.repaint();
                } else {
                    BasicTabbedPaneUI.this.tabPane.setSelectedIndex(index);
                    BasicTabbedPaneUI.this.tabPane.revalidate();
                    BasicTabbedPaneUI.this.tabPane.repaint();
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
            Object s = e.getSource();
            if (BasicTabbedPaneUI.this.tabPane != e.getSource()) {
                this.redispatchEvent(e);
                e.setSource(s);
            }
            int tabIndex = BasicTabbedPaneUI.this.tabForCoordinate(BasicTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            BasicTabbedPaneUI.this.setRolloverTab(tabIndex);
        }

        public void mouseExited(MouseEvent e) {
            Object s = e.getSource();
            if (BasicTabbedPaneUI.this.tabPane != e.getSource()) {
                this.redispatchEvent(e);
                e.setSource(s);
            }
            BasicTabbedPaneUI.this.setRolloverTab(-1);
        }

        public void mouseMoved(MouseEvent ev) {
            Object s = ev.getSource();
            if (BasicTabbedPaneUI.this.tabPane != ev.getSource()) {
                ev.setSource(BasicTabbedPaneUI.this.tabPane);
                BasicTabbedPaneUI.this.tabPane.dispatchEvent(ev);
                ev.setSource(s);
            }
            int tabIndex = BasicTabbedPaneUI.this.tabForCoordinate(BasicTabbedPaneUI.this.tabPane, ev.getX(), ev.getY());
            BasicTabbedPaneUI.this.setRolloverTab(tabIndex);
        }

        void redispatchEvent(MouseEvent me) {
            me.setSource(BasicTabbedPaneUI.this.tabPane);
            Point viewPos = BasicTabbedPaneUI.this.viewport.getViewPosition();
            viewPos.x -= BasicTabbedPaneUI.this.viewport.getX();
            viewPos.y -= BasicTabbedPaneUI.this.viewport.getY();
            me.translatePoint(-viewPos.x, -viewPos.y);
            BasicTabbedPaneUI.this.tabPane.dispatchEvent(me);
            me.translatePoint(viewPos.x, viewPos.y);
        }
    }

    static class NavigateAction
    extends AbstractAction {
        int direction;

        NavigateAction(String name, int dir) {
            super(name);
            this.direction = dir;
        }

        public void actionPerformed(ActionEvent event) {
            JTabbedPane tp = (JTabbedPane)event.getSource();
            BasicTabbedPaneUI ui = (BasicTabbedPaneUI)tp.getUI();
            ui.navigateSelectedTab(this.direction);
        }
    }

    static class NavigatePageDownAction
    extends AbstractAction {
        public NavigatePageDownAction() {
            super("navigatePageDown");
        }

        public void actionPerformed(ActionEvent event) {
            JTabbedPane tp = (JTabbedPane)event.getSource();
            BasicTabbedPaneUI ui = (BasicTabbedPaneUI)tp.getUI();
            int i = tp.getSelectedIndex();
            if (i < 0) {
                i = 0;
            }
            ui.selectNextTabInRun(i);
        }
    }

    static class NavigatePageUpAction
    extends AbstractAction {
        public NavigatePageUpAction() {
            super("navigatePageUp");
        }

        public void actionPerformed(ActionEvent event) {
            JTabbedPane tp = (JTabbedPane)event.getSource();
            BasicTabbedPaneUI ui = (BasicTabbedPaneUI)tp.getUI();
            int i = tp.getSelectedIndex();
            if (i < 0) {
                i = 0;
            }
            ui.selectPreviousTabInRun(i);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            block5: {
                block4: {
                    if (!e.getPropertyName().equals("tabLayoutPolicy")) break block4;
                    BasicTabbedPaneUI.this.currentScrollOffset = 0;
                    BasicTabbedPaneUI.this.currentScrollLocation = 0;
                    BasicTabbedPaneUI.this.layoutManager = BasicTabbedPaneUI.this.createLayoutManager();
                    BasicTabbedPaneUI.this.tabPane.setLayout(BasicTabbedPaneUI.this.layoutManager);
                    break block5;
                }
                if (!e.getPropertyName().equals("tabPlacement") || BasicTabbedPaneUI.this.tabPane.getTabLayoutPolicy() != 1) break block5;
                BasicTabbedPaneUI.this.incrButton = BasicTabbedPaneUI.this.createIncreaseButton();
                BasicTabbedPaneUI.this.decrButton = BasicTabbedPaneUI.this.createDecreaseButton();
                int oldPlacement = (Integer)e.getOldValue();
                int newPlacement = (Integer)e.getNewValue();
                switch (newPlacement) {
                    case 1: 
                    case 3: {
                        if (oldPlacement != 1 && oldPlacement != 3) {
                            BasicTabbedPaneUI.this.currentScrollOffset = BasicTabbedPaneUI.this.getTabAreaInsets((int)newPlacement).left;
                            break;
                        }
                        break block5;
                    }
                    default: {
                        if (oldPlacement == 2 || oldPlacement == 4) break block5;
                        BasicTabbedPaneUI.this.currentScrollOffset = BasicTabbedPaneUI.this.getTabAreaInsets((int)newPlacement).top;
                    }
                }
                BasicTabbedPaneUI.this.updateViewPosition();
                BasicTabbedPaneUI.this.updateButtons();
            }
            BasicTabbedPaneUI.this.tabPane.revalidate();
            BasicTabbedPaneUI.this.tabPane.repaint();
        }
    }

    static class RequestFocusAction
    extends AbstractAction {
        public RequestFocusAction() {
            super("requestFocus");
        }

        public void actionPerformed(ActionEvent event) {
            ((JTabbedPane)event.getSource()).requestFocus();
        }
    }

    static class RequestFocusForVisibleComponentAction
    extends AbstractAction {
        public RequestFocusForVisibleComponentAction() {
            super("requestFocusForVisibleComponent");
        }

        public void actionPerformed(ActionEvent event) {
            JTabbedPane tp = (JTabbedPane)event.getSource();
            tp.getSelectedComponent().requestFocus();
        }
    }

    private class ScrollingButton
    extends BasicArrowButton
    implements UIResource {
        public ScrollingButton(int dir) {
            super(dir);
        }
    }

    private class ScrollingPanel
    extends JPanel {
        private ScrollingPanel() {
        }

        public void updateUI() {
            this.setUI(new ScrollingPanelUI());
        }

        private class ScrollingPanelUI
        extends BasicPanelUI {
            private ScrollingPanelUI() {
            }

            public void paint(Graphics g, JComponent c) {
                int placement = ((ScrollingPanel)ScrollingPanel.this).BasicTabbedPaneUI.this.tabPane.getTabPlacement();
                g.setColor(((ScrollingPanel)ScrollingPanel.this).BasicTabbedPaneUI.this.highlight);
                if (placement == 1 || placement == 3) {
                    g.fillRect(((ScrollingPanel)ScrollingPanel.this).BasicTabbedPaneUI.this.currentScrollOffset, 0, ((ScrollingPanel)ScrollingPanel.this).BasicTabbedPaneUI.this.tabAreaRect.width, ((ScrollingPanel)ScrollingPanel.this).BasicTabbedPaneUI.this.tabAreaRect.height);
                } else {
                    g.fillRect(0, ((ScrollingPanel)ScrollingPanel.this).BasicTabbedPaneUI.this.currentScrollOffset, ((ScrollingPanel)ScrollingPanel.this).BasicTabbedPaneUI.this.tabAreaRect.width, ((ScrollingPanel)ScrollingPanel.this).BasicTabbedPaneUI.this.tabAreaRect.height);
                }
                BasicTabbedPaneUI.this.paintTabArea(g, placement, ((ScrollingPanel)ScrollingPanel.this).BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
            }
        }
    }

    private class ScrollingViewport
    extends JViewport
    implements UIResource {
        private ScrollingViewport() {
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(BasicTabbedPaneUI.this.tabPane.getTabCount(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
            if (BasicTabbedPaneUI.this.tabPane.getTabLayoutPolicy() == 0) {
                BasicTabbedPaneUI.this.tabPane.revalidate();
            }
            BasicTabbedPaneUI.this.tabPane.repaint();
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void calculateLayoutInfo() {
            int count = BasicTabbedPaneUI.this.tabPane.getTabCount();
            BasicTabbedPaneUI.this.assureRectsCreated(count);
            this.calculateTabRects(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), count);
            BasicTabbedPaneUI.this.tabRunsDirty = false;
        }

        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int width = 0;
            int height = 0;
            int count = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int i = 0;
            while (i < count) {
                Component c = BasicTabbedPaneUI.this.tabPane.getComponentAt(i);
                if (c != null) {
                    Dimension dims;
                    Dimension dimension = dims = minimum ? c.getMinimumSize() : c.getPreferredSize();
                    if (dims != null) {
                        height = Math.max(height, dims.height);
                        width = Math.max(width, dims.width);
                    }
                }
                ++i;
            }
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            if (tabPlacement == 1 || tabPlacement == 3) {
                width = Math.max(BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement), width);
                height += this.preferredTabAreaHeight(tabPlacement, width - tabAreaInsets.left - tabAreaInsets.right);
            } else {
                height = Math.max(BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement), height);
                width += this.preferredTabAreaWidth(tabPlacement, height - tabAreaInsets.top - tabAreaInsets.bottom);
            }
            Insets tabPaneInsets = BasicTabbedPaneUI.this.tabPane.getInsets();
            return new Dimension(width + tabPaneInsets.left + tabPaneInsets.right, height + tabPaneInsets.top + tabPaneInsets.bottom);
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int i;
            int breakAt;
            int y;
            int x;
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Dimension size = BasicTabbedPaneUI.this.tabPane.getSize();
            switch (tabPlacement) {
                case 2: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    breakAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - (insets.right + tabAreaInsets.right) - BasicTabbedPaneUI.this.maxTabWidth - 1;
                    y = insets.top + tabAreaInsets.top;
                    breakAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - (insets.bottom + tabAreaInsets.bottom) - BasicTabbedPaneUI.this.maxTabHeight - 1;
                    breakAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    breakAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            if (tabCount == 0) {
                return;
            }
            FontMetrics fm = BasicTabbedPaneUI.this.getFontMetrics();
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            int selectedIndex = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            if (tabPlacement == 1 || tabPlacement == 3) {
                i = 0;
                while (i < tabCount) {
                    rect = BasicTabbedPaneUI.this.rects[i];
                    if (i > 0) {
                        rect.x = BasicTabbedPaneUI.this.rects[i - 1].x + BasicTabbedPaneUI.this.rects[i - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = BasicTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, fm);
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rect.width);
                    if (rect.x != 2 + insets.left && rect.x + rect.width > breakAt) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = i;
                        ++BasicTabbedPaneUI.this.runCount;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = BasicTabbedPaneUI.this.maxTabHeight;
                    if (i == selectedIndex) {
                        BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.runCount - 1;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < tabCount) {
                    rect = BasicTabbedPaneUI.this.rects[i];
                    if (i > 0) {
                        rect.y = BasicTabbedPaneUI.this.rects[i - 1].y + BasicTabbedPaneUI.this.rects[i - 1].height;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = BasicTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fm.getHeight());
                    BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rect.height);
                    if (rect.y != 2 + insets.top && rect.y + rect.height > breakAt) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = i;
                        ++BasicTabbedPaneUI.this.runCount;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = BasicTabbedPaneUI.this.maxTabWidth;
                    if (i == selectedIndex) {
                        BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.runCount - 1;
                    }
                    ++i;
                }
            }
            if (BasicTabbedPaneUI.this.runCount > 1) {
                int start = tabPlacement == 1 || tabPlacement == 3 ? x : y;
                this.normalizeTabRuns(tabPlacement, tabCount, start, breakAt);
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(tabCount, selectedIndex);
                if (BasicTabbedPaneUI.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, BasicTabbedPaneUI.this.selectedRun);
                }
            }
            if (BasicTabbedPaneUI.this.runCount == 1) {
                return;
            }
            int tabRunOverlay = BasicTabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            int i2 = BasicTabbedPaneUI.this.runCount - 1;
            while (i2 >= 0) {
                int j;
                int end;
                int start = BasicTabbedPaneUI.this.tabRuns[i2];
                int nextIndex = i2 == BasicTabbedPaneUI.this.runCount - 1 ? 0 : i2 + 1;
                int next = BasicTabbedPaneUI.this.tabRuns[nextIndex];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (tabPlacement == 1 || tabPlacement == 3) {
                    j = start;
                    while (j <= end) {
                        rect = BasicTabbedPaneUI.this.rects[j];
                        rect.y = y;
                        rect.x += BasicTabbedPaneUI.this.getTabRunIndent(tabPlacement, i2);
                        ++j;
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i2)) {
                        this.padTabRun(tabPlacement, start, end, breakAt);
                    }
                    y = tabPlacement == 3 ? (y -= BasicTabbedPaneUI.this.maxTabHeight - tabRunOverlay) : (y += BasicTabbedPaneUI.this.maxTabHeight - tabRunOverlay);
                } else {
                    j = start;
                    while (j <= end) {
                        rect = BasicTabbedPaneUI.this.rects[j];
                        rect.x = x;
                        rect.y += BasicTabbedPaneUI.this.getTabRunIndent(tabPlacement, i2);
                        ++j;
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i2)) {
                        this.padTabRun(tabPlacement, start, end, breakAt);
                    }
                    x = tabPlacement == 4 ? (x -= BasicTabbedPaneUI.this.maxTabWidth - tabRunOverlay) : (x += BasicTabbedPaneUI.this.maxTabWidth - tabRunOverlay);
                }
                --i2;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
        }

        public void layoutContainer(Container parent) {
            int childCount;
            this.calculateLayoutInfo();
            int tabPlacement = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component selectedComponent = null;
            if (selectedIndex >= 0) {
                selectedComponent = BasicTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
            }
            if (selectedComponent != null) {
                BasicTabbedPaneUI.this.setVisibleComponent(selectedComponent);
            }
            if ((childCount = BasicTabbedPaneUI.this.tabPane.getComponentCount()) > 0) {
                int compY;
                int compX;
                int tabAreaWidth = 0;
                int tabAreaHeight = 0;
                switch (tabPlacement) {
                    case 2: {
                        tabAreaWidth = BasicTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                        compX = tabAreaWidth + insets.left + BasicTabbedPaneUI.this.contentBorderInsets.left;
                        compY = insets.top + BasicTabbedPaneUI.this.contentBorderInsets.top;
                        break;
                    }
                    case 4: {
                        tabAreaWidth = BasicTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                        compX = insets.left + BasicTabbedPaneUI.this.contentBorderInsets.left;
                        compY = insets.top + BasicTabbedPaneUI.this.contentBorderInsets.top;
                        break;
                    }
                    case 3: {
                        tabAreaHeight = BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                        compX = insets.left + BasicTabbedPaneUI.this.contentBorderInsets.left;
                        compY = insets.top + BasicTabbedPaneUI.this.contentBorderInsets.top;
                        break;
                    }
                    default: {
                        tabAreaHeight = BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                        compX = insets.left + BasicTabbedPaneUI.this.contentBorderInsets.left;
                        compY = tabAreaHeight + insets.top + BasicTabbedPaneUI.this.contentBorderInsets.top;
                    }
                }
                Rectangle bounds = BasicTabbedPaneUI.this.tabPane.getBounds();
                int compWidth = bounds.width - tabAreaWidth - insets.left - insets.right - BasicTabbedPaneUI.this.contentBorderInsets.left - BasicTabbedPaneUI.this.contentBorderInsets.right;
                int compHeight = bounds.height - tabAreaHeight - insets.top - insets.bottom - BasicTabbedPaneUI.this.contentBorderInsets.top - BasicTabbedPaneUI.this.contentBorderInsets.bottom;
                int i = 0;
                while (i < childCount) {
                    Component c = BasicTabbedPaneUI.this.tabPane.getComponent(i);
                    c.setBounds(compX, compY, compWidth, compHeight);
                    ++i;
                }
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(true);
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            boolean horizontal = tabPlacement == 1 || tabPlacement == 3;
            int currentRun = BasicTabbedPaneUI.this.runCount - 1;
            double weight = 1.25;
            boolean adjust = true;
            while (adjust) {
                int prevLength;
                int end;
                int last = BasicTabbedPaneUI.this.lastTabInRun(tabCount, currentRun);
                int prevLast = BasicTabbedPaneUI.this.lastTabInRun(tabCount, currentRun - 1);
                if (horizontal) {
                    end = BasicTabbedPaneUI.this.rects[last].x + BasicTabbedPaneUI.this.rects[last].width;
                    prevLength = (int)((double)BasicTabbedPaneUI.this.maxTabWidth * weight);
                } else {
                    end = BasicTabbedPaneUI.this.rects[last].y + BasicTabbedPaneUI.this.rects[last].height;
                    prevLength = (int)((double)BasicTabbedPaneUI.this.maxTabWidth * weight * 2.0);
                }
                if (max - end > prevLength) {
                    BasicTabbedPaneUI.this.tabRuns[currentRun] = prevLast;
                    if (horizontal) {
                        BasicTabbedPaneUI.this.rects[prevLast].x = start;
                    } else {
                        BasicTabbedPaneUI.this.rects[prevLast].y = start;
                    }
                    int i = prevLast + 1;
                    while (i <= last) {
                        if (horizontal) {
                            BasicTabbedPaneUI.this.rects[i].x = BasicTabbedPaneUI.this.rects[i - 1].x + BasicTabbedPaneUI.this.rects[i - 1].width;
                        } else {
                            BasicTabbedPaneUI.this.rects[i].y = BasicTabbedPaneUI.this.rects[i - 1].y + BasicTabbedPaneUI.this.rects[i - 1].height;
                        }
                        ++i;
                    }
                } else if (currentRun == BasicTabbedPaneUI.this.runCount - 1) {
                    adjust = false;
                }
                if (currentRun - 1 > 0) {
                    --currentRun;
                    continue;
                }
                currentRun = BasicTabbedPaneUI.this.runCount - 1;
                weight += 0.25;
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            Insets insets = BasicTabbedPaneUI.this.getSelectedTabPadInsets(tabPlacement);
            BasicTabbedPaneUI.this.rects[selectedIndex].x -= insets.left;
            BasicTabbedPaneUI.this.rects[selectedIndex].y -= insets.top;
            BasicTabbedPaneUI.this.rects[selectedIndex].width += insets.left + insets.right;
            BasicTabbedPaneUI.this.rects[selectedIndex].height += insets.top + insets.bottom;
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = BasicTabbedPaneUI.this.rects[end].x + BasicTabbedPaneUI.this.rects[end].width;
                int spaceRemaining = max - runWidth;
                int numTabs = end - start + 1;
                int spaceAllocated = spaceRemaining / numTabs;
                int currX = BasicTabbedPaneUI.this.rects[start].x;
                int i = start;
                while (i <= end) {
                    BasicTabbedPaneUI.this.rects[i].x = currX;
                    BasicTabbedPaneUI.this.rects[i].width += spaceAllocated;
                    currX += BasicTabbedPaneUI.this.rects[i].width;
                    if (i == end && BasicTabbedPaneUI.this.rects[i].x + BasicTabbedPaneUI.this.rects[i].width != max) {
                        BasicTabbedPaneUI.this.rects[i].width = max - BasicTabbedPaneUI.this.rects[i].x;
                    }
                    ++i;
                }
            } else {
                int runHeight = BasicTabbedPaneUI.this.rects[end].y + BasicTabbedPaneUI.this.rects[end].height;
                int spaceRemaining = max - runHeight;
                int numTabs = end - start + 1;
                int spaceAllocated = spaceRemaining / numTabs;
                int currY = BasicTabbedPaneUI.this.rects[start].y;
                int i = start;
                while (i <= end) {
                    BasicTabbedPaneUI.this.rects[i].y = currY;
                    BasicTabbedPaneUI.this.rects[i].height += spaceAllocated;
                    currY += BasicTabbedPaneUI.this.rects[i].height;
                    if (i == end && BasicTabbedPaneUI.this.rects[i].y + BasicTabbedPaneUI.this.rects[i].height != max) {
                        BasicTabbedPaneUI.this.rects[i].height = max - BasicTabbedPaneUI.this.rects[i].y;
                    }
                    ++i;
                }
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 0;
            int runWidth = 0;
            int tabWidth = 0;
            FontMetrics fm = BasicTabbedPaneUI.this.getFontMetrics();
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            width -= tabAreaInsets.left + tabAreaInsets.right + insets.left + insets.right;
            int i = 0;
            while (i < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                tabWidth = BasicTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, fm);
                if (runWidth + tabWidth > width) {
                    runWidth = tabWidth;
                    ++runs;
                } else {
                    runWidth += tabWidth;
                }
                ++i;
            }
            int maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            int tabAreaHeight = BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, ++runs, maxTabHeight);
            return tabAreaHeight;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 0;
            int runHeight = 0;
            int tabHeight = 0;
            FontMetrics fm = BasicTabbedPaneUI.this.getFontMetrics();
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            height -= tabAreaInsets.top + tabAreaInsets.bottom + insets.top + insets.bottom;
            int fontHeight = fm.getHeight();
            int i = 0;
            while (i < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                tabHeight = BasicTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                if (runHeight + tabHeight > height) {
                    runHeight = tabHeight;
                    ++runs;
                } else {
                    runHeight += tabHeight;
                }
                ++i;
            }
            int maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
            int tabAreaWidth = BasicTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, ++runs, maxTabWidth);
            return tabAreaWidth;
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            if (BasicTabbedPaneUI.this.runCount == 1 || selectedRun == 0 || selectedRun == -1) {
                return;
            }
            int[] newTabRuns = new int[BasicTabbedPaneUI.this.tabRuns.length];
            int currentRun = selectedRun;
            int i = 0;
            do {
                newTabRuns[i] = BasicTabbedPaneUI.this.tabRuns[currentRun];
                currentRun = BasicTabbedPaneUI.this.getNextTabRun(currentRun);
            } while (++i < BasicTabbedPaneUI.this.runCount);
            BasicTabbedPaneUI.this.tabRuns = newTabRuns;
            BasicTabbedPaneUI.this.selectedRun = 1;
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return super.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return super.calculateSize(true);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 1;
            int maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            int tabAreaHeight = BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, runs, maxTabHeight);
            return tabAreaHeight;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 1;
            int maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
            int tabAreaWidth = BasicTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, runs, maxTabWidth);
            return tabAreaWidth;
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            if (tabCount == 0) {
                return;
            }
            FontMetrics fm = BasicTabbedPaneUI.this.getFontMetrics();
            SwingUtilities.calculateInnerArea(BasicTabbedPaneUI.this.tabPane, BasicTabbedPaneUI.this.calcRect);
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            if (tabPlacement == 1 || tabPlacement == 3) {
                int maxHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                BasicTabbedPaneUI.this.calcRect.width -= tabAreaInsets.left + tabAreaInsets.right;
                int width = 0;
                int runWidth = tabAreaInsets.left + insets.left;
                int top = insets.top + tabAreaInsets.top;
                int i = 0;
                while (i < tabCount) {
                    width = BasicTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, fm);
                    BasicTabbedPaneUI.this.rects[i].setBounds(runWidth, top, width, maxHeight);
                    runWidth += width;
                    ++i;
                }
                BasicTabbedPaneUI.this.tabAreaRect.width = BasicTabbedPaneUI.this.tabPane.getWidth() - insets.left - insets.right;
                BasicTabbedPaneUI.this.tabAreaRect.height = BasicTabbedPaneUI.this.maxTabHeight + tabAreaInsets.top + tabAreaInsets.bottom;
                BasicTabbedPaneUI.this.contentRect.width = BasicTabbedPaneUI.this.tabAreaRect.width;
                BasicTabbedPaneUI.this.contentRect.height = BasicTabbedPaneUI.this.tabPane.getHeight() - insets.top - insets.bottom - BasicTabbedPaneUI.this.tabAreaRect.height;
                BasicTabbedPaneUI.this.contentRect.x = insets.left;
                BasicTabbedPaneUI.this.tabAreaRect.x = insets.left;
                if (tabPlacement == 3) {
                    BasicTabbedPaneUI.this.contentRect.y = insets.top;
                    BasicTabbedPaneUI.this.tabAreaRect.y = BasicTabbedPaneUI.this.contentRect.y + BasicTabbedPaneUI.this.contentRect.height;
                } else {
                    BasicTabbedPaneUI.this.tabAreaRect.y = insets.top;
                    BasicTabbedPaneUI.this.contentRect.y = BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height;
                }
            } else {
                int maxWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                BasicTabbedPaneUI.this.calcRect.height -= tabAreaInsets.top + tabAreaInsets.bottom;
                int height = 0;
                int runHeight = tabAreaInsets.top + insets.top;
                int fontHeight = fm.getHeight();
                int left = insets.left + tabAreaInsets.left;
                int i = 0;
                while (i < tabCount) {
                    height = BasicTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    BasicTabbedPaneUI.this.rects[i].setBounds(left, runHeight, maxWidth, height);
                    runHeight += height;
                    ++i;
                }
                BasicTabbedPaneUI.this.tabAreaRect.width = BasicTabbedPaneUI.this.maxTabWidth + tabAreaInsets.left + tabAreaInsets.right;
                BasicTabbedPaneUI.this.tabAreaRect.height = BasicTabbedPaneUI.this.tabPane.getHeight() - insets.top - insets.bottom;
                BasicTabbedPaneUI.this.tabAreaRect.y = insets.top;
                BasicTabbedPaneUI.this.contentRect.width = BasicTabbedPaneUI.this.tabPane.getWidth() - insets.left - insets.right - BasicTabbedPaneUI.this.tabAreaRect.width;
                BasicTabbedPaneUI.this.contentRect.height = BasicTabbedPaneUI.this.tabAreaRect.height;
                BasicTabbedPaneUI.this.contentRect.y = insets.top;
                if (tabPlacement == 2) {
                    BasicTabbedPaneUI.this.tabAreaRect.x = insets.left;
                    BasicTabbedPaneUI.this.contentRect.x = BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width;
                } else {
                    BasicTabbedPaneUI.this.contentRect.x = insets.left;
                    BasicTabbedPaneUI.this.tabAreaRect.x = BasicTabbedPaneUI.this.contentRect.x + BasicTabbedPaneUI.this.contentRect.width;
                }
            }
        }

        public void layoutContainer(Container pane) {
            Dimension decrDims;
            Dimension incrDims;
            super.layoutContainer(pane);
            int tabCount = BasicTabbedPaneUI.this.tabPane.getTabCount();
            if (tabCount == 0) {
                return;
            }
            int tabPlacement = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                if (BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width < BasicTabbedPaneUI.this.rects[tabCount - 1].x + BasicTabbedPaneUI.this.rects[tabCount - 1].width) {
                    incrDims = BasicTabbedPaneUI.this.incrButton.getPreferredSize();
                    decrDims = BasicTabbedPaneUI.this.decrButton.getPreferredSize();
                    if (tabPlacement == 3) {
                        BasicTabbedPaneUI.this.decrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width - incrDims.width - decrDims.width, BasicTabbedPaneUI.this.tabAreaRect.y, decrDims.width, decrDims.height);
                        BasicTabbedPaneUI.this.incrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width - incrDims.width, BasicTabbedPaneUI.this.tabAreaRect.y, incrDims.width, incrDims.height);
                    } else {
                        BasicTabbedPaneUI.this.decrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width - incrDims.width - decrDims.width, BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height - decrDims.height, decrDims.width, decrDims.height);
                        BasicTabbedPaneUI.this.incrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width - incrDims.width, BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height - incrDims.height, incrDims.width, incrDims.height);
                    }
                    BasicTabbedPaneUI.this.tabAreaRect.width -= decrDims.width + incrDims.width;
                    BasicTabbedPaneUI.this.updateButtons();
                    BasicTabbedPaneUI.this.incrButton.setVisible(true);
                    BasicTabbedPaneUI.this.decrButton.setVisible(true);
                } else {
                    BasicTabbedPaneUI.this.incrButton.setVisible(false);
                    BasicTabbedPaneUI.this.decrButton.setVisible(false);
                    BasicTabbedPaneUI.this.currentScrollOffset = 0;
                    BasicTabbedPaneUI.this.currentScrollLocation = 0;
                }
            }
            if (tabPlacement == 2 || tabPlacement == 4) {
                if (BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height < BasicTabbedPaneUI.this.rects[tabCount - 1].y + BasicTabbedPaneUI.this.rects[tabCount - 1].height) {
                    incrDims = BasicTabbedPaneUI.this.incrButton.getPreferredSize();
                    decrDims = BasicTabbedPaneUI.this.decrButton.getPreferredSize();
                    if (tabPlacement == 4) {
                        BasicTabbedPaneUI.this.decrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x, BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height - incrDims.height - decrDims.height, decrDims.width, decrDims.height);
                        BasicTabbedPaneUI.this.incrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x, BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height - incrDims.height, incrDims.width, incrDims.height);
                    } else {
                        BasicTabbedPaneUI.this.decrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width - decrDims.width, BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height - incrDims.height - decrDims.height, decrDims.width, decrDims.height);
                        BasicTabbedPaneUI.this.incrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width - incrDims.width, BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height - incrDims.height, incrDims.width, incrDims.height);
                    }
                    BasicTabbedPaneUI.this.tabAreaRect.height -= decrDims.height + incrDims.height;
                    BasicTabbedPaneUI.this.incrButton.setVisible(true);
                    BasicTabbedPaneUI.this.decrButton.setVisible(true);
                } else {
                    BasicTabbedPaneUI.this.incrButton.setVisible(false);
                    BasicTabbedPaneUI.this.decrButton.setVisible(false);
                    BasicTabbedPaneUI.this.currentScrollOffset = 0;
                    BasicTabbedPaneUI.this.currentScrollLocation = 0;
                }
            }
            BasicTabbedPaneUI.this.viewport.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x, BasicTabbedPaneUI.this.tabAreaRect.y, BasicTabbedPaneUI.this.tabAreaRect.width, BasicTabbedPaneUI.this.tabAreaRect.height);
            BasicTabbedPaneUI.this.updateViewPosition();
            BasicTabbedPaneUI.this.viewport.repaint();
        }
    }
}

