/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayoutCache
implements RowMapper {
    protected NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected boolean rootVisible;
    protected int rowHeight;

    public void setNodeDimensions(NodeDimensions dimensions) {
        this.nodeDimensions = dimensions;
    }

    public NodeDimensions getNodeDimensions() {
        return this.nodeDimensions;
    }

    protected Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle bounds) {
        Rectangle d = null;
        if (this.nodeDimensions != null) {
            d = this.nodeDimensions.getNodeDimensions(value, row, depth, expanded, bounds);
        }
        return d;
    }

    public void setModel(TreeModel model) {
        this.treeModel = model;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setRootVisible(boolean visible) {
        this.rootVisible = visible;
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRowHeight(int height) {
        this.rowHeight = height;
        this.invalidateSizes();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setSelectionModel(TreeSelectionModel model) {
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(null);
        }
        this.treeSelectionModel = model;
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.setRowMapper(this);
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public int getPreferredHeight() {
        int height = 0;
        int n = this.getRowCount();
        Rectangle r = new Rectangle();
        int i = 0;
        while (i < n) {
            TreePath path = this.getPathForRow(i);
            height += this.getBounds((TreePath)path, (Rectangle)r).height;
            ++i;
        }
        return height;
    }

    public int getPreferredWidth(Rectangle rect) {
        int maximalWidth = 0;
        Rectangle r = new Rectangle();
        int n = this.getRowCount();
        int i = 0;
        while (i < n) {
            TreePath path = this.getPathForRow(i);
            r.setBounds(0, 0, 0, 0);
            r = this.getBounds(path, r);
            if (r.x + r.width > maximalWidth) {
                maximalWidth = r.x + r.width;
            }
            this.invalidatePathBounds(path);
            ++i;
        }
        return maximalWidth;
    }

    public abstract boolean isExpanded(TreePath var1);

    public abstract Rectangle getBounds(TreePath var1, Rectangle var2);

    public abstract TreePath getPathForRow(int var1);

    public abstract int getRowForPath(TreePath var1);

    public abstract TreePath getPathClosestTo(int var1, int var2);

    public abstract Enumeration<TreePath> getVisiblePathsFrom(TreePath var1);

    public abstract int getVisibleChildCount(TreePath var1);

    public abstract void setExpandedState(TreePath var1, boolean var2);

    public abstract boolean getExpandedState(TreePath var1);

    public abstract int getRowCount();

    public abstract void invalidateSizes();

    public abstract void invalidatePathBounds(TreePath var1);

    public abstract void treeNodesChanged(TreeModelEvent var1);

    public abstract void treeNodesInserted(TreeModelEvent var1);

    public abstract void treeNodesRemoved(TreeModelEvent var1);

    public abstract void treeStructureChanged(TreeModelEvent var1);

    @Override
    public int[] getRowsForPaths(TreePath[] paths) {
        int[] rows = null;
        if (paths != null) {
            rows = new int[paths.length];
            int i = 0;
            while (i < rows.length) {
                rows[i] = this.getRowForPath(paths[i]);
                ++i;
            }
        }
        return rows;
    }

    protected boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public static abstract class NodeDimensions {
        public abstract Rectangle getNodeDimensions(Object var1, int var2, int var3, boolean var4, Rectangle var5);
    }
}

