#!/bin/sh
export PATH='/usr/obj/ports/hs-HTTP-4000.3.7/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: HTTP
version: 4000.3.7
id: HTTP-4000.3.7-BrMupjBt6VI5SSxxBJEd3T
key: HTTP-4000.3.7-BrMupjBt6VI5SSxxBJEd3T
license: BSD3
maintainer: Ganesh Sittampalam <ganesh@earth.li>
homepage: https://github.com/haskell/HTTP
synopsis: A library for client-side HTTP
description:
    The HTTP package supports client-side web programming in Haskell. It lets you set up
    HTTP connections, transmitting requests and processing the responses coming back, all
    from within the comforts of Haskell. It'\''s dependent on the network package to operate,
    but other than that, the implementation is all written in Haskell.
    .
    A basic API for issuing single HTTP requests + receiving responses is provided. On top
    of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
    it taking care of handling the management of persistent connections, proxies,
    state (cookies) and authentication credentials required to handle multi-step
    interactions with a web server.
    .
    The representation of the bytes flowing across is extensible via the use of a type class,
    letting you pick the representation of requests and responses that best fits your use.
    Some pre-packaged, common instances are provided for you (@ByteString@, @String@).
    .
    Here'\''s an example use:
    .
    >
    >    do
    >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
    >              -- fetch document and return it (as a '\''String'\''.)
    >      fmap (take 100) (getResponseBody rsp)
    >
    >    do
    >      (_, rsp)
    >         <- Network.Browser.browse $ do
    >               setAllowRedirects True -- handle HTTP redirects
    >               request $ getRequest "http://www.haskell.org/"
    >      return (take 100 (rspBody rsp))
    .
    __Note:__ This package does not support HTTPS connections.
    If you need HTTPS, take a look at the following packages:
    .
    * <http://hackage.haskell.org/package/http-streams http-streams>
    .
    * <http://hackage.haskell.org/package/http-client http-client> (in combination with
    <http://hackage.haskell.org/package/http-client-tls http-client-tls>)
    .
    * <http://hackage.haskell.org/package/req req>
    .
    * <http://hackage.haskell.org/package/wreq wreq>
    .
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
exposed: True
indefinite: False
exposed-modules:
    Network.Browser Network.BufferType Network.HTTP Network.HTTP.Auth
    Network.HTTP.Base Network.HTTP.Cookie Network.HTTP.HandleStream
    Network.HTTP.Headers Network.HTTP.Proxy Network.HTTP.Stream
    Network.Stream Network.StreamDebugger Network.StreamSocket
    Network.TCP
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
abi: 693ee8a20f4df0228fc914af93c30119
trusted: False
import-dirs: /usr/local/lib/ghc/HTTP-4000.3.7
library-dirs: /usr/local/lib/ghc/HTTP-4000.3.7
              /usr/local/lib/x86_64-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-HTTP-4000.3.7
hs-libraries: HSHTTP-4000.3.7-BrMupjBt6VI5SSxxBJEd3T
depends:
    base-4.10.1.0 parsec-3.1.9-444fzLM2idQ5vByZuGIOJ array-0.5.2.0
    bytestring-0.10.8.2 time-1.8.0.2 mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    network-uri-2.6.0.3-GWiZs2R299yBQO2d6Ohaq0
    network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV
abi-depends: base-4.10.1.0=3319c96bc0bdd0e7df6bb89e8bc8756b
             parsec-3.1.9-444fzLM2idQ5vByZuGIOJ=355b0baaf01dc31d4083e3a8f8b08b8a
             array-0.5.2.0=26dc06837667b4f45ea7fe07c114ff89
             bytestring-0.10.8.2=bad4023def214da3b9be582a43b5e246
             time-1.8.0.2=1980548222fbca3cc4f4aa5245bbb96e
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=1e76d6f7019a4b5c8c222b2fbbb06681
             network-uri-2.6.0.3-GWiZs2R299yBQO2d6Ohaq0=c298d83f1aeab331cf26f106bd96624a
             network-2.6.2.1-EN7QebdZTnQLy4O4vi1CmV=1e391bce62287578e3a86dbbea151616
haddock-interfaces: /usr/local/share/doc/hs-HTTP-4000.3.7/html/HTTP.haddock
haddock-html: /usr/local/share/doc/hs-HTTP-4000.3.7/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

