/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocksmaker;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JumpInfo;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.TargetInsnNode;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.SplitterBlockAttr;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BlockSplitter
extends AbstractVisitor {
    private static final Set<InsnType> SEPARATE_INSNS = EnumSet.of(InsnType.RETURN, new InsnType[]{InsnType.IF, InsnType.SWITCH, InsnType.MONITOR_ENTER, InsnType.MONITOR_EXIT, InsnType.THROW});

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        mth.checkInstructions();
        mth.initBasicBlocks();
        BlockSplitter.splitBasicBlocks(mth);
        BlockSplitter.removeInsns(mth);
        BlockSplitter.removeEmptyDetachedBlocks(mth);
        BlockSplitter.initBlocksInTargetNodes(mth);
    }

    private static void initBlocksInTargetNodes(MethodNode mth) {
        mth.getBasicBlocks().forEach(block -> {
            InsnNode lastInsn = BlockUtils.getLastInsn(block);
            if (lastInsn instanceof TargetInsnNode) {
                ((TargetInsnNode)lastInsn).initBlocks((BlockNode)block);
            }
        });
    }

    private static void splitBasicBlocks(MethodNode mth) {
        InsnNode prevInsn = null;
        HashMap<Integer, BlockNode> blocksMap = new HashMap<Integer, BlockNode>();
        BlockNode curBlock = BlockSplitter.startNewBlock(mth, 0);
        mth.setEnterBlock(curBlock);
        for (InsnNode insn : mth.getInstructions()) {
            if (insn == null) continue;
            boolean startNew = false;
            if (prevInsn != null) {
                BlockNode block;
                InsnType type = prevInsn.getType();
                if (type == InsnType.GOTO || type == InsnType.THROW || SEPARATE_INSNS.contains((Object)type)) {
                    if (type == InsnType.RETURN || type == InsnType.THROW) {
                        mth.addExitBlock(curBlock);
                    }
                    block = BlockSplitter.startNewBlock(mth, insn.getOffset());
                    if (type == InsnType.MONITOR_ENTER || type == InsnType.MONITOR_EXIT) {
                        BlockSplitter.connect(curBlock, block);
                    }
                    curBlock = block;
                    startNew = true;
                } else {
                    boolean bl = startNew = BlockSplitter.isSplitByJump(prevInsn, insn) || SEPARATE_INSNS.contains((Object)insn.getType()) || BlockSplitter.isDoWhile(blocksMap, curBlock, insn) || insn.contains(AType.EXC_HANDLER) || prevInsn.contains(AFlag.TRY_LEAVE) || prevInsn.getType() == InsnType.MOVE_EXCEPTION;
                    if (startNew) {
                        block = BlockSplitter.startNewBlock(mth, insn.getOffset());
                        BlockSplitter.connect(curBlock, block);
                        curBlock = block;
                    }
                }
            }
            if (insn.contains(AFlag.TRY_ENTER)) {
                BlockNode block;
                if (insn.getOffset() != 0 && !startNew) {
                    block = BlockSplitter.startNewBlock(mth, insn.getOffset());
                    BlockSplitter.connect(curBlock, block);
                    curBlock = block;
                }
                blocksMap.put(insn.getOffset(), curBlock);
                block = BlockSplitter.startNewBlock(mth, -1);
                curBlock.add(AFlag.SYNTHETIC);
                SplitterBlockAttr splitter = new SplitterBlockAttr(curBlock);
                block.addAttr(splitter);
                curBlock.addAttr(splitter);
                BlockSplitter.connect(curBlock, block);
                curBlock = block;
            } else {
                blocksMap.put(insn.getOffset(), curBlock);
            }
            curBlock.getInstructions().add(insn);
            prevInsn = insn;
        }
        BlockSplitter.setupConnections(mth, blocksMap);
    }

    static BlockNode startNewBlock(MethodNode mth, int offset) {
        BlockNode block = new BlockNode(mth.getBasicBlocks().size(), offset);
        mth.getBasicBlocks().add(block);
        return block;
    }

    static void connect(BlockNode from, BlockNode to) {
        if (!from.getSuccessors().contains(to)) {
            from.getSuccessors().add(to);
        }
        if (!to.getPredecessors().contains(from)) {
            to.getPredecessors().add(from);
        }
    }

    static void removeConnection(BlockNode from, BlockNode to) {
        from.getSuccessors().remove(to);
        to.getPredecessors().remove(from);
    }

    static void replaceConnection(BlockNode source, BlockNode oldDest, BlockNode newDest) {
        BlockSplitter.removeConnection(source, oldDest);
        BlockSplitter.connect(source, newDest);
        BlockSplitter.replaceTarget(source, oldDest, newDest);
    }

    static BlockNode insertBlockBetween(MethodNode mth, BlockNode source, BlockNode target) {
        BlockNode newBlock = BlockSplitter.startNewBlock(mth, target.getStartOffset());
        newBlock.add(AFlag.SYNTHETIC);
        BlockSplitter.removeConnection(source, target);
        BlockSplitter.connect(source, newBlock);
        BlockSplitter.connect(newBlock, target);
        BlockSplitter.replaceTarget(source, target, newBlock);
        source.updateCleanSuccessors();
        newBlock.updateCleanSuccessors();
        return newBlock;
    }

    static void replaceTarget(BlockNode source, BlockNode oldTarget, BlockNode newTarget) {
        InsnNode lastInsn = BlockUtils.getLastInsn(source);
        if (lastInsn instanceof TargetInsnNode) {
            ((TargetInsnNode)lastInsn).replaceTargetBlock(oldTarget, newTarget);
        }
    }

    private static void setupConnections(MethodNode mth, Map<Integer, BlockNode> blocksMap) {
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                List jumps = insn.getAll(AType.JUMP);
                for (JumpInfo jump : jumps) {
                    BlockNode srcBlock = BlockSplitter.getBlock(jump.getSrc(), blocksMap);
                    BlockNode thisBlock = BlockSplitter.getBlock(jump.getDest(), blocksMap);
                    BlockSplitter.connect(srcBlock, thisBlock);
                }
                BlockSplitter.connectExceptionHandlers(blocksMap, block, insn);
            }
        }
    }

    private static void connectExceptionHandlers(Map<Integer, BlockNode> blocksMap, BlockNode block, InsnNode insn) {
        CatchAttr catches = insn.get(AType.CATCH_BLOCK);
        SplitterBlockAttr spl = block.get(AType.SPLITTER_BLOCK);
        if (catches == null || spl == null) {
            return;
        }
        BlockNode splitterBlock = spl.getBlock();
        boolean tryEnd = insn.contains(AFlag.TRY_LEAVE);
        for (ExceptionHandler h : catches.getTryBlock().getHandlers()) {
            BlockNode handlerBlock = BlockSplitter.getBlock(h.getHandleOffset(), blocksMap);
            if (splitterBlock != handlerBlock) {
                if (!handlerBlock.contains(AType.SPLITTER_BLOCK)) {
                    handlerBlock.addAttr(spl);
                }
                BlockSplitter.connect(splitterBlock, handlerBlock);
            }
            if (!tryEnd) continue;
            BlockSplitter.connect(block, handlerBlock);
        }
    }

    private static boolean isSplitByJump(InsnNode prevInsn, InsnNode currentInsn) {
        List pJumps = prevInsn.getAll(AType.JUMP);
        for (JumpInfo jump : pJumps) {
            if (jump.getSrc() != prevInsn.getOffset()) continue;
            return true;
        }
        List cJumps = currentInsn.getAll(AType.JUMP);
        for (JumpInfo jump : cJumps) {
            if (jump.getDest() != currentInsn.getOffset()) continue;
            return true;
        }
        return false;
    }

    private static boolean isDoWhile(Map<Integer, BlockNode> blocksMap, BlockNode curBlock, InsnNode insn) {
        if (insn.getType() != InsnType.IF) {
            return false;
        }
        IfNode ifs = (IfNode)insn;
        BlockNode targetBlock = blocksMap.get(ifs.getTarget());
        return targetBlock == curBlock;
    }

    private static BlockNode getBlock(int offset, Map<Integer, BlockNode> blocksMap) {
        BlockNode block = blocksMap.get(offset);
        if (block == null) {
            throw new JadxRuntimeException("Missing block: " + offset);
        }
        return block;
    }

    private static void removeInsns(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            block.getInstructions().removeIf(insn -> {
                InsnType insnType = insn.getType();
                return insnType == InsnType.GOTO || insnType == InsnType.NOP;
            });
        }
    }

    static boolean removeEmptyDetachedBlocks(MethodNode mth) {
        return mth.getBasicBlocks().removeIf(block -> block.getInstructions().isEmpty() && block.getPredecessors().isEmpty() && block.getSuccessors().isEmpty());
    }
}

