/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.gui.treemodel.JCertificate;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.CertificatePanel;
import jadx.gui.ui.CodeArea;
import jadx.gui.ui.CodePanel;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.ImagePanel;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.JumpManager;
import jadx.gui.utils.NLS;
import jadx.gui.utils.Position;
import jadx.gui.utils.Utils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TabbedPane
extends JTabbedPane {
    private static final Logger LOG = LoggerFactory.getLogger(TabbedPane.class);
    private static final long serialVersionUID = -8833600618794570904L;
    private static final ImageIcon ICON_CLOSE = Utils.openIcon("cross");
    private static final ImageIcon ICON_CLOSE_INACTIVE = Utils.openIcon("cross_grayed");
    private final transient MainWindow mainWindow;
    private final transient Map<JNode, ContentPanel> openTabs = new LinkedHashMap<JNode, ContentPanel>();
    private transient JumpManager jumps = new JumpManager();

    TabbedPane(MainWindow window) {
        this.mainWindow = window;
        this.setTabLayoutPolicy(1);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int direction = e.getWheelRotation();
                int index = TabbedPane.this.getSelectedIndex();
                int maxIndex = TabbedPane.this.getTabCount() - 1;
                index = index == 0 && direction < 0 || index == maxIndex && direction > 0 ? maxIndex - index : (index += direction);
                TabbedPane.this.setSelectedIndex(index);
            }
        });
    }

    MainWindow getMainWindow() {
        return this.mainWindow;
    }

    private void showCode(final Position pos) {
        final CodePanel contentPanel = (CodePanel)this.getContentPanel(pos.getNode());
        if (contentPanel == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabbedPane.this.setSelectedComponent(contentPanel);
                CodeArea codeArea = contentPanel.getCodeArea();
                int line = pos.getLine();
                if (line < 0) {
                    try {
                        line = 1 + codeArea.getLineOfOffset(-line);
                    }
                    catch (BadLocationException e) {
                        LOG.error("Can't get line for: {}", (Object)pos, (Object)e);
                        line = pos.getNode().getLine();
                    }
                }
                codeArea.scrollToLine(line);
                codeArea.requestFocus();
            }
        });
    }

    public void showResource(JResource res) {
        final ContentPanel contentPanel = this.getContentPanel(res);
        if (contentPanel == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabbedPane.this.setSelectedComponent(contentPanel);
            }
        });
    }

    public void showCertificate(JCertificate cert) {
        final ContentPanel contentPanel = this.getContentPanel(cert);
        if (contentPanel == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TabbedPane.this.setSelectedComponent(contentPanel);
            }
        });
    }

    public void codeJump(Position pos) {
        Position curPos = this.getCurrentPosition();
        if (curPos != null) {
            this.jumps.addPosition(curPos);
            this.jumps.addPosition(pos);
        }
        this.showCode(pos);
    }

    @Nullable
    private Position getCurrentPosition() {
        ContentPanel selectedCodePanel = this.getSelectedCodePanel();
        if (selectedCodePanel instanceof CodePanel) {
            return ((CodePanel)selectedCodePanel).getCodeArea().getCurrentPosition();
        }
        return null;
    }

    public void navBack() {
        Position pos = this.jumps.getPrev();
        if (pos != null) {
            this.showCode(pos);
        }
    }

    public void navForward() {
        Position pos = this.jumps.getNext();
        if (pos != null) {
            this.showCode(pos);
        }
    }

    private void addContentPanel(ContentPanel contentPanel) {
        this.openTabs.put(contentPanel.getNode(), contentPanel);
        this.add(contentPanel);
    }

    private void closeCodePanel(ContentPanel contentPanel) {
        this.openTabs.remove(contentPanel.getNode());
        this.remove(contentPanel);
    }

    @Nullable
    private ContentPanel getContentPanel(JNode node) {
        ContentPanel panel = this.openTabs.get(node);
        if (panel == null) {
            panel = this.makeContentPanel(node);
            if (panel == null) {
                return null;
            }
            this.addContentPanel(panel);
            this.setTabComponentAt(this.indexOfComponent(panel), this.makeTabComponent(panel));
        }
        return panel;
    }

    @Nullable
    private ContentPanel makeContentPanel(JNode node) {
        if (node instanceof JResource) {
            JResource res = (JResource)node;
            ResourceFile resFile = res.getResFile();
            if (resFile != null) {
                if (resFile.getType() == ResourceType.IMG) {
                    return new ImagePanel(this, res);
                }
            } else {
                return null;
            }
        }
        if (node instanceof JCertificate) {
            return new CertificatePanel(this, node);
        }
        return new CodePanel(this, node);
    }

    @Nullable
    ContentPanel getSelectedCodePanel() {
        return (ContentPanel)this.getSelectedComponent();
    }

    private Component makeTabComponent(final ContentPanel contentPanel) {
        JNode node = contentPanel.getNode();
        String name = node.makeLongString();
        final JPanel panel = new JPanel(new FlowLayout(1, 3, 0));
        panel.setOpaque(false);
        JLabel label = new JLabel(name);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        label.setIcon(node.getIcon());
        JButton button = new JButton();
        button.setIcon(ICON_CLOSE_INACTIVE);
        button.setRolloverIcon(ICON_CLOSE);
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        button.setUI(new BasicButtonUI());
        button.setContentAreaFilled(false);
        button.setFocusable(false);
        button.setBorder(null);
        button.setBorderPainted(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedPane.this.closeCodePanel(contentPanel);
            }
        });
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    TabbedPane.this.closeCodePanel(contentPanel);
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu = TabbedPane.this.createTabPopupMenu(contentPanel);
                    menu.show(panel, e.getX(), e.getY());
                } else {
                    TabbedPane.this.setSelectedComponent(contentPanel);
                }
            }
        });
        panel.add(label);
        panel.add(button);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        return panel;
    }

    private JPopupMenu createTabPopupMenu(final ContentPanel contentPanel) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem closeTab = new JMenuItem(NLS.str("tabs.close"));
        closeTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedPane.this.closeCodePanel(contentPanel);
            }
        });
        menu.add(closeTab);
        if (this.openTabs.size() > 1) {
            JMenuItem closeOther = new JMenuItem(NLS.str("tabs.closeOthers"));
            closeOther.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList contentPanels = new ArrayList(TabbedPane.this.openTabs.values());
                    for (ContentPanel panel : contentPanels) {
                        if (panel == contentPanel) continue;
                        TabbedPane.this.closeCodePanel(panel);
                    }
                }
            });
            menu.add(closeOther);
            JMenuItem closeAll = new JMenuItem(NLS.str("tabs.closeAll"));
            closeAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedPane.this.closeAllTabs();
                }
            });
            menu.add(closeAll);
            menu.addSeparator();
            ContentPanel selectedContentPanel = this.getSelectedCodePanel();
            for (Map.Entry<JNode, ContentPanel> entry : this.openTabs.entrySet()) {
                final ContentPanel cp = entry.getValue();
                if (cp == selectedContentPanel) continue;
                JNode node = entry.getKey();
                String clsName = node.makeLongString();
                JMenuItem item = new JMenuItem(clsName);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TabbedPane.this.setSelectedComponent(cp);
                    }
                });
                item.setIcon(node.getIcon());
                menu.add(item);
            }
        }
        return menu;
    }

    public void closeAllTabs() {
        ArrayList<ContentPanel> contentPanels = new ArrayList<ContentPanel>(this.openTabs.values());
        for (ContentPanel panel : contentPanels) {
            this.closeCodePanel(panel);
        }
    }

    public void loadSettings() {
        for (ContentPanel panel : this.openTabs.values()) {
            panel.loadSettings();
        }
    }
}

