/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.HashMap;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.accessor.Accessor;
import jd.core.model.classfile.accessor.InvokeMethodAccessor;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokeinterface;
import jd.core.model.instruction.bytecode.instruction.Invokespecial;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.process.analyzer.classfile.visitor.OuterGetStaticVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OuterInvokeMethodVisitor
extends OuterGetStaticVisitor {
    public OuterInvokeMethodVisitor(HashMap<String, ClassFile> innerClassesMap, ConstantPool constants) {
        super(innerClassesMap, constants);
    }

    @Override
    protected Accessor match(Instruction i) {
        if (i.opcode != 184) {
            return null;
        }
        Invokestatic is = (Invokestatic)i;
        ConstantMethodref cmr = this.constants.getConstantMethodref(is.index);
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.name_and_type_index);
        String descriptor = this.constants.getConstantUtf8(cnat.descriptor_index);
        if (descriptor.charAt(1) == ')') {
            return null;
        }
        String className = this.constants.getConstantClassName(cmr.class_index);
        ClassFile classFile = (ClassFile)this.innerClassesMap.get(className);
        if (classFile == null) {
            return null;
        }
        String name = this.constants.getConstantUtf8(cnat.name_index);
        Accessor accessor = classFile.getAccessor(name, descriptor);
        if (accessor == null || accessor.tag != 5) {
            return null;
        }
        return accessor;
    }

    @Override
    protected Instruction newInstruction(Instruction i, Accessor a) {
        InvokeMethodAccessor ima = (InvokeMethodAccessor)a;
        Invokestatic is = (Invokestatic)i;
        int nameIndex = this.constants.addConstantUtf8(ima.methodName);
        int descriptorIndex = this.constants.addConstantUtf8(ima.methodDescriptor);
        int cnatIndex = this.constants.addConstantNameAndType(nameIndex, descriptorIndex);
        int classNameIndex = this.constants.addConstantUtf8(ima.className);
        int classIndex = this.constants.addConstantClass(classNameIndex);
        int cmrIndex = this.constants.addConstantMethodref(classIndex, cnatIndex, ima.listOfParameterSignatures, ima.returnedSignature);
        switch (ima.methodOpcode) {
            case 183: {
                Instruction objectref = (Instruction)is.args.remove(0);
                return new Invokespecial(183, i.offset, i.lineNumber, cmrIndex, objectref, is.args);
            }
            case 182: {
                Instruction objectref = (Instruction)is.args.remove(0);
                return new Invokevirtual(182, i.offset, i.lineNumber, cmrIndex, objectref, is.args);
            }
            case 185: {
                Instruction objectref = (Instruction)is.args.remove(0);
                return new Invokeinterface(185, i.offset, i.lineNumber, cmrIndex, objectref, is.args);
            }
            case 184: {
                return new Invokestatic(184, i.offset, i.lineNumber, cmrIndex, is.args);
            }
        }
        return i;
    }
}

