/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.attribute.CodeException;
import jd.core.model.classfile.attribute.LineNumber;
import jd.core.model.instruction.bytecode.ByteCodeConstants;
import jd.core.model.instruction.bytecode.instruction.ExceptionLoad;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.ReturnAddressLoad;
import jd.core.process.analyzer.instruction.bytecode.InstructionListException;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactoryConstants;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.util.IntSet;
import jd.core.util.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionListBuilder {
    private static CodeExceptionComparator COMPARATOR = new CodeExceptionComparator();

    public static void Build(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze) throws Exception {
        byte[] code = method.getCode();
        if (code != null) {
            int offset = 0;
            try {
                int nextLineOffset;
                int lineNumber;
                int exceptionOffset;
                int length = code.length;
                boolean[] jumps = new boolean[length];
                IntSet offsetSet = new IntSet();
                InstructionListBuilder.PopulateJumpsArrayAndSubProcOffsets(code, length, jumps, offsetSet);
                int[] subProcOffsets = offsetSet.toArray();
                int subProcOffsetsIndex = 0;
                int subProcOffset = subProcOffsets == null ? -1 : subProcOffsets[0];
                Stack<Instruction> stack = new Stack<Instruction>();
                CodeException[] codeExceptions = method.getCodeExceptions();
                int codeExceptionsIndex = 0;
                ConstantPool constants = classFile.getConstantPool();
                if (codeExceptions == null) {
                    exceptionOffset = -1;
                } else {
                    Arrays.sort(codeExceptions, COMPARATOR);
                    exceptionOffset = codeExceptions[0].handler_pc;
                }
                LineNumber[] lineNumbers = method.getLineNumbers();
                int lineNumbersIndex = 0;
                if (lineNumbers == null) {
                    lineNumber = Instruction.UNKNOWN_LINE_NUMBER;
                    nextLineOffset = -1;
                } else {
                    LineNumber ln = lineNumbers[lineNumbersIndex];
                    lineNumber = ln.line_number;
                    nextLineOffset = -1;
                    int startPc = ln.start_pc;
                    while (++lineNumbersIndex < lineNumbers.length) {
                        ln = lineNumbers[lineNumbersIndex];
                        if (ln.start_pc != startPc) {
                            nextLineOffset = ln.start_pc;
                            break;
                        }
                        lineNumber = ln.line_number;
                    }
                }
                offset = 0;
                while (offset < length) {
                    int opcode = code[offset] & 0xFF;
                    InstructionFactory factory = InstructionFactoryConstants.FACTORIES[opcode];
                    if (factory != null) {
                        if (offset == exceptionOffset) {
                            int nextOffsetException;
                            int signatureIndex;
                            int catchType = codeExceptions[codeExceptionsIndex].catch_type;
                            if (catchType == 0) {
                                signatureIndex = 0;
                            } else {
                                String catchClassName = SignatureUtil.CreateTypeName(constants.getConstantClassName(catchType));
                                signatureIndex = constants.addConstantUtf8(catchClassName);
                            }
                            ExceptionLoad el = new ExceptionLoad(270, offset, lineNumber, signatureIndex);
                            stack.push(el);
                            listForAnalyze.add(el);
                            do {
                                if (++codeExceptionsIndex < codeExceptions.length) continue;
                                nextOffsetException = -1;
                                break;
                            } while ((nextOffsetException = codeExceptions[codeExceptionsIndex].handler_pc) == exceptionOffset);
                            exceptionOffset = nextOffsetException;
                        }
                        if (offset == subProcOffset) {
                            stack.push(new ReturnAddressLoad(279, offset, lineNumber));
                            subProcOffset = ++subProcOffsetsIndex >= subProcOffsets.length ? -1 : subProcOffsets[subProcOffsetsIndex];
                        }
                        if (offset == nextLineOffset) {
                            LineNumber ln = lineNumbers[lineNumbersIndex];
                            lineNumber = ln.line_number;
                            nextLineOffset = -1;
                            int startPc = ln.start_pc;
                            while (++lineNumbersIndex < lineNumbers.length) {
                                ln = lineNumbers[lineNumbersIndex];
                                if (ln.start_pc != startPc) {
                                    nextLineOffset = ln.start_pc;
                                    break;
                                }
                                lineNumber = ln.line_number;
                            }
                        }
                        offset += factory.create(classFile, method, list, listForAnalyze, stack, code, offset, lineNumber, jumps);
                    } else {
                        String msg = "No factory for " + ByteCodeConstants.OPCODE_NAMES[opcode];
                        System.err.println(msg);
                        throw new Exception(msg);
                    }
                    ++offset;
                }
                if (!stack.isEmpty()) {
                    String className = classFile.getClassName();
                    String methodName = classFile.getConstantPool().getConstantUtf8(method.name_index);
                    System.err.println("'" + className + '.' + methodName + "' build error: stack not empty. stack=" + stack);
                }
            }
            catch (Exception e) {
                throw new InstructionListException(classFile, method, offset, e);
            }
        }
    }

    private static void PopulateJumpsArrayAndSubProcOffsets(byte[] code, int length, boolean[] jumps, IntSet offsetSet) {
        int offset = 0;
        while (offset < length) {
            int opcode = code[offset] & 0xFF;
            block0 : switch (ByteCodeConstants.NO_OF_OPERANDS[opcode]) {
                case 0: {
                    break;
                }
                case 2: {
                    int jumpOffset;
                    switch (opcode) {
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 198: 
                        case 199: {
                            jumpOffset = offset++ + (short)((code[offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                            jumps[jumpOffset] = true;
                            break block0;
                        }
                        case 168: {
                            jumpOffset = offset++ + (short)((code[offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                            offsetSet.add(jumpOffset);
                            break block0;
                        }
                    }
                    offset += 2;
                    break;
                }
                case 4: {
                    int jumpOffset;
                    switch (opcode) {
                        case 200: {
                            jumpOffset = offset++ + ((code[offset] & 0xFF) << 24) | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                            jumps[jumpOffset] = true;
                            break block0;
                        }
                        case 201: {
                            jumpOffset = offset++ + ((code[offset] & 0xFF) << 24) | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                            offsetSet.add(jumpOffset);
                            break block0;
                        }
                    }
                    offset += 4;
                    break;
                }
                default: {
                    switch (opcode) {
                        case 170: {
                            offset = ByteCodeUtil.NextTableSwitchOffset(code, offset);
                            break block0;
                        }
                        case 171: {
                            offset = ByteCodeUtil.NextLookupSwitchOffset(code, offset);
                            break block0;
                        }
                        case 196: {
                            offset = ByteCodeUtil.NextWideOffset(code, offset);
                            break block0;
                        }
                    }
                    offset += ByteCodeConstants.NO_OF_OPERANDS[opcode];
                }
            }
            ++offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CodeExceptionComparator
    implements Comparator<CodeException> {
        private CodeExceptionComparator() {
        }

        @Override
        public int compare(CodeException ce1, CodeException ce2) {
            if (ce1.handler_pc != ce2.handler_pc) {
                return ce1.handler_pc - ce2.handler_pc;
            }
            if (ce1.end_pc != ce2.end_pc) {
                return ce1.end_pc - ce2.end_pc;
            }
            if (ce1.start_pc != ce2.start_pc) {
                return ce1.start_pc - ce2.start_pc;
            }
            return ce1.index - ce2.index;
        }
    }
}

