"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var channel_1 = require("../../channel");
var util_1 = require("../../util");
var dataflow_1 = require("./dataflow");
var GeoPointNode = /** @class */ (function (_super) {
    tslib_1.__extends(GeoPointNode, _super);
    function GeoPointNode(parent, projection, fields, as) {
        var _this = _super.call(this, parent) || this;
        _this.projection = projection;
        _this.fields = fields;
        _this.as = as;
        return _this;
    }
    GeoPointNode.prototype.clone = function () {
        return new GeoPointNode(null, this.projection, util_1.duplicate(this.fields), util_1.duplicate(this.as));
    };
    GeoPointNode.parseAll = function (parent, model) {
        if (!model.projectionName()) {
            return parent;
        }
        [[channel_1.LONGITUDE, channel_1.LATITUDE], [channel_1.LONGITUDE2, channel_1.LATITUDE2]].forEach(function (coordinates) {
            var pair = coordinates.map(function (channel) { return model.channelHasField(channel) ? model.fieldDef(channel).field : undefined; });
            var suffix = coordinates[0] === channel_1.LONGITUDE2 ? '2' : '';
            if (pair[0] || pair[1]) {
                parent = new GeoPointNode(parent, model.projectionName(), pair, [model.getName('x' + suffix), model.getName('y' + suffix)]);
            }
        });
        return parent;
    };
    GeoPointNode.prototype.assemble = function () {
        return {
            type: 'geopoint',
            projection: this.projection,
            fields: this.fields,
            as: this.as
        };
    };
    return GeoPointNode;
}(dataflow_1.DataFlowNode));
exports.GeoPointNode = GeoPointNode;
//# sourceMappingURL=data:application/json;base64,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