/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ext;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.ObjectMappers;
import org.logstash.RubyUtil;
import org.logstash.Timestamp;

public final class JrubyTimestampExtLibrary {

    @JRubyClass(name={"Timestamp"}, include={"Comparable"})
    @JsonSerialize(using=ObjectMappers.RubyTimestampSerializer.class)
    public static final class RubyTimestamp
    extends RubyObject {
        private static final long serialVersionUID = 1L;
        private Timestamp timestamp;

        public RubyTimestamp(Ruby runtime, RubyClass klass) {
            super(runtime, klass);
        }

        public static RubyTimestamp newRubyTimestamp(Ruby runtime, Timestamp timestamp) {
            RubyTimestamp stamp = new RubyTimestamp(runtime, RubyUtil.RUBY_TIMESTAMP_CLASS);
            stamp.timestamp = timestamp;
            return stamp;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        @JRubyMethod(optional=1)
        public RubyTimestamp initialize(ThreadContext context, IRubyObject[] args) {
            IRubyObject time = (args = Arity.scanArgs((Ruby)context.runtime, (IRubyObject[])args, (int)0, (int)1))[0];
            if (time.isNil()) {
                this.timestamp = new Timestamp();
            } else if (time instanceof RubyTime) {
                this.timestamp = new Timestamp(((RubyTime)time).getDateTime());
            } else if (time instanceof RubyString) {
                try {
                    this.timestamp = new Timestamp(time.toString());
                }
                catch (IllegalArgumentException e) {
                    throw new RaiseException(this.getRuntime(), RubyUtil.TIMESTAMP_PARSER_ERROR, "invalid timestamp string format " + time, true);
                }
            } else {
                throw context.runtime.newTypeError("wrong argument type " + time.getMetaClass() + " (expected Time)");
            }
            return this;
        }

        @JRubyMethod(name={"time"})
        public RubyTime ruby_time(ThreadContext context) {
            return RubyTime.newTime((Ruby)context.runtime, (DateTime)this.timestamp.getTime());
        }

        @JRubyMethod(name={"to_i"})
        public IRubyObject ruby_to_i(ThreadContext context) {
            return RubyFixnum.newFixnum((Ruby)context.runtime, (long)(this.timestamp.getTime().getMillis() / 1000L));
        }

        @JRubyMethod(name={"to_f"})
        public IRubyObject ruby_to_f(ThreadContext context) {
            return RubyFloat.newFloat((Ruby)context.runtime, (double)((double)this.timestamp.getTime().getMillis() / 1000.0));
        }

        @JRubyMethod(name={"to_s"})
        public IRubyObject ruby_to_s(ThreadContext context) {
            return this.ruby_to_iso8601(context);
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject ruby_inspect(ThreadContext context) {
            return this.ruby_to_iso8601(context);
        }

        @JRubyMethod(name={"to_iso8601"})
        public IRubyObject ruby_to_iso8601(ThreadContext context) {
            return RubyString.newString((Ruby)context.runtime, (String)this.timestamp.toString());
        }

        @JRubyMethod(name={"to_java"})
        public IRubyObject ruby_to_java(ThreadContext context) {
            return JavaUtil.convertJavaToUsableRubyObject((Ruby)context.runtime, (Object)this.timestamp);
        }

        @JRubyMethod(name={"clone"})
        public IRubyObject ruby_clone(ThreadContext context) {
            return RubyTimestamp.newRubyTimestamp(context.runtime, this.timestamp);
        }

        @JRubyMethod(name={"dup"})
        public IRubyObject ruby_dup(ThreadContext context) {
            return this.ruby_clone(context);
        }

        @JRubyMethod(name={"to_json"}, rest=true)
        public IRubyObject ruby_to_json(ThreadContext context, IRubyObject[] args) {
            return RubyString.newString((Ruby)context.runtime, (String)("\"" + this.timestamp.toString() + "\""));
        }

        @JRubyMethod(name={"coerce"}, meta=true)
        public static IRubyObject ruby_coerce(ThreadContext context, IRubyObject recv, IRubyObject time) {
            try {
                if (time instanceof RubyTimestamp) {
                    return time;
                }
                if (time instanceof RubyTime) {
                    return RubyTimestamp.newRubyTimestamp(context.runtime, new Timestamp(((RubyTime)time).getDateTime()));
                }
                if (time instanceof RubyString) {
                    return RubyTimestamp.fromRString(context.runtime, (RubyString)time);
                }
                return context.runtime.getNil();
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(context.runtime, RubyUtil.TIMESTAMP_PARSER_ERROR, "invalid timestamp format " + e.getMessage(), true);
            }
        }

        @JRubyMethod(name={"parse_iso8601"}, meta=true)
        public static IRubyObject ruby_parse_iso8601(ThreadContext context, IRubyObject recv, IRubyObject time) {
            if (time instanceof RubyString) {
                try {
                    return RubyTimestamp.fromRString(context.runtime, (RubyString)time);
                }
                catch (IllegalArgumentException e) {
                    throw new RaiseException(context.runtime, RubyUtil.TIMESTAMP_PARSER_ERROR, "invalid timestamp format " + e.getMessage(), true);
                }
            }
            throw context.runtime.newTypeError("wrong argument type " + time.getMetaClass() + " (expected String)");
        }

        @JRubyMethod(name={"at"}, required=1, optional=1, meta=true)
        public static RubyTimestamp ruby_at(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
            RubyTime t = args.length == 1 ? (RubyTime)RubyTime.at((ThreadContext)context, (IRubyObject)context.runtime.getTime(), (IRubyObject)args[0]) : (RubyTime)RubyTime.at((ThreadContext)context, (IRubyObject)context.runtime.getTime(), (IRubyObject)args[0], (IRubyObject)args[1]);
            return RubyTimestamp.newRubyTimestamp(context.runtime, new Timestamp(t.getDateTime()));
        }

        @JRubyMethod(name={"now"}, meta=true)
        public static RubyTimestamp ruby_now(ThreadContext context, IRubyObject recv) {
            return RubyTimestamp.newRubyTimestamp(context.runtime, new Timestamp());
        }

        @JRubyMethod(name={"utc"})
        public IRubyObject ruby_utc() {
            return this;
        }

        @JRubyMethod(name={"gmtime"})
        public IRubyObject ruby_gmtime() {
            return this;
        }

        @JRubyMethod(name={"usec", "tv_usec"})
        public IRubyObject ruby_usec(ThreadContext context) {
            return RubyFixnum.newFixnum((Ruby)context.runtime, (long)this.timestamp.usec());
        }

        @JRubyMethod(name={"year"})
        public IRubyObject ruby_year(ThreadContext context) {
            return RubyFixnum.newFixnum((Ruby)context.runtime, (long)this.timestamp.getTime().getYear());
        }

        @JRubyMethod(name={"<=>"})
        public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
            if (other instanceof RubyTimestamp) {
                return this.ruby_time(context).op_cmp(context, (IRubyObject)((RubyTimestamp)other).ruby_time(context));
            }
            return context.nil;
        }

        @JRubyMethod(name={">="})
        public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
            if (other instanceof RubyTimestamp) {
                return context.runtime.newBoolean(this.compare(context, other) >= 0);
            }
            return RubyComparable.op_ge((ThreadContext)context, (IRubyObject)this, (IRubyObject)other);
        }

        @JRubyMethod(name={">"})
        public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
            if (other instanceof RubyTimestamp) {
                return context.runtime.newBoolean(this.compare(context, other) > 0);
            }
            return RubyComparable.op_gt((ThreadContext)context, (IRubyObject)this, (IRubyObject)other);
        }

        @JRubyMethod(name={"<="})
        public IRubyObject op_le(ThreadContext context, IRubyObject other) {
            if (other instanceof RubyTimestamp) {
                return context.runtime.newBoolean(this.compare(context, other) <= 0);
            }
            return RubyComparable.op_le((ThreadContext)context, (IRubyObject)this, (IRubyObject)other);
        }

        @JRubyMethod(name={"<"})
        public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
            if (other instanceof RubyTimestamp) {
                return context.runtime.newBoolean(this.compare(context, other) < 0);
            }
            return RubyComparable.op_lt((ThreadContext)context, (IRubyObject)this, (IRubyObject)other);
        }

        @JRubyMethod(name={"eql?", "=="})
        public IRubyObject eql(ThreadContext context, IRubyObject other) {
            return this == other || other.getClass() == RubyTimestamp.class && this.timestamp.equals(((RubyTimestamp)other).timestamp) ? context.tru : context.fals;
        }

        @JRubyMethod(name={"+"})
        public IRubyObject plus(ThreadContext context, IRubyObject val) {
            return this.ruby_time(context).callMethod(context, "+", val);
        }

        @JRubyMethod(name={"-"})
        public IRubyObject minus(ThreadContext context, IRubyObject val) {
            return this.ruby_time(context).callMethod(context, "-", (IRubyObject)(val instanceof RubyTimestamp ? ((RubyTimestamp)val).ruby_time(context) : val));
        }

        private int compare(ThreadContext context, IRubyObject other) {
            return this.op_cmp(context, other).convertToInteger().getIntValue();
        }

        private static RubyTimestamp fromRString(Ruby runtime, RubyString string) {
            return RubyTimestamp.newRubyTimestamp(runtime, new Timestamp(string.toString()));
        }
    }
}

