/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.pipeline;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.logstash.instrument.witness.SerializableWitness;
import org.logstash.instrument.witness.pipeline.PipelineWitness;

@JsonSerialize(using=Serializer.class)
public final class PipelinesWitness
implements SerializableWitness {
    private final Map<String, PipelineWitness> pipelines = new ConcurrentHashMap<String, PipelineWitness>();
    private static final String KEY = "pipelines";

    public PipelineWitness pipeline(String name) {
        return this.pipelines.computeIfAbsent(name, k -> new PipelineWitness((String)k));
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen, provider);
    }

    public static final class Serializer
    extends StdSerializer<PipelinesWitness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(PipelinesWitness.class);
        }

        protected Serializer(Class<PipelinesWitness> t) {
            super(t);
        }

        public void serialize(PipelinesWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen, provider);
            gen.writeEndObject();
        }

        static void innerSerialize(PipelinesWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObjectFieldStart(PipelinesWitness.KEY);
            for (Map.Entry entry : witness.pipelines.entrySet()) {
                ((PipelineWitness)entry.getValue()).genJson(gen, provider);
            }
            gen.writeEndObject();
        }
    }
}

