/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.config.ir.PipelineIR;
import org.logstash.config.ir.compiler.AbstractOutputDelegatorExt;
import org.logstash.config.ir.compiler.FilterDelegatorExt;
import org.logstash.config.ir.compiler.OutputDelegatorExt;
import org.logstash.config.ir.compiler.OutputStrategyExt;
import org.logstash.config.ir.compiler.RubyIntegration;
import org.logstash.config.ir.graph.Vertex;
import org.logstash.execution.ExecutionContextExt;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.NullMetricExt;
import org.logstash.plugins.PluginLookup;

public final class PluginFactoryExt {

    @JRubyClass(name={"PluginMetricFactory"})
    public static final class Metrics
    extends RubyBasicObject {
        private static final RubySymbol PLUGINS = RubyUtil.RUBY.newSymbol("plugins");
        private RubySymbol pipelineId;
        private AbstractMetricExt metric;

        public Metrics(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod
        public Metrics initialize(ThreadContext context, IRubyObject pipelineId, IRubyObject metrics) {
            this.pipelineId = pipelineId.convertToString().intern19();
            this.metric = metrics.isNil() ? new NullMetricExt(context.runtime, RubyUtil.NULL_METRIC_CLASS) : (AbstractMetricExt)metrics;
            return this;
        }

        @JRubyMethod
        public AbstractNamespacedMetricExt create(ThreadContext context, IRubyObject pluginType) {
            return this.metric.namespace(context, (IRubyObject)RubyArray.newArray((Ruby)context.runtime, Arrays.asList(MetricKeys.STATS_KEY, MetricKeys.PIPELINES_KEY, this.pipelineId, PLUGINS))).namespace(context, (IRubyObject)RubyUtil.RUBY.newSymbol(String.format("%ss", pluginType.asJavaString())));
        }
    }

    @JRubyClass(name={"ExecutionContextFactory"})
    public static final class ExecutionContext
    extends RubyBasicObject {
        private IRubyObject agent;
        private IRubyObject pipeline;
        private IRubyObject dlqWriter;

        public ExecutionContext(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod
        public ExecutionContext initialize(ThreadContext context, IRubyObject agent, IRubyObject pipeline, IRubyObject dlqWriter) {
            this.agent = agent;
            this.pipeline = pipeline;
            this.dlqWriter = dlqWriter;
            return this;
        }

        @JRubyMethod
        public ExecutionContextExt create(ThreadContext context, IRubyObject id, IRubyObject classConfigName) {
            return new ExecutionContextExt(context.runtime, RubyUtil.EXECUTION_CONTEXT_CLASS).initialize(context, new IRubyObject[]{this.pipeline, this.agent, id, classConfigName, this.dlqWriter});
        }
    }

    @JRubyClass(name={"PluginFactory"})
    public static final class Plugins
    extends RubyBasicObject
    implements RubyIntegration.PluginFactory {
        private static final RubyString ID_KEY = RubyUtil.RUBY.newString("id");
        private final Collection<String> pluginsById = new HashSet<String>();
        private PipelineIR lir;
        private ExecutionContext executionContext;
        private Metrics metrics;
        private RubyClass filterClass;

        @JRubyMethod(name={"filter_delegator"}, meta=true, required=5)
        public static IRubyObject filterDelegator(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
            RubyHash arguments = (RubyHash)args[2];
            IRubyObject filterInstance = args[1].callMethod(context, "new", (IRubyObject)arguments);
            RubyString id = (RubyString)arguments.op_aref(context, (IRubyObject)ID_KEY);
            filterInstance.callMethod(context, "metric=", (IRubyObject)((AbstractMetricExt)args[3]).namespace(context, (IRubyObject)id.intern19()));
            filterInstance.callMethod(context, "execution_context=", args[4]);
            return args[0].callMethod(context, "new", new IRubyObject[]{filterInstance, id});
        }

        public Plugins(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod(required=4)
        public Plugins initialize(ThreadContext context, IRubyObject[] args) {
            return this.init((PipelineIR)args[0].toJava(PipelineIR.class), (Metrics)args[1], (ExecutionContext)args[2], (RubyClass)args[3]);
        }

        public Plugins init(PipelineIR lir, Metrics metrics, ExecutionContext executionContext, RubyClass filterClass) {
            this.lir = lir;
            this.metrics = metrics;
            this.executionContext = executionContext;
            this.filterClass = filterClass;
            return this;
        }

        @Override
        public IRubyObject buildInput(RubyString name, RubyInteger line, RubyInteger column, IRubyObject args) {
            return this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.INPUT, name.asJavaString(), line.getIntValue(), column.getIntValue(), (Map)args);
        }

        @JRubyMethod(required=4)
        public IRubyObject buildInput(ThreadContext context, IRubyObject[] args) {
            return this.buildInput((RubyString)args[0], args[1].convertToInteger(), args[2].convertToInteger(), args[3]);
        }

        @Override
        public AbstractOutputDelegatorExt buildOutput(RubyString name, RubyInteger line, RubyInteger column, IRubyObject args) {
            return (OutputDelegatorExt)this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.OUTPUT, name.asJavaString(), line.getIntValue(), column.getIntValue(), (Map)args);
        }

        @JRubyMethod(required=4)
        public AbstractOutputDelegatorExt buildOutput(ThreadContext context, IRubyObject[] args) {
            return this.buildOutput((RubyString)args[0], args[1].convertToInteger(), args[2].convertToInteger(), args[3]);
        }

        @Override
        public FilterDelegatorExt buildFilter(RubyString name, RubyInteger line, RubyInteger column, IRubyObject args) {
            return (FilterDelegatorExt)this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.FILTER, name.asJavaString(), line.getIntValue(), column.getIntValue(), (Map)args);
        }

        @JRubyMethod(required=4)
        public IRubyObject buildFilter(ThreadContext context, IRubyObject[] args) {
            return this.buildFilter((RubyString)args[0], args[1].convertToInteger(), args[2].convertToInteger(), args[3]);
        }

        @Override
        public IRubyObject buildCodec(RubyString name, IRubyObject args) {
            return this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.CODEC, name.asJavaString(), 0, 0, (Map)args);
        }

        @JRubyMethod(required=4)
        public IRubyObject buildCodec(ThreadContext context, IRubyObject[] args) {
            return this.buildCodec((RubyString)args[0], args[1]);
        }

        @JRubyMethod(required=4, optional=1)
        public IRubyObject plugin(ThreadContext context, IRubyObject[] args) {
            return this.plugin(context, PluginLookup.PluginType.valueOf(args[0].asJavaString().toUpperCase(Locale.ENGLISH)), args[1].asJavaString(), args[2].convertToInteger().getIntValue(), args[3].convertToInteger().getIntValue(), args.length > 4 ? (Map)args[4] : new HashMap());
        }

        private IRubyObject plugin(ThreadContext context, PluginLookup.PluginType type, String name, int line, int column, Map<String, IRubyObject> args) {
            String id = type == PluginLookup.PluginType.CODEC ? UUID.randomUUID().toString() : (String)this.lir.getGraph().vertices().filter(v -> v.getSourceWithMetadata() != null && v.getSourceWithMetadata().getLine() == line && v.getSourceWithMetadata().getColumn() == column).findFirst().map(Vertex::getId).orElse(null);
            if (id == null) {
                throw context.runtime.newRaiseException(RubyUtil.CONFIGURATION_ERROR_CLASS, String.format("Could not determine ID for %s/%s", type.rubyLabel().asJavaString(), name));
            }
            if (this.pluginsById.contains(id)) {
                throw context.runtime.newRaiseException(RubyUtil.CONFIGURATION_ERROR_CLASS, String.format("Two plugins have the id '%s', please fix this conflict", id));
            }
            this.pluginsById.add(id);
            AbstractNamespacedMetricExt typeScopedMetric = this.metrics.create(context, (IRubyObject)type.rubyLabel());
            PluginLookup.PluginClass pluginClass = PluginLookup.lookup(type, name);
            if (pluginClass.language() == PluginLookup.PluginLanguage.RUBY) {
                HashMap<String, IRubyObject> newArgs = new HashMap<String, IRubyObject>(args);
                newArgs.put("id", (IRubyObject)id);
                RubyClass klass = (RubyClass)pluginClass.klass();
                ExecutionContextExt executionCntx = this.executionContext.create(context, (IRubyObject)RubyUtil.RUBY.newString(id), klass.callMethod(context, "config_name"));
                RubyHash rubyArgs = RubyHash.newHash((Ruby)context.runtime);
                rubyArgs.putAll(newArgs);
                if (type == PluginLookup.PluginType.OUTPUT) {
                    return new OutputDelegatorExt(context.runtime, RubyUtil.RUBY_OUTPUT_DELEGATOR_CLASS).initialize(context, new IRubyObject[]{klass, typeScopedMetric, executionCntx, OutputStrategyExt.OutputStrategyRegistryExt.instance(context, null), rubyArgs});
                }
                if (type == PluginLookup.PluginType.FILTER) {
                    return Plugins.filterDelegator(context, null, new IRubyObject[]{this.filterClass, klass, rubyArgs, typeScopedMetric, executionCntx});
                }
                IRubyObject pluginInstance = klass.callMethod(context, "new", (IRubyObject)rubyArgs);
                AbstractNamespacedMetricExt scopedMetric = typeScopedMetric.namespace(context, (IRubyObject)RubyUtil.RUBY.newSymbol(id));
                scopedMetric.gauge(context, (IRubyObject)MetricKeys.NAME_KEY, pluginInstance.callMethod(context, "config_name"));
                pluginInstance.callMethod(context, "metric=", (IRubyObject)scopedMetric);
                pluginInstance.callMethod(context, "execution_context=", (IRubyObject)executionCntx);
                return pluginInstance;
            }
            return context.nil;
        }
    }
}

