/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;

public final class PluginLookup {
    private static final IRubyObject RUBY_REGISTRY = RubyUtil.RUBY.executeScript("require 'logstash/plugins/registry'\nrequire 'logstash/plugin'\nLogStash::Plugin", "");

    private PluginLookup() {
    }

    public static PluginClass lookup(final PluginType type, final String name) {
        return new PluginClass(){

            @Override
            public PluginLanguage language() {
                return PluginLanguage.RUBY;
            }

            @Override
            public Object klass() {
                return RUBY_REGISTRY.callMethod(RubyUtil.RUBY.getCurrentContext(), "lookup", new IRubyObject[]{type.rubyLabel(), RubyUtil.RUBY.newString(name)});
            }
        };
    }

    public static enum PluginType {
        INPUT("input"),
        FILTER("filter"),
        OUTPUT("output"),
        CODEC("codec");

        private final RubyString label;

        private PluginType(String label) {
            this.label = RubyUtil.RUBY.newString(label);
        }

        RubyString rubyLabel() {
            return this.label;
        }
    }

    public static enum PluginLanguage {
        JAVA,
        RUBY;

    }

    public static interface PluginClass {
        public PluginLanguage language();

        public Object klass();
    }
}

