/*
 * Decompiled with CFR 0.152.
 */
package processing.app.format;

import java.util.Stack;
import java.util.regex.Pattern;
import processing.app.Preferences;
import processing.core.PApplet;

public class AutoFormat {
    private char[] chars;
    private final StringBuilder buf = new StringBuilder();
    private final StringBuilder result = new StringBuilder();
    private int indentValue;
    private boolean EOF;
    private boolean a_flg;
    private boolean e_flg;
    private boolean if_flg;
    private boolean s_flag;
    private boolean q_flg;
    private boolean[] s_if_flg;
    private int pos;
    private int lineNumber;
    private int[] s_level;
    private int c_level;
    private int[][] sp_flg;
    private int[][] s_ind;
    private int[] s_if_lev;
    private int if_lev;
    private int level;
    private int[] ind;
    private int paren;
    private int[] p_flg;
    private char l_char;
    private int ct;
    private int[][] s_tabs;
    private boolean jdoc_flag;
    private char cc;
    private int tabs;
    private char c;
    private final Stack<Boolean> castFlags = new Stack();
    private char lastNonWhitespace = '\u0000';

    private void comment() {
        boolean save_s_flg = this.s_flag;
        this.c = this.next();
        this.buf.append(this.c);
        do {
            this.c = this.next();
            this.buf.append(this.c);
            while (this.c != '/') {
                if (this.c == '\n') {
                    ++this.lineNumber;
                    this.writeIndentedComment();
                    this.s_flag = true;
                }
                this.c = this.next();
                this.buf.append(this.c);
            }
        } while (this.buf.length() < 2 || this.buf.charAt(this.buf.length() - 2) != '*');
        this.jdoc_flag = false;
        this.writeIndentedComment();
        this.s_flag = save_s_flg;
        this.jdoc_flag = false;
    }

    private char get_string() {
        char ch;
        block0: while (true) {
            ch = this.next();
            this.buf.append(ch);
            if (ch == '\\') {
                this.buf.append(this.next());
                continue;
            }
            if (ch == '\'' || ch == '\"') {
                this.cc = this.next();
                this.buf.append(this.cc);
                while (true) {
                    if (this.EOF || this.cc == ch) continue block0;
                    if (this.cc == '\\') {
                        this.buf.append(this.next());
                    }
                    this.cc = this.next();
                    this.buf.append(this.cc);
                }
            }
            if (ch != '\n') break;
            this.writeIndentedLine();
            this.a_flg = true;
        }
        return ch;
    }

    private void writeIndentedLine() {
        if (this.buf.length() == 0) {
            if (this.s_flag) {
                this.a_flg = false;
                this.s_flag = false;
            }
            return;
        }
        if (this.s_flag) {
            boolean shouldIndent;
            boolean bl = shouldIndent = this.tabs > 0 && this.buf.charAt(0) != '{' && this.a_flg;
            if (shouldIndent) {
                ++this.tabs;
            }
            this.printIndentation();
            this.s_flag = false;
            if (shouldIndent) {
                --this.tabs;
            }
            this.a_flg = false;
        }
        this.result.append((CharSequence)this.buf);
        this.buf.setLength(0);
    }

    private void writeIndentedComment() {
        boolean saved_s_flag = this.s_flag;
        if (this.buf.length() > 0) {
            if (this.s_flag) {
                this.printIndentation();
                this.s_flag = false;
            }
            int i = 0;
            while (this.buf.charAt(i) == ' ') {
                ++i;
            }
            if (this.lookup_com("/**")) {
                this.jdoc_flag = true;
            }
            if (this.buf.charAt(i) == '/' && this.buf.charAt(i + 1) == '*') {
                if (saved_s_flag && this.prev() != 59) {
                    this.result.append(this.buf.substring(i));
                } else {
                    this.result.append((CharSequence)this.buf);
                }
            } else if (this.buf.charAt(i) == '*' || !this.jdoc_flag) {
                this.result.append(" " + this.buf.substring(i));
            } else {
                this.result.append(" * " + this.buf.substring(i));
            }
            this.buf.setLength(0);
        }
    }

    private void handleSingleLineComment() {
        this.c = this.next();
        while (this.c != '\n') {
            this.buf.append(this.c);
            this.c = this.next();
        }
        ++this.lineNumber;
        this.writeIndentedLine();
        this.s_flag = true;
    }

    private void printIndentation() {
        if (this.tabs < 0) {
            this.tabs = 0;
        }
        if (this.tabs == 0) {
            return;
        }
        int spaces = this.tabs * this.indentValue;
        for (int k = 0; k < spaces; ++k) {
            this.result.append(" ");
        }
    }

    private char peek() {
        if (this.pos + 1 >= this.chars.length) {
            return '\u0000';
        }
        return this.chars[this.pos + 1];
    }

    private int prev() {
        return this.lastNonWhitespace;
    }

    private char next() {
        char c;
        if (this.EOF) {
            return '\u0000';
        }
        ++this.pos;
        if (this.pos < this.chars.length) {
            c = this.chars[this.pos];
            if (!Character.isWhitespace(c)) {
                this.lastNonWhitespace = c;
            }
        } else {
            c = '\u0000';
        }
        if (this.pos == this.chars.length - 1) {
            this.EOF = true;
        }
        return c;
    }

    private void gotelse() {
        this.tabs = this.s_tabs[this.c_level][this.if_lev];
        this.p_flg[this.level] = this.sp_flg[this.c_level][this.if_lev];
        this.ind[this.level] = this.s_ind[this.c_level][this.if_lev];
        this.if_flg = true;
    }

    private boolean getnl() {
        int savedTabs = this.tabs;
        char c = this.peek();
        while (!(this.EOF || c != '\t' && c != ' ')) {
            this.buf.append(this.next());
            c = this.peek();
        }
        if (c == '/') {
            this.buf.append(this.next());
            c = this.peek();
            if (c == '*') {
                this.buf.append(this.next());
                this.comment();
            } else if (c == '/') {
                this.buf.append(this.next());
                this.handleSingleLineComment();
                return true;
            }
        }
        if ((c = this.peek()) == '\n') {
            this.next();
            ++this.lineNumber;
            this.tabs = savedTabs;
            return true;
        }
        return false;
    }

    private boolean lookup(String keyword) {
        return Pattern.matches("^\\s*" + keyword + "(?![a-zA-Z0-9_&]).*$", this.buf);
    }

    private boolean lookup_com(String keyword) {
        String regex = "^\\s*" + keyword.replaceAll("\\*", "\\\\*") + ".*$";
        return Pattern.matches(regex, this.buf);
    }

    public String format(String source) {
        String normalizedText = source.replaceAll("\r", "");
        String cleanText = normalizedText + (normalizedText.endsWith("\n") ? "" : "\n");
        this.result.setLength(0);
        this.indentValue = Preferences.getInteger("editor.tabs.size");
        this.lineNumber = 0;
        this.if_flg = false;
        this.a_flg = false;
        this.e_flg = false;
        this.q_flg = false;
        this.s_flag = true;
        this.paren = 0;
        this.level = 0;
        this.if_lev = 0;
        this.c_level = 0;
        this.tabs = 0;
        this.jdoc_flag = false;
        this.s_level = new int[10];
        this.sp_flg = new int[20][10];
        this.s_ind = new int[20][10];
        this.s_if_lev = new int[10];
        this.s_if_flg = new boolean[10];
        this.ind = new int[10];
        this.p_flg = new int[10];
        this.s_tabs = new int[20][10];
        this.pos = -1;
        this.chars = cleanText.toCharArray();
        this.lineNumber = 1;
        this.EOF = false;
        block15: while (!this.EOF) {
            this.c = this.next();
            switch (this.c) {
                default: {
                    this.buf.append(this.c);
                    this.l_char = this.c;
                    break;
                }
                case ',': {
                    this.trimRight(this.buf);
                    this.buf.append(this.c);
                    break;
                }
                case '\t': 
                case ' ': {
                    if (this.lookup("else")) {
                        this.gotelse();
                        if (!this.s_flag || this.buf.length() > 0) {
                            this.buf.append(this.c);
                        }
                        this.writeIndentedLine();
                        this.s_flag = false;
                        break;
                    }
                    if (this.s_flag && this.buf.length() <= 0) continue block15;
                    this.buf.append(this.c);
                    break;
                }
                case '\n': {
                    char lastChar;
                    ++this.lineNumber;
                    if (this.EOF) break;
                    this.e_flg = this.lookup("else");
                    if (this.e_flg) {
                        this.gotelse();
                    }
                    if (this.lookup_com("//") && (lastChar = this.buf.charAt(this.buf.length() - 1)) == '\n') {
                        this.buf.setLength(this.buf.length() - 1);
                    }
                    this.writeIndentedLine();
                    this.result.append("\n");
                    this.s_flag = true;
                    if (this.e_flg) {
                        int n = this.level;
                        this.p_flg[n] = this.p_flg[n] + 1;
                        ++this.tabs;
                        break;
                    }
                    if (this.prev() != this.l_char) continue block15;
                    this.a_flg = true;
                    break;
                }
                case '{': {
                    if (this.lookup("else")) {
                        this.gotelse();
                    }
                    if (this.s_if_lev.length == this.c_level) {
                        this.s_if_lev = PApplet.expand((int[])this.s_if_lev);
                        this.s_if_flg = PApplet.expand((boolean[])this.s_if_flg);
                    }
                    this.s_if_lev[this.c_level] = this.if_lev;
                    this.s_if_flg[this.c_level] = this.if_flg;
                    this.if_lev = 0;
                    this.if_flg = false;
                    ++this.c_level;
                    if (this.s_flag && this.p_flg[this.level] != 0) {
                        int n = this.level;
                        this.p_flg[n] = this.p_flg[n] - 1;
                        --this.tabs;
                    }
                    this.trimRight(this.buf);
                    if (this.buf.length() > 0 || this.result.length() > 0 && !Character.isWhitespace(this.result.charAt(this.result.length() - 1))) {
                        this.buf.append(" ");
                    }
                    this.buf.append(this.c);
                    this.writeIndentedLine();
                    this.getnl();
                    this.writeIndentedLine();
                    this.result.append("\n");
                    ++this.tabs;
                    this.s_flag = true;
                    if (this.p_flg[this.level] <= 0) continue block15;
                    this.ind[this.level] = 1;
                    ++this.level;
                    this.s_level[this.level] = this.c_level;
                    break;
                }
                case '}': {
                    --this.c_level;
                    if (this.c_level < 0) {
                        this.c_level = 0;
                        this.buf.append(this.c);
                        this.writeIndentedLine();
                        break;
                    }
                    this.if_lev = this.s_if_lev[this.c_level] - 1;
                    if (this.if_lev < 0) {
                        this.if_lev = 0;
                    }
                    this.if_flg = this.s_if_flg[this.c_level];
                    this.trimRight(this.buf);
                    this.writeIndentedLine();
                    --this.tabs;
                    this.trimRight(this.result);
                    this.result.append("\n");
                    this.printIndentation();
                    this.result.append(this.c);
                    if (this.peek() == ';') {
                        this.result.append(this.next());
                    }
                    this.getnl();
                    this.writeIndentedLine();
                    this.result.append("\n");
                    this.s_flag = true;
                    if (this.c_level < this.s_level[this.level] && this.level > 0) {
                        --this.level;
                    }
                    if (this.ind[this.level] == 0) continue block15;
                    this.tabs -= this.p_flg[this.level];
                    this.p_flg[this.level] = 0;
                    this.ind[this.level] = 0;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.buf.append(this.c);
                    this.cc = this.next();
                    while (!this.EOF && this.cc != this.c) {
                        this.buf.append(this.cc);
                        if (this.cc == '\\') {
                            this.cc = this.next();
                            this.buf.append(this.cc);
                        }
                        if (this.cc == '\n') {
                            ++this.lineNumber;
                            this.writeIndentedLine();
                            this.s_flag = true;
                        }
                        this.cc = this.next();
                    }
                    this.buf.append(this.cc);
                    if (!this.getnl()) continue block15;
                    this.l_char = this.cc;
                    this.chars[this.pos--] = 10;
                    break;
                }
                case ';': {
                    this.buf.append(this.c);
                    this.writeIndentedLine();
                    if (this.p_flg[this.level] > 0 && this.ind[this.level] == 0) {
                        this.tabs -= this.p_flg[this.level];
                        this.p_flg[this.level] = 0;
                    }
                    this.getnl();
                    this.writeIndentedLine();
                    this.result.append("\n");
                    this.s_flag = true;
                    if (this.if_lev <= 0) continue block15;
                    if (this.if_flg) {
                        --this.if_lev;
                        this.if_flg = false;
                        break;
                    }
                    this.if_lev = 0;
                    break;
                }
                case '\\': {
                    this.buf.append(this.c);
                    this.buf.append(this.next());
                    break;
                }
                case '?': {
                    this.q_flg = true;
                    this.buf.append(this.c);
                    break;
                }
                case ':': {
                    this.buf.append(this.c);
                    if (this.peek() == ':') {
                        this.writeIndentedLine();
                        this.result.append(this.next());
                        break;
                    }
                    if (this.q_flg) {
                        this.q_flg = false;
                        break;
                    }
                    if (!this.lookup("default") && !this.lookup("case")) {
                        this.s_flag = false;
                        this.writeIndentedLine();
                    } else {
                        --this.tabs;
                        this.writeIndentedLine();
                        ++this.tabs;
                    }
                    if (this.peek() == ';') {
                        this.result.append(this.next());
                    }
                    this.getnl();
                    this.writeIndentedLine();
                    this.result.append("\n");
                    this.s_flag = true;
                    break;
                }
                case '/': {
                    char la = this.peek();
                    if (la == '/') {
                        this.buf.append(this.c).append(this.next());
                        this.handleSingleLineComment();
                        this.result.append("\n");
                        break;
                    }
                    if (la == '*') {
                        if (this.buf.length() > 0) {
                            this.writeIndentedLine();
                        }
                        this.buf.append(this.c).append(this.next());
                        this.comment();
                        break;
                    }
                    this.buf.append(this.c);
                    break;
                }
                case ')': {
                    boolean isCast = this.castFlags.isEmpty() ? false : this.castFlags.pop();
                    --this.paren;
                    if (this.paren < 0) {
                        this.paren = 0;
                    }
                    this.buf.append(this.c);
                    this.writeIndentedLine();
                    if (!this.getnl()) continue block15;
                    this.chars[this.pos--] = 10;
                    if (this.paren != 0) {
                        this.a_flg = true;
                        break;
                    }
                    if (this.tabs <= 0 || isCast) continue block15;
                    int n = this.level;
                    this.p_flg[n] = this.p_flg[n] + 1;
                    ++this.tabs;
                    this.ind[this.level] = 0;
                    break;
                }
                case '(': {
                    this.castFlags.push(Pattern.matches("^.*?(?:int|color|float)\\s*$", this.buf));
                    this.buf.append(this.c);
                    ++this.paren;
                    if (this.lookup("for")) {
                        this.c = this.get_string();
                        while (this.c != ';') {
                            this.c = this.get_string();
                        }
                        this.ct = 0;
                        boolean for_done = false;
                        while (!for_done) {
                            this.c = this.get_string();
                            while (this.c != ')') {
                                if (this.c == '(') {
                                    ++this.ct;
                                }
                                this.c = this.get_string();
                            }
                            if (this.ct != 0) {
                                --this.ct;
                                continue;
                            }
                            for_done = true;
                        }
                        --this.paren;
                        if (this.paren < 0) {
                            this.paren = 0;
                        }
                        this.writeIndentedLine();
                        if (!this.getnl()) continue block15;
                        this.chars[this.pos--] = 10;
                        int n = this.level;
                        this.p_flg[n] = this.p_flg[n] + 1;
                        ++this.tabs;
                        this.ind[this.level] = 0;
                        break;
                    }
                    if (!this.lookup("if")) continue block15;
                    this.writeIndentedLine();
                    this.s_tabs[this.c_level][this.if_lev] = this.tabs;
                    this.sp_flg[this.c_level][this.if_lev] = this.p_flg[this.level];
                    this.s_ind[this.c_level][this.if_lev] = this.ind[this.level];
                    ++this.if_lev;
                    this.if_flg = true;
                }
            }
        }
        String formatted = this.result.toString();
        return formatted.equals(cleanText) ? source : formatted;
    }

    private void trimRight(StringBuilder sb) {
        while (sb.length() >= 1 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.setLength(sb.length() - 1);
        }
    }
}

