/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog.assignment;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.dialog.assignment.AssignmentEntryPane;
import com.projity.dialog.assignment.CommonAssignmentDialog;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.resource.Resource;
import com.projity.strings.Messages;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class ReplaceAssignmentDialog
extends AbstractDialog
implements CommonAssignmentDialog {
    DocumentFrame documentFrame;
    Resource resource;
    AssignmentEntryPane spreadSheetPane;
    JLabel resourceName;

    public static List getReplacementFromDialog(DocumentFrame documentFrame, Resource resource) {
        ReplaceAssignmentDialog replaceAssignmentDialog = new ReplaceAssignmentDialog(documentFrame, resource);
        if (!replaceAssignmentDialog.doModal()) {
            return null;
        }
        return replaceAssignmentDialog.getSelectedResources();
    }

    private ReplaceAssignmentDialog(DocumentFrame documentFrame, Resource resource) {
        super(documentFrame.getGraphicManager().getFrame(), Messages.getString("Text.ReplaceResource"), true);
        this.documentFrame = documentFrame;
        this.resource = resource;
        this.createContentPanel();
        this.addDocHelp("Assign_Resources#Replacing_one_resource_with_another");
    }

    protected void initControls() {
        this.spreadSheetPane = new AssignmentEntryPane(this, this.documentFrame.getProject(), null, true, null);
        this.spreadSheetPane.setProject(this.documentFrame.getProject());
        this.spreadSheetPane.updateTable();
        this.resourceName = new JLabel(Messages.getString("Text.Replace") + " " + this.resource.getName());
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("140dlu:grow", "p, 3dlu, p, 3dlu, fill:200dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(this.resourceName);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("Text.With"));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(this.spreadSheetPane);
        return defaultFormBuilder.getPanel();
    }

    @Override
    public void setEditorButtonsVisible(boolean bl) {
    }

    public List getSelectedResources() {
        return this.spreadSheetPane.getSelectedResources(false);
    }
}

