/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.functor;

import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.functor.AssignmentFieldFunctor;
import com.projity.pm.resource.Resource;
import com.projity.pm.time.HasStartAndEnd;

public class ResourceAvailabilityFunctor
extends AssignmentFieldFunctor {
    double maxUnits;

    private ResourceAvailabilityFunctor(Assignment assignment) {
        super(assignment, assignment.getResource().getEffectiveWorkCalendar(), null);
        if (this.workCalendar == null) {
            this.workCalendar = assignment.getTask().getProject().getEffectiveWorkCalendar();
        }
        this.maxUnits = assignment.getResource().getMaximumUnits();
    }

    private ResourceAvailabilityFunctor(Resource resource) {
        super(null, resource.getEffectiveWorkCalendar(), null);
        this.maxUnits = resource.getMaximumUnits();
    }

    @Override
    public void execute(Object object) {
        HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)object;
        this.value += this.maxUnits * (double)this.workCalendar.compare(hasStartAndEnd.getEnd(), hasStartAndEnd.getStart(), false);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public static ResourceAvailabilityFunctor getInstance(Assignment assignment) {
        return new ResourceAvailabilityFunctor(assignment);
    }

    public static ResourceAvailabilityFunctor getInstance(Resource resource) {
        return new ResourceAvailabilityFunctor(resource);
    }
}

