/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.chart;

import com.projity.document.ObjectEvent;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.grouping.core.model.NodeModel;
import com.projity.pm.graphic.chart.AxisPanel;
import com.projity.pm.graphic.chart.ChartLegend;
import com.projity.pm.graphic.chart.ChartModel;
import com.projity.pm.graphic.chart.TimeChartPanel;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.event.CacheListener;
import com.projity.pm.graphic.model.event.CompositeCacheEvent;
import com.projity.pm.graphic.spreadsheet.selection.event.SelectionNodeEvent;
import com.projity.pm.graphic.spreadsheet.selection.event.SelectionNodeListener;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.graphic.views.ChartView;
import com.projity.pm.resource.Resource;
import com.projity.pm.scheduling.ScheduleEvent;
import com.projity.pm.scheduling.ScheduleEventListener;
import com.projity.pm.task.Project;
import com.projity.timescale.TimeScaleEvent;
import com.projity.timescale.TimeScaleListener;
import com.projity.workspace.SavableToWorkspace;
import com.projity.workspace.WorkspaceSetting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;

public class ChartInfo
implements Serializable,
SelectionNodeListener,
ScheduleEventListener,
TimeScaleListener,
ObjectEvent.Listener,
CacheListener,
SavableToWorkspace {
    private static final long serialVersionUID = -6593093924980192805L;
    Project project;
    NodeModel nodeModel;
    ChartView chartView;
    boolean simple;
    List selectedObjects = new ArrayList();
    ChartModel model;
    ChartLegend chartLegend;
    JFreeChart chart;
    CoordinatesConverter coord;
    List tasks;
    List resources;
    boolean cumulative = false;
    boolean histogram = true;
    boolean selectedOnTop = true;
    boolean work = true;
    Object[] traces = new Object[0];
    TimeChartPanel chartPanel;
    AxisPanel axisPanel;
    NodeModelCache cache = null;
    private boolean restoring = false;

    public ChartView getChartView() {
        return this.chartView;
    }

    public void setChartView(ChartView chartView) {
        this.chartView = chartView;
    }

    public CoordinatesConverter getCoord() {
        return this.coord;
    }

    public void setCoord(CoordinatesConverter coordinatesConverter) {
        if (this.coord != null) {
            this.coord.removeTimeScaleListener(this);
        }
        this.coord = coordinatesConverter;
        this.model = new ChartModel(coordinatesConverter);
        coordinatesConverter.addTimeScaleListener(this);
    }

    public boolean isCumulative() {
        return this.cumulative;
    }

    public boolean isSelectedOnTop() {
        return this.selectedOnTop;
    }

    public boolean isHistogram() {
        return this.histogram;
    }

    public void setHistogram(boolean bl) {
        this.histogram = bl;
        this.updateChart(this.tasks, this.resources);
    }

    public ChartModel getModel() {
        return this.model;
    }

    public void setModel(ChartModel chartModel) {
        this.model = chartModel;
    }

    public List getResources() {
        return this.resources;
    }

    public void setResources(List list) {
        this.resources = list;
    }

    public List getSelectedObjects() {
        return this.selectedObjects;
    }

    public void setSelectedObjects(List list) {
        this.selectedObjects = list;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean bl) {
        this.simple = bl;
    }

    public List getTasks() {
        return this.tasks;
    }

    public void setTasks(List list) {
        this.tasks = list;
    }

    public Object[] getTraces() {
        return this.traces;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public JFreeChart setChart(JFreeChart jFreeChart) {
        this.chart = jFreeChart;
        return jFreeChart;
    }

    public TimeChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setChartPanel(TimeChartPanel timeChartPanel) {
        this.chartPanel = timeChartPanel;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        if (this.project != null) {
            this.project.removeScheduleListener(this);
            this.project.getResourcePool().removeObjectListener(this);
        }
        this.project = project;
        project.addScheduleListener(this);
        project.getResourcePool().addObjectListener(this);
        this.nodeModel = project.getResourcePool().getResourceOutline();
    }

    public NodeModel getNodeModel() {
        return this.nodeModel;
    }

    public void setNodeModel(NodeModel nodeModel) {
        this.nodeModel = nodeModel;
    }

    @Override
    public void selectionChanged(SelectionNodeEvent selectionNodeEvent) {
        if (!this.isVisible()) {
            return;
        }
        this.chartLegend.selectionChanged(selectionNodeEvent);
    }

    public ChartLegend getChartLegend() {
        return this.chartLegend;
    }

    public void setChartLegend(ChartLegend chartLegend) {
        this.chartLegend = chartLegend;
    }

    public void setTraces(Object[] objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        this.traces = objectArray;
        if (this.chartPanel != null) {
            this.updateChart(this.tasks, this.resources);
        }
    }

    @Override
    public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
        if (!this.isVisible()) {
            return;
        }
        this.updateChart(this.tasks, this.resources);
    }

    @Override
    public void scheduleChanged(ScheduleEvent scheduleEvent) {
        if (!this.isVisible()) {
            return;
        }
        this.updateChart(this.tasks, this.resources);
    }

    public void setCumulative(boolean bl) {
        this.cumulative = bl;
        this.updateChart(this.tasks, this.resources);
    }

    public void setSelectedOnTop(boolean bl) {
        this.selectedOnTop = bl;
    }

    public double getFooterHeight() {
        return this.chartPanel.getNonPlotHeight();
    }

    public double getHeaderHeight() {
        return this.chartView.getHeaderComponentHeight();
    }

    public void updateChart(List list, List list2) {
        this.tasks = list;
        this.resources = list2;
        if (this.isSimple()) {
            this.model.computeHistogram(this.getProject(), list, list2, this.traces);
        } else {
            this.model.computeValues(list, list2, this.cumulative, this.traces, this.histogram);
        }
        this.chart = this.chartPanel.buildChart();
        this.setChart(this.chart);
        this.chartPanel.updateChart();
        this.axisPanel.setAxis(this.getChart().getXYPlot().getRangeAxis());
        this.axisPanel.repaint();
    }

    public AxisPanel getAxisPanel() {
        return this.axisPanel;
    }

    public void setAxisPanel(AxisPanel axisPanel) {
        this.axisPanel = axisPanel;
    }

    @Override
    public void objectChanged(ObjectEvent objectEvent) {
        if (!this.isVisible()) {
            return;
        }
        if (objectEvent.getObject() instanceof Resource) {
            this.chartLegend.rebuildTree();
            this.updateChart(this.tasks, this.resources);
        }
    }

    boolean isVisible() {
        return this.chartView.isVisible();
    }

    public void setCache(NodeModelCache nodeModelCache) {
        if (this.cache == null) {
            nodeModelCache.removeNodeModelListener(this);
        }
        this.cache = nodeModelCache;
        nodeModelCache.update();
        nodeModelCache.addNodeModelListener(this);
    }

    public final NodeModelCache getCache() {
        return this.cache;
    }

    @Override
    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        if (!this.isVisible()) {
            return;
        }
        this.chartLegend.rebuildTree();
    }

    public void setCumulativeCostMode() {
        this.cumulative = true;
        this.histogram = false;
    }

    public boolean isWork() {
        return this.work;
    }

    public void setWork(boolean bl) {
        this.work = bl;
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.cumulative = workspace.cumulative;
        this.histogram = workspace.histogram;
        this.selectedOnTop = workspace.selectedOnTop;
        this.work = workspace.work;
        this.chartPanel.setVerticalScrolling(workspace.verticalScroll);
        this.chartPanel.verticalScrollingItem.setSelected(workspace.verticalScroll);
        if (!this.simple) {
            this.setTraces(SpreadSheetFieldArray.fromIdArray(workspace.traces));
        }
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.cumulative = this.cumulative;
        workspace.histogram = this.histogram;
        workspace.selectedOnTop = this.selectedOnTop;
        workspace.work = this.work;
        workspace.verticalScroll = this.chartPanel.isVerticalScrolling();
        if (!this.simple) {
            workspace.traces = SpreadSheetFieldArray.toIdArray(this.traces);
        }
        return workspace;
    }

    public boolean isRestoring() {
        return this.restoring;
    }

    public void setRestoring(boolean bl) {
        this.restoring = bl;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -1369065811123053002L;
        boolean cumulative;
        boolean histogram;
        boolean selectedOnTop;
        boolean work;
        Object[] traces;
        boolean verticalScroll;

        public boolean isCumulative() {
            return this.cumulative;
        }

        public void setCumulative(boolean bl) {
            this.cumulative = bl;
        }

        public boolean isHistogram() {
            return this.histogram;
        }

        public void setHistogram(boolean bl) {
            this.histogram = bl;
        }

        public boolean isSelectedOnTop() {
            return this.selectedOnTop;
        }

        public void setSelectedOnTop(boolean bl) {
            this.selectedOnTop = bl;
        }

        public boolean isWork() {
            return this.work;
        }

        public void setWork(boolean bl) {
            this.work = bl;
        }

        public Object[] getTraces() {
            return this.traces;
        }

        public void setTraces(Object[] objectArray) {
            this.traces = objectArray;
        }

        public boolean isVerticalScroll() {
            return this.verticalScroll;
        }

        public void setVerticalScroll(boolean bl) {
            this.verticalScroll = bl;
        }
    }
}

