/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.chart;

import com.projity.algorithm.TimeIteratorGenerator;
import com.projity.algorithm.buffer.CalculatedValues;
import com.projity.algorithm.buffer.GroupedCalculatedValues;
import com.projity.algorithm.buffer.NonGroupedCalculatedValues;
import com.projity.algorithm.buffer.SeriesCallback;
import com.projity.association.AssociationList;
import com.projity.field.Field;
import com.projity.options.CalendarOption;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.HasAssignments;
import com.projity.pm.assignment.HasTimeDistributedData;
import com.projity.pm.assignment.TimeDistributedConstants;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.graphic.views.ChartView;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.task.Project;
import com.projity.timescale.TimeInterval;
import com.projity.timescale.TimeIterator;
import com.projity.util.Environment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartModel
implements TimeDistributedConstants,
Serializable {
    private static final long serialVersionUID = -1617376166476506096L;
    private ChartView chartModel;
    XYSeriesCollection seriesCollection;
    XYSeriesCollection secondSeriesCollection = null;
    CoordinatesConverter coord;

    public ChartModel(CoordinatesConverter coordinatesConverter) {
        this.coord = coordinatesConverter;
    }

    public CalculatedValues computeTrace(Iterator iterator, List list, Object object, boolean bl, boolean bl2) {
        if (iterator == null || !iterator.hasNext()) {
            return null;
        }
        CalculatedValues calculatedValues = bl ? new GroupedCalculatedValues() : new NonGroupedCalculatedValues(bl2, this.coord.getOrigin());
        TimeIterator timeIterator = null;
        Iterator iterator2 = iterator;
        double d = 0.0;
        ArrayList arrayList = new ArrayList();
        boolean bl3 = false;
        block0: while (iterator2.hasNext()) {
            Object e = iterator2.next();
            if (!(e instanceof HasAssignments)) continue;
            AssociationList associationList = ((HasAssignments)e).getAssignments();
            for (Assignment assignment : associationList) {
                TimeIteratorGenerator timeIteratorGenerator;
                if (bl) {
                    timeIterator = this.coord.getProjectTimeIterator();
                    timeIteratorGenerator = bl ? TimeIteratorGenerator.getInstance(timeIterator) : null;
                } else {
                    timeIteratorGenerator = null;
                }
                if (this.isTaskBased(object)) {
                    bl3 = true;
                    assignment.calcDataBetween(object, timeIteratorGenerator, calculatedValues);
                    continue block0;
                }
                if (assignment.isDefault() || list != null && !list.contains(assignment.getResource())) continue;
                bl3 = true;
                assignment.calcDataBetween(object, timeIteratorGenerator, calculatedValues);
            }
        }
        if (!bl3) {
            return null;
        }
        return calculatedValues;
    }

    public CalculatedValues computeAvailability(List list) {
        GroupedCalculatedValues groupedCalculatedValues = new GroupedCalculatedValues();
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof Resource)) continue;
                Resource resource = (Resource)e;
                TimeIterator timeIterator = this.coord.getProjectTimeIterator();
                TimeIteratorGenerator timeIteratorGenerator = TimeIteratorGenerator.getInstance(timeIterator);
                Assignment.calcResourceAvailabilityBetween(resource, timeIteratorGenerator, groupedCalculatedValues);
            }
        }
        return groupedCalculatedValues;
    }

    public CalculatedValues computeOtherProjects(List list, List list2) {
        GroupedCalculatedValues groupedCalculatedValues = new GroupedCalculatedValues();
        if (list2 != null && list2.size() > 0 || list != null && list.size() > 0) {
            TimeInterval timeInterval;
            Iterator iterator = (list2 == null || list2.size() == 0 ? list : list2).iterator();
            GroupedCalculatedValues groupedCalculatedValues2 = groupedCalculatedValues;
            TimeIterator timeIterator = this.coord.getProjectTimeIterator();
            int n = 0;
            while (timeIterator.hasNext()) {
                timeInterval = timeIterator.next();
                groupedCalculatedValues2.set(n, timeInterval.getStart1(), timeInterval.getEnd1(), 0.0, null);
                ++n;
            }
            while (iterator.hasNext()) {
                GroupedCalculatedValues groupedCalculatedValues3;
                ResourceImpl resourceImpl;
                timeInterval = iterator.next();
                if (timeInterval instanceof Assignment) {
                    resourceImpl = (ResourceImpl)((Assignment)((Object)timeInterval)).getResource();
                } else {
                    if (!(timeInterval instanceof ResourceImpl)) continue;
                    resourceImpl = (ResourceImpl)((Object)timeInterval);
                }
                if ((groupedCalculatedValues3 = resourceImpl.getGlobalResource().getGlobalWorkVector()) == null) continue;
                groupedCalculatedValues3 = groupedCalculatedValues3.dayByDayConvert();
                groupedCalculatedValues2.mergeIn(groupedCalculatedValues3);
            }
            return groupedCalculatedValues2;
        }
        return groupedCalculatedValues;
    }

    public void computeHistogram(Project project, List list, List list2, Object[] objectArray) {
        boolean bl = objectArray == (Environment.getStandAlone() ? HasTimeDistributedData.histogramTypes : HasTimeDistributedData.serverHistogramTypes);
        GroupedCalculatedValues groupedCalculatedValues = (GroupedCalculatedValues)this.computeAvailability(list2);
        GroupedCalculatedValues groupedCalculatedValues2 = null;
        if (!Environment.getStandAlone()) {
            groupedCalculatedValues2 = (GroupedCalculatedValues)this.computeOtherProjects(list, list2);
        }
        GroupedCalculatedValues groupedCalculatedValues3 = (GroupedCalculatedValues)this.computeTrace(project.getTaskOutlineIterator(), list2, WORK, true, false);
        GroupedCalculatedValues groupedCalculatedValues4 = (GroupedCalculatedValues)this.computeTrace(list == null ? null : list.iterator(), list2, WORK, true, false);
        for (int i = 0; i < groupedCalculatedValues.size(); ++i) {
            double d;
            double d2;
            double d3 = d2 = groupedCalculatedValues3 != null ? groupedCalculatedValues3.getUnscaledValue(i) : 0.0;
            if (groupedCalculatedValues2 != null) {
                d3 += groupedCalculatedValues2.getUnscaledValue(i);
            }
            double d4 = d = groupedCalculatedValues4 != null ? groupedCalculatedValues4.getUnscaledValue(i) : 0.0;
            if (bl) {
                if (groupedCalculatedValues4 != null) {
                    groupedCalculatedValues4.setValue(i, d3);
                }
                if (groupedCalculatedValues3 == null) continue;
                groupedCalculatedValues3.setValue(i, d3 - d);
                continue;
            }
            if (groupedCalculatedValues2 == null) continue;
            groupedCalculatedValues2.setValue(i, d3);
        }
        XYSeries xYSeries = this.buildHistogramSeries(AVAILABILITY, groupedCalculatedValues);
        XYSeries xYSeries2 = null;
        if (groupedCalculatedValues2 != null) {
            xYSeries2 = this.buildHistogramSeries(OTHER_PROJECTS, groupedCalculatedValues2);
        }
        XYSeries xYSeries3 = this.buildHistogramSeries(THIS_PROJECT, groupedCalculatedValues3);
        XYSeries xYSeries4 = this.buildHistogramSeries(SELECTED, groupedCalculatedValues4);
        this.seriesCollection = new XYSeriesCollection();
        if (bl) {
            this.seriesCollection.addSeries(xYSeries4);
            this.seriesCollection.addSeries(xYSeries3);
            if (xYSeries2 != null) {
                this.seriesCollection.addSeries(xYSeries2);
            }
        } else {
            if (xYSeries2 != null) {
                this.seriesCollection.addSeries(xYSeries2);
            }
            this.seriesCollection.addSeries(xYSeries3);
            this.seriesCollection.addSeries(xYSeries4);
        }
        this.secondSeriesCollection = new XYSeriesCollection();
        this.secondSeriesCollection.addSeries(xYSeries);
    }

    private XYSeries buildHistogramSeries(Object object, CalculatedValues calculatedValues) {
        if (calculatedValues == null) {
            return this.dummySeries(object);
        }
        XYSeries xYSeries = new XYSeries((Comparable)((Object)object.toString()), false, true);
        this.makeSeries(xYSeries, object, false, calculatedValues);
        return xYSeries;
    }

    private XYSeries dummySeries(Object object) {
        return new XYSeries((Comparable)((Object)object.toString()), false, true);
    }

    private int findTrace(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    public void dumpDataset(Object[] objectArray) {
        for (int i = 0; i < this.seriesCollection.getSeriesCount(); ++i) {
            System.out.println("series " + i + " " + objectArray[i]);
            ChartModel.dumpSeries(this.seriesCollection.getSeries(i));
        }
    }

    public static void dumpSeries(XYSeries xYSeries) {
        for (int i = 0; i < xYSeries.getItemCount(); ++i) {
            System.out.println(new Date(xYSeries.getX(i).longValue()) + " " + xYSeries.getY(i));
        }
    }

    private boolean isTraceRectilinear(Object object) {
        return object == AVAILABILITY;
    }

    private void makeSeries(XYSeries xYSeries, Object object, boolean bl, CalculatedValues calculatedValues) {
        final double d = this.getScaleFactor(object);
        final XYSeries xYSeries2 = xYSeries;
        if (this.isTraceRectilinear(object)) {
            calculatedValues.makeRectilinearSeries(new SeriesCallback(){

                @Override
                public void add(int n, double d3, double d2) {
                    xYSeries2.add(d3, d2 / d);
                }
            });
        } else {
            calculatedValues.makeSeries(bl, new SeriesCallback(){

                @Override
                public void add(int n, double d3, double d2) {
                    xYSeries2.add(d3, d2 / d);
                }
            });
        }
    }

    public void computeValues(List list, List list2, boolean bl, Object[] objectArray, boolean bl2) {
        int n;
        if (list == null) {
            return;
        }
        CalculatedValues[] calculatedValuesArray = new CalculatedValues[objectArray.length];
        this.seriesCollection = new XYSeriesCollection();
        this.secondSeriesCollection = null;
        for (n = 0; n < objectArray.length; ++n) {
            calculatedValuesArray[n] = this.computeTrace(list == null ? null : list.iterator(), list2, objectArray[n], bl2, bl);
        }
        for (n = 0; n < objectArray.length; ++n) {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)objectArray[n].toString()), false, true);
            if (calculatedValuesArray[n] == null) {
                System.out.println("skipping null values array " + objectArray[n]);
                continue;
            }
            this.makeSeries(xYSeries, objectArray[n], bl, calculatedValuesArray[n]);
            this.seriesCollection.addSeries(xYSeries);
        }
    }

    private double getScaleFactor(Object object) {
        if (object instanceof Field && !((Field)object).isDurationOrWork()) {
            return 1.0;
        }
        double d = CalendarOption.getInstance().getHoursPerDay() / 24.0;
        return d * (double)this.coord.getIntervalDuration();
    }

    public AbstractXYDataset getDataset() {
        return this.seriesCollection;
    }

    private final boolean isTaskBased(Object object) {
        return object == FIXED_COST || object == ACTUAL_FIXED_COST;
    }

    public XYDataset getSecondDataset() {
        return this.secondSeriesCollection;
    }
}

