/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.model.cache;

import com.projity.functor.IntervalConsumer;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.grouping.core.GroupNodeImpl;
import com.projity.grouping.core.LazyParent;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.transform.HierarchicObject;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.scheduling.Schedule;
import com.projity.pm.scheduling.ScheduleInterval;
import com.projity.pm.scheduling.ScheduleService;
import com.projity.pm.task.Task;
import com.projity.server.data.CommonDataObject;
import com.projity.server.data.DataObject;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GraphicNode
implements HierarchicObject {
    protected Node node;
    protected int level;
    protected int pertLevel;
    protected boolean voidNode;
    protected boolean composite;
    protected boolean summary;
    protected boolean collapsed;
    protected boolean dirty;
    protected boolean scheduleCaching;
    protected ArrayList intervals = null;
    protected long start = -1L;
    protected long end = -1L;
    protected int intervalCount = 1;
    protected static CacheIntervalConsumer intervalConsumer = new CacheIntervalConsumer();
    private ContainsIntervalConsumer containsConsumer = null;
    protected double ganttShapeOffset = 0.0;
    protected double ganttShapeHeight = GraphicConfiguration.getInstance().getGanttBarHeight();
    protected int row;
    protected GeneralPath pertShape = null;
    protected GeneralPath xbsShape = null;
    protected Point2D pertCenter = null;
    protected Point2D xbsCenter = null;
    protected List tmpChildren = new ArrayList();
    protected boolean tmpFiltered;

    public GraphicNode(Node node, int n) {
        this.setNode(node);
        this.level = n;
        this.dirty = false;
        this.pertLevel = -1;
        this.setScheduleCaching(false);
    }

    public int getLevel() {
        return this.level;
    }

    void setLevel(int n) {
        this.level = n;
        this.dirty = true;
    }

    public int getPertLevel() {
        return this.pertLevel;
    }

    void setPertLevel(int n) {
        this.pertLevel = n;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
        this.dirty = true;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public void setComposite(boolean bl) {
        this.composite = bl;
        this.dirty = true;
    }

    public boolean isSummary() {
        return this.summary;
    }

    public void setSummary(boolean bl) {
        this.summary = bl;
        this.dirty = true;
    }

    public boolean isLazyParent() {
        return this.node.getImpl() instanceof LazyParent;
    }

    public boolean isValidLazyParent() {
        if (this.node.getImpl() instanceof LazyParent) {
            return ((LazyParent)this.node.getImpl()).isValid();
        }
        return false;
    }

    public boolean isFetched() {
        if (this.node.getImpl() instanceof LazyParent) {
            return ((LazyParent)this.node.getImpl()).isDataFetched();
        }
        return true;
    }

    public boolean fetch() {
        if (this.node.getImpl() instanceof LazyParent) {
            return ((LazyParent)this.node.getImpl()).fetchData(this.node);
        }
        return true;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean bl) {
        this.collapsed = bl;
        this.dirty = true;
    }

    public boolean isVoid() {
        return this.voidNode;
    }

    public void setVoid(boolean bl) {
        this.voidNode = bl;
        this.dirty = true;
    }

    public boolean isAssignment() {
        return this.getNode().getImpl() instanceof Assignment;
    }

    public boolean isGroup() {
        return this.getNode().getImpl() instanceof GroupNodeImpl;
    }

    public int getSubprojectLevel() {
        return this.node.getSubprojectLevel();
    }

    public boolean isLinkable() {
        Object object = this.getNode().getImpl();
        if (object instanceof Assignment) {
            return false;
        }
        return !(object instanceof Task) || !((Task)object).isExternal();
    }

    public boolean isServer() {
        Object object = this.getNode().getImpl();
        if (!(object instanceof DataObject)) {
            return false;
        }
        return !CommonDataObject.isLocal((DataObject)object);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public String toString() {
        return this.node.toString();
    }

    public static Object getImpl(Object object) {
        if (object instanceof GraphicNode) {
            return ((GraphicNode)object).getNode().getImpl();
        }
        if (object instanceof Node) {
            return ((Node)object).getImpl();
        }
        return object;
    }

    public static boolean isVoid(Object object) {
        if (object instanceof GraphicNode) {
            return ((GraphicNode)object).isVoid();
        }
        if (object instanceof Node) {
            return ((Node)object).isVoid();
        }
        return object == null;
    }

    public long getStart() {
        return this.scheduleCaching || !this.isSchedule() ? this.start : ((Schedule)this.node.getImpl()).getStart();
    }

    public long getEnd() {
        return this.scheduleCaching || !this.isSchedule() ? this.end : ((Schedule)this.node.getImpl()).getEnd();
    }

    public int getIntervalCount() {
        return this.intervalCount;
    }

    public boolean isScheduleCaching() {
        return this.scheduleCaching;
    }

    public void setScheduleCaching(boolean bl) {
        this.scheduleCaching = bl;
        this.intervals = bl ? new ArrayList() : null;
        Object var2_2 = null;
    }

    public void updateScheduleCache() {
        if (this.scheduleCaching || GraphicConfiguration.getInstance().getGanttBarMinWidth() > 0) {
            Object object = this.node.getImpl();
            if (!this.isSchedule()) {
                return;
            }
            intervalConsumer.initCache(this, this.intervals);
            ScheduleService.getInstance().consumeIntervals((Schedule)object, intervalConsumer);
            this.intervalCount = GraphicNode.intervalConsumer.size > 0 ? GraphicNode.intervalConsumer.size : 1;
        }
    }

    public void consumeIntervals(IntervalConsumer intervalConsumer) {
        if (this.scheduleCaching) {
            Iterator iterator = this.intervals.iterator();
            while (iterator.hasNext()) {
                intervalConsumer.consumeInterval((ScheduleInterval)iterator.next());
            }
        } else {
            Object object = this.node.getImpl();
            if (this.isSchedule()) {
                ScheduleService.getInstance().consumeIntervals((Schedule)object, intervalConsumer);
            }
        }
    }

    public ScheduleInterval contains(double d, double d2, double d3, CoordinatesConverter coordinatesConverter) {
        if (this.scheduleCaching) {
            for (ScheduleInterval scheduleInterval : this.intervals) {
                if (coordinatesConverter != null) {
                    scheduleInterval = coordinatesConverter.adaptSmallBarTimeInterval(scheduleInterval, this, null);
                }
                if (!(d >= (double)scheduleInterval.getStart() - d2) || !(d <= (double)scheduleInterval.getEnd() + d3)) continue;
                return scheduleInterval;
            }
            return null;
        }
        if (this.containsConsumer == null) {
            this.containsConsumer = new ContainsIntervalConsumer();
        }
        this.containsConsumer.init(d, d2, d3, coordinatesConverter, this);
        Object object = this.node.getImpl();
        if (this.isSchedule()) {
            ScheduleService.getInstance().consumeIntervals((Schedule)object, this.containsConsumer);
        }
        return this.containsConsumer.getInterval();
    }

    public boolean isSchedule() {
        return this.node.getImpl() instanceof Schedule;
    }

    public double getGanttShapeHeight() {
        return this.ganttShapeHeight;
    }

    public void setGanttShapeHeight(double d) {
        this.ganttShapeHeight = d;
    }

    public double getGanttShapeOffset() {
        return this.ganttShapeOffset;
    }

    public void setGanttShapeOffset(double d) {
        this.ganttShapeOffset = d;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public GeneralPath getPertShape() {
        return this.pertShape;
    }

    public void setPertShape(GeneralPath generalPath, double d, double d2) {
        this.pertShape = generalPath;
        if (this.pertCenter == null) {
            this.pertCenter = new Point2D.Double();
        }
        this.pertCenter.setLocation(d, d2);
    }

    public GeneralPath getXbsShape() {
        return this.xbsShape;
    }

    public void setXbsShape(GeneralPath generalPath, double d, double d2) {
        this.xbsShape = generalPath;
        this.setXbsCenter(d, d2);
    }

    private void setXbsCenter(double d, double d2) {
        if (this.xbsCenter == null) {
            this.xbsCenter = new Point2D.Double();
        }
        this.xbsCenter.setLocation(d, d2);
    }

    public Point2D getPertCenter() {
        return this.pertCenter;
    }

    public Point2D getXbsCenter() {
        return this.xbsCenter;
    }

    public void translatePertShape(double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        this.getPertShape().transform(affineTransform);
        Point2D point2D = this.getPertCenter();
        point2D.setLocation(point2D.getX() + d, point2D.getY() + d2);
    }

    public void translateXbsShape(double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        this.getXbsShape().transform(affineTransform);
        Point2D point2D = this.getXbsCenter();
        point2D.setLocation(point2D.getX() + d, point2D.getY() + d2);
    }

    public long getCompleted() {
        if (!(this.getNode().getImpl() instanceof Schedule)) {
            return 0L;
        }
        long l = ScheduleService.getInstance().getCompleted((Schedule)this.getNode().getImpl());
        return l == 0L ? this.getStart() : l;
    }

    public boolean isStarted() {
        if (!(this.getNode().getImpl() instanceof Schedule)) {
            return false;
        }
        return ((Schedule)this.getNode().getImpl()).getPercentComplete() > 0.0;
    }

    @Override
    public List getChildren() {
        return this.tmpChildren;
    }

    public boolean isFiltered() {
        return this.tmpFiltered;
    }

    public void setFiltered(boolean bl) {
        this.tmpFiltered = bl;
    }

    private static class ContainsIntervalConsumer
    implements IntervalConsumer {
        ScheduleInterval interval = null;
        double t;
        double deltaT1;
        double deltaT2;
        CoordinatesConverter coord;
        GraphicNode node;

        private ContainsIntervalConsumer() {
        }

        public void init(double d, double d2, double d3, CoordinatesConverter coordinatesConverter, GraphicNode graphicNode) {
            this.interval = null;
            this.t = d;
            this.deltaT1 = d2;
            this.deltaT2 = d3;
            this.coord = coordinatesConverter;
            this.node = graphicNode;
        }

        public ScheduleInterval getInterval() {
            return this.interval;
        }

        @Override
        public void consumeInterval(ScheduleInterval scheduleInterval) {
            if (this.coord != null) {
                scheduleInterval = this.coord.adaptSmallBarTimeInterval(scheduleInterval, this.node, null);
            }
            if (this.t >= (double)scheduleInterval.getStart() - this.deltaT1 && this.t <= (double)scheduleInterval.getEnd() + this.deltaT2) {
                this.interval = scheduleInterval;
            }
        }
    }

    protected static class CacheIntervalConsumer
    implements IntervalConsumer {
        protected List cache = null;
        protected GraphicNode gnode = null;
        int size;

        protected CacheIntervalConsumer() {
        }

        public void initCache(GraphicNode graphicNode, List list) {
            this.size = 0;
            if (list != null) {
                list.clear();
            }
            this.cache = list;
            this.gnode = graphicNode;
        }

        @Override
        public void consumeInterval(ScheduleInterval scheduleInterval) {
            if (this.size++ == 0) {
                this.gnode.start = scheduleInterval.getStart();
            }
            this.gnode.end = scheduleInterval.getEnd();
            if (this.cache != null) {
                this.cache.add(scheduleInterval);
            }
        }
    }
}

