#!/usr/bin/python

# Example code that illustrates the problem described in
# bug #955889 -- see
#   https://sourceforge.net/tracker/index.php?func=detail&aid=955889&group_id=38019&atid=421097
# for details.  (This problem has been fixed, so this code shows
# the right way [as of Optik 1.5] to do things.)

from copy import copy
from optik import OptionParser, Option, OptionValueError

_time_units = { 's' : 1, 'm' : 60, 'h' : 60*60, 'd' : 60*60*24 }

def _get_duration(value):
    if not value[-1].isdigit():
        return int(value[:-1]) * _time_units[value[-1]]
    else:
        return int(value)

def _check_duration(option, opt, value):
    try:
        return _get_duration(value)
    except (ValueError, IndexError, KeyError):
        raise OptionValueError(
            'option %s: invalid duration: %r' % (opt, value))

class MyOption(Option):
    TYPES = Option.TYPES + ('duration',)
    TYPE_CHECKER = copy(Option.TYPE_CHECKER)
    TYPE_CHECKER['duration'] = _check_duration

class MyOptionParser(OptionParser):
    def __init__(self):
        OptionParser.__init__(self, option_class=MyOption,
            usage='usage: %prog [options]')
        self.add_option(
            '--delay',
            type='duration',
            default='5m',     # this did not work prior to Optik 1.5
            help='self destruct delay [default: %default]')

parser = MyOptionParser()
(options, args) = parser.parse_args()

print 'self destruct in %s seconds' % options.delay
