#!/usr/bin/env python

# "Required options" with Optik, version 2:
# extend Option and add a 'required' attribute;
# extend OptionParser to ensure that required options
# are present after parsing.

import optik

class Option (optik.Option):
    ATTRS = optik.Option.ATTRS + ['required']

    def _check_required (self):
        if self.required and not self.takes_value():
            raise OptionError(
                "required flag set for option that doesn't take a value",
                 self)

    # Make sure _check_required() is called from the constructor!
    CHECK_METHODS = optik.Option.CHECK_METHODS + [_check_required]

    def process (self, opt, value, values, parser):
        optik.Option.process(self, opt, value, values, parser)
        parser.option_seen[self] = 1


class OptionParser (optik.OptionParser):

    def _init_parsing_state (self):
        optik.OptionParser._init_parsing_state(self)
        self.option_seen = {}

    def check_values (self, values, args):
        for option in self.option_list:
            if (isinstance(option, Option) and
                option.required and
                not self.option_seen.has_key(option)):
                self.error("%s not supplied" % option)
        return (values, args)


parser = OptionParser(option_list=[
    Option("-v", action="count", dest="verbose"),
    Option("-f", "--file", required=1)])
(options, args) = parser.parse_args()

print "verbose:", options.verbose
print "file:", options.file
