/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.VcsAnnotation;
import com.intellij.openapi.vcs.annotate.VcsCacheableAnnotationProvider;
import com.intellij.openapi.vcs.annotate.VcsLineAnnotationData;
import com.intellij.openapi.vcs.annotate.VcsRareLineAnnotationData;
import com.intellij.openapi.vcs.annotate.VcsUsualLineAnnotationData;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnDiffProvider;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.annotate.AnnotationConsumer;
import org.jetbrains.idea.svn.annotate.BaseSvnFileAnnotation;
import org.jetbrains.idea.svn.annotate.SvnFileAnnotation;
import org.jetbrains.idea.svn.annotate.SvnRemoteFileAnnotation;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.info.Info;

public class SvnAnnotationProvider
implements AnnotationProvider,
VcsCacheableAnnotationProvider {
    private static final Object MERGED_KEY = new Object();
    @NotNull
    private final SvnVcs myVcs;

    public SvnAnnotationProvider(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(1);
        }
        SvnDiffProvider provider = (SvnDiffProvider)this.myVcs.getDiffProvider();
        SvnRevisionNumber currentRevision = (SvnRevisionNumber)provider.getCurrentRevision(file);
        VcsRevisionDescription lastChangedRevision = provider.getCurrentRevisionDescription(file);
        if (lastChangedRevision == null) {
            throw new VcsException("Can not get current revision for file " + file.getPath());
        }
        Revision revision = ((SvnRevisionNumber)lastChangedRevision.getRevisionNumber()).getRevision();
        if (!revision.isValid()) {
            throw new VcsException("Can not get last changed revision for file: " + file.getPath() + "\nPlease run svn info for this file and file an issue.");
        }
        FileAnnotation fileAnnotation = this.annotate(file, currentRevision, lastChangedRevision.getRevisionNumber(), (Throwable2Computable<String, VcsException, IOException>)((Throwable2Computable)() -> {
            if (file == null) {
                SvnAnnotationProvider.$$$reportNull$$$0(35);
            }
            byte[] data = SvnUtil.getFileContents(this.myVcs, Target.on(VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsoluteFile()), Revision.BASE, Revision.UNDEFINED);
            return LoadTextUtil.getTextByBinaryPresentation((byte[])data, (VirtualFile)file, (boolean)false, (boolean)false).toString();
        }));
        if (fileAnnotation == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(2);
        }
        return fileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file, @NotNull VcsFileRevision revision) throws VcsException {
        if (file == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(3);
        }
        if (revision == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(4);
        }
        FileAnnotation fileAnnotation = this.annotate(file, ((SvnFileRevision)revision).getRevisionNumber(), revision.getRevisionNumber(), (Throwable2Computable<String, VcsException, IOException>)((Throwable2Computable)() -> {
            if (revision == null) {
                SvnAnnotationProvider.$$$reportNull$$$0(33);
            }
            if (file == null) {
                SvnAnnotationProvider.$$$reportNull$$$0(34);
            }
            byte[] bytes = VcsHistoryUtil.loadRevisionContent((VcsFileRevision)revision);
            return LoadTextUtil.getTextByBinaryPresentation((byte[])bytes, (VirtualFile)file, (boolean)false, (boolean)false).toString();
        }));
        if (fileAnnotation == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(5);
        }
        return fileAnnotation;
    }

    @NotNull
    private FileAnnotation annotate(@NotNull VirtualFile file, @NotNull SvnRevisionNumber revisionNumber, @NotNull VcsRevisionNumber lastChangedRevision, @NotNull Throwable2Computable<String, VcsException, IOException> contentLoader) throws VcsException {
        if (file == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(6);
        }
        if (revisionNumber == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(7);
        }
        if (lastChangedRevision == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(8);
        }
        if (contentLoader == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(9);
        }
        if (file.isDirectory()) {
            throw new VcsException(SvnBundle.message("exception.text.cannot.annotate.directory", new Object[0]));
        }
        FileAnnotation[] annotation = new FileAnnotation[1];
        VcsException[] exception = new VcsException[1];
        Runnable command = () -> {
            if (file == null) {
                SvnAnnotationProvider.$$$reportNull$$$0(29);
            }
            if (contentLoader == null) {
                SvnAnnotationProvider.$$$reportNull$$$0(30);
            }
            if (lastChangedRevision == null) {
                SvnAnnotationProvider.$$$reportNull$$$0(31);
            }
            if (revisionNumber == null) {
                SvnAnnotationProvider.$$$reportNull$$$0(32);
            }
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsoluteFile();
            Info info = null;
            try {
                String contents = (String)contentLoader.compute();
                SvnFileAnnotation result = new SvnFileAnnotation(this.myVcs, file, contents, lastChangedRevision);
                info = this.myVcs.getInfo(ioFile);
                if (info == null) {
                    exception[0] = new SvnBindException("File '" + ioFile + "' is not under version control");
                    return;
                }
                Url url = info.getURL();
                Revision endRevision = revisionNumber.getRevision();
                if (Revision.WORKING.equals(endRevision)) {
                    endRevision = info.getRevision();
                }
                if (progress != null) {
                    progress.setText(SvnBundle.message("progress.text.computing.annotation", file.getName()));
                }
                AnnotationConsumer annotateHandler = SvnAnnotationProvider.createAnnotationHandler(progress, result);
                boolean calculateMergeinfo = this.myVcs.getSvnConfiguration().isShowMergeSourcesInAnnotate() && SvnUtil.checkRepositoryVersion15(this.myVcs, url);
                MySteppedLogGetter logGetter = new MySteppedLogGetter(this.myVcs, ioFile, progress, this.myVcs.getFactory(ioFile).createHistoryClient(), endRevision, result, url, calculateMergeinfo, file.getCharset());
                logGetter.go();
                LinkedList<Revision> rp = logGetter.getRevisionPoints();
                AnnotateClient annotateClient = this.myVcs.getFactory(ioFile).createAnnotateClient();
                for (int i = 0; i < rp.size() - 1; ++i) {
                    annotateClient.annotate(Target.on(ioFile), rp.get(i + 1), rp.get(i), calculateMergeinfo, SvnAnnotationProvider.getLogClientOptions(this.myVcs), annotateHandler);
                }
                if (rp.get(1).getNumber() > 0L) {
                    result.setFirstRevision(rp.get(1));
                }
                annotation[0] = result;
            }
            catch (IOException e) {
                exception[0] = new VcsException((Throwable)e);
            }
            catch (SvnBindException e) {
                this.handleSvnException(ioFile, info, e, file, revisionNumber, annotation, exception);
            }
            catch (VcsException e) {
                exception[0] = e;
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("action.text.annotate", new Object[0]), false, this.myVcs.getProject());
        } else {
            command.run();
        }
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
        FileAnnotation fileAnnotation = annotation[0];
        if (fileAnnotation == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(10);
        }
        return fileAnnotation;
    }

    private void handleSvnException(File ioFile, Info info, @NotNull SvnBindException e, @NotNull VirtualFile file, @NotNull SvnRevisionNumber revisionNumber, @NotNull FileAnnotation[] annotation, @NotNull VcsException[] exception) {
        if (e == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(11);
        }
        if (file == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(12);
        }
        if (revisionNumber == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(13);
        }
        if (annotation == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(14);
        }
        if (exception == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(15);
        }
        if (e.contains(ErrorCode.FS_NOT_FOUND)) {
            CommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> provider = this.myVcs.getCommittedChangesProvider();
            try {
                Pair pair = provider.getOneList(file, (VcsRevisionNumber)revisionNumber);
                if (pair != null && info != null && pair.getSecond() != null && !Comparing.equal((Object)((FilePath)pair.getSecond()).getIOFile(), (Object)ioFile)) {
                    annotation[0] = this.annotateNonExisting((Pair<SvnChangeList, FilePath>)pair, revisionNumber, info, file.getCharset(), file);
                }
            }
            catch (VcsException e1) {
                exception[0] = e1;
            }
            catch (IOException e1) {
                exception[0] = new VcsException((Throwable)e1);
            }
        } else {
            exception[0] = e;
        }
    }

    public static File getCommonAncestor(File file1, File file2) throws IOException {
        if (FileUtil.filesEqual((File)file1, (File)file2)) {
            return file1;
        }
        File can1 = file1.getCanonicalFile();
        File can2 = file2.getCanonicalFile();
        List parts1 = StringUtil.split((String)can1.getPath(), (String)File.separator, (boolean)true);
        List parts2 = StringUtil.split((String)can2.getPath(), (String)File.separator, (boolean)true);
        for (int cnt = 0; parts1.size() > cnt && parts2.size() > cnt; ++cnt) {
            if (((String)parts1.get(cnt)).equals(parts2.get(cnt))) continue;
            if (cnt > 0) {
                return new File(StringUtil.join(parts1.subList(0, cnt), (String)File.separator));
            }
            return null;
        }
        if (parts1.size() > parts2.size()) {
            return file2;
        }
        return file1;
    }

    @NotNull
    private SvnRemoteFileAnnotation annotateNonExisting(@NotNull Pair<SvnChangeList, FilePath> pair, @NotNull SvnRevisionNumber revisionNumber, @NotNull Info info, @NotNull Charset charset, @NotNull VirtualFile current) throws VcsException, IOException {
        String[] strings;
        File wasFile;
        File root;
        if (pair == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(16);
        }
        if (revisionNumber == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(17);
        }
        if (info == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(18);
        }
        if (charset == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(19);
        }
        if (current == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(20);
        }
        if ((root = SvnAnnotationProvider.getCommonAncestor(wasFile = ((FilePath)pair.getSecond()).getIOFile(), info.getFile())) == null) {
            throw new VcsException("Can not find relative path for " + wasFile.getPath() + "@" + revisionNumber.asString());
        }
        String relativePath = FileUtil.getRelativePath((String)root.getPath(), (String)wasFile.getPath(), (char)File.separatorChar);
        if (relativePath == null) {
            throw new VcsException("Can not find relative path for " + wasFile.getPath() + "@" + revisionNumber.asString());
        }
        Info wcRootInfo = this.myVcs.getInfo(root);
        if (wcRootInfo == null || wcRootInfo.getURL() == null) {
            throw new VcsException("Can not find relative path for " + wasFile.getPath() + "@" + revisionNumber.asString());
        }
        Url wasUrl = wcRootInfo.getURL();
        for (String string : strings = relativePath.replace('\\', '/').split("/")) {
            wasUrl = SvnUtil.append(wasUrl, string, true);
        }
        Revision revision = revisionNumber.getRevision();
        byte[] data = SvnUtil.getFileContents(this.myVcs, Target.on(wasUrl), revision, revision);
        String contents = LoadTextUtil.getTextByBinaryPresentation((byte[])data, (Charset)charset).toString();
        SvnRemoteFileAnnotation result = new SvnRemoteFileAnnotation(this.myVcs, contents, revisionNumber, current);
        AnnotationConsumer annotateHandler = SvnAnnotationProvider.createAnnotationHandler(ProgressManager.getInstance().getProgressIndicator(), result);
        boolean calculateMergeinfo = this.myVcs.getSvnConfiguration().isShowMergeSourcesInAnnotate() && SvnUtil.checkRepositoryVersion15(this.myVcs, wasUrl);
        AnnotateClient client = this.myVcs.getFactory().createAnnotateClient();
        client.annotate(Target.on(wasUrl, revision), Revision.of(1L), revision, calculateMergeinfo, SvnAnnotationProvider.getLogClientOptions(this.myVcs), annotateHandler);
        SvnRemoteFileAnnotation svnRemoteFileAnnotation = result;
        if (svnRemoteFileAnnotation == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(21);
        }
        return svnRemoteFileAnnotation;
    }

    @NotNull
    private static AnnotationConsumer createAnnotationHandler(@Nullable ProgressIndicator progress, @NotNull BaseSvnFileAnnotation result) {
        if (result == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(22);
        }
        AnnotationConsumer annotationConsumer = (lineNumber, info, mergeInfo) -> {
            if (result == null) {
                SvnAnnotationProvider.$$$reportNull$$$0(28);
            }
            if (progress != null) {
                progress.checkCanceled();
            }
            result.setLineInfo(lineNumber, info, mergeInfo != null && info.getRevision() > mergeInfo.getRevision() ? mergeInfo : null);
        };
        if (annotationConsumer == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(23);
        }
        return annotationConsumer;
    }

    public VcsAnnotation createCacheable(FileAnnotation fileAnnotation) {
        if (!(fileAnnotation instanceof SvnFileAnnotation)) {
            return null;
        }
        SvnFileAnnotation svnFileAnnotation = (SvnFileAnnotation)fileAnnotation;
        AnnotationSourceSwitcher annotationSourceSwitcher = svnFileAnnotation.getAnnotationSourceSwitcher();
        if (annotationSourceSwitcher != null) {
            annotationSourceSwitcher.switchTo(AnnotationSource.LOCAL);
        }
        int size = svnFileAnnotation.getLineCount();
        VcsUsualLineAnnotationData lineAnnotationData = new VcsUsualLineAnnotationData(size);
        for (int i = 0; i < size; ++i) {
            VcsRevisionNumber revisionNumber = svnFileAnnotation.getLineRevisionNumber(i);
            lineAnnotationData.put(i, revisionNumber);
        }
        VcsAnnotation vcsAnnotation = new VcsAnnotation(VcsUtil.getFilePath((VirtualFile)svnFileAnnotation.getFile()), (VcsLineAnnotationData)lineAnnotationData, (VcsRevisionNumber)svnFileAnnotation.getFirstRevisionNumber());
        if (annotationSourceSwitcher != null) {
            VcsRareLineAnnotationData merged = new VcsRareLineAnnotationData(size);
            HashMap<VcsRevisionNumber, SvnFileRevision> addMap = new HashMap<VcsRevisionNumber, SvnFileRevision>();
            annotationSourceSwitcher.switchTo(AnnotationSource.MERGE);
            for (int i = 0; i < size; ++i) {
                VcsRevisionNumber number;
                if (!annotationSourceSwitcher.mergeSourceAvailable(i) || (number = svnFileAnnotation.getLineRevisionNumber(i)) == null) continue;
                merged.put(i, number);
                addMap.put(number, svnFileAnnotation.getRevision(((SvnRevisionNumber)number).getRevision().getNumber()));
            }
            if (!merged.isEmpty()) {
                vcsAnnotation.addAnnotation(MERGED_KEY, (VcsLineAnnotationData)merged);
                vcsAnnotation.addCachedOtherRevisions(addMap);
            }
        }
        return vcsAnnotation;
    }

    @Nullable
    public FileAnnotation restore(@NotNull VcsAnnotation vcsAnnotation, @NotNull VcsAbstractHistorySession session, @NotNull String annotatedContent, boolean forCurrentRevision, VcsRevisionNumber revisionNumber) {
        if (vcsAnnotation == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(24);
        }
        if (session == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(25);
        }
        if (annotatedContent == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(26);
        }
        SvnFileAnnotation annotation = new SvnFileAnnotation(this.myVcs, vcsAnnotation.getFilePath().getVirtualFile(), annotatedContent, revisionNumber);
        VcsLineAnnotationData basicAnnotation = vcsAnnotation.getBasicAnnotation();
        VcsLineAnnotationData data = (VcsLineAnnotationData)vcsAnnotation.getAdditionalAnnotations().get(MERGED_KEY);
        Map historyAsMap = session.getHistoryAsMap();
        Map cachedOtherRevisions = vcsAnnotation.getCachedOtherRevisions();
        for (int i = 0; i < basicAnnotation.getNumLines(); ++i) {
            VcsRevisionNumber revision = basicAnnotation.getRevision(i);
            VcsRevisionNumber mergedData = data == null ? null : data.getRevision(i);
            SvnFileRevision fileRevision = (SvnFileRevision)historyAsMap.get(revision);
            if (fileRevision == null) {
                return null;
            }
            if (mergedData == null) {
                annotation.setLineInfo(i, fileRevision.getCommitInfo(), null);
                continue;
            }
            SvnFileRevision mergedRevision = (SvnFileRevision)cachedOtherRevisions.get(mergedData);
            if (mergedRevision == null) {
                return null;
            }
            annotation.setLineInfo(i, fileRevision.getCommitInfo(), mergedRevision.getCommitInfo());
        }
        if (vcsAnnotation.getFirstRevision() != null) {
            annotation.setFirstRevision(((SvnRevisionNumber)vcsAnnotation.getFirstRevision()).getRevision());
        }
        for (VcsRevisionNumber revision : session.getRevisionList()) {
            annotation.setRevision(((SvnRevisionNumber)revision.getRevisionNumber()).getRevision().getNumber(), (SvnFileRevision)revision);
        }
        return annotation;
    }

    @Nullable
    private static DiffOptions getLogClientOptions(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnAnnotationProvider.$$$reportNull$$$0(27);
        }
        return vcs.getSvnConfiguration().isIgnoreSpacesInAnnotate() ? new DiffOptions(true, true, true) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 12: 
            case 29: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/annotate/SvnAnnotationProvider";
                break;
            }
            case 4: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 7: 
            case 13: 
            case 17: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 8: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastChangedRevision";
                break;
            }
            case 9: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentLoader";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsAnnotation";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotatedContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/annotate/SvnAnnotationProvider";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "annotateNonExisting";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 21: 
            case 23: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleSvnException";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "annotateNonExisting";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationHandler";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLogClientOptions";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createAnnotationHandler$3";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$annotate$2";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$annotate$1";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$annotate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySteppedLogGetter {
        private final LinkedList<Revision> myRevisionPoints;
        private final SvnVcs myVcs;
        private final File myIoFile;
        private final ProgressIndicator myProgress;
        private final HistoryClient myClient;
        private final Revision myEndRevision;
        private final boolean myCalculateMergeinfo;
        private final SvnFileAnnotation myResult;
        private final Url myUrl;
        private final Charset myCharset;

        private MySteppedLogGetter(SvnVcs vcs, File ioFile, ProgressIndicator progress, HistoryClient client, Revision endRevision, SvnFileAnnotation result, Url url, boolean calculateMergeinfo, Charset charset) {
            this.myVcs = vcs;
            this.myIoFile = ioFile;
            this.myProgress = progress;
            this.myClient = client;
            this.myEndRevision = endRevision;
            this.myCalculateMergeinfo = calculateMergeinfo;
            this.myResult = result;
            this.myUrl = url;
            this.myCharset = charset;
            this.myRevisionPoints = new LinkedList();
        }

        public void go() throws VcsException {
            int maxAnnotateRevisions = this.myVcs.getSvnConfiguration().getMaxAnnotateRevisions();
            boolean longHistory = true;
            if (maxAnnotateRevisions == -1) {
                longHistory = false;
            } else if (this.myEndRevision.getNumber() < (long)maxAnnotateRevisions) {
                longHistory = false;
            }
            if (!longHistory) {
                this.doLog(this.myCalculateMergeinfo, null, 0);
                this.putDefaultBounds();
            } else {
                this.doLog(false, null, 0);
                List<VcsFileRevision> fileRevisionList = this.myResult.getRevisions();
                if (fileRevisionList.size() < maxAnnotateRevisions) {
                    this.putDefaultBounds();
                    if (this.myCalculateMergeinfo) {
                        this.doLog(true, null, 0);
                    }
                    return;
                }
                this.myRevisionPoints.add(((SvnRevisionNumber)fileRevisionList.get(0).getRevisionNumber()).getRevision());
                Revision truncateTo = ((SvnRevisionNumber)fileRevisionList.get(maxAnnotateRevisions - 1).getRevisionNumber()).getRevision();
                this.myRevisionPoints.add(truncateTo);
                if (this.myCalculateMergeinfo) {
                    this.doLog(true, truncateTo, maxAnnotateRevisions);
                }
            }
        }

        private void putDefaultBounds() {
            this.myRevisionPoints.add(this.myEndRevision);
            this.myRevisionPoints.add(Revision.of(0L));
        }

        private void doLog(boolean includeMerged, Revision truncateTo, int max) throws VcsException {
            this.myClient.doLog(Target.on(this.myIoFile), this.myEndRevision, truncateTo == null ? Revision.of(1L) : truncateTo, false, false, includeMerged, max, null, logEntry -> {
                if (Revision.UNDEFINED.getNumber() == logEntry.getRevision()) {
                    return;
                }
                if (this.myProgress != null) {
                    this.myProgress.checkCanceled();
                    this.myProgress.setText2(SvnBundle.message("progress.text2.revision.processed", logEntry.getRevision()));
                }
                this.myResult.setRevision(logEntry.getRevision(), new SvnFileRevision(this.myVcs, Revision.UNDEFINED, (LogEntry)logEntry, this.myUrl, ""));
            });
        }

        public LinkedList<Revision> getRevisionPoints() {
            return this.myRevisionPoints;
        }
    }
}

