/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.NotNullFunction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeModel;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.SvnRepositoryTreeCellRenderer;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.history.SvnFileRevision;

public class RepositoryBrowserComponent
extends JPanel
implements Disposable,
DataProvider {
    private JTree myRepositoryTree;
    private final SvnVcs myVCS;

    public RepositoryBrowserComponent(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            RepositoryBrowserComponent.$$$reportNull$$$0(0);
        }
        this.myVCS = vcs;
        this.createComponent();
    }

    public JTree getRepositoryTree() {
        return this.myRepositoryTree;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myVCS.getProject();
        if (project == null) {
            RepositoryBrowserComponent.$$$reportNull$$$0(1);
        }
        return project;
    }

    public void setRepositoryURLs(Url[] urls, boolean showFiles) {
        this.setRepositoryURLs(urls, showFiles, null, false);
    }

    public void setRepositoryURLs(Url[] urls, boolean showFiles, @Nullable NotNullFunction<RepositoryBrowserComponent, Expander> defaultExpanderFactory, boolean expandFirst) {
        RepositoryTreeModel model = new RepositoryTreeModel(this.myVCS, showFiles, this);
        if (defaultExpanderFactory != null) {
            model.setDefaultExpanderFactory(defaultExpanderFactory);
        }
        model.setRoots(urls);
        Disposer.register((Disposable)this, (Disposable)model);
        this.myRepositoryTree.setModel(model);
        if (expandFirst) {
            this.myRepositoryTree.expandRow(0);
        }
    }

    public void setRepositoryURL(Url url, boolean showFiles, NotNullFunction<RepositoryBrowserComponent, Expander> defaultExpanderFactory) {
        RepositoryTreeModel model = new RepositoryTreeModel(this.myVCS, showFiles, this);
        model.setDefaultExpanderFactory(defaultExpanderFactory);
        model.setSingleRoot(url);
        Disposer.register((Disposable)this, (Disposable)model);
        this.myRepositoryTree.setModel(model);
        this.myRepositoryTree.setRootVisible(true);
        this.myRepositoryTree.setSelectionRow(0);
    }

    public void setRepositoryURL(Url url, boolean showFiles) {
        RepositoryTreeModel model = new RepositoryTreeModel(this.myVCS, showFiles, this);
        model.setSingleRoot(url);
        Disposer.register((Disposable)this, (Disposable)model);
        this.myRepositoryTree.setModel(model);
        this.myRepositoryTree.setRootVisible(true);
        this.myRepositoryTree.setSelectionRow(0);
    }

    public void expandNode(@NotNull TreeNode treeNode) {
        Object[] pathToNode;
        if (treeNode == null) {
            RepositoryBrowserComponent.$$$reportNull$$$0(2);
        }
        if ((pathToNode = ((RepositoryTreeModel)this.myRepositoryTree.getModel()).getPathToRoot(treeNode)) != null && pathToNode.length > 0) {
            TreePath treePath = new TreePath(pathToNode);
            this.myRepositoryTree.expandPath(treePath);
        }
    }

    public Collection<TreeNode> getExpandedSubTree(@NotNull TreeNode treeNode) {
        if (treeNode == null) {
            RepositoryBrowserComponent.$$$reportNull$$$0(3);
        }
        Object[] pathToNode = ((RepositoryTreeModel)this.myRepositoryTree.getModel()).getPathToRoot(treeNode);
        Enumeration<TreePath> expanded = this.myRepositoryTree.getExpandedDescendants(new TreePath(pathToNode));
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        if (expanded != null) {
            while (expanded.hasMoreElements()) {
                TreePath treePath = expanded.nextElement();
                result.add((TreeNode)treePath.getLastPathComponent());
            }
        }
        return result;
    }

    public boolean isExpanded(@NotNull TreeNode treeNode) {
        Object[] pathToNode;
        if (treeNode == null) {
            RepositoryBrowserComponent.$$$reportNull$$$0(4);
        }
        return (pathToNode = ((RepositoryTreeModel)this.myRepositoryTree.getModel()).getPathToRoot(treeNode)) != null && pathToNode.length > 0 && this.myRepositoryTree.isExpanded(new TreePath(pathToNode));
    }

    public void addURL(@NotNull Url url) {
        if (url == null) {
            RepositoryBrowserComponent.$$$reportNull$$$0(5);
        }
        ((RepositoryTreeModel)this.myRepositoryTree.getModel()).addRoot(url);
    }

    public void removeURL(@NotNull Url url) {
        if (url == null) {
            RepositoryBrowserComponent.$$$reportNull$$$0(6);
        }
        ((RepositoryTreeModel)this.myRepositoryTree.getModel()).removeRoot(url);
    }

    @Nullable
    public DirectoryEntry getSelectedEntry() {
        TreePath selection = this.myRepositoryTree.getSelectionPath();
        if (selection == null) {
            return null;
        }
        Object element = selection.getLastPathComponent();
        if (element instanceof RepositoryTreeNode) {
            RepositoryTreeNode node = (RepositoryTreeNode)element;
            return node.getSVNDirEntry();
        }
        return null;
    }

    @Nullable
    public String getSelectedURL() {
        Url selectedUrl = this.getSelectedSVNURL();
        return selectedUrl == null ? null : selectedUrl.toString();
    }

    @Nullable
    public Url getSelectedSVNURL() {
        TreePath selection = this.myRepositoryTree.getSelectionPath();
        if (selection == null) {
            return null;
        }
        Object element = selection.getLastPathComponent();
        if (element instanceof RepositoryTreeNode) {
            RepositoryTreeNode node = (RepositoryTreeNode)element;
            return node.getURL();
        }
        return null;
    }

    public void addChangeListener(TreeSelectionListener l) {
        this.myRepositoryTree.addTreeSelectionListener(l);
    }

    public void removeChangeListener(TreeSelectionListener l) {
        this.myRepositoryTree.removeTreeSelectionListener(l);
    }

    public Component getPreferredFocusedComponent() {
        return this.myRepositoryTree;
    }

    private void createComponent() {
        this.setLayout(new BorderLayout());
        this.myRepositoryTree = new Tree();
        this.myRepositoryTree.getSelectionModel().setSelectionMode(1);
        this.myRepositoryTree.setRootVisible(false);
        this.myRepositoryTree.setShowsRootHandles(true);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myRepositoryTree, (int)22, (int)32);
        this.add((Component)scrollPane, "Center");
        this.myRepositoryTree.setCellRenderer((TreeCellRenderer)((Object)new SvnRepositoryTreeCellRenderer()));
        TreeSpeedSearch search = new TreeSpeedSearch(this.myRepositoryTree, o -> {
            Object component = o.getLastPathComponent();
            if (component instanceof RepositoryTreeNode) {
                return ((RepositoryTreeNode)component).getURL().toDecodedString();
            }
            return null;
        });
        search.setComparator(new SpeedSearchComparator(false, true));
        EditSourceOnDoubleClickHandler.install((JTree)this.myRepositoryTree);
    }

    @Nullable
    public RepositoryTreeNode getSelectedNode() {
        TreePath selection = this.myRepositoryTree.getSelectionPath();
        if (selection != null && selection.getLastPathComponent() instanceof RepositoryTreeNode) {
            return (RepositoryTreeNode)selection.getLastPathComponent();
        }
        return null;
    }

    public void setSelectedNode(@NotNull TreeNode node) {
        if (node == null) {
            RepositoryBrowserComponent.$$$reportNull$$$0(7);
        }
        Object[] pathNodes = ((RepositoryTreeModel)this.myRepositoryTree.getModel()).getPathToRoot(node);
        this.myRepositoryTree.setSelectionPath(new TreePath(pathNodes));
    }

    @Nullable
    public VirtualFile getSelectedVcsFile() {
        RepositoryTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        DirectoryEntry entry = node.getSVNDirEntry();
        if (entry == null || !entry.isFile()) {
            return null;
        }
        String name = entry.getName();
        FileTypeManager manager = FileTypeManager.getInstance();
        if (entry.getName().lastIndexOf(46) > 0 && !manager.getFileTypeByFileName(name).isBinary()) {
            Url url = node.getURL();
            SvnFileRevision revision = new SvnFileRevision(this.myVCS, Revision.UNDEFINED, Revision.HEAD, url, entry.getAuthor(), entry.getDate(), null, null);
            return new VcsVirtualFile(node.getSVNDirEntry().getName(), (VcsFileRevision)revision, (VirtualFileSystem)VcsFileSystem.getInstance());
        }
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            final Project project = this.myVCS.getProject();
            if (project == null || project.isDefault()) {
                return null;
            }
            final VirtualFile vcsFile = this.getSelectedVcsFile();
            return vcsFile != null ? new NavigatableAdapter(){

                public void navigate(boolean requestFocus) {
                    1.navigate((Project)project, (VirtualFile)vcsFile, (boolean)requestFocus);
                }
            } : null;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myVCS.getProject();
        }
        return null;
    }

    public void dispose() {
    }

    public void setLazyLoadingExpander(NotNullFunction<RepositoryBrowserComponent, Expander> expanderFactory) {
        ((RepositoryTreeModel)this.myRepositoryTree.getModel()).setDefaultExpanderFactory(expanderFactory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/RepositoryBrowserComponent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeNode";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/RepositoryBrowserComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expandNode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedSubTree";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExpanded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeURL";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

