/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.util.FilePathByPathComparator;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.FilePathUtil;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnVcs;

public class SvnUpdateContext
implements SequentialUpdatesContext {
    private final Set<File> myUpdatedExternals;
    private final SvnVcs myVcs;
    private final List<FilePath> myContentRoots;

    public SvnUpdateContext(SvnVcs vcs, FilePath[] contentRoots) {
        this.myVcs = vcs;
        this.myContentRoots = Arrays.asList(contentRoots);
        Collections.sort(this.myContentRoots, FilePathByPathComparator.getInstance());
        this.myUpdatedExternals = new HashSet<File>();
    }

    @NotNull
    public String getMessageWhenInterruptedBeforeStart() {
        if (null == null) {
            SvnUpdateContext.$$$reportNull$$$0(0);
        }
        return null;
    }

    public boolean shouldFail() {
        return false;
    }

    public void registerExternalRootBeingUpdated(File root) {
        this.myUpdatedExternals.add(root);
    }

    public boolean shouldRunFor(File ioRoot) {
        RootUrlInfo info;
        boolean result = true;
        if (this.myUpdatedExternals.contains(ioRoot)) {
            result = false;
        } else if (FilePathUtil.isNested(this.myContentRoots, ioRoot) && (info = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(ioRoot)) != null) {
            if (NestedCopyType.switched.equals((Object)info.getType())) {
                result = false;
            } else if (NestedCopyType.external.equals((Object)info.getType())) {
                result = !this.myVcs.getSvnConfiguration().isIgnoreExternals();
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/update/SvnUpdateContext", "getMessageWhenInterruptedBeforeStart"));
    }
}

