/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleData
extends AbstractNamedData
implements Named,
ExternalConfigPathAware,
Identifiable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final Map<ExternalSystemSourceType, String> myCompileOutputPaths;
    @Nullable
    private Map<String, String> myProperties;
    @NotNull
    private final String myId;
    @NotNull
    private final String myModuleTypeId;
    @NotNull
    private final String myExternalConfigPath;
    @NotNull
    private String myModuleFileDirectoryPath;
    @Nullable
    private String myGroup;
    @Nullable
    private String myVersion;
    @Nullable
    private String myDescription;
    @NotNull
    private List<File> myArtifacts;
    @Nullable
    private String[] myIdeModuleGroup;
    @Nullable
    private String mySourceCompatibility;
    @Nullable
    private String myTargetCompatibility;
    @Nullable
    private String mySdkName;
    @Nullable
    private String myProductionModuleId;
    @Nullable
    private ProjectCoordinate myPublication;
    private boolean myInheritProjectCompileOutputPath;

    public ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String typeId, @NotNull String name, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        if (id == null) {
            ModuleData.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            ModuleData.$$$reportNull$$$0(1);
        }
        if (typeId == null) {
            ModuleData.$$$reportNull$$$0(2);
        }
        if (name == null) {
            ModuleData.$$$reportNull$$$0(3);
        }
        if (moduleFileDirectoryPath == null) {
            ModuleData.$$$reportNull$$$0(4);
        }
        if (externalConfigPath == null) {
            ModuleData.$$$reportNull$$$0(5);
        }
        super(owner, name, name.replaceAll("(/|\\\\)", "_"));
        this.myCompileOutputPaths = ContainerUtil.newHashMap();
        this.myInheritProjectCompileOutputPath = true;
        this.myId = id;
        this.myModuleTypeId = typeId;
        this.myExternalConfigPath = externalConfigPath;
        this.myArtifacts = Collections.emptyList();
        this.myModuleFileDirectoryPath = moduleFileDirectoryPath;
    }

    protected ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String typeId, @NotNull String externalName, @NotNull String internalName, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        if (id == null) {
            ModuleData.$$$reportNull$$$0(6);
        }
        if (owner == null) {
            ModuleData.$$$reportNull$$$0(7);
        }
        if (typeId == null) {
            ModuleData.$$$reportNull$$$0(8);
        }
        if (externalName == null) {
            ModuleData.$$$reportNull$$$0(9);
        }
        if (internalName == null) {
            ModuleData.$$$reportNull$$$0(10);
        }
        if (moduleFileDirectoryPath == null) {
            ModuleData.$$$reportNull$$$0(11);
        }
        if (externalConfigPath == null) {
            ModuleData.$$$reportNull$$$0(12);
        }
        super(owner, externalName, internalName);
        this.myCompileOutputPaths = ContainerUtil.newHashMap();
        this.myInheritProjectCompileOutputPath = true;
        this.myId = id;
        this.myModuleTypeId = typeId;
        this.myExternalConfigPath = externalConfigPath;
        this.myArtifacts = Collections.emptyList();
        this.myModuleFileDirectoryPath = moduleFileDirectoryPath;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            ModuleData.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getModuleTypeId() {
        String string = this.myModuleTypeId;
        if (string == null) {
            ModuleData.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        String string = this.myExternalConfigPath;
        if (string == null) {
            ModuleData.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getModuleFilePath() {
        String string = ExternalSystemApiUtil.toCanonicalPath(this.myModuleFileDirectoryPath + "/" + this.getInternalName() + ".iml");
        if (string == null) {
            ModuleData.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getModuleFileDirectoryPath() {
        String string = this.myModuleFileDirectoryPath;
        if (string == null) {
            ModuleData.$$$reportNull$$$0(17);
        }
        return string;
    }

    public void setModuleFileDirectoryPath(@NotNull String path2) {
        if (path2 == null) {
            ModuleData.$$$reportNull$$$0(18);
        }
        this.myModuleFileDirectoryPath = path2;
    }

    @Nullable
    public String getProductionModuleId() {
        return this.myProductionModuleId;
    }

    public void setProductionModuleId(@Nullable String productionModuleId) {
        this.myProductionModuleId = productionModuleId;
    }

    public boolean isInheritProjectCompileOutputPath() {
        return this.myInheritProjectCompileOutputPath;
    }

    public void setInheritProjectCompileOutputPath(boolean inheritProjectCompileOutputPath) {
        this.myInheritProjectCompileOutputPath = inheritProjectCompileOutputPath;
    }

    @Nullable
    public String getCompileOutputPath(@NotNull ExternalSystemSourceType type) {
        if (type == null) {
            ModuleData.$$$reportNull$$$0(19);
        }
        return this.myCompileOutputPaths.get(type);
    }

    public void setCompileOutputPath(@NotNull ExternalSystemSourceType type, @Nullable String path2) {
        if (type == null) {
            ModuleData.$$$reportNull$$$0(20);
        }
        if (path2 == null) {
            this.myCompileOutputPaths.remove(type);
            return;
        }
        this.myCompileOutputPaths.put(type, ExternalSystemApiUtil.toCanonicalPath(path2));
    }

    @Nullable
    public String getGroup() {
        return this.myGroup;
    }

    public void setGroup(@Nullable String group) {
        this.myGroup = group;
    }

    @Nullable
    public ProjectCoordinate getPublication() {
        return this.myPublication;
    }

    public void setPublication(@Nullable ProjectCoordinate publication) {
        this.myPublication = publication;
    }

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(@Nullable String version) {
        this.myVersion = version;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }

    @NotNull
    public List<File> getArtifacts() {
        List<File> list = this.myArtifacts;
        if (list == null) {
            ModuleData.$$$reportNull$$$0(21);
        }
        return list;
    }

    public void setArtifacts(@NotNull List<File> artifacts) {
        if (artifacts == null) {
            ModuleData.$$$reportNull$$$0(22);
        }
        this.myArtifacts = artifacts;
    }

    @Nullable
    public String[] getIdeModuleGroup() {
        return this.myIdeModuleGroup;
    }

    public void setIdeModuleGroup(@Nullable String[] ideModuleGroup) {
        this.myIdeModuleGroup = ideModuleGroup;
    }

    @Nullable
    public String getSourceCompatibility() {
        return this.mySourceCompatibility;
    }

    public void setSourceCompatibility(@Nullable String sourceCompatibility) {
        this.mySourceCompatibility = sourceCompatibility;
    }

    @Nullable
    public String getTargetCompatibility() {
        return this.myTargetCompatibility;
    }

    public void setTargetCompatibility(@Nullable String targetCompatibility) {
        this.myTargetCompatibility = targetCompatibility;
    }

    @Nullable
    public String getSdkName() {
        return this.mySdkName;
    }

    public void setSdkName(@Nullable String sdkName) {
        this.mySdkName = sdkName;
    }

    @Nullable
    public String getProperty(String key) {
        return this.myProperties != null ? this.myProperties.get(key) : null;
    }

    public void setProperty(String key, String value) {
        if (this.myProperties == null) {
            this.myProperties = ContainerUtil.newHashMap();
        }
        this.myProperties.put(key, value);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ModuleData)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModuleData that = (ModuleData)o;
        if (!this.myId.equals(that.myId)) {
            return false;
        }
        if (!this.myExternalConfigPath.equals(that.myExternalConfigPath)) {
            return false;
        }
        if (this.myGroup != null ? !this.myGroup.equals(that.myGroup) : that.myGroup != null) {
            return false;
        }
        if (!this.myModuleTypeId.equals(that.myModuleTypeId)) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null) {
            return false;
        }
        if (this.myDescription != null ? !this.myDescription.equals(that.myDescription) : that.myDescription != null) {
            return false;
        }
        return !(this.mySdkName != null ? !this.mySdkName.equals(that.mySdkName) : that.mySdkName != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myId.hashCode();
        result2 = 31 * result2 + this.myExternalConfigPath.hashCode();
        result2 = 31 * result2 + this.myModuleTypeId.hashCode();
        result2 = 31 * result2 + (this.myGroup != null ? this.myGroup.hashCode() : 0);
        result2 = 31 * result2 + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result2 = 31 * result2 + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result2 = 31 * result2 + (this.mySdkName != null ? this.mySdkName.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.getId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileDirectoryPath";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalConfigPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/project/ModuleData";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/project/ModuleData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTypeId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedExternalProjectPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFilePath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFileDirectoryPath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setModuleFileDirectoryPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCompileOutputPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setCompileOutputPath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

