/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class FixedSizeButton
extends JButton {
    private int mySize;
    private JComponent myComponent;

    public FixedSizeButton() {
        this(-1, null);
    }

    private FixedSizeButton(int size, JComponent component) {
        Icon icon = AllIcons.General.Ellipsis;
        if (icon != null) {
            this.setIcon(icon);
        } else {
            this.setText(".");
        }
        this.mySize = size;
        this.myComponent = component;
        this.setMargin((Insets)JBUI.emptyInsets());
        this.setDefaultCapable(false);
        this.setFocusable(false);
        if (UIUtil.isUnderAquaLookAndFeel() && size == -1 || UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderDarcula()) {
            this.putClientProperty("JButton.buttonType", "square");
        }
    }

    public FixedSizeButton(int size) {
        this(size, null);
        if (size <= 0) {
            throw new IllegalArgumentException("wrong size: " + size);
        }
    }

    public FixedSizeButton(@NotNull JComponent component) {
        if (component == null) {
            FixedSizeButton.$$$reportNull$$$0(0);
        }
        this(-1, component);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int width;
        if (this.mySize != -1) {
            return new Dimension(this.mySize, this.mySize);
        }
        Dimension d = super.getPreferredSize();
        int base = new JTextField().getPreferredSize().height;
        if (base % 2 == 1) {
            ++base;
        }
        d.width = Math.max(d.height, base);
        int n = width = this.mySize == -1 ? d.width : this.mySize;
        int height = this.myComponent != null ? this.myComponent.getPreferredSize().height : (this.mySize != -1 ? this.mySize : base);
        return new Dimension(width, height);
    }

    public void setAttachedComponent(JComponent component) {
        this.myComponent = component;
    }

    public JComponent getAttachedComponent() {
        return this.myComponent;
    }

    public void setSize(int size) {
        this.mySize = size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/ui/FixedSizeButton", "<init>"));
    }
}

