/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TemplateManagerListener;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateManagerImpl
extends TemplateManager
implements Disposable {
    private static final TemplateContextType[] ourContextTypes = (TemplateContextType[])Extensions.getExtensions((ExtensionPointName)TemplateContextType.EP_NAME);
    private final Project myProject;
    private final MessageBus myMessageBus;
    private boolean myTemplateTesting;
    private static final Key<TemplateState> TEMPLATE_STATE_KEY = Key.create((String)"TEMPLATE_STATE_KEY");
    private static final OffsetKey START_OFFSET = OffsetKey.create((String)"start", (boolean)false);
    private static final OffsetKey END_OFFSET = OffsetKey.create((String)"end", (boolean)true);

    public TemplateManagerImpl(Project project, MessageBus messageBus) {
        this.myProject = project;
        this.myMessageBus = messageBus;
        EditorFactoryAdapter myEditorFactoryListener = new EditorFactoryAdapter(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                Editor editor;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((editor = event.getEditor()).getProject() != null && editor.getProject() != TemplateManagerImpl.this.myProject) {
                    return;
                }
                if (TemplateManagerImpl.this.myProject.isDisposed() || !TemplateManagerImpl.this.myProject.isOpen()) {
                    return;
                }
                TemplateState state2 = TemplateManagerImpl.getTemplateState(editor);
                if (state2 != null) {
                    state2.gotoEnd();
                }
                TemplateManagerImpl.clearTemplateState(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/impl/TemplateManagerImpl$1", "editorReleased"));
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)myEditorFactoryListener, (Disposable)this.myProject);
    }

    public void dispose() {
    }

    @Deprecated
    public void setTemplateTesting(boolean templateTesting) {
        this.myTemplateTesting = templateTesting;
    }

    public static void setTemplateTesting(Project project, Disposable parentDisposable) {
        TemplateManagerImpl instance = (TemplateManagerImpl)TemplateManagerImpl.getInstance(project);
        instance.myTemplateTesting = true;
        Disposer.register((Disposable)parentDisposable, () -> {
            instance.myTemplateTesting = false;
        });
    }

    private static void disposeState(@NotNull TemplateState state2) {
        if (state2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(0);
        }
        Disposer.dispose((Disposable)state2);
    }

    @Override
    public Template createTemplate(@NotNull String key, String group) {
        if (key == null) {
            TemplateManagerImpl.$$$reportNull$$$0(1);
        }
        return new TemplateImpl(key, group);
    }

    @Override
    public Template createTemplate(@NotNull String key, String group, String text2) {
        if (key == null) {
            TemplateManagerImpl.$$$reportNull$$$0(2);
        }
        return new TemplateImpl(key, text2, group);
    }

    @Nullable
    public static TemplateState getTemplateState(@NotNull Editor editor) {
        TemplateState templateState;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(3);
        }
        if ((templateState = (TemplateState)editor.getUserData(TEMPLATE_STATE_KEY)) != null && templateState.isDisposed()) {
            editor.putUserData(TEMPLATE_STATE_KEY, null);
            return null;
        }
        return templateState;
    }

    static void clearTemplateState(@NotNull Editor editor) {
        TemplateState prevState;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(4);
        }
        if ((prevState = TemplateManagerImpl.getTemplateState(editor)) != null) {
            TemplateManagerImpl.disposeState(prevState);
        }
        editor.putUserData(TEMPLATE_STATE_KEY, null);
    }

    private TemplateState initTemplateState(@NotNull Editor editor) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(5);
        }
        TemplateManagerImpl.clearTemplateState(editor);
        TemplateState state2 = new TemplateState(this.myProject, editor);
        Disposer.register((Disposable)this, (Disposable)state2);
        editor.putUserData(TEMPLATE_STATE_KEY, (Object)state2);
        return state2;
    }

    @Override
    public boolean startTemplate(@NotNull Editor editor, char shortcutChar) {
        Runnable runnable2;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(6);
        }
        if ((runnable2 = this.prepareTemplate(editor, shortcutChar, null)) != null) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
            runnable2.run();
        }
        return runnable2 != null;
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(7);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(8);
        }
        this.startTemplate(editor, template, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, String selectionString, @NotNull Template template) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(9);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(10);
        }
        this.startTemplate(editor, selectionString, template, true, null, null, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, TemplateEditingListener listener2, PairProcessor<String, String> processor2) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(11);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(12);
        }
        this.startTemplate(editor, null, template, true, listener2, processor2, null);
    }

    private void startTemplate(Editor editor, String selectionString, Template template, boolean inSeparateCommand, TemplateEditingListener listener2, PairProcessor<String, String> processor2, Map<String, String> predefinedVarValues) {
        TemplateState templateState = this.initTemplateState(editor);
        templateState.getProperties().put(ExpressionContext.SELECTION, selectionString);
        if (listener2 != null) {
            templateState.addTemplateStateListener(listener2);
        }
        Runnable r = () -> {
            if (selectionString != null) {
                ApplicationManager.getApplication().runWriteAction(() -> EditorModificationUtil.deleteSelectedText((Editor)editor));
            } else {
                editor.getSelectionModel().removeSelection();
            }
            templateState.start((TemplateImpl)template, processor2, predefinedVarValues);
            this.fireTemplateStarted(templateState);
        };
        if (inSeparateCommand) {
            CommandProcessor.getInstance().executeCommand(this.myProject, r, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
        } else {
            r.run();
        }
        if (this.shouldSkipInTests() && !templateState.isFinished()) {
            templateState.gotoEnd(false);
        }
    }

    public boolean shouldSkipInTests() {
        return ApplicationManager.getApplication().isUnitTestMode() && !this.myTemplateTesting;
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, TemplateEditingListener listener2) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(13);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(14);
        }
        this.startTemplate(editor, null, template, true, listener2, null, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor, @NotNull Template template, boolean inSeparateCommand, Map<String, String> predefinedVarValues, TemplateEditingListener listener2) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(15);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(16);
        }
        this.startTemplate(editor, null, template, inSeparateCommand, listener2, null, predefinedVarValues);
    }

    private static int passArgumentBack(CharSequence text2, int caretOffset) {
        char c;
        int i;
        for (i = caretOffset - 1; i >= 0 && !TemplateManagerImpl.isDelimiter(c = text2.charAt(i)); --i) {
        }
        return i + 1;
    }

    private static boolean isDelimiter(char c) {
        return !Character.isJavaIdentifierPart(c);
    }

    private static <T, U> void addToMap(@NotNull Map<T, U> map2, @NotNull Collection<? extends T> keys, U value) {
        if (map2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(17);
        }
        if (keys == null) {
            TemplateManagerImpl.$$$reportNull$$$0(18);
        }
        for (T key : keys) {
            map2.put(key, value);
        }
    }

    private static boolean containsTemplateStartingBefore(Map<TemplateImpl, String> template2argument, int offset, int caretOffset, CharSequence text2) {
        for (TemplateImpl template : template2argument.keySet()) {
            String argument;
            int templateStart = TemplateManagerImpl.getTemplateStart(template, argument = template2argument.get(template), caretOffset, text2);
            if (templateStart >= offset) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Runnable prepareTemplate(Editor editor, char shortcutChar, @Nullable PairProcessor<String, String> processor2) {
        if (editor.getSelectionModel().hasSelection()) {
            return null;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)this.myProject);
        if (file2 == null || file2 instanceof PsiCompiledElement) {
            return null;
        }
        Map<TemplateImpl, String> template2argument = this.findMatchingTemplates(file2, editor, Character.valueOf(shortcutChar), TemplateSettings.getInstance());
        List customCandidates = ContainerUtil.findAll((Object[])CustomLiveTemplate.EP_NAME.getExtensions(), customLiveTemplate -> shortcutChar == customLiveTemplate.getShortcut() && (editor.getCaretModel().getCaretCount() <= 1 || TemplateManagerImpl.supportsMultiCaretMode(customLiveTemplate)));
        if (!customCandidates.isEmpty()) {
            int caretOffset = editor.getCaretModel().getOffset();
            PsiFile fileCopy = TemplateManagerImpl.insertDummyIdentifierWithCache(file2, caretOffset, caretOffset, "").getFile();
            Document document = editor.getDocument();
            for (CustomLiveTemplate customLiveTemplate2 : customCandidates) {
                String key;
                if (!TemplateManagerImpl.isApplicable(customLiveTemplate2, editor, fileCopy) || (key = customLiveTemplate2.computeTemplateKey(new CustomTemplateCallback(editor, fileCopy))) == null) continue;
                int offsetBeforeKey = caretOffset - key.length();
                CharSequence text2 = document.getImmutableCharSequence();
                if (template2argument != null && TemplateManagerImpl.containsTemplateStartingBefore(template2argument, offsetBeforeKey, caretOffset, text2)) continue;
                return () -> customLiveTemplate2.expand(key, new CustomTemplateCallback(editor, file2));
            }
        }
        return this.startNonCustomTemplates(template2argument, editor, processor2);
    }

    private static boolean supportsMultiCaretMode(CustomLiveTemplate customLiveTemplate) {
        return !(customLiveTemplate instanceof CustomLiveTemplateBase) || ((CustomLiveTemplateBase)customLiveTemplate).supportsMultiCaret();
    }

    public static boolean isApplicable(@NotNull CustomLiveTemplate customLiveTemplate, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (customLiveTemplate == null) {
            TemplateManagerImpl.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(21);
        }
        return TemplateManagerImpl.isApplicable(customLiveTemplate, editor, file2, false);
    }

    public static boolean isApplicable(@NotNull CustomLiveTemplate customLiveTemplate, @NotNull Editor editor, @NotNull PsiFile file2, boolean wrapping) {
        if (customLiveTemplate == null) {
            TemplateManagerImpl.$$$reportNull$$$0(22);
        }
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(24);
        }
        CustomTemplateCallback callback2 = new CustomTemplateCallback(editor, file2);
        return customLiveTemplate.isApplicable(callback2, callback2.getOffset(), wrapping);
    }

    private static int getArgumentOffset(int caretOffset, String argument, CharSequence text2) {
        int argumentOffset = caretOffset - argument.length();
        if (argumentOffset > 0 && text2.charAt(argumentOffset - 1) == ' ' && argumentOffset - 2 >= 0 && Character.isJavaIdentifierPart(text2.charAt(argumentOffset - 2))) {
            --argumentOffset;
        }
        return argumentOffset;
    }

    private static int getTemplateStart(TemplateImpl template, String argument, int caretOffset, CharSequence text2) {
        int templateStart;
        if (argument == null) {
            templateStart = caretOffset - template.getKey().length();
        } else {
            int argOffset = TemplateManagerImpl.getArgumentOffset(caretOffset, argument, text2);
            templateStart = argOffset - template.getKey().length();
        }
        return templateStart;
    }

    public Map<TemplateImpl, String> findMatchingTemplates(PsiFile file2, Editor editor, @Nullable Character shortcutChar, TemplateSettings templateSettings) {
        List<TemplateImpl> candidatesWithArgument;
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        int caretOffset = editor.getCaretModel().getOffset();
        List<TemplateImpl> candidatesWithoutArgument = TemplateManagerImpl.findMatchingTemplates(text2, caretOffset, shortcutChar, templateSettings, false);
        int argumentOffset = TemplateManagerImpl.passArgumentBack(text2, caretOffset);
        String argument = null;
        if (argumentOffset >= 0) {
            argument = text2.subSequence(argumentOffset, caretOffset).toString();
            if (argumentOffset > 0 && text2.charAt(argumentOffset - 1) == ' ' && argumentOffset - 2 >= 0 && Character.isJavaIdentifierPart(text2.charAt(argumentOffset - 2))) {
                --argumentOffset;
            }
        }
        if ((candidatesWithArgument = TemplateManagerImpl.findMatchingTemplates(text2, argumentOffset, shortcutChar, templateSettings, true)).isEmpty() && candidatesWithoutArgument.isEmpty()) {
            return null;
        }
        candidatesWithoutArgument = TemplateManagerImpl.filterApplicableCandidates(file2, caretOffset, candidatesWithoutArgument);
        candidatesWithArgument = TemplateManagerImpl.filterApplicableCandidates(file2, argumentOffset, candidatesWithArgument);
        HashMap<TemplateImpl, String> candidate2Argument = new HashMap<TemplateImpl, String>();
        TemplateManagerImpl.addToMap(candidate2Argument, candidatesWithoutArgument, null);
        TemplateManagerImpl.addToMap(candidate2Argument, candidatesWithArgument, argument);
        return candidate2Argument;
    }

    @Nullable
    public Runnable startNonCustomTemplates(Map<TemplateImpl, String> template2argument, Editor editor, @Nullable PairProcessor<String, String> processor2) {
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        if (template2argument == null || template2argument.isEmpty()) {
            return null;
        }
        return () -> {
            if (template2argument.size() == 1) {
                TemplateImpl template = (TemplateImpl)template2argument.keySet().iterator().next();
                String argument = (String)template2argument.get(template);
                int templateStart = TemplateManagerImpl.getTemplateStart(template, argument, caretOffset, text2);
                this.startTemplateWithPrefix(editor, template, templateStart, processor2, argument);
            } else {
                ListTemplatesHandler.showTemplatesLookup(this.myProject, editor, template2argument);
            }
        };
    }

    private static List<TemplateImpl> findMatchingTemplates(CharSequence text2, int caretOffset, @Nullable Character shortcutChar, TemplateSettings settings, boolean hasArgument) {
        String key;
        int wordStart;
        List<TemplateImpl> candidates = Collections.emptyList();
        for (int i = settings.getMaxKeyLength(); i >= 1 && ((wordStart = caretOffset - i) < 0 || Character.isJavaIdentifierStart((key = text2.subSequence(wordStart, caretOffset).toString()).charAt(0)) && wordStart > 0 && Character.isJavaIdentifierPart(text2.charAt(wordStart - 1)) || (candidates = settings.collectMatchingCandidates(key, shortcutChar, hasArgument)).isEmpty()); --i) {
        }
        return candidates;
    }

    public void startTemplateWithPrefix(Editor editor, TemplateImpl template, @Nullable PairProcessor<String, String> processor2, @Nullable String argument) {
        int caretOffset = editor.getCaretModel().getOffset();
        String key = template.getKey();
        int startOffset = caretOffset - key.length();
        if (argument != null) {
            if (!TemplateManagerImpl.isDelimiter(key.charAt(key.length() - 1))) {
                --startOffset;
            }
            startOffset -= argument.length();
        }
        this.startTemplateWithPrefix(editor, template, startOffset, processor2, argument);
    }

    public void startTemplateWithPrefix(Editor editor, TemplateImpl template, int templateStart, @Nullable PairProcessor<String, String> processor2, @Nullable String argument) {
        int caretOffset = editor.getCaretModel().getOffset();
        TemplateState templateState = this.initTemplateState(editor);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            editor.getDocument().deleteString(templateStart, caretOffset);
            editor.getCaretModel().moveToOffset(templateStart);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            HashMap<String, String> predefinedVarValues = null;
            if (argument != null) {
                predefinedVarValues = new HashMap<String, String>();
                predefinedVarValues.put("ARG", argument);
            }
            templateState.start(template, processor2, predefinedVarValues);
            this.fireTemplateStarted(templateState);
        }, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
    }

    private void fireTemplateStarted(TemplateState templateState) {
        ((TemplateManagerListener)this.myMessageBus.syncPublisher(TEMPLATE_STARTED_TOPIC)).templateStarted(templateState);
    }

    private static List<TemplateImpl> filterApplicableCandidates(PsiFile file2, int caretOffset, List<TemplateImpl> candidates) {
        if (candidates.isEmpty()) {
            return candidates;
        }
        PsiFile copy = TemplateManagerImpl.insertDummyIdentifierWithCache(file2, caretOffset, caretOffset, CompletionUtil.DUMMY_IDENTIFIER_TRIMMED).getFile();
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateImpl candidate : candidates) {
            if (!TemplateManagerImpl.isApplicable(copy, caretOffset - candidate.getKey().length(), candidate)) continue;
            result2.add(candidate);
        }
        return result2;
    }

    private static List<TemplateContextType> getBases(TemplateContextType type) {
        ArrayList<TemplateContextType> list2 = new ArrayList<TemplateContextType>();
        while ((type = type.getBaseContextType()) != null) {
            list2.add(type);
        }
        return list2;
    }

    private static Set<TemplateContextType> getDirectlyApplicableContextTypes(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(25);
        }
        LinkedHashSet<TemplateContextType> set2 = new LinkedHashSet<TemplateContextType>();
        LinkedList<TemplateContextType> contexts = TemplateManagerImpl.buildOrderedContextTypes();
        for (TemplateContextType contextType : contexts) {
            if (!contextType.isInContext(file2, offset)) continue;
            set2.add(contextType);
        }
        block1: while (true) {
            for (TemplateContextType type : set2) {
                if (!set2.removeAll(TemplateManagerImpl.getBases(type))) continue;
                continue block1;
            }
            break;
        }
        return set2;
    }

    private static LinkedList<TemplateContextType> buildOrderedContextTypes() {
        TemplateContextType[] typeCollection = TemplateManagerImpl.getAllContextTypes();
        LinkedList<TemplateContextType> userDefinedExtensionsFirst = new LinkedList<TemplateContextType>();
        for (TemplateContextType contextType : typeCollection) {
            if (contextType.getClass().getName().startsWith(Template.class.getPackage().getName())) {
                userDefinedExtensionsFirst.addLast(contextType);
                continue;
            }
            userDefinedExtensionsFirst.addFirst(contextType);
        }
        return userDefinedExtensionsFirst;
    }

    public static TemplateContextType[] getAllContextTypes() {
        return ourContextTypes;
    }

    @Override
    @Nullable
    public Template getActiveTemplate(@NotNull Editor editor) {
        TemplateState templateState;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(26);
        }
        return (templateState = TemplateManagerImpl.getTemplateState(editor)) != null ? templateState.getTemplate() : null;
    }

    @Override
    public boolean finishTemplate(@NotNull Editor editor) {
        TemplateState state2;
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(27);
        }
        if ((state2 = TemplateManagerImpl.getTemplateState(editor)) != null) {
            state2.gotoEnd();
            return true;
        }
        return false;
    }

    public static boolean isApplicable(PsiFile file2, int offset, TemplateImpl template) {
        return TemplateManagerImpl.isApplicable(template, TemplateManagerImpl.getApplicableContextTypes(file2, offset));
    }

    public static boolean isApplicable(TemplateImpl template, Set<TemplateContextType> contextTypes) {
        for (TemplateContextType type : contextTypes) {
            if (!template.getTemplateContext().isEnabled(type)) continue;
            return true;
        }
        return false;
    }

    public static List<TemplateImpl> listApplicableTemplates(PsiFile file2, int offset, boolean selectionOnly) {
        Set<TemplateContextType> contextTypes = TemplateManagerImpl.getApplicableContextTypes(file2, offset);
        ArrayList result2 = ContainerUtil.newArrayList();
        for (TemplateImpl template : TemplateSettings.getInstance().getTemplates()) {
            if (template.isDeactivated() || selectionOnly && !template.isSelectionTemplate() || !TemplateManagerImpl.isApplicable(template, contextTypes)) continue;
            result2.add(template);
        }
        return result2;
    }

    public static List<TemplateImpl> listApplicableTemplateWithInsertingDummyIdentifier(Editor editor, PsiFile file2, boolean selectionOnly) {
        int startOffset = editor.getSelectionModel().getSelectionStart();
        int endOffset = editor.getSelectionModel().getSelectionEnd();
        OffsetsInFile offsets = TemplateManagerImpl.insertDummyIdentifierWithCache(file2, startOffset, endOffset, CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
        return TemplateManagerImpl.listApplicableTemplates(offsets.getFile(), TemplateManagerImpl.getStartOffset(offsets), selectionOnly);
    }

    public static List<CustomLiveTemplate> listApplicableCustomTemplates(@NotNull Editor editor, @NotNull PsiFile file2, boolean selectionOnly) {
        if (editor == null) {
            TemplateManagerImpl.$$$reportNull$$$0(28);
        }
        if (file2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(29);
        }
        ArrayList<CustomLiveTemplate> result2 = new ArrayList<CustomLiveTemplate>();
        for (CustomLiveTemplate template : (CustomLiveTemplate[])CustomLiveTemplate.EP_NAME.getExtensions()) {
            if (selectionOnly && !template.supportsWrapping() || !TemplateManagerImpl.isApplicable(template, editor, file2, selectionOnly)) continue;
            result2.add(template);
        }
        return result2;
    }

    public static Set<TemplateContextType> getApplicableContextTypes(PsiFile file2, int offset) {
        PsiFile basePsi;
        Language languageAtOffset;
        PsiFile basePsi2;
        Set<TemplateContextType> result2 = TemplateManagerImpl.getDirectlyApplicableContextTypes(file2, offset);
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        if (baseLanguage != file2.getLanguage() && (basePsi2 = file2.getViewProvider().getPsi(baseLanguage)) != null) {
            result2.addAll(TemplateManagerImpl.getDirectlyApplicableContextTypes(basePsi2, offset));
        }
        if ((languageAtOffset = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset)) != file2.getLanguage() && languageAtOffset != baseLanguage && (basePsi = file2.getViewProvider().getPsi(languageAtOffset)) != null) {
            result2.addAll(TemplateManagerImpl.getDirectlyApplicableContextTypes(basePsi, offset));
        }
        return result2;
    }

    private static int getStartOffset(OffsetsInFile offsets) {
        return offsets.getOffsets().getOffset(START_OFFSET);
    }

    private static int getEndOffset(OffsetsInFile offsets) {
        return offsets.getOffsets().getOffset(END_OFFSET);
    }

    private static OffsetsInFile insertDummyIdentifierWithCache(PsiFile file2, int startOffset, int endOffset, String replacement) {
        ProperTextRange editRange = ProperTextRange.create((int)startOffset, (int)endOffset);
        TemplateManagerImpl.assertRangeWithinDocument(editRange, file2.getViewProvider().getDocument());
        ConcurrentMap map2 = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file2, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(key -> TemplateManagerImpl.copyWithDummyIdentifier(new OffsetsInFile(file2), ((ProperTextRange)key.first).getStartOffset(), ((ProperTextRange)key.first).getEndOffset(), (String)key.second)), (Object[])new Object[]{file2, file2.getViewProvider().getDocument()}));
        return (OffsetsInFile)map2.get(Pair.create((Object)editRange, (Object)replacement));
    }

    private static void assertRangeWithinDocument(ProperTextRange editRange, Document document) {
        TextRange docRange = TextRange.from((int)0, (int)document.getTextLength());
        assert (docRange.contains((TextRange)editRange)) : docRange + " doesn't contain " + editRange;
    }

    @NotNull
    public static OffsetsInFile copyWithDummyIdentifier(OffsetsInFile offsetMap, int startOffset, int endOffset, String replacement) {
        offsetMap.getOffsets().addOffset(START_OFFSET, startOffset);
        offsetMap.getOffsets().addOffset(END_OFFSET, endOffset);
        Document document = offsetMap.getFile().getViewProvider().getDocument();
        assert (document != null);
        if (replacement.isEmpty() && startOffset == endOffset) {
            PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)offsetMap.getFile().getProject());
            if (ApplicationManager.getApplication().isDispatchThread()) {
                pdm.commitDocument(document);
            }
            if (pdm.isCommitted(document)) {
                OffsetsInFile offsetsInFile = offsetMap;
                if (offsetsInFile == null) {
                    TemplateManagerImpl.$$$reportNull$$$0(30);
                }
                return offsetsInFile;
            }
        }
        OffsetsInFile hostOffsets = offsetMap.toTopLevelFile();
        OffsetsInFile hostCopy = hostOffsets.copyWithReplacement(TemplateManagerImpl.getStartOffset(hostOffsets), TemplateManagerImpl.getEndOffset(hostOffsets), replacement);
        OffsetsInFile offsetsInFile = hostCopy.toInjectedIfAny(TemplateManagerImpl.getStartOffset(hostCopy));
        if (offsetsInFile == null) {
            TemplateManagerImpl.$$$reportNull$$$0(31);
        }
        return offsetsInFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customLiveTemplate";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateManagerImpl";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithDummyIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "disposeState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearTemplateState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initTemplateState";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addToMap";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDirectlyApplicableContextTypes";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getActiveTemplate";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "finishTemplate";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "listApplicableCustomTemplates";
                break;
            }
            case 30: 
            case 31: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

